//
// Copyright (C) 1999-2002 Toshikaz Hirabayashi
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to
// deal in the Software without restriction, including without limitation the
// rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
// sell copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
// TOSHIKAZ HIRABAYASHI BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, 
// WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF 
// OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE 
// SOFTWARE. 
// Except as contained in this notice, the name of Toshikaz Hirabayashi shall
// not be used in advertising or otherwise to promote the sale, use or other 
// dealings in this Software without prior written authorization from  
// Toshikaz Hirabayashi.

#ifndef WSCBASEDIALOG_H
#define WSCBASEDIALOG_H

#include <WScom.h>
#include <WSCwindow.h>

class WSCvbtn;
class WSCvlabel;
class WSCform;

#define WSCbaseDialog_VER  1000

class WSCbaseDialog :public WSCwindow{

  private:
  protected:
    WSCvbtn*  _end_btn;
    WSCvbtn*  _ok_btn;
    WSCvbtn*  _no_btn;
    WSCform*  _cmd_form;
    WSCvlabel* _title_label;
    WSCvlabel* _title_labels1;
    WSCvlabel* _title_labels2;
    void*     _rep;
    char*     _ok_str;
    char*     _no_str;
    char*     _cancel_str;
    short     _title_pixmap;
    unsigned  _ok:1;
    unsigned  _no:1;
    unsigned  _cancel:1;
    unsigned  _status:2;
    unsigned  _modal:1;
    unsigned  _default_pos:1;
    unsigned  _popuped:1;

    WSMFpropertyDef(WSNok,              WSCbool, _ok);
    WSMFpropertyDef(WSNno,              WSCbool, _no);
    WSMFpropertyDef(WSNcancel,              WSCbool, _cancel);
    WSMFpropertyDef(WSNlabelPixmap,     short,   _title_pixmap);
    WSMFpropertyDef(WSNokString,        char*,   _ok_str);
    WSMFpropertyDef(WSNnoString,        char*,   _no_str);
    WSMFpropertyDef(WSNcancelString,        char*,   _cancel_str);
    WSMFpropertyDef(WSNreplyHandler,    void*,   _rep);
    WSMFpropertyDef(WSNmodal,           WSCbool, _modal);
    WSMFpropertyDef(WSNdefaultPosition, WSCbool, _default_pos);

    virtual void setWorkWSNwidth(WSCushort);
    virtual void setWorkWSNheight(WSCushort);
    virtual void setWorkWSNtitleString(char*);

    static void _ok_btn_work(WSCbase*);
    static void _no_btn_work(WSCbase*);
    static void _end_btn_work(WSCbase*);

     virtual long _device_initialize();

  public:
    WSCbaseDialog(WSCbase*,char*);
    virtual  ~WSCbaseDialog();
    virtual  long initialize();

    virtual void onResize(WSCrect*);
    virtual void onVisibleChange(WSCbool);
    virtual void onParentVisibleChange(WSCbool);
    virtual void onActivate();
    virtual void onGuiPolicyChange(long);
    virtual void onFocusChange(WSCbool);

    WSCbase* getFormObject();
    WSCbase* getCmdFormObject();
    long     getStatus();
    virtual  long popup();

    WSMFguiClassDef(WSCbaseDialog,WSCwindow);
    WSMFversionDef(WSCbaseDialog);
};
#endif
