;;; menu-tree.el --- get/set menu tree title
;;; for GNU Emacs version 22, 23

;; Copyright (C) 1999 YAGI Tatsuya
;;           (C) 2008 IRIE Shinsuke

;; Author: YAGI Tatsuya
;;         IRIE Shinsuke
;; Maintainer: IRIE Shinsuke
;; Keywords: japanese

;; This file is NOT part of GNU Emacs

;;; Commentary:
;;
;; GNU Emacs Υ˥塼ܸ첽ץ
;;
;; ȯGNU Emacs23.0.60ǹԤäƤ
;; GNU Emacs 22, 23 ư
;;
;; ˡ:
;; (require 'menu-tree)
;
;; ʸ
;; (setq menu-tree-coding-system 'utf-8) ;; ƼδĶ˹碌
;;
;;
;;; HISTORY:
;;  2008-11-09  S. Irie
;;          * ܸɲ
;;          * Emacs23ΰΥСǥ顼ФԶ
;;          * Version 0.93
;;
;;  2008-05-15  S. Irie
;;          * ܸ
;;          * Version 0.92
;;
;;  2008-05-08  S. Irie
;;          * ,@ Ȥäƾʬ褦ˤ
;;          * Version 0.91
;;
;;  2008-03-26  S. Irie
;;          * GNU Emacs22,23 б
;;          * Version 0.90
;;
;;
;; TODO:
;;
;;

;;; Code:

(defconst menu-tree-version "0.93"
  "Version number for the Menu-tree package.")

(defvar menu-tree-coding-system nil
  "Coding system used for menu item")

(defvar menu-tree-alist-ja-langs
  '(
    (Default "ɸ")
    (Chinese ""
	     (Chinese-GB "(GB)")
	     (Chinese-BIG5 "(BIG5)")
	     (Chinese-CNS "(CNS)")
	     (Chinese-EUC-TW "(EUC-TW)")
	     (Chinese-GBK "(GBK)")
	     (Chinese-GB18030 "(GB18030)")
	     )
    (Cyrillic "ʸ"
	      (Cyrillic-ISO "ʸ(ISO)")
	      (Cyrillic-KOI8 "ʸ(KOI8)")
	      (Russian "")
	      (Cyrillic-ALT "ʸ(ALT)")
	      (Tajik "")
	      (Bulgarian "֥륬ꥢ")
	      (Belarusian "٥롼")
	      (Ukrainian "饤ʸ")
	      )
    (Indian "ɤθ"
	    (Devanagari "ǡʡ꡼ʸ")
	    (Bengali "٥󥬥")
	    (Punjabi "ѥ󥸥㡼ָ")
	    (Gujarati "顼ȸ")
	    (Oriya "䡼")
	    (Tamil "ߥ")
	    (Telugu "ƥ륰")
	    (Kannada "ʥ")
	    (Malayalam "ޥ䡼")
	    )
    (Sinhala "ϥ")
    (English "Ѹ")
    (ASCII "ASCII")
    (Ethiopic "ԥ")
    (European "衼åѷϸ"
	      (Latin-1 "ƥϸ(1)")
	      (Latin-2 "ƥϸ(2)")
	      (Latin-3 "ƥϸ(3)")
	      (Latin-4 "ƥϸ(4)")
	      (Latin-5 "ƥϸ(5)")
	      (Latin-8 "ƥϸ(8)")
	      (Latin-9 "ƥϸ(9)")
	      (Esperanto "ڥ")
	      (Dutch "")
	      (German "ɥĸ")
	      (French "ե󥹸")
	      (Italian "ꥢ")
	      (Slovenian "٥˥")
	      (Spanish "ڥ")
	      (Polish "ݡɸ")
	      (Welsh "륺")
	      (Latin-6 "ƥϸ(6)")
	      (Latin-7 "ƥϸ(7)")
	      (Lithuanian "ȥ˥")
	      (Latvian "ȥӥ")
	      (Swedish "ǥ")
	      (Croatian "")
	      (Brazilian\ Portuguese "ݥȥ(֥饸)")
	      (Czech "")
	      (Slovak "Х")
	      (Romanian "롼ޥ˥")
	      (Georgian "른")
	      )
    (Turkish "ȥ륳")
    (Greek "ꥷ")
    (Hebrew "إ֥饤")
    (Japanese "ܸ")
    (Korean "ڹ")
    (Lao "饪")
    (TaiViet "ϸ(TaiViet)")
    (Thai "")
    (Tibetan "٥åȸ")
    (Vietnamese "٥ȥʥ")
    (IPA "ȯ")
    (UTF-8 "UTF-8")
    (Khmer "᡼")
    (Burmese "ӥ޸")
    (Cham "")
    )
  )

(defvar menu-tree-alist-ja
  `((global-map
     (buffer "Хåե"
	     ;; ...
;	     (frames-separator "--")
	     (frames "ե졼")
;	     (command-separator "--")
	     (next-buffer "ΥХåե")
	     (previous-buffer "ΥХåե")
	     (select-named-buffer "Хåե̾...")
	     (list-all-buffers "Хåե")
	     )
     (file "ե"
	    (new-file "...")
	    (open-file "...")
	    (dired "ǥ쥯ȥ򳫤...")
	    (insert-file "ե...")
	    (kill-buffer "Ĥ")
;	    (separator-save "--")
	    (save-buffer "¸")
	    (write-file "̾Ĥ¸...")
	    (revert-buffer "ɤ߹")
	    (recover-session "å")
;	    (separator-print "--")
	    (print-buffer "")
	    (print-region "ΰ")
	    (ps-print-buffer-faces "Postscriptǰ")
	    (ps-print-region-faces "Postscriptΰ")
	    (ps-print-buffer "Postscriptǰ()")
	    (ps-print-region "Postscriptΰΰ()")
;	    (separator-window "--")
	    (split-window "ɥʬ")
	    (one-window "ʬ")
	    (make-frame "ե졼")
	    (make-frame-on-display "ե졼(̤)...")
	    (delete-this-frame "ե졼Ĥ")
;	    (separator-exit "--")
	    (exit-emacs "λ")
	    )
     (tools "ġ"
	    (grep "ե򸡺(Grep)...")
	    (compile "ѥ...")
	    (shell "륳ޥ...")
	    (shell-on-region "ϰϤ򥷥륳ޥɤǽ...")
	    (gdb "ǥХå(GDB)")
;	    (separator-prog "--")
 	    (spell "ڥå"
		   (ispell-buffer "Хåեå")
		   (ispell-message "᡼ȥ˥塼å")
		   (ispell-region "ΰå")
		   (ispell-comments-and-strings "Ȥʸå")
		   (ispell-word "ñå")
		   (ispell-continue "ڥåƳ")
		   (ispell-complete-word-interior-frag "ñҤ䴰")
		   (ispell-complete-word "ñ䴰")
		   (flyspell-mode "ưǥڥå(Flyspell)")
		   (ispell-help "إ")
		   (ispell-customize "...")
		   (ispell-pdict-save "¸")
		   (ispell-kill-ispell "λ")
		   (ispell-change-dictionary "ѹ...")
		   ,@(if (= emacs-major-version 22)
			 '((american "ꥫѸμ")
			   (british "ꥹѸμ")
			   (canadian "ʥѸμ")
			   (english "Ѹμ")))
		   )
;	    (separator-spell "--")
 	    (compare "(Ediff)"
		     (ediff-files "2ĤΥե...")
		     (ediff-buffers "2ĤΥХåե...")
		     (ediff-files3 "3ĤΥե...")
		     (ediff-buffers3 "3ĤΥХåե...")
;		     (separator-ediff-files "--")
		     (ediff-directories "2ĤΥǥ쥯ȥ...")
		     (ediff-directories3 "3ĤΥǥ쥯ȥ...")
;		     (separator-ediff-directories "--")
		     (ediff-revision "եΥС...")
		     (ediff-dir-revision "ǥ쥯ȥΥС...")
;		     (separator-ediff-regions "--")
		     (ediff-regions-wordwise "ΰ(ñ줴)...")
		     (ediff-regions-linewise "ΰ(Ԥ)...")
;		     (separator-ediff-windows "--")
		     (ediff-windows-wordwise "ɥ(ñ줴)...")
		     (ediff-windows-linewise "ɥ(Ԥ)...")
		     (window "Υɥ٤Υɥ")
		     )
	    (ediff-merge "ޡ"
			 (ediff-merge-files "ե...")
			 (ediff-merge-files-with-ancestor "ե(򻲾)...")
			 (ediff-merge-buffers "Хåե...")
			 (ediff-merge-buffers-with-ancestor "Хåե(򻲾)...")
;			 (separator-ediff-merge-dirs "--")
			 (ediff-merge-directories "ǥ쥯ȥ...")
			 (ediff-merge-directories-with-ancestor "ǥ쥯ȥ(򻲾)...")
;			 (separator-ediff-merge "--")
			 (ediff-merge-revisions "С...")
			 (ediff-merge-revisions-with-ancestor "С(򻲾)...")
			 (ediff-merge-dir-revisions "ǥ쥯ȥΥС...")
			 (ediff-merge-dir-revisions-with-ancestor "ǥ쥯ȥΥС(򻲾)...")
			 )
	    (epatch "ѥåŬ"
		    (ediff-patch-file "եФ...")
		    (ediff-patch-buffer "ХåեФ...")
		    )
	    (ediff-misc "Ediff ¾"
			(ediff-doc "Ediffޥ˥奢")
			(ediff-cust "Ediff򥫥ޥ")
			(eregistry "EdiffΥå")
			(emultiframe "ȥХåեե졼λ/Ի")
			)
;	    (separator-compare "--")
	    (vc "С"
		,@(if (= emacs-major-version 23)
		      '((vc-dir "VCǥ쥯ȥ")))
		(vc-register "Ͽ")
		(vc-next-action "å/")
		(vc-update "ǿС˹")
		,@(if (= emacs-major-version 23)
		      '((vc-revert "ѹ˴Ƹ᤹")))
		,@(if (= emacs-major-version 22)
		      '((vc-revert-buffer "ѹ˴Ƹ᤹")))
		(undo "ǸΥåä")
		(vc-insert-header "إå")
;		(separator2 "----")
		(vc-print-log "ɽ")
		(vc-update-change-log "򹹿")
		(vc-diff "ΥС")
		,@(if (= emacs-major-version 23)
		      '((vc-revision-other-window "¾ΥС򸫤")))
		,@(if (= emacs-major-version 22)
		      '((vc-version-other-window "¾ΥС򸫤")))
		(vc-rename-file "ե̾ѹ")
		(vc-annotate "ѹǿʬ(Annotate)")
;		(separator1 "----")
		(vc-directory "VCǥ쥯ȥΰ")
		(vc-create-snapshot "ʥåץåȤ")
		(vc-retrieve-snapshot "ʥåץåȤФ")
		,@(if (= emacs-major-version 23)
		      '((vc-create-tag "դ")
			(vc-retrieve-tag "դ줿ʪФ")))
		)
	    (pcl-cvs "PCL-CVS"
		(examine "ǥ쥯ȥĴ")
		(update "ǥ쥯ȥ򹹿")
		(checkout "⥸塼å")
		(status "ǥ쥯ȥΥơ")
		)
;	    (separator-vc "--")
	    (gnus "ͥåȥ˥塼ɤ(Gnus)")
	    (rmail (format "᡼ɤ(%s)" (read-mail-item-name)))
	    (compose-mail (format "᡼(%s)" (send-mail-item-name)))
	    (directory-search "ǥ쥯ȥ긡"
		(load "ФΥۥåȥꥹȤ")
		(new "")
;		(separator-eudc-query "--")
		(query "ե䤤碌")
		(expand-inline "饤󥯥Ÿ")
;		(separator-eudc-email "--")
		(email "Żҥ᡼륢ɥ쥹")
		(phone "ֹ")
		(Server ""
;			(--- "---")
			(Bookmark\ Current\ Server "ߤΥФ֥åޡ")
			(Edit\ Server\ List "ФΥꥹȤԽ")
			(New\ Server "")
			)
;		(--- "---")
		(Query\ with\ Form "ե䤤碌")
		(Expand\ Inline\ Query "饤󥯥Ÿ")
		(Insert\ Record\ into\ BBDB "BBDBإ쥳ɤ")
		(Insert\ All\ Records\ into\ BBDB "BBDBƤΥ쥳ɤ")
;		(--- "---")
		(Get\ Email "Żҥ᡼륢ɥ쥹")
		(Get\ Phone "ֹ")
		(List\ Valid\ Attribute\ Names "ͭ°̾ΰ")
;		(--- "---")
		(Customize "ޥ"
			   (Eudc\.\.\. "Eudc...")
;			   (nil "--")
			   (Eudc\ Ph "Eudc Ph")
			   (Eudc\ Ldap "Eudc Ldap")
			   (Eudc\ Bbdb "Eudc Bbdb")
			   (Eudc\ Server\.\.\. "...")
			   (Eudc\ Protocol\.\.\. "ץȥ...")
			   (Eudc\ Strict\ Return\ Matches\.\.\. "Υޥå̩ˤ...")
			   (Eudc\ Default\ Return\ Attributes\.\.\. "°Υǥե...")
			   (Eudc\ Multiple\ Match\ Handling\ Method\.\.\. "ʣޥåνˡ...")
			   (Eudc\ Duplicate\ Attribute\ Handling\ Method\.\.\. "ʣ°ޤνˡ...")
			   (Format\ of\ Inline\ Expansion\ Queries\.\.\. "饤ŸΥե...")
			   (Eudc\ Expansion\ Overwrites\ Query\.\.\. "ʸ񤭤Ÿ...")
			   (Eudc\ Inline\ Expansion\ Format\.\.\. "饤Ÿν...")
			   (Eudc\ Inline\ Expansion\ Servers\.\.\. "饤Ÿ...")
			   (Max\ Number\ of\ Servers\ to\ Query\.\.\. "䤤碌륵Фκ...")
			   (Attributes\ in\ Query\ Forms\.\.\. "ե°...")
			   (User-defined\ Names\ of\ Directory\ Attributes\.\.\. "ǥ쥯ȥ°Υ桼̾...")
			   (Eudc\ Use\ Raw\ Directory\ Names\.\.\. "Υǥ쥯ȥ°̾...")
			   (Attribute\ Decoding\ Functions\.\.\. "°ͤǥɤؿ...")
			   (External\ Viewer\ Programs\.\.\. "ӥ塼ץ...")
			   (Eudc\ Options\ File\.\.\. "СۥåȥꥹȤ¸ե...")
			   (Eudc\ Mode\ Hook\.\.\. "Eudc⡼ɥեå...")
		))
;	    (separator-net "--")
	    (calendar "")
	    (calc "")
	    (simple-calculator "")
;	    (separator-encryption-decryption "--")
	    (encryption-decryption "Ź沽/沽"
				   (decrypt-file "ե沽...")
				   (encrypt-file "եŹ沽...")
				   (verify-file "ե򸡾...")
				   (sign-file "ե˽̾...")
				   (separator-file "--")
				   (decrypt-region "ϰϤ沽")
				   (encrypt-region "ϰϤŹ沽")
				   (verify-region "ϰϤ򸡾")
				   (sign-region "ϰϤ˽̾")
				   (separator-keys "--")
				   (list-keys "ΰ")
				   (import-keys "ե뤫鸰򥤥ݡ...")
				   (import-keys-region "ϰϤ鸰򥤥ݡ")
				   (export-keys "򥨥ݡ")
				   (insert-keys "")
				   )
;	    (separator-games "--")
	    (games ""
	        (5x5 "5x5")
		(adventure "ɥ٥㡼")
		(black-box "֥åܥå")
		(bubbles "Х֥륺")
		(gomoku "¤")
		(hanoi "ϥΥ")
		(life "饤ե")
		(mult "ݤѥ")
		(pong "ԥݥ")
		(snake "͡")
		(solitaire "ƥ")
		(tetris "ƥȥꥹ")
		(zone "󥢥")
		)
	    )
     (edit "Խ"
	   (undo "᤹")
	   (redo "ľ")
	   (cut "ڤ")
	   (copy "ԡ")
	   (paste "Žդ")
	   (paste-from-menu "Žդ(˥塼)"
			 ;; ...
			 )
	   (clear "")
	   (mark-whole-buffer "")
;	   (separator-edit "--")
	   (search ""
		   (search-forward "...")
		   (search-backward "...")
		   (re-search-forward "(ɽ)...")
		   (re-search-backward "(ɽ)...")
;		   (separator-repeat-search "--")
		   (repeat-search-fwd "򸡺")
		   (repeat-search-back "򸡺")
;		   (separator-tag-search "--")
		   (tags-srch "դեǸ...")
		   (tags-continue "η֤")
;		   (separator-tag-isearch"--")
		   (i-search "󥯥󥿥륵"
			     (isearch-forward "...")
			     (isearch-backward "...")
			     (isearch-forward-regexp "(ɽ)...")
			     (isearch-backward-regexp "(ɽ)...")
			     ))
	   (replace "ִ"
		    (query-replace "ִ...")
		    (query-replace-regexp "ִ(ɽ)...")
;		    (separator-replace-tags "--")
		    (tags-repl "դեִ...")
		    (tags-repl-continue "ִη֤")
		    )
	   (goto ""
		 (go-to-line "Ԥ˥...")
		 (go-to-pos "Хåեλ֤˥...")
		 (beg-of-buf "ХåեƬ˥")
		 (end-of-buf "Хåե˥")
;		 (separator-tags "--")
		 (find-tag "򸡺...")
		 (find-tag-otherw "¾Υɥǥ򸡺...")
		 (next-tag "Υ򸡺")
		 (next-tag-otherw "¾ΥɥǼΥ򸡺")
		 (apropos-tags "򸡺(ɽ)...")
;		 (separator-tag-file "--")
		 (set-tags-name "ե̾...")
		 )
	   (bookmark "֥åޡ"
		     (jump "֥åޡإ...")
		     (set "֥åޡ...")
		     (insert "Ƥ...")
		     (locate "...")
		     (rename "֥åޡ̾ѹ...")
		     (delete "֥åޡ...")
		     (edit "֥åޡꥹȤԽ")
		     (save "֥åޡ¸")
		     (write "̾Ĥ¸...")
		     (load "֥åޡեɤ߹..."))
;	   (separator-bookmark "--")
	   (fill "ԤĹ·")
	   (props ""
		  (fc ""
		      (100 "ɸ")
		      (98 "")
		      (105 "")
		      (108 "")
		      (117 "դ")
		      (111 "¾..."))
		  (fg "迧"
		      (111 "¾..."))
		  (bg "طʿ"
		      (111 "¾..."))
		  (sp "ü°"
		      (114 "߶ػ")
		      (118 "ԲĻ")
		      (116 "ԲĿ")
		      (115 "ü°μä"))
;		  (s2 "--")
		  (ju ""
		      (117 "ʤ")
		      (108 "")
		      (114 "")
		      (98 "")
		      (99 ""))
		  (in "ǥ"
		      (increase-left-margin "䤹")
		      (decrease-left-margin "餹")
		      (increase-right-margin "䤹()")
		      (decrease-right-margin "餹()"))
;		  (s1 "--")
		  (rm "ե(ʸ°)ɸ᤹")
		  (ra "ɸ᤹")
		  (dp "°ξ֤򸫤")
		  (df "եΰ򸫤")
		  (dc "ΰ򸫤"))
	   )
     (options "ץ"
	      (transient-mark-mode "ΰζĴɽ")
	      (highlight-paren-mode "פ̤Ĵɽ(ɽ⡼)")
;	      (highlight-separator "--")
	      ,@(if (= emacs-major-version 23)
		    '((line-wrapping "Ԥޤ֤"
				     (window-wrap "ɥüޤ֤")
				     (truncate "ĹԤڤͤɽ")
				     (word-wrap "ɥå(Visual line mode)")
				     )))
	      (truncate-lines "ĹԤޤ֤ɽ")
	      (auto-fill-mode "ƥȥ⡼ɤǼưޤ֤")
	      (case-fold-search "ʸʸ̤ʤ")
	      (cua-emulation-mode "Shift+륭ϰ(CUA)")
	      (cua-mode "C-x/C-c/C-vǥåȡڡ(CUA)")
;	      (edit-options-separator "--")
	      (uniquify "Хåե̾˥ǥ쥯ȥ̾ޤ")
	      (save-place "åξ֤¸")
;	      (cursor-separator "--")
	      (blink-cursor-mode "Ǥ륫")
;	      (debugger-separator "--")
	      (debug-on-error "顼ȯ˥ǥХåذܤ")
	      (debug-on-quit "(C-g)˥ǥХåذܤ")
;	      (mule-separator "--")
	      (mule ""
		    ,(append '(set-language-environment "Ķ") menu-tree-alist-ja-langs)
;		    (separator-mule "--")
		    (toggle-input-method "ץåȥ᥽åɤΥ/")
		    (set-input-method "ץåȥ᥽åɤ...")
;		    (separator-input-method "--")
		    (set-various-coding-system "ʸɤ"
					       (universal-coding-system-argument "˼¹Ԥ륳ޥ")
;					       (separator-1 "--")
					       (set-buffer-file-coding-system "ߤΥХåե")
					       (revert-buffer-with-coding-system  "Υեɤ߹")
					       (set-file-name-coding-system "ե̾")
					       (set-keyboard-coding-system "ܡ")
					       (set-terminal-coding-system "ߥʥ")
					       (set-selection-coding-system "ɥƥΥåץܡ")
					       (set-next-selection-coding-system "Υåץܡ")
					       (set-buffer-process-coding-system "֥ץФ")
					       )
;		    (separator-coding-system "--")
		    (view-hello-file "¿ޤʸ")
		    ,(append '(describe-language-environment "Ķ") menu-tree-alist-ja-langs)
		    (describe-input-method "ץåȥ᥽åɤ...")
		    (describe-coding-system "ʸɤ...")
		    (list-character-sets "饯åȤΰ")
		    (mule-diag "¿첽ǽξ֤ɽ"))
;	      (showhide-separator "--")
	      (showhide "ɽ/ɽ"
			(showhide-tool-bar "ġС")
			(menu-bar-mode "˥塼С")
			(showhide-tooltip-mode "ġå")
			(showhide-scroll-bar "С"
					     (none "ʤ")
					     (left "¦")
					     (right "¦")
					     )
			(showhide-fringe "ե"
					 (none "ʤ")
					 (left "¦")
					 (right "¦")
					 (default "ɸ")
					 (customize "ե󥸤Υޥ")
					 (indicate-empty-lines "ԤΥ󥸥")
					 (showhide-fringe-ind "Хåեζ"
							      (none "󥸥ʤ")
							      (left "¦")
							      (right "¦")
							      (box "¦(ʤ)")
							      (mixed "¦(¦)")
							      (customize "¾(ޥ)")
							      ))
			(showhide-speedbar "ԡɥС")
;			(datetime-separator "--")
			(showhide-date-time "١᡼")
			(showhide-battery "Хåƥ꡼ξ")
;			(linecolumn-separator "--")
			(size-indication-mode "Хåե")
			(line-number-mode "ֹ")
			(column-number-mode "ֹ")
			)
	      ,@(if (= emacs-major-version 23)
		    '((menu-set-font "ɸΥեȤ...")))
	      (mouse-set-font "ե/եȥå...")
;	      (custom-separator "--")
	      (save "ץ¸")
	      (customize "ޥ"
			 (customize "ȥåץ٥륰롼")
			 (customize-browse "롼פγɽ")
;			 (separator-3 "--")
			 (customize-saved "¸줿Ťץ")
			 (customize-changed-options "ߤΥץ...")
			 (customize-option "ꤷץ...")
			 (customize-face "ꤷե...")
			 (customize-group "ꤷ롼...")
;			 (separator-2 "--")
			 (customize-apropos "ɽǸ...")
			 (customize-apropos-options "ɽǸ(ץ)...")
			 (customize-apropos-faces "ɽǸ(ե)...")
			 (customize-apropos-groups "ɽǸ(롼)..."))
	      )
     (help-menu "إ"
		(emacs-tutorial "Emacs塼ȥꥢ")
		(emacs-tutorial-language-specific "Emacs塼ȥꥢ()...")
		(emacs-faq "EmacsΤ褯Ȥβ")
		(emacs-news "Emacs˥塼")
		(emacs-known-problems "EmacsδΤ")
		(send-emacs-bug-report "ХݡȤ...")
		(emacs-psychotherapist "Emacsʰ")
		,@(if (= emacs-major-version 22)
		      '((emacs-problems "EmacsδΤ")
			(report-emacs-bug "ХݡȤ...")
			(eliza "Emacsʰ")))
;		(sep1 "--")
		(debian-emacs-readme "Debian README")
		(debian-emacs-news "Debian˥塼")
		(debian-emacs-changelog "Debianѹ")
;		(sep2 "--")
		(search-documentation "ʸ򸡺"
				      (emacs-terminology "Emacs˴ؤѸ")
				      (lookup-subject-in-emacs-manual "桼ޥ˥奢Ǹ...")
				      (lookup-subject-in-elisp-manual "ELispޥ˥奢Ǹ...")
				      (lookup-key-in-manual "桼ޥ˥奢ǥХɤ򸡺...")
				      (lookup-command-in-manual "桼ޥ˥奢ǥޥɤ򸡺...")
;				      (sep1 "--")
				      (find-commands-by-name "ޥ̾Ĵ٤...")
				      (find-options-by-name "ץ̾Ĵ٤...")
				      (find-option-by-value "ץͤĴ٤...")
				      (find-any-object-by-name "ƤΥ֥Ȥоݤ̾Ĵ٤...")
				      (search-documentation-strings "ؿѿʸ򸡺...")
				      )
		,@(if (= emacs-major-version 22)
		      '((apropos "ʸ򸡺"
				 (emacs-glossary "Emacs˴ؤѸ")
				 (emacs-index-search "桼ޥ˥奢Ǹ...")
				 (elisp-index-search "ELispޥ˥奢Ǹ...")
				 (emacs-key-command-node "桼ޥ˥奢ǥХɤ򸡺...")
				 (emacs-command-node "桼ޥ˥奢ǥޥɤ򸡺...")
;				 (sep1 "--")
				 (apropos-commands "ޥ̾Ĵ٤...")
				 (apropos-variables "ץ̾Ĵ٤...")
				 (apropos-value "ץͤĴ٤...")
				 (apropos "ƤΥ֥Ȥоݤ̾Ĵ٤...")
				 (apropos-documentation "ؿѿʸ򸡺...")
				 )))
		(describe ""
			  (describe-mode "ХåեΥ⡼")
			  (describe-key-1 "ܡɤȥޥ...")
			  (describe-function "ؿ...")
			  (describe-variable "ѿ...")
			  (describe-face "ե...")
			  (describe-current-display-table "ɽơ֥")
			  (list-keybindings "դ")
			  ,(append '(describe-language-environment "Ķ") menu-tree-alist-ja-langs)
			  (describe-input-method "ץåȥ᥽å...")
			  (describe-coding-system "ʸ...")
			  (describe-coding-system-briefly "ʸ()")
			  (mule-diag "¿첽ǽξ֤ɽ")
			  )
		(emacs-manual "Emacsޥ˥奢ɤ")
		(more-manuals "¾Υޥ˥奢"
			      (emac-lisp-intro "Emacs Lisp")
			      (emacs-lisp-reference "Emacs Lispե")
			      (other-manuals "¾ƤΥޥ˥奢(Info)")
			      (lookup-subject-in-all-manuals "ƤΥޥ˥奢뤫鸡...")
			      (order-emacs-manuals "ޥ˥奢ʸˡ")
;			      (sep2 "--")
			      (man "Man Pageɤ...")
			      )
		(find-emacs-packages "EmacsѥåĴ٤")
		(external-packages "ѥå")
;		(sep3 "--")
		(getting-new-versions "СEmacsˡ")
		,@(if (= emacs-major-version 22)
		      '((manuals "¾Υޥ˥奢"
				 (info-elintro "Emacs Lisp")
				 (info-lisp "Emacs Lispե")
				 (info "¾ƤΥޥ˥奢(Info)")
				 (info-apropos "ƤΥޥ˥奢뤫鸡...")
				 (order-emacs-manuals "ޥ˥奢ʸˡ")
;				 (sep2 "--")
				 (man "Man Pageɤ...")
				 )
			(finder-by-keyword "EmacsѥåĴ٤")
			(more "ѥå")
			(describe-distribution "СEmacsˡ")
			))
		(describe-copying "饤ʸ򸫤")
		(describe-no-warranty "(̵)ݾ")
;		(sep4 "--")
		(about-emacs "EmacsˤĤ")
		,@(if (= emacs-major-version 22)
		      '((about "EmacsˤĤ")))
		(about-gnu-project "GNUˤĤ")
		)
     )
    (minibuffer-local-map
     (minibuf "ߥ˥Хåե"
	      (return "")
	      (quit "λ")
	      ))
    (minibuffer-local-completion-map
     (minibuf "ߥ˥Хåե"
	      (tab "䴰")
	      (space "ñ䴰")
	      (63 "䴰ΰ")
	      ))
    (help-mode-map
     (Help-Mode "إץ⡼"
		(Show\ Help\ for\ Symbol "֤ˤ륷ܥΥإ")
		(Previous\ Topic "Υȥԥå")
		(Next\ Topic "Υȥԥå˿ʤ")
		(Move\ to\ Previous\ Button "Υܥذư")
		(Move\ to\ Next\ Button "Υܥذư")
		))
    (Info-mode-map
     (Info "Info⡼"
	   (Up "")
	   (Next "")
	   (Previous "")
	   (Backward "Υڡ")
	   (Forward "Υڡ")
	   (Beginning "Υڡκǽ")
	   (Top "־")
	   (Final\ Node "ֺǸΥڡ")
	   (Menu\ Item "ΥڡΥ˥塼")
	   (Reference "Υڡλ")
	   (Search\.\.\. "...")
	   (Search\ Next "򸡺")
	   (Go\ to\ Node\.\.\. "ڡ...")
	   (Back\ in\ history "")
	   (Forward\ in\ history "ʤ")
	   (History "")
	   (Table\ of\ Contents "ܼ")
	   (Index ""
		  (Lookup\ a\ String\.\.\. "ʸ򸡺...")
		  (Next\ Matching\ Item "򸡺")
		  (Lookup\ a\ string\ in\ all\ indices\.\.\. "Ƥκ鸡...")
	    )
	   (Copy\ Node\ Name "ڡΥȥ򥳥ԡ")
	   (Clone\ Info\ buffer "InfoХåեʣ")
	   (Exit "λ")
	   ))
    (outline-mode-map
     (headings "Ф"
	       (outline-up-heading "γ")
	       (outline-next-visible-heading "")
	       (outline-previous-visible-heading "")
	       (outline-forward-same-level "(Ʊ)")
	       (outline-backward-same-level "(Ʊ)")
	       (outline-insert-heading "θФ")
	       (copy "ԡ")
	       (move-subtree-up "ذư")
	       (move-subtree-down "ذư")
	       (promote-subtree "ؤ夲")
	       (demote-subtree "ؤ򲼤")
	       )
     (show "ɽ"
	   (show-all "")
	   (show-entry "֤߰ʸ")
	   (show-branches "γؤθФ")
	   (show-children "1ĲγؤθФ")
	   (show-subtree "γ")
	   )
     (hide ""
	   (hide-leaves "γؤʸ")
	   (hide-body "ʸΤʸ")
	   (hide-entry "֤߰ʸ")
	   (hide-subtree "γ")
	   (hide-sublevels "ʸΤβγ")
	   (hide-other "ְ߰ʳʸ")
	   ))
    (custom-mode-map
     (Custom ""
	     (Customize "ޥ")
	     ,@(if (= emacs-major-version 23)
		   '((Set\ for\ current\ session "ߤΥåŬ")
		     (Save\ for\ future\ sessions "ѹ¸Ŭ")
		     (Undo\ edits "Խä")
		     (Reset\ to\ saved "¸Ƥ֤᤹")
		     (Erase\ customizations "Ƥɸξ֤᤹")
		     (Help\ for\ Customize "ޥΥإ")
		     (Exit "λ")))
	     ,@(if (= emacs-major-version 22)
		   '((Set "ߤΥåŬ")
		     (Save "ѹ¸Ŭ")
		     (Undo\ Edits "Խä")
		     (Reset\ to\ Saved "¸Ƥ֤᤹")
		     (Erase\ Customization "Ƥɸξ֤᤹" )
		     (Info "")))
	     ))
    ,@(if (= emacs-major-version 23)
	  '((lisp-interaction-mode-map
	     (lisp-interaction "Lisp-Interaction"
			       (lisp-complete-symbol "Lispܥ䴰")
			       (indent-pp-sexp "ǥȤޤ")
			       (edebug-defun-lisp-interaction "ؿ򥤥󥹥ĥȤƥǥХå")
			       (eval-print-last-sexp "ɾɽ")
			       (eval-defun "ؿɾ")
			       ))))
    (emacs-lisp-mode-map
     (emacs-lisp "Emacs-Lisp"
		 (indent-line "Ԥ򥤥ǥ")
		 (indent-region "ΰ򥤥ǥ")
		 (comment-region "ΰ򥳥ȥ")
;		 (separator-format "--")
		 (eval-sexp "S-ɾ")
		 (eval-region "ΰɾ")
		 (eval-buffer "Хåեɾ")
		 ,@(if (= emacs-major-version 23)
		       '((ielm "󥿥饯ƥ֤˼ɾ")))
;		 (separator-eval "--")
		 (byte-compile "ΥեХȥѥ")
		 (emacs-byte-compile-and-load "Хȥѥ뤷ɤ߹")
		 (byte-recompile "ǥ쥯ȥХȥѥ...")
		 ,@(if (= emacs-major-version 23)
		       '((disas "Хȥѥ뤵줿֥Ȥեѥ...")))
;		 (separator-byte "--")
		 (edebug-defun "ؿǥХåϿ")
		 ,@(if (= emacs-major-version 23)
		       '((profiling "ץե"
				    (prof-func "ؿ򥤥󥹥ĥ...")
				    (prof-pack "ѥå򥤥󥹥ĥ...")
				    (prof-res "ץե󥰤η̤ɽ")
				    (prof-resfunc "ؿΥ󥿤ꥻå...")
				    (prof-resall "ƤδؿΥ󥿤ꥻå")
;				    (sep-rem "--")
				    (prof-restfunc "ؿΥ󥹥ĥơ...")
				    (prof-restall "ƤδؿΥ󥹥ĥơ")
				    )
			 (tracing "ȥ졼"
				  (tr-f "ؿȥ졼...")
				  (tr-q "ؿȥ졼(Ϥ)...")
;				  (tr-sep "--")
				  (tr-uf "ؿΥȥ졼...")
				  (tr-a "ƤδؿΥȥ졼")
				  )
			 (re-builder "ɽ(RE-Builder)")
			 (checkdoc "ʸ򸡺")
			 (eldoc "ʸưŪɽ")))
		 ))
    ,@(if (= emacs-major-version 23)
	  '((reb-mode-map
	     (reb-mode "Re-Builder"
		       (rc "ߤɽ򥳥ԡ")
		       (rp "Υޥåذư")
		       (rn "Υޥåذư")
		       (ru "Ū˹")
		       (re "ʬɽ⡼ɤ")
		       (rs "󥿥åѹ...")
		       (rb "оݤΥХåեѹ...")
		       (rt "ʸ/ʸ̤")
		       (rq "λ")
		       ))))
    (dired-mode-map
     (operate "ե"
	      (copy "ԡ...")
	      (rename "̾ѹ...")
	      (delete "")
	      (command "ե˥ޥɤ¹...")
	      (symlink "ܥå󥯤...")
	      (hardlink "ϡɥ󥯤...")
	      (print "...")
	      (compress "")
	      (compile "Хȥѥ")
	      (load "ɤ߹")
	      (touch "ॹפѹ")
	      (chmod "°ѹ...")
	      (chgrp "롼פѹ...")
	      (chown "ͭԤѹ...")
	      (search "ե򸡺...")
	      (query-replace "եִ...")
;	      (dashes-3 "--")
	      (image-dired-display-thumbs "Υͥɽ")
	      (image-dired-dired-comment-files "˥Ȥղ...")
	      (image-dired-tag-files "᡼ղ...")
	      (image-dired-delete-tag "᡼...")
	      )
     (mark "ޡ"
	   (toggle-marks "ޡȿž")
	   (mark "ޡ")
	   (unmark "ޡä")
	   (deletion "Ѥ˥ޡ")
	   (auto-save-files "ư¸ե")
	   (backup-files "Хååץե")
	   (garbage-files "פʥե")
	   (executables "¹ԥե")
	   (directory "ŤХååץե")
	   (directories "ǥ쥯ȥ")
	   (symlinks "ܥå")
	   (unmark-all "ޡƾä")
	   (marks "ޡμѹ...")
	   (next "Υޡذư")
	   (prev "Υޡذư"))
     (regexp "ɽ"
	     (mark-cont "եƤǥޡ...")
	     (mark "ޡ...")
	     (flag "Ѥ˥ޡ...")
	     (copy "ԡ...")
	     (rename "̾ѹ...")
	     (symlink "ܥå󥯤...")
	     (hardlink "ϡɥ󥯤...")
	     (upcase "ե̾ʸˤ")
	     (downcase "ե̾ʸˤ")
;	     (dashes-1 "--")
	     (image-dired-mark-tagged-files "᡼ǥޡ...")
	     )
     (immediate "¨¹"
	      (wdired-mode "ե̾DiredХåեԽ(WDired)")
	      (create-directory "ǥ쥯ȥ...")
	      (find-file "եԽ")
	      (find-file-other-window "̤ΥɥԽ")
	      (display "̤ΥɥǱ")
	      (view "ե")
	      (diff "ʬ...")
	      (backup-diff "ХååץեȤκʬ")
	      (compare-directories "ǥ쥯ȥ...")
;	      (dashes "--")
	      (revert-buffer "ɽ")
;	      (dashes-4 "--")
	      (image-dired-dired-display-image "ɽ")
	      (image-dired-dired-display-external "ӥ塼ǲɽ")
	      )
     (subdir "֥ǥ쥯ȥ"
	     (insert "֥ǥ쥯ȥɽ")
	     (next-dirline "Υǥ쥯ȥ")
	     (prev-dirline "Υǥ쥯ȥ")
	     (next-subdir "Υ֥ǥ쥯ȥ")
	     (prev-subdir "Υ֥ǥ쥯ȥ")
	     (up "Υǥ쥯ȥ")
	     (tree-up "Υ֥ǥ쥯ȥ")
	     (tree-down "Υ֥ǥ쥯ȥ")
	     (hide-subdir "֥ǥ쥯ȥɽ/ɽ")
	     (hide-all "ƤΥ֥ǥ쥯ȥɽ/ɽ")
	     ))
    (wdired-mode-map
     (wdired "DiredХåեԽ"
	     (wdired-finish-edit "ѹŬ")
	     (wdired-abort-changes "")
;	     (dashes "--")
	     (wdired-customize "ץ")
	     ))
    (image-dired-display-image-mode-map
     (image-dired "ǥ쥯ȥꥨǥ"
		  (image-dired-display-current-image-full "Υ")
		  (image-dired-display-current-image-sized "ɥ˹碌")
		  (image-dired-kill-buffer-and-window "λ")
		  ))
    (image-dired-thumbnail-mode-map
     (image-dired "ǥ쥯ȥꥨǥ"
		  (image-dired-display-thumbnail-original-image "ɽ")
		  (image-dired-thumbnail-display-external "ӥ塼ɽ")
		  (image-dired-mark-thumb-original-file "եޡ")
		  (image-dired-unmark-thumb-original-file "եΥޡä")
		  (image-dired-flag-thumb-original-file "եѤ˥ޡ")
		  (image-dired-track-original-file "Υե˰ư")
		  (image-dired-jump-original-dired-buffer "DiredХåեإ")
		  (image-dired-toggle-movement-tracking "եؤΰưON/OFF")
		  (image-dired-rotate-original-right "Υե򱦲ž")
		  (image-dired-rotate-original-left "Υե򺸲ž")
		  (image-dired-rotate-thumbnail-right "ͥ򱦲ž")
		  (image-dired-rotate-thumbnail-left "ͥ򺸲ž")
		  (image-dired-line-up "ͥ")
		  (image-dired-line-up-dynamic "ưŪ")
		  (image-dired-refresh-thumb "ͥ򹹿")
		  (image-dired-comment-thumbnail "ͥ˥Ȥղ")
		  (image-dired-tag-thumbnail "ͥ˥դ")
		  (image-dired-tag-thumbnail-remove "ͥΥ")
		  (image-dired-delete-char "ͥ")
		  (image-dired-kill-buffer-and-window "λ")
		  ))
    (eudc-hotlist-mode-map
     (EUDC\ Hotlist\ Edit "EUDCۥåȥꥹԽ"
;	(--- "---")
	(Add\ New\ Server "")
	(Delete\ Server "Ф")
	(Select\ Server "Ф")
	(Transpose\ Servers "Фؤ")
	(Save\ and\ Quit "¸ƽλ")
	(Exit\ without\ Saving "¸˽λ")
	))
    (calendar-mode-map
     ,@(if (= emacs-major-version 23)
	   '((Scroll ""
		     (Forward\ 1\ Month "1")
		     (Forward\ 3\ Months "3")
		     (Forward\ 1\ Year "1ǯ")
		     (Backward\ 1\ Month "1")
		     (Backward\ 3\ Months "3")
		     (Backward\ 1\ Year "1ǯ")
		     )
	     (Goto ""
		   (Today "")
		   (Beginning\ of\ Week "ν")
		   (End\ of\ Week "ν")
		   (Beginning\ of\ Month "ν")
		   (End\ of\ Month "ν")
		   (Beginning\ of\ Year "ǯν")
		   (End\ of\ Year "ǯν")
		   (Other\ Date "ǯ")
		   (Day\ of\ Year "ǯ餫")
		   (ISO\ Week "ǯ餫ν")
		   (ISO\ Date "ǯ餫ν")
		   (Astronomical\ Date "ŷʸŪ(ꥦ)")
		   (Hebrew\ Date "")
		   (Persian\ Date "ڥ륷")
		   (Baha\'i\ Date "Хϡ")
		   (Islamic\ Date "")
		   (Julian\ Date "ꥦ")
		   (Chinese\ Date "")
		   (Coptic\ Date "ץ")
		   (Ethiopic\ Date "ԥ")
		   (Mayan\ Date "ޥ"
				(Next\ Tzolkin "Υĥ륭")
				(Previous\ Tzolkin "Υĥ륭")
				(Next\ Haab "Υϥ")
				(Previous\ Haab "Υϥ")
				(Next\ Round "Υ饦")
				(Previous\ Round "Υ饦")
				)
		   (French\ Date "ե")
		   )))
     ,@(if (= emacs-major-version 22)
	   '((scroll ""
		     (fwd-1 "1")
		     (fwd-3 "3")
		     (fwd-12 "1ǯ")
		     (bk-1 "1")
		     (bk-3 "3")
		     (bk-12 "1ǯ")
		     )
	     (goto ""
		   (today "")
		   (beginning-of-week "ν")
		   (end-of-week "ν")
		   (beginning-of-month "ν")
		   (end-of-month "ν")
		   (beginning-of-year "ǯν")
		   (end-of-year "ǯν")
		   (gregorian "ǯ")
		   (day-of-year "ǯ餫")
		   (iso-week "ǯ餫ν")
		   (iso "ǯ餫ν")
		   (astro "ŷʸŪ(ꥦ)")
		   (hebrew "")
		   (persian "ڥ륷")
		   (islamic "")
		   (julian "ꥦ")
		   (chinese "")
		   (coptic "ץ")
		   (ethiopic "ԥ")
		   (mayan "ޥ"
			  (next-tzol "Υĥ륭")
			  (prev-tzol "Υĥ륭")
			  (next-haab "Υϥ")
			  (prev-haab "Υϥ")
			  (nxt-rnd "Υ饦")
			  (prev-rnd "Υ饦")
			  )
		   (french "ե")
		   )))
     (Holidays ""
	       ,@(if (= emacs-major-version 23)
		     '((For\ Cursor\ Date\ -	(concat "֤ - " (calendar-date-string (calendar-cursor-to-date) t t)))
		       (For\ Window\ -		(concat "ɥ - " (cal-menu-holiday-window-suffix)))
		       (For\ Today\ -		(concat " - " (calendar-date-string (calendar-current-date) t t)))
;		       (nil "--")
		       (hol-year-0 (format "%dǯ" (+ displayed-year -5)))
		       (hol-year-1 (format "%dǯ" (+ displayed-year -4)))
		       (hol-year-2 (format "%dǯ" (+ displayed-year -3)))
		       (hol-year-3 (format "%dǯ" (+ displayed-year -2)))
		       (hol-year-4 (format "%dǯ" (+ displayed-year -1)))
		       (hol-year-5 (format "%dǯ" (+ displayed-year 0)))
		       (hol-year-6 (format "%dǯ" (+ displayed-year 1)))
		       (hol-year-7 (format "%dǯ" (+ displayed-year 2)))
		       (hol-year-8 (format "%dǯ" (+ displayed-year 3)))
		       (hol-year-9 (format "%dǯ" (+ displayed-year 4)))
		       (hol-year-10 (format "%dǯ" (+ displayed-year 5)))
		       ))
	       ,@(if (= emacs-major-version 22)
		     '((1-day	(concat "֤ - " (calendar-date-string (calendar-cursor-to-date) t t)))
		       (3-month	(concat "ɥ - " (cal-menu-holiday-window-suffix)))
		       (today	(concat " - " (calendar-date-string (calendar-current-date) t t)))
;		       (nil "--")
		       ((intern (format "For Year %d" (+ displayed-year -5))) (format "%dǯ" (+ displayed-year -5)))
		       ((intern (format "For Year %d" (+ displayed-year -4))) (format "%dǯ" (+ displayed-year -4)))
		       ((intern (format "For Year %d" (+ displayed-year -3))) (format "%dǯ" (+ displayed-year -3)))
		       ((intern (format "For Year %d" (+ displayed-year -2))) (format "%dǯ" (+ displayed-year -2)))
		       ((intern (format "For Year %d" (+ displayed-year -1))) (format "%dǯ" (+ displayed-year -1)))
		       ((intern (format "For Year %d" (+ displayed-year 0))) (format "%dǯ" (+ displayed-year 0)))
		       ((intern (format "For Year %d" (+ displayed-year 1))) (format "%dǯ" (+ displayed-year 1)))
		       ((intern (format "For Year %d" (+ displayed-year 2))) (format "%dǯ" (+ displayed-year 2)))
		       ((intern (format "For Year %d" (+ displayed-year 3))) (format "%dǯ" (+ displayed-year 3)))
		       ((intern (format "For Year %d" (+ displayed-year 4))) (format "%dǯ" (+ displayed-year 4)))
		       ((intern (format "For Year %d" (+ displayed-year 5))) (format "%dǯ" (+ displayed-year 5)))
		       ))
;	       (nil "--")
	       (Unmark\ Calendar "Υޡä")
	       (Mark\ Holidays "ޡ")
	       )
     ,@(if (= emacs-major-version 23)
	   '((Diary ""
		    (Other\ File "¾Υե")
		    (Cursor\ Date "֤")
		    (Mark\ All "ƥޡ")
		    (Show\ All "ɽ")
		    (Insert\ Diary\ Entry "")
		    (Insert\ Weekly "ñ")
		    (Insert\ Monthly "ñ")
		    (Insert\ Yearly "ǯñ")
		    (Insert\ Anniversary "ǰ")
		    (Insert\ Block "֥å")
		    (Insert\ Cyclic "Ū")
		    (Insert\ Baha\'i "Хϡ"
				     (\  (concat "  " (calendar-bahai-date-string (calendar-cursor-to-date))))
				     (One\ time "1¤")
				     (Monthly "ñ")
				     (Yearly "ǯñ")
				     )
		    (Insert\ Islamic ""
				     (\  (concat "  " (calendar-islamic-date-string (calendar-cursor-to-date))))
				     (One\ time "1¤")
				     (Monthly "ñ")
				     (Yearly "ǯñ")
				     )
		    (Insert\ Hebrew ""
				    (\  (concat "  " (calendar-hebrew-date-string (calendar-cursor-to-date))))
				    (One\ time "1¤")
				    (Monthly "ñ")
				    (Yearly "ǯñ")
				    )
		    )
	     (Moon ""
		   (Lunar\ Phases "")
		   )
	     (Sun/Moon "/"
		       (Lunar\ Phases "")
		       (Sunrise/sunset\ for\ cursor\ date "֤ν/")
		       (Sunrise/sunset\ for\ cursor\ month "֤ην/")
		       )
	     ))
     ,@(if (= emacs-major-version 22)
	   '((diary ""
		    (view "¾Υե")
		    (mark "ƥޡ")
		    (all "ɽ")
		    (ent "")
		    (wk "ñ")
		    (mon "ñ")
		    (yr "ǯñ")
		    (ann "ǰ")
		    (blk "֥å")
		    (cyc "Ū")
		    (baha "Хϡ")
		    (isl "")
		    (heb "")
		    )
	     (moon ""
		   (moon "")
		   )
	     ))
     )
    (calc-mode-map
     (Calc ""
	   (Arithmetic ""
		       (Basic "")
		       (Rounding "")
		       (Complex\ Numbers "ʣǿ")
		       (Conversion "Ѵ")
		       (Binary "2ʿ")
;		       (nil "-------")
		       (Help\ on\ Arithmetic "ѤΥإ")
		       )
	   (Scientific\ Functions "ʳشؿ"
				  (Constants "")
				  (Logs\ and\ Exps "пؿ")
				  (Trigonometric\ Functions "Ѵؿ")
				  (Hyperbolic\ Functions "жؿ")
				  (Advanced\ Math\ Functions "٤ʴؿ")
				  (Combinatorial\ Functions "ȹ礻")
;				  (nil "----")
				  (Help\ on\ Scientific\ Functions "ʳشؿΥإ")
				  )
	   (Algebra ""
		    (Simplification "ñ")
		    (Manipulation "")
		    (Polynomials "¿༰")
		    (Calculus "ʬ")
		    (Solving "")
		    (Curve\ Fitting "")
;		    (nil "----")
		    (Help\ on\ Algebra "Υإ")
		    )
	   (Graphics ""
		     (Graph\ 2D\ \[\(1:\)=\ y\ values\,\ \(2:\)=\ x\ values\] "ʿ̤Υ [(1:)= yɸ, (2:)= xɸ]")
		     (Graph\ 3D\ \[\(1:\)=\ z\ values\,\ \(2:\)=\ y\ values\,\ \(3:\)=\ x\ values\] "֤Υ [(1:)= zɸ, (2:)= yɸ, (3:)= xɸ]")
;		     (nil "----")
		     (Help\ on\ Graphics "դΥإ")
		     )
	   (Matrices/Vectors "󡦥٥ȥ"
			     (Matrices "")
			     (Vectors "٥ȥ")
			     (Vectors\ As\ Sets "ͤȤȤƤΥ٥ȥ")
			     (Statistics\ On\ Vectors "٥ȥ")
			     (Abbreviate\ long\ vectors "Ĺ٥ȥûɽ")
;			     (nil "----")
			     (Help\ on\ Matrices/Vectors "󡦥٥ȥΥإ")
			     )
	   (Units "ñ"
		  (Convert\ units\ in\ \(1:\) "ñ̤(1:)Ѵ")
		  (Convert\ temperature\ in\ \(1:\) "٤(1:)Ѵ")
		  (Simplify\ units\ in\ \(1:\) "ñ̤(1:)˴ñ")
		  (View\ units\ table "ñ̤ΰɽ")
;		  (nil "----")
		  (Help\ on\ Units "ñ̤Υإ")
		  )
	   (Variables "ѿ"
		      (Store\ \(1:\)\ into\ a\ variable "(1:)ѿ")
		      (Recall\ a\ variable\ value "ѿͤɤ߽Ф")
		      (Edit\ the\ value\ of\ a\ variable "ѿͤԽ")
		      (Exchange\ \(1:\)\ with\ a\ variable\ value "(1:)ѿͤ")
		      (Clear\ variable\ value "ѿ򥯥ꥢ")
		      (Evaluate\ variables\ in\ \(1:\) "(1:)ѿɾ")
		      (Evaluate\ \(1:\)\,\ assigning\ a\ value\ to\ a\ variable "ѿ˰Ūͤդ(1:)ɾ")
;		      (nil "----")
		      (Help\ on\ Variables "ѿΥإ")
		      )
	   (Stack "å"
		  (Remove\ \(1:\) "(1:)")
		  (Switch\ \(1:\)\ and\ \(2:\) "(1:)(2:)")
		  (Duplicate\ \(1:\) "(1:)ʣ")
		  (Edit\ \(1:\) "(1:)Խ")
;		  (nil "----")
		  (Help\ on\ Stack "åΥإ")
		  )
	   (Undo "ä"
		 (Undo "᤹")
		 (Redo "ľ")
;		 (nil "----")
		 (Help\ on\ Undo "äΥإ")
		 )
	   (Modes "⡼"
		  (Precision "")
		  (Fraction\ mode "ʬ⡼")
		  (Symbolic\ mode "ܥå⡼")
		  (Infinite\ mode "̵⡼")
		  (Abbreviate\ long\ vectors "Ĺ٥ȥûɽ")
		  (Angle\ Measure "٤ñ")
		  (Radix "")
		  (Float\ Format "ưη")
		  (Complex\ Format "ʣǿη")
		  (Algebraic "")
		  (Language "")
;		  (nil "----")
		  (Save\ mode\ settings "⡼ɤ¸")
;		  (nil "----")
		  (Help\ on\ Modes "⡼ɤΥإ")
		  )
	   (Help "إ"
		 (Manual "ޥ˥奢")
		 (Tutorial "塼ȥꥢ")
		 (Summary "")
;		 (nil "----")
		 (Help\ on\ Help "إפΥإ")
		 )
	   (Reset "ꥻå")
	   (Quit "λ")
	   ))
    (calculator-mode-map
     (Calculator ""
		 (Help "إ")
;		 (nil "---")
		 (Copy "ԡ")
		 (Paste "Žդ")
;		 (nil "---")
		 (Electric\ mode "쥯ȥå⡼")
		 (Normal\ mode "ɸ⡼")
;		 (nil "---")
		 (Functions "ؿ"
			    (Repeat-right "α黻򷫤֤")
			    (Repeat-left "α黻򷫤֤")
;			    (nil "------------")
			    (Reciprocal "տ")
			    (Log "п")
			    (Square-root "ʿ")
			    (Factorial "")
;			    (nil "------Ѵؿ------")
			    (Sinus "(sin)")
			    (Cosine ";(cos)")
			    (Tangent "(tan)")
			    (Inv-Sinus "(arcsin)")
			    (Inv-Cosine ";(arccos)")
			    (Inv-Tangent "(arctan)")
;			    (nil "------ӥåȷ׻------")
			    (Or "(AND)")
			    (Xor "¾Ū(XOR)")
			    (And "(AND)")
			    (Not "(NOT)")
			    )
		 (Saved\ List "¸줿ꥹ"
			      (Eval+Save "ɾƥꥹȤɲ")
			      (Prev\ number "")
			      (Next\ number "")
			      (Delete\ current "Ǥ򥯥ꥢ")
			      (Delete\ all "ƤǤ򥯥ꥢ")
;			      (nil "---")
			      (List-total "ꥹȤι")
			      (List-average "ꥹȤʿ")
			      )
		 (Registers "쥸"
			    (Get\ register "쥸ɤ߽Ф")
			    (Set\ register "쥸˽񤭹")
			    )
		 (Modes "⡼"
			(Radians "饸")
			(Degrees "")
;			(nil "---")
			(Decimal "10ˡ")
			(Binary "2ˡ")
			(Octal "8ˡ")
			(Hexadecimal "16ˡ")
			(Separate\ I/O "Ϥ̡δ"
				       (Decimal\ Input "10ˡ")
				       (Binary\ Input "2ˡ")
				       (Octal\ Input "8ˡ")
				       (Hexadecimal\ Input "16ˡ")
;				       (nil "---")
				       (Decimal\ Output "10ˡν")
				       (Binary\ Output "2ˡν")
				       (Octal\ Output "8ˡν")
				       (Hexadecimal\ Output "16ˡν")
				       ))
		 (Decimal\ Display "ɽ"
				   (Standard\ display\,\ decimal\ point\ or\ scientific "ɸ")
				   (Eng\ display "")
				   (Standard\ display\,\ decimal\ point "")
				   (Standard\ display\,\ scientific "ʳ")
				   (Emacs\ printer "Emacsץ")
;				   (nil "---")
				   (Change\ Prev\ Display "η򸺤餹")
				   (Change\ Next\ Display "η䤹")
				   )
;		 (nil "---")
		 (Copy+Quit "ԡƽλ")
		 (Quit "λ")
		 ))
(bubbles-mode-map
 (Bubbles "Х֥륺"
	  (bubbles-undo "᤹")
;	  (bubbles-separator-2 "--")
	  (bubbles-graphics-theme-menu "ơ"
				       (bubbles-set-graphics-theme-circles "")
				       (bubbles-set-graphics-theme-squares "")
				       (bubbles-set-graphics-theme-diamonds "ɩ")
				       (bubbles-set-graphics-theme-balls "")
				       (bubbles-set-graphics-theme-emacs "Emacs")
				       (bubbles-set-graphics-theme-ascii "ASCII")
				       )
	  (bubbles-game-theme-menu ""
				   (bubbles-set-game-easy "ñ")
				   (bubbles-set-game-medium "")
				   (bubbles-set-game-difficult "񤷤")
				   (bubbles-set-game-hard "")
				   (bubbles-set-game-userdefined "桼")
				   )
	  (bubbles-customize "ޥ")
	  (bubbles-save-settings "¸")
;	  (bubbles-separator-1 "--")
	  (bubbles "")
	  (bubbles-quit "λ")
	  ))
))

(defvar menu-tree-alist menu-tree-alist-ja
  "alist used for overriding menu item string")

;;; functions

(defun menu-tree-override (km tree)
  (if (not (keymapp km))
      nil
    (let ((alis (if (symbolp km)
		    (symbol-function km)
		  km)))
      (while tree
	(let* ((entry (car tree))
	       (event (car entry))
	       (name (car (cdr entry)))
	       (map (cdr (cdr entry)))
	       (cell (assoc event alis)))
	  (unless (symbolp event) (setq cell (assoc (eval event) alis)))
	  (unless (stringp name) (setq name (eval name)))
	  (if menu-tree-coding-system
	      (setq name
		    (encode-coding-string name menu-tree-coding-system)))
	  (and cell
	       (consp (cdr cell))
	       (cond ((stringp (car (cdr cell)))
		      (setcar (cdr cell) name)
		      (cond ((keymapp (cdr (cdr cell)))
			     (menu-tree-override (cdr (cdr cell)) map))
			    ((consp (cdr (cdr cell)))
			     (menu-tree-override (nthcdr 3 cell) map))))
		     ((eq 'menu-item (car (cdr cell)))
		      (setcar (cdr (cdr cell)) name)
		      (menu-tree-override (nth 3 cell) map)))))
	(setq tree (cdr tree))))))

(defun menu-tree-override-by-alist (keymap-symbol)
  (menu-tree-override (lookup-key (symbol-value keymap-symbol) [menu-bar])
		      (cdr (assq keymap-symbol menu-tree-alist)))
  (force-mode-line-update))

;;; static overriding menu

(menu-tree-override-by-alist 'global-map)
(menu-tree-override-by-alist 'minibuffer-local-map)
(menu-tree-override-by-alist 'minibuffer-local-completion-map)
(if (= emacs-major-version 23)
    (menu-tree-override-by-alist 'lisp-interaction-mode-map))
(menu-tree-override-by-alist 'emacs-lisp-mode-map)
(if (= emacs-major-version 23)
    (eval-after-load "re-builder"
      '(menu-tree-override-by-alist 'reb-mode-map)))
(add-hook 'help-mode-hook
	  (lambda ()
	    (menu-tree-override-by-alist 'help-mode-map)) t)
(eval-after-load "outline"
  '(menu-tree-override-by-alist 'outline-mode-map))
(eval-after-load "cus-edit"
  '(menu-tree-override-by-alist 'custom-mode-map))
(eval-after-load "dired"
  '(menu-tree-override-by-alist 'dired-mode-map))
(eval-after-load "wdired"
  '(menu-tree-override-by-alist 'wdired-mode-map))
(add-hook 'image-dired-display-image-mode-hook
	  (lambda ()
	    (menu-tree-override-by-alist 'image-dired-display-image-mode-map)) t)
(add-hook 'image-dired-thumbnail-mode-hook
	  (lambda ()
	    (menu-tree-override-by-alist 'image-dired-thumbnail-mode-map)) t)
(add-hook 'calc-mode-hook
	  (lambda ()
	    (menu-tree-override-by-alist 'calc-mode-map)) t)
(eval-after-load "calculator"
  '(menu-tree-override-by-alist 'calculator-mode-map))
(eval-after-load "eudc"
  '(menu-tree-override
    (lookup-key (current-global-map) [menu-bar tools])
    (list (assq 'directory-search
		(cdr (assq 'tools
			   (cdr (assq 'global-map menu-tree-alist))))))))
(eval-after-load "eudc-hotlist"
  '(menu-tree-override-by-alist 'eudc-hotlist-mode-map))
(eval-after-load "bubbles"
  '(menu-tree-override-by-alist 'bubbles-mode-map))
(eval-after-load "redo+"
  '(menu-tree-override
    (lookup-key (current-global-map) [menu-bar edit])
    (list (assq 'redo
		(cdr (assq 'edit
			   (cdr (assq 'global-map menu-tree-alist))))))))

;;; dynamic overriding menu

(add-hook 'menu-bar-update-hook
	  `(lambda ()
	     ;; Buffer menu
	     (menu-tree-override
	      (lookup-key (current-global-map) [menu-bar])
	      (list (assq 'buffer
			  (cdr (assq 'global-map menu-tree-alist)))))
	     ;; ispell
	     ,@(if (= emacs-major-version 22)
		   '((menu-tree-override
		      (lookup-key (current-global-map) [menu-bar tools])
		      (list (assq 'spell
				  (cdr (assq 'tools
					     (cdr (assq 'global-map menu-tree-alist)))))))))
	    ) t)
;; Info-mode
(add-hook 'Info-mode-hook
	  (lambda ()
	    ;; dynamic overriding
	    (add-hook 'menu-bar-update-hook
		      (lambda ()
			(menu-tree-override-by-alist 'Info-mode-map)) t t)
	    ) t)
;; calendar-mode
(setq calendar-month-name-array
      [ "1" "2" "3"  "4"  "5"  "6"
	"7" "8" "9" "10" "11" "12" ])
(setq calendar-date-display-form
      '(year "ǯ" monthname day "" (if dayname (concat "(" (substring dayname 0 3) ")"))))
(add-hook 'calendar-mode-hook
	  (lambda ()
	    (defun cal-menu-holiday-window-suffix ()
	      (let ((my1 (if (fboundp 'calendar-increment-month-cons)
			     (calendar-increment-month-cons -1)
			   (calendar-increment-month -1)))
		    (my2 (if (fboundp 'calendar-increment-month-cons)
			     (calendar-increment-month-cons 1)
			   (calendar-increment-month 1))))
		(if (= (cdr my1) (cdr my2))
		    (format "%dǯ%s-%s"
			    (cdr my2)
			    (calendar-month-name (car my1) 'abbrev)
			    (calendar-month-name (car my2) 'abbrev))
		  (format "%dǯ%s-%dǯ%s"
			  (cdr my1)
			  (calendar-month-name (car my1) 'abbrev)
			  (cdr my2)
			  (calendar-month-name (car my2) 'abbrev)))))
	    ;; dynamic overriding
	    (add-hook 'menu-bar-update-hook
		      (lambda ()
			(menu-tree-override-by-alist 'calendar-mode-map)) t t)
	    ) t)

(provide 'menu-tree)
;;; menu-tree.el ends here
