/* valaexpression.c generated by valac, the Vala compiler
 * generated from valaexpression.vala, do not modify */

/* valaexpression.vala
 *
 * Copyright (C) 2006-2010  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include "vala.h"
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <valagee.h>
#include <glib-object.h>

#define _vala_code_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_node_unref (var), NULL)))
#define _vala_target_value_unref0(var) ((var == NULL) ? NULL : (var = (vala_target_value_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

struct _ValaExpressionPrivate {
	ValaDataType* _value_type;
	ValaDataType* _formal_value_type;
	ValaDataType* _target_type;
	ValaDataType* _formal_target_type;
	ValaSymbol* _symbol_reference;
	gboolean _lvalue;
	ValaTargetValue* _target_value;
};

static gint ValaExpression_private_offset;
static gpointer vala_expression_parent_class = NULL;

static gboolean vala_expression_real_is_constant (ValaExpression* self);
static gboolean vala_expression_real_is_pure (ValaExpression* self);
static gboolean vala_expression_real_is_non_null (ValaExpression* self);
static gboolean vala_expression_real_is_accessible (ValaExpression* self,
                                             ValaSymbol* sym);
static gboolean vala_expression_real_check (ValaCodeNode* base,
                                     ValaCodeContext* context);
static void vala_expression_finalize (ValaCodeNode * obj);
static GType vala_expression_get_type_once (void);

static inline gpointer
vala_expression_get_instance_private (ValaExpression* self)
{
	return G_STRUCT_MEMBER_P (self, ValaExpression_private_offset);
}

ValaDataType*
vala_expression_get_value_type (ValaExpression* self)
{
	ValaDataType* result;
	ValaDataType* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_value_type;
	result = _tmp0_;
	return result;
}

static gpointer
_vala_code_node_ref0 (gpointer self)
{
	return self ? vala_code_node_ref (self) : NULL;
}

void
vala_expression_set_value_type (ValaExpression* self,
                                ValaDataType* value)
{
	ValaDataType* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_code_node_ref0 (value);
	_vala_code_node_unref0 (self->priv->_value_type);
	self->priv->_value_type = _tmp0_;
}

ValaDataType*
vala_expression_get_formal_value_type (ValaExpression* self)
{
	ValaDataType* result;
	ValaDataType* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_formal_value_type;
	result = _tmp0_;
	return result;
}

void
vala_expression_set_formal_value_type (ValaExpression* self,
                                       ValaDataType* value)
{
	ValaDataType* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_code_node_ref0 (value);
	_vala_code_node_unref0 (self->priv->_formal_value_type);
	self->priv->_formal_value_type = _tmp0_;
}

ValaDataType*
vala_expression_get_target_type (ValaExpression* self)
{
	ValaDataType* result;
	ValaDataType* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_target_type;
	result = _tmp0_;
	return result;
}

void
vala_expression_set_target_type (ValaExpression* self,
                                 ValaDataType* value)
{
	ValaDataType* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_code_node_ref0 (value);
	_vala_code_node_unref0 (self->priv->_target_type);
	self->priv->_target_type = _tmp0_;
}

ValaDataType*
vala_expression_get_formal_target_type (ValaExpression* self)
{
	ValaDataType* result;
	ValaDataType* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_formal_target_type;
	result = _tmp0_;
	return result;
}

void
vala_expression_set_formal_target_type (ValaExpression* self,
                                        ValaDataType* value)
{
	ValaDataType* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_code_node_ref0 (value);
	_vala_code_node_unref0 (self->priv->_formal_target_type);
	self->priv->_formal_target_type = _tmp0_;
}

ValaSymbol*
vala_expression_get_symbol_reference (ValaExpression* self)
{
	ValaSymbol* result;
	ValaSymbol* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_symbol_reference;
	result = _tmp0_;
	return result;
}

void
vala_expression_set_symbol_reference (ValaExpression* self,
                                      ValaSymbol* value)
{
	g_return_if_fail (self != NULL);
	self->priv->_symbol_reference = value;
}

gboolean
vala_expression_get_lvalue (ValaExpression* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_lvalue;
	return result;
}

void
vala_expression_set_lvalue (ValaExpression* self,
                            gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_lvalue = value;
}

ValaTargetValue*
vala_expression_get_target_value (ValaExpression* self)
{
	ValaTargetValue* result;
	ValaTargetValue* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_target_value;
	result = _tmp0_;
	return result;
}

static gpointer
_vala_target_value_ref0 (gpointer self)
{
	return self ? vala_target_value_ref (self) : NULL;
}

void
vala_expression_set_target_value (ValaExpression* self,
                                  ValaTargetValue* value)
{
	ValaTargetValue* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_target_value_ref0 (value);
	_vala_target_value_unref0 (self->priv->_target_value);
	self->priv->_target_value = _tmp0_;
}

/**
 * Returns whether this expression is constant, i.e. whether this
 * expression only consists of literals and other constants.
 */
static gboolean
vala_expression_real_is_constant (ValaExpression* self)
{
	gboolean result = FALSE;
	result = FALSE;
	return result;
}

gboolean
vala_expression_is_constant (ValaExpression* self)
{
	ValaExpressionClass* _klass_;
	g_return_val_if_fail (self != NULL, FALSE);
	_klass_ = VALA_EXPRESSION_GET_CLASS (self);
	if (_klass_->is_constant) {
		return _klass_->is_constant (self);
	}
	return FALSE;
}

/**
 * Returns whether this expression is pure, i.e. whether this expression
 * is free of side-effects.
 */
static gboolean
vala_expression_real_is_pure (ValaExpression* self)
{
	gboolean _tmp0_ = FALSE;
	g_critical ("Type `%s' does not implement abstract method `vala_expression_is_pure'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return _tmp0_;
}

gboolean
vala_expression_is_pure (ValaExpression* self)
{
	ValaExpressionClass* _klass_;
	g_return_val_if_fail (self != NULL, FALSE);
	_klass_ = VALA_EXPRESSION_GET_CLASS (self);
	if (_klass_->is_pure) {
		return _klass_->is_pure (self);
	}
	return FALSE;
}

/**
 * Returns whether this expression is guaranteed to be non-null.
 */
static gboolean
vala_expression_real_is_non_null (ValaExpression* self)
{
	gboolean result = FALSE;
	result = FALSE;
	return result;
}

gboolean
vala_expression_is_non_null (ValaExpression* self)
{
	ValaExpressionClass* _klass_;
	g_return_val_if_fail (self != NULL, FALSE);
	_klass_ = VALA_EXPRESSION_GET_CLASS (self);
	if (_klass_->is_non_null) {
		return _klass_->is_non_null (self);
	}
	return FALSE;
}

/**
 * Check whether symbol_references in this expression are at least
 * as accessible as the specified symbol.
 */
static gboolean
vala_expression_real_is_accessible (ValaExpression* self,
                                    ValaSymbol* sym)
{
	gboolean result = FALSE;
	g_return_val_if_fail (sym != NULL, FALSE);
	result = TRUE;
	return result;
}

gboolean
vala_expression_is_accessible (ValaExpression* self,
                               ValaSymbol* sym)
{
	ValaExpressionClass* _klass_;
	g_return_val_if_fail (self != NULL, FALSE);
	_klass_ = VALA_EXPRESSION_GET_CLASS (self);
	if (_klass_->is_accessible) {
		return _klass_->is_accessible (self, sym);
	}
	return FALSE;
}

/**
 * Check whether this expression is always true.
 */
gboolean
vala_expression_is_always_true (ValaExpression* self)
{
	ValaBooleanLiteral* literal = NULL;
	gboolean _tmp0_ = FALSE;
	ValaBooleanLiteral* _tmp1_;
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	literal = VALA_IS_BOOLEAN_LITERAL (self) ? ((ValaBooleanLiteral*) self) : NULL;
	_tmp1_ = literal;
	if (_tmp1_ != NULL) {
		ValaBooleanLiteral* _tmp2_;
		gboolean _tmp3_;
		gboolean _tmp4_;
		_tmp2_ = literal;
		_tmp3_ = vala_boolean_literal_get_value (_tmp2_);
		_tmp4_ = _tmp3_;
		_tmp0_ = _tmp4_;
	} else {
		_tmp0_ = FALSE;
	}
	result = _tmp0_;
	return result;
}

/**
 * Check whether this expression is always false.
 */
gboolean
vala_expression_is_always_false (ValaExpression* self)
{
	ValaBooleanLiteral* literal = NULL;
	gboolean _tmp0_ = FALSE;
	ValaBooleanLiteral* _tmp1_;
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	literal = VALA_IS_BOOLEAN_LITERAL (self) ? ((ValaBooleanLiteral*) self) : NULL;
	_tmp1_ = literal;
	if (_tmp1_ != NULL) {
		ValaBooleanLiteral* _tmp2_;
		gboolean _tmp3_;
		gboolean _tmp4_;
		_tmp2_ = literal;
		_tmp3_ = vala_boolean_literal_get_value (_tmp2_);
		_tmp4_ = _tmp3_;
		_tmp0_ = !_tmp4_;
	} else {
		_tmp0_ = FALSE;
	}
	result = _tmp0_;
	return result;
}

ValaStatement*
vala_expression_get_parent_statement (ValaExpression* self)
{
	ValaStatement* result;
	ValaCodeNode* _tmp0_;
	ValaCodeNode* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
	_tmp1_ = _tmp0_;
	if (VALA_IS_MEMBER_INITIALIZER (_tmp1_)) {
		ValaCodeNode* _tmp2_;
		ValaCodeNode* _tmp3_;
		ValaCodeNode* _tmp4_;
		ValaCodeNode* _tmp5_;
		ValaStatement* _tmp6_;
		ValaStatement* _tmp7_;
		_tmp2_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
		_tmp3_ = _tmp2_;
		_tmp4_ = vala_code_node_get_parent_node (_tmp3_);
		_tmp5_ = _tmp4_;
		_tmp6_ = vala_expression_get_parent_statement (G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, VALA_TYPE_EXPRESSION, ValaExpression));
		_tmp7_ = _tmp6_;
		result = _tmp7_;
		return result;
	} else {
		ValaCodeNode* _tmp8_;
		ValaCodeNode* _tmp9_;
		_tmp8_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
		_tmp9_ = _tmp8_;
		if (VALA_IS_LOCAL_VARIABLE (_tmp9_)) {
			ValaCodeNode* _tmp10_;
			ValaCodeNode* _tmp11_;
			ValaCodeNode* _tmp12_;
			ValaCodeNode* _tmp13_;
			_tmp10_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
			_tmp11_ = _tmp10_;
			_tmp12_ = vala_code_node_get_parent_node (_tmp11_);
			_tmp13_ = _tmp12_;
			result = G_TYPE_CHECK_INSTANCE_CAST (_tmp13_, VALA_TYPE_STATEMENT, ValaStatement);
			return result;
		} else {
			ValaCodeNode* _tmp14_;
			ValaCodeNode* _tmp15_;
			_tmp14_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
			_tmp15_ = _tmp14_;
			if (VALA_IS_STATEMENT (_tmp15_)) {
				ValaCodeNode* _tmp16_;
				ValaCodeNode* _tmp17_;
				_tmp16_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
				_tmp17_ = _tmp16_;
				result = G_TYPE_CHECK_INSTANCE_CAST (_tmp17_, VALA_TYPE_STATEMENT, ValaStatement);
				return result;
			} else {
				ValaCodeNode* _tmp18_;
				ValaCodeNode* _tmp19_;
				_tmp18_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
				_tmp19_ = _tmp18_;
				if (VALA_IS_EXPRESSION (_tmp19_)) {
					ValaCodeNode* _tmp20_;
					ValaCodeNode* _tmp21_;
					ValaStatement* _tmp22_;
					ValaStatement* _tmp23_;
					_tmp20_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
					_tmp21_ = _tmp20_;
					_tmp22_ = vala_expression_get_parent_statement (G_TYPE_CHECK_INSTANCE_CAST (_tmp21_, VALA_TYPE_EXPRESSION, ValaExpression));
					_tmp23_ = _tmp22_;
					result = _tmp23_;
					return result;
				} else {
					result = NULL;
					return result;
				}
			}
		}
	}
}

void
vala_expression_insert_statement (ValaExpression* self,
                                  ValaBlock* block,
                                  ValaStatement* stmt)
{
	ValaStatement* _tmp0_;
	ValaStatement* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (block != NULL);
	g_return_if_fail (stmt != NULL);
	_tmp0_ = vala_expression_get_parent_statement (self);
	_tmp1_ = _tmp0_;
	vala_block_insert_before (block, _tmp1_, stmt);
}

static gboolean
vala_expression_real_check (ValaCodeNode* base,
                            ValaCodeContext* context)
{
	ValaExpression * self;
	ValaMethodCall* call = NULL;
	ValaExpression* _tmp0_ = NULL;
	ValaMethodCall* _tmp1_;
	ValaExpression* access = NULL;
	ValaMemberAccess* member_access = NULL;
	ValaExpression* _tmp5_;
	ValaElementAccess* elem_access = NULL;
	ValaExpression* _tmp6_;
	ValaSliceExpression* slice_expr = NULL;
	ValaExpression* _tmp7_;
	ValaExpression* inner = NULL;
	gboolean _tmp8_ = FALSE;
	ValaMemberAccess* _tmp9_;
	ValaExpression* _tmp32_;
	ValaMemberAccess* _tmp33_;
	ValaExpression* _tmp45_;
	ValaDataType* _tmp46_;
	ValaDataType* inner_type = NULL;
	ValaExpression* _tmp50_;
	ValaDataType* _tmp51_;
	ValaDataType* _tmp52_;
	gboolean _tmp53_ = FALSE;
	gboolean _tmp54_;
	gboolean _tmp55_;
	ValaLocalVariable* inner_local = NULL;
	ValaDataType* _tmp63_;
	gchar* _tmp64_;
	gchar* _tmp65_;
	ValaExpression* _tmp66_;
	ValaExpression* _tmp67_;
	ValaSourceReference* _tmp68_;
	ValaSourceReference* _tmp69_;
	ValaLocalVariable* _tmp70_;
	ValaLocalVariable* _tmp71_;
	ValaDeclarationStatement* inner_decl = NULL;
	ValaLocalVariable* _tmp72_;
	ValaExpression* _tmp73_;
	ValaSourceReference* _tmp74_;
	ValaSourceReference* _tmp75_;
	ValaDeclarationStatement* _tmp76_;
	ValaSemanticAnalyzer* _tmp77_;
	ValaSemanticAnalyzer* _tmp78_;
	ValaBlock* _tmp79_;
	ValaDeclarationStatement* _tmp80_;
	ValaDeclarationStatement* _tmp81_;
	ValaExpression* non_null_expr = NULL;
	ValaExpression* inner_access = NULL;
	ValaLocalVariable* _tmp82_;
	const gchar* _tmp83_;
	const gchar* _tmp84_;
	ValaSourceReference* _tmp85_;
	ValaSourceReference* _tmp86_;
	ValaMemberAccess* _tmp87_;
	gboolean _tmp88_;
	gboolean _tmp89_;
	ValaMemberAccess* _tmp94_;
	gboolean _tmp131_ = FALSE;
	gboolean _tmp132_ = FALSE;
	ValaMemberAccess* _tmp133_;
	ValaExpression* _tmp142_;
	ValaExpression* _tmp143_;
	ValaDataType* _tmp144_;
	ValaDataType* result_type = NULL;
	ValaMethodCall* _tmp147_;
	ValaDataType* _tmp172_;
	gboolean result = FALSE;
	self = (ValaExpression*) base;
	g_return_val_if_fail (context != NULL, FALSE);
	call = VALA_IS_METHOD_CALL (self) ? ((ValaMethodCall*) self) : NULL;
	_tmp1_ = call;
	if (_tmp1_ != NULL) {
		ValaMethodCall* _tmp2_;
		ValaExpression* _tmp3_;
		ValaExpression* _tmp4_;
		_tmp2_ = call;
		_tmp3_ = vala_method_call_get_call (_tmp2_);
		_tmp4_ = _tmp3_;
		_tmp0_ = _tmp4_;
	} else {
		_tmp0_ = self;
	}
	access = _tmp0_;
	_tmp5_ = access;
	member_access = VALA_IS_MEMBER_ACCESS (_tmp5_) ? ((ValaMemberAccess*) _tmp5_) : NULL;
	_tmp6_ = access;
	elem_access = VALA_IS_ELEMENT_ACCESS (_tmp6_) ? ((ValaElementAccess*) _tmp6_) : NULL;
	_tmp7_ = access;
	slice_expr = VALA_IS_SLICE_EXPRESSION (_tmp7_) ? ((ValaSliceExpression*) _tmp7_) : NULL;
	inner = NULL;
	_tmp9_ = member_access;
	if (_tmp9_ != NULL) {
		ValaMemberAccess* _tmp10_;
		gboolean _tmp11_;
		gboolean _tmp12_;
		_tmp10_ = member_access;
		_tmp11_ = vala_member_access_get_null_safe_access (_tmp10_);
		_tmp12_ = _tmp11_;
		_tmp8_ = _tmp12_;
	} else {
		_tmp8_ = FALSE;
	}
	if (_tmp8_) {
		ValaMemberAccess* _tmp13_;
		ValaExpression* _tmp14_;
		ValaExpression* _tmp15_;
		_tmp13_ = member_access;
		_tmp14_ = vala_member_access_get_inner (_tmp13_);
		_tmp15_ = _tmp14_;
		inner = _tmp15_;
	} else {
		gboolean _tmp16_ = FALSE;
		ValaElementAccess* _tmp17_;
		_tmp17_ = elem_access;
		if (_tmp17_ != NULL) {
			ValaElementAccess* _tmp18_;
			gboolean _tmp19_;
			gboolean _tmp20_;
			_tmp18_ = elem_access;
			_tmp19_ = vala_element_access_get_null_safe_access (_tmp18_);
			_tmp20_ = _tmp19_;
			_tmp16_ = _tmp20_;
		} else {
			_tmp16_ = FALSE;
		}
		if (_tmp16_) {
			ValaElementAccess* _tmp21_;
			ValaExpression* _tmp22_;
			ValaExpression* _tmp23_;
			_tmp21_ = elem_access;
			_tmp22_ = vala_element_access_get_container (_tmp21_);
			_tmp23_ = _tmp22_;
			inner = _tmp23_;
		} else {
			gboolean _tmp24_ = FALSE;
			ValaSliceExpression* _tmp25_;
			_tmp25_ = slice_expr;
			if (_tmp25_ != NULL) {
				ValaSliceExpression* _tmp26_;
				gboolean _tmp27_;
				gboolean _tmp28_;
				_tmp26_ = slice_expr;
				_tmp27_ = vala_slice_expression_get_null_safe_access (_tmp26_);
				_tmp28_ = _tmp27_;
				_tmp24_ = _tmp28_;
			} else {
				_tmp24_ = FALSE;
			}
			if (_tmp24_) {
				ValaSliceExpression* _tmp29_;
				ValaExpression* _tmp30_;
				ValaExpression* _tmp31_;
				_tmp29_ = slice_expr;
				_tmp30_ = vala_slice_expression_get_container (_tmp29_);
				_tmp31_ = _tmp30_;
				inner = _tmp31_;
			} else {
				result = TRUE;
				return result;
			}
		}
	}
	_tmp32_ = inner;
	if (!vala_code_node_check ((ValaCodeNode*) _tmp32_, context)) {
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		result = FALSE;
		return result;
	}
	_tmp33_ = member_access;
	if (_tmp33_ != NULL) {
		ValaMemberAccess* _tmp34_;
		ValaExpression* _tmp35_;
		ValaExpression* _tmp36_;
		_tmp34_ = member_access;
		_tmp35_ = vala_member_access_get_inner (_tmp34_);
		_tmp36_ = _tmp35_;
		inner = _tmp36_;
	} else {
		ValaElementAccess* _tmp37_;
		_tmp37_ = elem_access;
		if (_tmp37_ != NULL) {
			ValaElementAccess* _tmp38_;
			ValaExpression* _tmp39_;
			ValaExpression* _tmp40_;
			_tmp38_ = elem_access;
			_tmp39_ = vala_element_access_get_container (_tmp38_);
			_tmp40_ = _tmp39_;
			inner = _tmp40_;
		} else {
			ValaSliceExpression* _tmp41_;
			_tmp41_ = slice_expr;
			if (_tmp41_ != NULL) {
				ValaSliceExpression* _tmp42_;
				ValaExpression* _tmp43_;
				ValaExpression* _tmp44_;
				_tmp42_ = slice_expr;
				_tmp43_ = vala_slice_expression_get_container (_tmp42_);
				_tmp44_ = _tmp43_;
				inner = _tmp44_;
			}
		}
	}
	_tmp45_ = inner;
	_tmp46_ = _tmp45_->priv->_value_type;
	if (_tmp46_ == NULL) {
		ValaExpression* _tmp47_;
		ValaSourceReference* _tmp48_;
		ValaSourceReference* _tmp49_;
		_tmp47_ = inner;
		_tmp48_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp47_);
		_tmp49_ = _tmp48_;
		vala_report_error (_tmp49_, "invalid inner expression");
		result = FALSE;
		return result;
	}
	_tmp50_ = inner;
	_tmp51_ = _tmp50_->priv->_value_type;
	_tmp52_ = vala_data_type_copy (_tmp51_);
	inner_type = _tmp52_;
	_tmp54_ = vala_code_context_get_experimental_non_null (context);
	_tmp55_ = _tmp54_;
	if (_tmp55_) {
		ValaDataType* _tmp56_;
		gboolean _tmp57_;
		gboolean _tmp58_;
		_tmp56_ = inner_type;
		_tmp57_ = vala_data_type_get_nullable (_tmp56_);
		_tmp58_ = _tmp57_;
		_tmp53_ = !_tmp58_;
	} else {
		_tmp53_ = FALSE;
	}
	if (_tmp53_) {
		ValaExpression* _tmp59_;
		ValaSourceReference* _tmp60_;
		ValaSourceReference* _tmp61_;
		ValaDataType* _tmp62_;
		_tmp59_ = inner;
		_tmp60_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp59_);
		_tmp61_ = _tmp60_;
		vala_report_warning (_tmp61_, "inner expression is never null");
		_tmp62_ = inner_type;
		vala_data_type_set_nullable (_tmp62_, TRUE);
	}
	_tmp63_ = inner_type;
	_tmp64_ = vala_code_node_get_temp_name ();
	_tmp65_ = _tmp64_;
	_tmp66_ = inner;
	_tmp67_ = inner;
	_tmp68_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp67_);
	_tmp69_ = _tmp68_;
	_tmp70_ = vala_local_variable_new (_tmp63_, _tmp65_, _tmp66_, _tmp69_);
	_tmp71_ = _tmp70_;
	_g_free0 (_tmp65_);
	inner_local = _tmp71_;
	_tmp72_ = inner_local;
	_tmp73_ = inner;
	_tmp74_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp73_);
	_tmp75_ = _tmp74_;
	_tmp76_ = vala_declaration_statement_new ((ValaSymbol*) _tmp72_, _tmp75_);
	inner_decl = _tmp76_;
	_tmp77_ = vala_code_context_get_analyzer (context);
	_tmp78_ = _tmp77_;
	_tmp79_ = _tmp78_->insert_block;
	_tmp80_ = inner_decl;
	vala_expression_insert_statement (self, _tmp79_, (ValaStatement*) _tmp80_);
	_tmp81_ = inner_decl;
	if (!vala_code_node_check ((ValaCodeNode*) _tmp81_, context)) {
		result = FALSE;
		_vala_code_node_unref0 (inner_decl);
		_vala_code_node_unref0 (inner_local);
		_vala_code_node_unref0 (inner_type);
		return result;
	}
	non_null_expr = NULL;
	_tmp82_ = inner_local;
	_tmp83_ = vala_symbol_get_name ((ValaSymbol*) _tmp82_);
	_tmp84_ = _tmp83_;
	_tmp85_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
	_tmp86_ = _tmp85_;
	_tmp87_ = vala_member_access_new_simple (_tmp84_, _tmp86_);
	inner_access = (ValaExpression*) _tmp87_;
	_tmp88_ = vala_code_context_get_experimental_non_null (context);
	_tmp89_ = _tmp88_;
	if (_tmp89_) {
		ValaExpression* _tmp90_;
		ValaSourceReference* _tmp91_;
		ValaSourceReference* _tmp92_;
		ValaCastExpression* _tmp93_;
		_tmp90_ = inner_access;
		_tmp91_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp92_ = _tmp91_;
		_tmp93_ = vala_cast_expression_new_non_null (_tmp90_, _tmp92_);
		_vala_code_node_unref0 (inner_access);
		inner_access = (ValaExpression*) _tmp93_;
	}
	_tmp94_ = member_access;
	if (_tmp94_ != NULL) {
		ValaExpression* _tmp95_;
		ValaMemberAccess* _tmp96_;
		const gchar* _tmp97_;
		const gchar* _tmp98_;
		ValaSourceReference* _tmp99_;
		ValaSourceReference* _tmp100_;
		ValaMemberAccess* _tmp101_;
		_tmp95_ = inner_access;
		_tmp96_ = member_access;
		_tmp97_ = vala_member_access_get_member_name (_tmp96_);
		_tmp98_ = _tmp97_;
		_tmp99_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp100_ = _tmp99_;
		_tmp101_ = vala_member_access_new (_tmp95_, _tmp98_, _tmp100_);
		_vala_code_node_unref0 (non_null_expr);
		non_null_expr = (ValaExpression*) _tmp101_;
	} else {
		ValaElementAccess* _tmp102_;
		_tmp102_ = elem_access;
		if (_tmp102_ != NULL) {
			ValaElementAccess* non_null_elem_access = NULL;
			ValaExpression* _tmp103_;
			ValaSourceReference* _tmp104_;
			ValaSourceReference* _tmp105_;
			ValaElementAccess* _tmp106_;
			ValaElementAccess* _tmp118_;
			ValaExpression* _tmp119_;
			_tmp103_ = inner_access;
			_tmp104_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp105_ = _tmp104_;
			_tmp106_ = vala_element_access_new (_tmp103_, _tmp105_);
			non_null_elem_access = _tmp106_;
			{
				ValaList* _index_list = NULL;
				ValaElementAccess* _tmp107_;
				ValaList* _tmp108_;
				gint _index_size = 0;
				ValaList* _tmp109_;
				gint _tmp110_;
				gint _tmp111_;
				gint _index_index = 0;
				_tmp107_ = elem_access;
				_tmp108_ = vala_element_access_get_indices (_tmp107_);
				_index_list = _tmp108_;
				_tmp109_ = _index_list;
				_tmp110_ = vala_collection_get_size ((ValaCollection*) _tmp109_);
				_tmp111_ = _tmp110_;
				_index_size = _tmp111_;
				_index_index = -1;
				while (TRUE) {
					gint _tmp112_;
					gint _tmp113_;
					ValaExpression* index = NULL;
					ValaList* _tmp114_;
					gpointer _tmp115_;
					ValaElementAccess* _tmp116_;
					ValaExpression* _tmp117_;
					_index_index = _index_index + 1;
					_tmp112_ = _index_index;
					_tmp113_ = _index_size;
					if (!(_tmp112_ < _tmp113_)) {
						break;
					}
					_tmp114_ = _index_list;
					_tmp115_ = vala_list_get (_tmp114_, _index_index);
					index = (ValaExpression*) _tmp115_;
					_tmp116_ = non_null_elem_access;
					_tmp117_ = index;
					vala_element_access_append_index (_tmp116_, _tmp117_);
					_vala_code_node_unref0 (index);
				}
			}
			_tmp118_ = non_null_elem_access;
			_tmp119_ = _vala_code_node_ref0 ((ValaExpression*) _tmp118_);
			_vala_code_node_unref0 (non_null_expr);
			non_null_expr = _tmp119_;
			_vala_code_node_unref0 (non_null_elem_access);
		} else {
			ValaSliceExpression* _tmp120_;
			_tmp120_ = slice_expr;
			if (_tmp120_ != NULL) {
				ValaExpression* _tmp121_;
				ValaSliceExpression* _tmp122_;
				ValaExpression* _tmp123_;
				ValaExpression* _tmp124_;
				ValaSliceExpression* _tmp125_;
				ValaExpression* _tmp126_;
				ValaExpression* _tmp127_;
				ValaSourceReference* _tmp128_;
				ValaSourceReference* _tmp129_;
				ValaSliceExpression* _tmp130_;
				_tmp121_ = inner_access;
				_tmp122_ = slice_expr;
				_tmp123_ = vala_slice_expression_get_start (_tmp122_);
				_tmp124_ = _tmp123_;
				_tmp125_ = slice_expr;
				_tmp126_ = vala_slice_expression_get_stop (_tmp125_);
				_tmp127_ = _tmp126_;
				_tmp128_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp129_ = _tmp128_;
				_tmp130_ = vala_slice_expression_new (_tmp121_, _tmp124_, _tmp127_, _tmp129_);
				_vala_code_node_unref0 (non_null_expr);
				non_null_expr = (ValaExpression*) _tmp130_;
			}
		}
	}
	_tmp133_ = member_access;
	if (_tmp133_ != NULL) {
		_tmp132_ = TRUE;
	} else {
		ValaElementAccess* _tmp134_;
		_tmp134_ = elem_access;
		_tmp132_ = _tmp134_ != NULL;
	}
	if (_tmp132_) {
		ValaExpression* _tmp135_;
		ValaCodeNode* _tmp136_;
		ValaCodeNode* _tmp137_;
		_tmp135_ = access;
		_tmp136_ = vala_code_node_get_parent_node ((ValaCodeNode*) _tmp135_);
		_tmp137_ = _tmp136_;
		_tmp131_ = VALA_IS_REFERENCE_TRANSFER_EXPRESSION (_tmp137_);
	} else {
		_tmp131_ = FALSE;
	}
	if (_tmp131_) {
		ValaExpression* _tmp138_;
		ValaSourceReference* _tmp139_;
		ValaSourceReference* _tmp140_;
		ValaReferenceTransferExpression* _tmp141_;
		_tmp138_ = non_null_expr;
		_tmp139_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp140_ = _tmp139_;
		_tmp141_ = vala_reference_transfer_expression_new (_tmp138_, _tmp140_);
		_vala_code_node_unref0 (non_null_expr);
		non_null_expr = (ValaExpression*) _tmp141_;
	}
	_tmp142_ = non_null_expr;
	if (!vala_code_node_check ((ValaCodeNode*) _tmp142_, context)) {
		result = FALSE;
		_vala_code_node_unref0 (inner_access);
		_vala_code_node_unref0 (non_null_expr);
		_vala_code_node_unref0 (inner_decl);
		_vala_code_node_unref0 (inner_local);
		_vala_code_node_unref0 (inner_type);
		return result;
	}
	_tmp143_ = non_null_expr;
	_tmp144_ = _tmp143_->priv->_value_type;
	if (_tmp144_ == NULL) {
		ValaSourceReference* _tmp145_;
		ValaSourceReference* _tmp146_;
		_tmp145_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp146_ = _tmp145_;
		vala_report_error (_tmp146_, "invalid null-safe expression");
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		result = FALSE;
		_vala_code_node_unref0 (inner_access);
		_vala_code_node_unref0 (non_null_expr);
		_vala_code_node_unref0 (inner_decl);
		_vala_code_node_unref0 (inner_local);
		_vala_code_node_unref0 (inner_type);
		return result;
	}
	_tmp147_ = call;
	if (_tmp147_ != NULL) {
		ValaMethodCall* non_null_call = NULL;
		ValaExpression* _tmp148_;
		ValaSourceReference* _tmp149_;
		ValaSourceReference* _tmp150_;
		ValaMethodCall* _tmp151_;
		ValaExpression* _tmp163_;
		ValaDataType* _tmp164_;
		ValaDataType* _tmp165_;
		ValaDataType* _tmp166_;
		ValaMethodCall* _tmp167_;
		ValaExpression* _tmp168_;
		_tmp148_ = non_null_expr;
		_tmp149_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp150_ = _tmp149_;
		_tmp151_ = vala_method_call_new (_tmp148_, _tmp150_);
		non_null_call = _tmp151_;
		{
			ValaList* _arg_list = NULL;
			ValaMethodCall* _tmp152_;
			ValaList* _tmp153_;
			gint _arg_size = 0;
			ValaList* _tmp154_;
			gint _tmp155_;
			gint _tmp156_;
			gint _arg_index = 0;
			_tmp152_ = call;
			_tmp153_ = vala_callable_expression_get_argument_list ((ValaCallableExpression*) _tmp152_);
			_arg_list = _tmp153_;
			_tmp154_ = _arg_list;
			_tmp155_ = vala_collection_get_size ((ValaCollection*) _tmp154_);
			_tmp156_ = _tmp155_;
			_arg_size = _tmp156_;
			_arg_index = -1;
			while (TRUE) {
				gint _tmp157_;
				gint _tmp158_;
				ValaExpression* arg = NULL;
				ValaList* _tmp159_;
				gpointer _tmp160_;
				ValaMethodCall* _tmp161_;
				ValaExpression* _tmp162_;
				_arg_index = _arg_index + 1;
				_tmp157_ = _arg_index;
				_tmp158_ = _arg_size;
				if (!(_tmp157_ < _tmp158_)) {
					break;
				}
				_tmp159_ = _arg_list;
				_tmp160_ = vala_list_get (_tmp159_, _arg_index);
				arg = (ValaExpression*) _tmp160_;
				_tmp161_ = non_null_call;
				_tmp162_ = arg;
				vala_callable_expression_add_argument ((ValaCallableExpression*) _tmp161_, _tmp162_);
				_vala_code_node_unref0 (arg);
			}
		}
		_tmp163_ = non_null_expr;
		_tmp164_ = _tmp163_->priv->_value_type;
		_tmp165_ = vala_data_type_get_return_type (_tmp164_);
		_tmp166_ = vala_data_type_copy (_tmp165_);
		_vala_code_node_unref0 (result_type);
		result_type = _tmp166_;
		_tmp167_ = non_null_call;
		_tmp168_ = _vala_code_node_ref0 ((ValaExpression*) _tmp167_);
		_vala_code_node_unref0 (non_null_expr);
		non_null_expr = _tmp168_;
		_vala_code_node_unref0 (non_null_call);
	} else {
		ValaExpression* _tmp169_;
		ValaDataType* _tmp170_;
		ValaDataType* _tmp171_;
		_tmp169_ = non_null_expr;
		_tmp170_ = _tmp169_->priv->_value_type;
		_tmp171_ = vala_data_type_copy (_tmp170_);
		_vala_code_node_unref0 (result_type);
		result_type = _tmp171_;
	}
	_tmp172_ = result_type;
	if (VALA_IS_VOID_TYPE (_tmp172_)) {
		ValaExpressionStatement* non_null_stmt = NULL;
		ValaExpression* _tmp173_;
		ValaSourceReference* _tmp174_;
		ValaSourceReference* _tmp175_;
		ValaExpressionStatement* _tmp176_;
		ValaBlock* non_null_block = NULL;
		ValaSourceReference* _tmp177_;
		ValaSourceReference* _tmp178_;
		ValaBlock* _tmp179_;
		ValaBlock* _tmp180_;
		ValaExpressionStatement* _tmp181_;
		ValaBinaryExpression* non_null_safe = NULL;
		ValaLocalVariable* _tmp182_;
		const gchar* _tmp183_;
		const gchar* _tmp184_;
		ValaSourceReference* _tmp185_;
		ValaSourceReference* _tmp186_;
		ValaMemberAccess* _tmp187_;
		ValaMemberAccess* _tmp188_;
		ValaSourceReference* _tmp189_;
		ValaSourceReference* _tmp190_;
		ValaNullLiteral* _tmp191_;
		ValaNullLiteral* _tmp192_;
		ValaSourceReference* _tmp193_;
		ValaSourceReference* _tmp194_;
		ValaBinaryExpression* _tmp195_;
		ValaBinaryExpression* _tmp196_;
		ValaIfStatement* non_null_ifstmt = NULL;
		ValaBinaryExpression* _tmp197_;
		ValaBlock* _tmp198_;
		ValaSourceReference* _tmp199_;
		ValaSourceReference* _tmp200_;
		ValaIfStatement* _tmp201_;
		ValaExpressionStatement* parent_stmt = NULL;
		ValaCodeNode* _tmp202_;
		ValaCodeNode* _tmp203_;
		ValaBlock* _tmp204_ = NULL;
		ValaExpressionStatement* _tmp205_;
		ValaBlock* parent_block = NULL;
		gboolean _tmp209_ = FALSE;
		ValaExpressionStatement* _tmp210_;
		ValaSemanticAnalyzer* _tmp214_;
		ValaSemanticAnalyzer* _tmp215_;
		ValaList* _tmp216_;
		ValaExpressionStatement* _tmp217_;
		ValaBlock* _tmp218_;
		ValaExpressionStatement* _tmp219_;
		ValaIfStatement* _tmp220_;
		ValaIfStatement* _tmp221_;
		_tmp173_ = non_null_expr;
		_tmp174_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp175_ = _tmp174_;
		_tmp176_ = vala_expression_statement_new (_tmp173_, _tmp175_);
		non_null_stmt = _tmp176_;
		_tmp177_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp178_ = _tmp177_;
		_tmp179_ = vala_block_new (_tmp178_);
		non_null_block = _tmp179_;
		_tmp180_ = non_null_block;
		_tmp181_ = non_null_stmt;
		vala_block_add_statement (_tmp180_, (ValaStatement*) _tmp181_);
		_tmp182_ = inner_local;
		_tmp183_ = vala_symbol_get_name ((ValaSymbol*) _tmp182_);
		_tmp184_ = _tmp183_;
		_tmp185_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp186_ = _tmp185_;
		_tmp187_ = vala_member_access_new_simple (_tmp184_, _tmp186_);
		_tmp188_ = _tmp187_;
		_tmp189_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp190_ = _tmp189_;
		_tmp191_ = vala_null_literal_new (_tmp190_);
		_tmp192_ = _tmp191_;
		_tmp193_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp194_ = _tmp193_;
		_tmp195_ = vala_binary_expression_new (VALA_BINARY_OPERATOR_INEQUALITY, (ValaExpression*) _tmp188_, (ValaExpression*) _tmp192_, _tmp194_);
		_tmp196_ = _tmp195_;
		_vala_code_node_unref0 (_tmp192_);
		_vala_code_node_unref0 (_tmp188_);
		non_null_safe = _tmp196_;
		_tmp197_ = non_null_safe;
		_tmp198_ = non_null_block;
		_tmp199_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp200_ = _tmp199_;
		_tmp201_ = vala_if_statement_new ((ValaExpression*) _tmp197_, _tmp198_, NULL, _tmp200_);
		non_null_ifstmt = _tmp201_;
		_tmp202_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
		_tmp203_ = _tmp202_;
		parent_stmt = VALA_IS_EXPRESSION_STATEMENT (_tmp203_) ? ((ValaExpressionStatement*) _tmp203_) : NULL;
		_tmp205_ = parent_stmt;
		if (_tmp205_ != NULL) {
			ValaExpressionStatement* _tmp206_;
			ValaCodeNode* _tmp207_;
			ValaCodeNode* _tmp208_;
			_tmp206_ = parent_stmt;
			_tmp207_ = vala_code_node_get_parent_node ((ValaCodeNode*) _tmp206_);
			_tmp208_ = _tmp207_;
			_tmp204_ = VALA_IS_BLOCK (_tmp208_) ? ((ValaBlock*) _tmp208_) : NULL;
		} else {
			_tmp204_ = NULL;
		}
		parent_block = _tmp204_;
		_tmp210_ = parent_stmt;
		if (_tmp210_ == NULL) {
			_tmp209_ = TRUE;
		} else {
			ValaBlock* _tmp211_;
			_tmp211_ = parent_block;
			_tmp209_ = _tmp211_ == NULL;
		}
		if (_tmp209_) {
			ValaSourceReference* _tmp212_;
			ValaSourceReference* _tmp213_;
			_tmp212_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp213_ = _tmp212_;
			vala_report_error (_tmp213_, "void method call not allowed here");
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			result = FALSE;
			_vala_code_node_unref0 (non_null_ifstmt);
			_vala_code_node_unref0 (non_null_safe);
			_vala_code_node_unref0 (non_null_block);
			_vala_code_node_unref0 (non_null_stmt);
			_vala_code_node_unref0 (result_type);
			_vala_code_node_unref0 (inner_access);
			_vala_code_node_unref0 (non_null_expr);
			_vala_code_node_unref0 (inner_decl);
			_vala_code_node_unref0 (inner_local);
			_vala_code_node_unref0 (inner_type);
			return result;
		}
		_tmp214_ = vala_code_context_get_analyzer (context);
		_tmp215_ = _tmp214_;
		_tmp216_ = _tmp215_->replaced_nodes;
		_tmp217_ = parent_stmt;
		vala_collection_add ((ValaCollection*) _tmp216_, (ValaCodeNode*) _tmp217_);
		_tmp218_ = parent_block;
		_tmp219_ = parent_stmt;
		_tmp220_ = non_null_ifstmt;
		vala_block_replace_statement (_tmp218_, (ValaStatement*) _tmp219_, (ValaStatement*) _tmp220_);
		_tmp221_ = non_null_ifstmt;
		result = vala_code_node_check ((ValaCodeNode*) _tmp221_, context);
		_vala_code_node_unref0 (non_null_ifstmt);
		_vala_code_node_unref0 (non_null_safe);
		_vala_code_node_unref0 (non_null_block);
		_vala_code_node_unref0 (non_null_stmt);
		_vala_code_node_unref0 (result_type);
		_vala_code_node_unref0 (inner_access);
		_vala_code_node_unref0 (non_null_expr);
		_vala_code_node_unref0 (inner_decl);
		_vala_code_node_unref0 (inner_local);
		_vala_code_node_unref0 (inner_type);
		return result;
	} else {
		ValaDataType* _tmp222_;
		gboolean _tmp223_;
		gboolean _tmp224_;
		ValaLocalVariable* result_local = NULL;
		ValaDataType* _tmp228_;
		gchar* _tmp229_;
		gchar* _tmp230_;
		ValaSourceReference* _tmp231_;
		ValaSourceReference* _tmp232_;
		ValaNullLiteral* _tmp233_;
		ValaNullLiteral* _tmp234_;
		ValaSourceReference* _tmp235_;
		ValaSourceReference* _tmp236_;
		ValaLocalVariable* _tmp237_;
		ValaLocalVariable* _tmp238_;
		ValaDeclarationStatement* result_decl = NULL;
		ValaLocalVariable* _tmp239_;
		ValaSourceReference* _tmp240_;
		ValaSourceReference* _tmp241_;
		ValaDeclarationStatement* _tmp242_;
		ValaSemanticAnalyzer* _tmp243_;
		ValaSemanticAnalyzer* _tmp244_;
		ValaBlock* _tmp245_;
		ValaDeclarationStatement* _tmp246_;
		ValaDeclarationStatement* _tmp247_;
		ValaBinaryExpression* non_null_safe = NULL;
		ValaLocalVariable* _tmp248_;
		const gchar* _tmp249_;
		const gchar* _tmp250_;
		ValaSourceReference* _tmp251_;
		ValaSourceReference* _tmp252_;
		ValaMemberAccess* _tmp253_;
		ValaMemberAccess* _tmp254_;
		ValaSourceReference* _tmp255_;
		ValaSourceReference* _tmp256_;
		ValaNullLiteral* _tmp257_;
		ValaNullLiteral* _tmp258_;
		ValaSourceReference* _tmp259_;
		ValaSourceReference* _tmp260_;
		ValaBinaryExpression* _tmp261_;
		ValaBinaryExpression* _tmp262_;
		ValaExpressionStatement* non_null_stmt = NULL;
		ValaLocalVariable* _tmp263_;
		const gchar* _tmp264_;
		const gchar* _tmp265_;
		ValaSourceReference* _tmp266_;
		ValaSourceReference* _tmp267_;
		ValaMemberAccess* _tmp268_;
		ValaMemberAccess* _tmp269_;
		ValaExpression* _tmp270_;
		ValaSourceReference* _tmp271_;
		ValaSourceReference* _tmp272_;
		ValaAssignment* _tmp273_;
		ValaAssignment* _tmp274_;
		ValaSourceReference* _tmp275_;
		ValaSourceReference* _tmp276_;
		ValaExpressionStatement* _tmp277_;
		ValaExpressionStatement* _tmp278_;
		ValaBlock* non_null_block = NULL;
		ValaSourceReference* _tmp279_;
		ValaSourceReference* _tmp280_;
		ValaBlock* _tmp281_;
		ValaBlock* _tmp282_;
		ValaExpressionStatement* _tmp283_;
		ValaIfStatement* non_null_ifstmt = NULL;
		ValaBinaryExpression* _tmp284_;
		ValaBlock* _tmp285_;
		ValaSourceReference* _tmp286_;
		ValaSourceReference* _tmp287_;
		ValaIfStatement* _tmp288_;
		ValaSemanticAnalyzer* _tmp289_;
		ValaSemanticAnalyzer* _tmp290_;
		ValaBlock* _tmp291_;
		ValaIfStatement* _tmp292_;
		ValaIfStatement* _tmp293_;
		ValaExpression* result_access = NULL;
		ValaLocalVariable* _tmp294_;
		ValaDataType* _tmp295_;
		ValaExpression* _tmp296_;
		ValaSemanticAnalyzer* _tmp297_;
		ValaSemanticAnalyzer* _tmp298_;
		ValaList* _tmp299_;
		ValaCodeNode* _tmp300_;
		ValaCodeNode* _tmp301_;
		ValaExpression* _tmp302_;
		gboolean _tmp303_;
		ValaExpression* _tmp308_;
		_tmp222_ = result_type;
		_tmp223_ = vala_data_type_get_nullable (_tmp222_);
		_tmp224_ = _tmp223_;
		if (!_tmp224_) {
			ValaDataType* _tmp225_;
			ValaDataType* _tmp227_;
			_tmp225_ = result_type;
			if (VALA_IS_VALUE_TYPE (_tmp225_)) {
				ValaDataType* _tmp226_;
				_tmp226_ = result_type;
				vala_data_type_set_value_owned (_tmp226_, TRUE);
			}
			_tmp227_ = result_type;
			vala_data_type_set_nullable (_tmp227_, TRUE);
		}
		_tmp228_ = result_type;
		_tmp229_ = vala_code_node_get_temp_name ();
		_tmp230_ = _tmp229_;
		_tmp231_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp232_ = _tmp231_;
		_tmp233_ = vala_null_literal_new (_tmp232_);
		_tmp234_ = _tmp233_;
		_tmp235_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp236_ = _tmp235_;
		_tmp237_ = vala_local_variable_new (_tmp228_, _tmp230_, (ValaExpression*) _tmp234_, _tmp236_);
		_tmp238_ = _tmp237_;
		_vala_code_node_unref0 (_tmp234_);
		_g_free0 (_tmp230_);
		result_local = _tmp238_;
		_tmp239_ = result_local;
		_tmp240_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp241_ = _tmp240_;
		_tmp242_ = vala_declaration_statement_new ((ValaSymbol*) _tmp239_, _tmp241_);
		result_decl = _tmp242_;
		_tmp243_ = vala_code_context_get_analyzer (context);
		_tmp244_ = _tmp243_;
		_tmp245_ = _tmp244_->insert_block;
		_tmp246_ = result_decl;
		vala_expression_insert_statement (self, _tmp245_, (ValaStatement*) _tmp246_);
		_tmp247_ = result_decl;
		if (!vala_code_node_check ((ValaCodeNode*) _tmp247_, context)) {
			result = FALSE;
			_vala_code_node_unref0 (result_decl);
			_vala_code_node_unref0 (result_local);
			_vala_code_node_unref0 (result_type);
			_vala_code_node_unref0 (inner_access);
			_vala_code_node_unref0 (non_null_expr);
			_vala_code_node_unref0 (inner_decl);
			_vala_code_node_unref0 (inner_local);
			_vala_code_node_unref0 (inner_type);
			return result;
		}
		_tmp248_ = inner_local;
		_tmp249_ = vala_symbol_get_name ((ValaSymbol*) _tmp248_);
		_tmp250_ = _tmp249_;
		_tmp251_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp252_ = _tmp251_;
		_tmp253_ = vala_member_access_new_simple (_tmp250_, _tmp252_);
		_tmp254_ = _tmp253_;
		_tmp255_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp256_ = _tmp255_;
		_tmp257_ = vala_null_literal_new (_tmp256_);
		_tmp258_ = _tmp257_;
		_tmp259_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp260_ = _tmp259_;
		_tmp261_ = vala_binary_expression_new (VALA_BINARY_OPERATOR_INEQUALITY, (ValaExpression*) _tmp254_, (ValaExpression*) _tmp258_, _tmp260_);
		_tmp262_ = _tmp261_;
		_vala_code_node_unref0 (_tmp258_);
		_vala_code_node_unref0 (_tmp254_);
		non_null_safe = _tmp262_;
		_tmp263_ = result_local;
		_tmp264_ = vala_symbol_get_name ((ValaSymbol*) _tmp263_);
		_tmp265_ = _tmp264_;
		_tmp266_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp267_ = _tmp266_;
		_tmp268_ = vala_member_access_new_simple (_tmp265_, _tmp267_);
		_tmp269_ = _tmp268_;
		_tmp270_ = non_null_expr;
		_tmp271_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp272_ = _tmp271_;
		_tmp273_ = vala_assignment_new ((ValaExpression*) _tmp269_, _tmp270_, VALA_ASSIGNMENT_OPERATOR_SIMPLE, _tmp272_);
		_tmp274_ = _tmp273_;
		_tmp275_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp276_ = _tmp275_;
		_tmp277_ = vala_expression_statement_new ((ValaExpression*) _tmp274_, _tmp276_);
		_tmp278_ = _tmp277_;
		_vala_code_node_unref0 (_tmp274_);
		_vala_code_node_unref0 (_tmp269_);
		non_null_stmt = _tmp278_;
		_tmp279_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp280_ = _tmp279_;
		_tmp281_ = vala_block_new (_tmp280_);
		non_null_block = _tmp281_;
		_tmp282_ = non_null_block;
		_tmp283_ = non_null_stmt;
		vala_block_add_statement (_tmp282_, (ValaStatement*) _tmp283_);
		_tmp284_ = non_null_safe;
		_tmp285_ = non_null_block;
		_tmp286_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp287_ = _tmp286_;
		_tmp288_ = vala_if_statement_new ((ValaExpression*) _tmp284_, _tmp285_, NULL, _tmp287_);
		non_null_ifstmt = _tmp288_;
		_tmp289_ = vala_code_context_get_analyzer (context);
		_tmp290_ = _tmp289_;
		_tmp291_ = _tmp290_->insert_block;
		_tmp292_ = non_null_ifstmt;
		vala_expression_insert_statement (self, _tmp291_, (ValaStatement*) _tmp292_);
		_tmp293_ = non_null_ifstmt;
		if (!vala_code_node_check ((ValaCodeNode*) _tmp293_, context)) {
			result = FALSE;
			_vala_code_node_unref0 (non_null_ifstmt);
			_vala_code_node_unref0 (non_null_block);
			_vala_code_node_unref0 (non_null_stmt);
			_vala_code_node_unref0 (non_null_safe);
			_vala_code_node_unref0 (result_decl);
			_vala_code_node_unref0 (result_local);
			_vala_code_node_unref0 (result_type);
			_vala_code_node_unref0 (inner_access);
			_vala_code_node_unref0 (non_null_expr);
			_vala_code_node_unref0 (inner_decl);
			_vala_code_node_unref0 (inner_local);
			_vala_code_node_unref0 (inner_type);
			return result;
		}
		_tmp294_ = result_local;
		_tmp295_ = self->priv->_target_type;
		_tmp296_ = vala_semantic_analyzer_create_temp_access (_tmp294_, _tmp295_);
		result_access = _tmp296_;
		_tmp297_ = vala_code_context_get_analyzer (context);
		_tmp298_ = _tmp297_;
		_tmp299_ = _tmp298_->replaced_nodes;
		vala_collection_add ((ValaCollection*) _tmp299_, (ValaCodeNode*) self);
		_tmp300_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
		_tmp301_ = _tmp300_;
		_tmp302_ = result_access;
		vala_code_node_replace_expression (_tmp301_, self, _tmp302_);
		_tmp303_ = self->priv->_lvalue;
		if (_tmp303_) {
			ValaExpression* _tmp304_;
			_tmp304_ = non_null_expr;
			if (VALA_IS_REFERENCE_TRANSFER_EXPRESSION (_tmp304_)) {
				ValaExpression* _tmp305_;
				_tmp305_ = result_access;
				vala_expression_set_lvalue (_tmp305_, TRUE);
			} else {
				ValaSourceReference* _tmp306_;
				ValaSourceReference* _tmp307_;
				_tmp306_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp307_ = _tmp306_;
				vala_report_error (_tmp307_, "null-safe expression not supported as lvalue");
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				result = FALSE;
				_vala_code_node_unref0 (result_access);
				_vala_code_node_unref0 (non_null_ifstmt);
				_vala_code_node_unref0 (non_null_block);
				_vala_code_node_unref0 (non_null_stmt);
				_vala_code_node_unref0 (non_null_safe);
				_vala_code_node_unref0 (result_decl);
				_vala_code_node_unref0 (result_local);
				_vala_code_node_unref0 (result_type);
				_vala_code_node_unref0 (inner_access);
				_vala_code_node_unref0 (non_null_expr);
				_vala_code_node_unref0 (inner_decl);
				_vala_code_node_unref0 (inner_local);
				_vala_code_node_unref0 (inner_type);
				return result;
			}
		}
		_tmp308_ = result_access;
		result = vala_code_node_check ((ValaCodeNode*) _tmp308_, context);
		_vala_code_node_unref0 (result_access);
		_vala_code_node_unref0 (non_null_ifstmt);
		_vala_code_node_unref0 (non_null_block);
		_vala_code_node_unref0 (non_null_stmt);
		_vala_code_node_unref0 (non_null_safe);
		_vala_code_node_unref0 (result_decl);
		_vala_code_node_unref0 (result_local);
		_vala_code_node_unref0 (result_type);
		_vala_code_node_unref0 (inner_access);
		_vala_code_node_unref0 (non_null_expr);
		_vala_code_node_unref0 (inner_decl);
		_vala_code_node_unref0 (inner_local);
		_vala_code_node_unref0 (inner_type);
		return result;
	}
}

ValaExpression*
vala_expression_construct (GType object_type)
{
	ValaExpression* self = NULL;
	self = (ValaExpression*) vala_code_node_construct (object_type);
	return self;
}

static void
vala_expression_class_init (ValaExpressionClass * klass,
                            gpointer klass_data)
{
	vala_expression_parent_class = g_type_class_peek_parent (klass);
	((ValaCodeNodeClass *) klass)->finalize = vala_expression_finalize;
	g_type_class_adjust_private_offset (klass, &ValaExpression_private_offset);
	((ValaExpressionClass *) klass)->is_constant = (gboolean (*) (ValaExpression*)) vala_expression_real_is_constant;
	((ValaExpressionClass *) klass)->is_pure = (gboolean (*) (ValaExpression*)) vala_expression_real_is_pure;
	((ValaExpressionClass *) klass)->is_non_null = (gboolean (*) (ValaExpression*)) vala_expression_real_is_non_null;
	((ValaExpressionClass *) klass)->is_accessible = (gboolean (*) (ValaExpression*, ValaSymbol*)) vala_expression_real_is_accessible;
	((ValaCodeNodeClass *) klass)->check = (gboolean (*) (ValaCodeNode*, ValaCodeContext*)) vala_expression_real_check;
}

static void
vala_expression_instance_init (ValaExpression * self,
                               gpointer klass)
{
	self->priv = vala_expression_get_instance_private (self);
}

static void
vala_expression_finalize (ValaCodeNode * obj)
{
	ValaExpression * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VALA_TYPE_EXPRESSION, ValaExpression);
	_vala_code_node_unref0 (self->priv->_value_type);
	_vala_code_node_unref0 (self->priv->_formal_value_type);
	_vala_code_node_unref0 (self->priv->_target_type);
	_vala_code_node_unref0 (self->priv->_formal_target_type);
	_vala_target_value_unref0 (self->priv->_target_value);
	VALA_CODE_NODE_CLASS (vala_expression_parent_class)->finalize (obj);
}

/**
 * Base class for all code nodes that might be used as an expression.
 */
static GType
vala_expression_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ValaExpressionClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_expression_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaExpression), 0, (GInstanceInitFunc) vala_expression_instance_init, NULL };
	GType vala_expression_type_id;
	vala_expression_type_id = g_type_register_static (VALA_TYPE_CODE_NODE, "ValaExpression", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
	ValaExpression_private_offset = g_type_add_instance_private (vala_expression_type_id, sizeof (ValaExpressionPrivate));
	return vala_expression_type_id;
}

GType
vala_expression_get_type (void)
{
	static volatile gsize vala_expression_type_id__volatile = 0;
	if (g_once_init_enter (&vala_expression_type_id__volatile)) {
		GType vala_expression_type_id;
		vala_expression_type_id = vala_expression_get_type_once ();
		g_once_init_leave (&vala_expression_type_id__volatile, vala_expression_type_id);
	}
	return vala_expression_type_id__volatile;
}

