/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.cryptofs.health.dirid;

import java.nio.file.Path;
import java.util.Map;
import org.cryptomator.cryptofs.health.api.DiagnosticResult;

public class MissingDirectory
implements DiagnosticResult {
    final String dirId;
    final Path file;

    MissingDirectory(String dirId, Path file) {
        this.dirId = dirId;
        this.file = file;
    }

    @Override
    public DiagnosticResult.Severity getSeverity() {
        return DiagnosticResult.Severity.CRITICAL;
    }

    @Override
    public String toString() {
        return String.format("dir.c9r file (%s) points to non-existing directory.", this.file);
    }

    @Override
    public Map<String, String> details() {
        return Map.of("Directory ID", this.dirId, "Directory ID File", this.file.toString());
    }
}

