/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.cryptofs.dir;

import com.google.common.base.CharMatcher;
import com.google.common.io.BaseEncoding;
import java.nio.charset.StandardCharsets;
import java.util.Optional;
import java.util.regex.MatchResult;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import javax.inject.Inject;
import javax.inject.Named;
import org.cryptomator.cryptofs.common.StringUtils;
import org.cryptomator.cryptofs.dir.DirectoryStreamScoped;
import org.cryptomator.cryptofs.dir.Node;
import org.cryptomator.cryptolib.api.AuthenticationFailedException;
import org.cryptomator.cryptolib.api.Cryptor;

@DirectoryStreamScoped
class C9rDecryptor {
    static final Pattern BASE64_PATTERN = Pattern.compile("([a-zA-Z0-9-_]{4})*[a-zA-Z0-9-_]{20}[a-zA-Z0-9-_=]{4}");
    private static final CharMatcher DELIM_MATCHER = CharMatcher.anyOf((CharSequence)"_-");
    private final Cryptor cryptor;
    private final byte[] dirId;

    @Inject
    public C9rDecryptor(Cryptor cryptor, @Named(value="dirId") String dirId) {
        this.cryptor = cryptor;
        this.dirId = dirId.getBytes(StandardCharsets.US_ASCII);
    }

    public Stream<Node> process(Node node) {
        String basename = StringUtils.removeEnd(node.fullCiphertextFileName, ".c9r");
        Matcher matcher = BASE64_PATTERN.matcher(basename);
        Optional<Node> match = this.extractCiphertext(node, matcher, 0, basename.length());
        if (match.isPresent()) {
            return Stream.of(match.get());
        }
        return Stream.empty();
    }

    private Optional<Node> extractCiphertext(Node node, Matcher matcher, int start, int end) {
        block12: {
            matcher.region(start, end);
            if (matcher.find()) {
                MatchResult match = matcher.toMatchResult();
                String validBase64 = match.group();
                assert (validBase64.length() >= 24);
                assert (match.end() - match.start() >= 24);
                try {
                    node.cleartextName = this.cryptor.fileNameCryptor().decryptFilename(BaseEncoding.base64Url(), validBase64, (byte[][])new byte[][]{this.dirId});
                    node.extractedCiphertext = validBase64;
                    return Optional.of(node);
                }
                catch (AuthenticationFailedException e) {
                    int firstDelimIdx = DELIM_MATCHER.indexIn((CharSequence)validBase64);
                    int lastDelimIdx = DELIM_MATCHER.lastIndexIn((CharSequence)validBase64);
                    if (firstDelimIdx == -1) {
                        assert (lastDelimIdx == -1);
                        return Optional.empty();
                    }
                    int newStart = match.start() + Math.max(1, firstDelimIdx);
                    assert (match.start() >= start);
                    assert (newStart > start);
                    Optional<Node> matchWithNewStart = this.extractCiphertext(node, matcher, newStart, end);
                    if (matchWithNewStart.isPresent()) {
                        return matchWithNewStart;
                    }
                    int delimDistanceFromEnd = validBase64.length() - lastDelimIdx;
                    int newEnd = match.end() - Math.max(1, delimDistanceFromEnd);
                    assert (match.end() <= end);
                    assert (newEnd < end);
                    Optional<Node> matchWithNewEnd = this.extractCiphertext(node, matcher, start, newEnd);
                    if (!matchWithNewEnd.isPresent()) break block12;
                    return matchWithNewEnd;
                }
            }
        }
        return Optional.empty();
    }
}

