/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.cryptofs.attr;

import java.nio.file.Path;
import java.nio.file.attribute.DosFileAttributes;
import java.util.Optional;
import org.cryptomator.cryptofs.CryptoFileSystemProperties;
import org.cryptomator.cryptofs.attr.CryptoBasicFileAttributes;
import org.cryptomator.cryptofs.common.CiphertextFileType;
import org.cryptomator.cryptofs.fh.OpenCryptoFile;
import org.cryptomator.cryptolib.api.Cryptor;

final class CryptoDosFileAttributes
extends CryptoBasicFileAttributes
implements DosFileAttributes {
    private final boolean readonlyFileSystem;
    private final DosFileAttributes delegate;

    public CryptoDosFileAttributes(DosFileAttributes delegate, CiphertextFileType ciphertextFileType, Path ciphertextPath, Cryptor cryptor, Optional<OpenCryptoFile> openCryptoFile, CryptoFileSystemProperties fileSystemProperties) {
        super(delegate, ciphertextFileType, ciphertextPath, cryptor, openCryptoFile);
        this.readonlyFileSystem = fileSystemProperties.readonly();
        this.delegate = delegate;
    }

    @Override
    public boolean isReadOnly() {
        return this.readonlyFileSystem || this.delegate.isReadOnly();
    }

    @Override
    public boolean isHidden() {
        return this.delegate.isHidden();
    }

    @Override
    public boolean isArchive() {
        return this.delegate.isArchive();
    }

    @Override
    public boolean isSystem() {
        return this.delegate.isSystem();
    }
}

