/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.ui.preferences;

import java.util.Optional;
import java.util.ResourceBundle;
import java.util.Set;
import javafx.application.Application;
import javafx.beans.binding.Bindings;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.Property;
import javafx.beans.value.ObservableValue;
import javafx.fxml.FXML;
import javafx.geometry.NodeOrientation;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ChoiceBox;
import javafx.scene.control.RadioButton;
import javafx.scene.control.Toggle;
import javafx.scene.control.ToggleGroup;
import javafx.stage.Stage;
import javafx.util.StringConverter;
import javax.inject.Inject;
import org.cryptomator.common.Environment;
import org.cryptomator.common.LicenseHolder;
import org.cryptomator.common.settings.Settings;
import org.cryptomator.common.settings.UiTheme;
import org.cryptomator.integrations.autostart.AutoStartProvider;
import org.cryptomator.integrations.autostart.ToggleAutoStartFailedException;
import org.cryptomator.integrations.keychain.KeychainAccessProvider;
import org.cryptomator.ui.common.ErrorComponent;
import org.cryptomator.ui.common.FxController;
import org.cryptomator.ui.preferences.PreferencesScoped;
import org.cryptomator.ui.preferences.PreferencesWindow;
import org.cryptomator.ui.preferences.SelectedPreferencesTab;
import org.cryptomator.ui.traymenu.TrayMenuComponent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PreferencesScoped
public class GeneralPreferencesController
implements FxController {
    private static final Logger LOG = LoggerFactory.getLogger(GeneralPreferencesController.class);
    private final Stage window;
    private final Settings settings;
    private final boolean trayMenuInitialized;
    private final boolean trayMenuSupported;
    private final Optional<AutoStartProvider> autoStartProvider;
    private final ObjectProperty<SelectedPreferencesTab> selectedTabProperty;
    private final LicenseHolder licenseHolder;
    private final ResourceBundle resourceBundle;
    private final Application application;
    private final Environment environment;
    private final Set<KeychainAccessProvider> keychainAccessProviders;
    private final ErrorComponent.Builder errorComponent;
    public ChoiceBox<UiTheme> themeChoiceBox;
    public ChoiceBox<KeychainAccessProvider> keychainBackendChoiceBox;
    public CheckBox showMinimizeButtonCheckbox;
    public CheckBox showTrayIconCheckbox;
    public CheckBox startHiddenCheckbox;
    public CheckBox debugModeCheckbox;
    public CheckBox autoStartCheckbox;
    public ToggleGroup nodeOrientation;
    public RadioButton nodeOrientationLtr;
    public RadioButton nodeOrientationRtl;

    @Inject
    GeneralPreferencesController(@PreferencesWindow Stage window, Settings settings, TrayMenuComponent trayMenu, Optional<AutoStartProvider> autoStartProvider, Set<KeychainAccessProvider> keychainAccessProviders, ObjectProperty<SelectedPreferencesTab> selectedTabProperty, LicenseHolder licenseHolder, ResourceBundle resourceBundle, Application application, Environment environment, ErrorComponent.Builder errorComponent) {
        this.window = window;
        this.settings = settings;
        this.trayMenuInitialized = trayMenu.isInitialized();
        this.trayMenuSupported = trayMenu.isSupported();
        this.autoStartProvider = autoStartProvider;
        this.keychainAccessProviders = keychainAccessProviders;
        this.selectedTabProperty = selectedTabProperty;
        this.licenseHolder = licenseHolder;
        this.resourceBundle = resourceBundle;
        this.application = application;
        this.environment = environment;
        this.errorComponent = errorComponent;
    }

    @FXML
    public void initialize() {
        this.themeChoiceBox.getItems().addAll((Object[])UiTheme.applicableValues());
        if (!this.themeChoiceBox.getItems().contains(this.settings.theme().get())) {
            this.settings.theme().set((Object)UiTheme.LIGHT);
        }
        this.themeChoiceBox.valueProperty().bindBidirectional(this.settings.theme());
        this.themeChoiceBox.setConverter((StringConverter)new UiThemeConverter(this.resourceBundle));
        this.showMinimizeButtonCheckbox.selectedProperty().bindBidirectional((Property)this.settings.showMinimizeButton());
        this.showTrayIconCheckbox.selectedProperty().bindBidirectional((Property)this.settings.showTrayIcon());
        this.startHiddenCheckbox.selectedProperty().bindBidirectional((Property)this.settings.startHidden());
        this.debugModeCheckbox.selectedProperty().bindBidirectional((Property)this.settings.debugMode());
        this.autoStartProvider.ifPresent(autoStart -> this.autoStartCheckbox.setSelected(autoStart.isEnabled()));
        this.nodeOrientationLtr.setSelected(this.settings.userInterfaceOrientation().get() == NodeOrientation.LEFT_TO_RIGHT);
        this.nodeOrientationRtl.setSelected(this.settings.userInterfaceOrientation().get() == NodeOrientation.RIGHT_TO_LEFT);
        this.nodeOrientation.selectedToggleProperty().addListener(this::toggleNodeOrientation);
        KeychainProviderClassNameConverter keychainSettingsConverter = new KeychainProviderClassNameConverter(this.keychainAccessProviders);
        this.keychainBackendChoiceBox.getItems().addAll(this.keychainAccessProviders);
        this.keychainBackendChoiceBox.setValue((Object)keychainSettingsConverter.fromString((String)this.settings.keychainProvider().get()));
        this.keychainBackendChoiceBox.setConverter((StringConverter)new KeychainProviderDisplayNameConverter());
        Bindings.bindBidirectional(this.settings.keychainProvider(), (Property)this.keychainBackendChoiceBox.valueProperty(), (StringConverter)keychainSettingsConverter);
    }

    public boolean isTrayMenuInitialized() {
        return this.trayMenuInitialized;
    }

    public boolean isTrayMenuSupported() {
        return this.trayMenuSupported;
    }

    public boolean isAutoStartSupported() {
        return this.autoStartProvider.isPresent();
    }

    private void toggleNodeOrientation(ObservableValue<? extends Toggle> observable, Toggle oldValue, Toggle newValue) {
        if (this.nodeOrientationLtr.equals(newValue)) {
            this.settings.userInterfaceOrientation().set((Object)NodeOrientation.LEFT_TO_RIGHT);
        } else if (this.nodeOrientationRtl.equals(newValue)) {
            this.settings.userInterfaceOrientation().set((Object)NodeOrientation.RIGHT_TO_LEFT);
        } else {
            LOG.warn("Unexpected toggle option {}", (Object)newValue);
        }
    }

    @FXML
    public void toggleAutoStart() {
        this.autoStartProvider.ifPresent(autoStart -> {
            boolean enableAutoStart = this.autoStartCheckbox.isSelected();
            try {
                if (enableAutoStart) {
                    autoStart.enable();
                } else {
                    autoStart.disable();
                }
            }
            catch (ToggleAutoStartFailedException e) {
                this.autoStartCheckbox.setSelected(!enableAutoStart);
                LOG.error("Failed to toggle autostart.", (Throwable)e);
                this.errorComponent.cause(e).window(this.window).returnToScene(this.window.getScene()).build().showErrorScene();
            }
        });
    }

    public LicenseHolder getLicenseHolder() {
        return this.licenseHolder;
    }

    @FXML
    public void showContributeTab() {
        this.selectedTabProperty.set((Object)SelectedPreferencesTab.CONTRIBUTE);
    }

    @FXML
    public void showLogfileDirectory() {
        this.environment.getLogDir().ifPresent(logDirPath -> this.application.getHostServices().showDocument(logDirPath.toUri().toString()));
    }

    private static class UiThemeConverter
    extends StringConverter<UiTheme> {
        private final ResourceBundle resourceBundle;

        UiThemeConverter(ResourceBundle resourceBundle) {
            this.resourceBundle = resourceBundle;
        }

        public String toString(UiTheme impl) {
            return this.resourceBundle.getString(impl.getDisplayName());
        }

        public UiTheme fromString(String string) {
            throw new UnsupportedOperationException();
        }
    }

    private static class KeychainProviderClassNameConverter
    extends StringConverter<KeychainAccessProvider> {
        private final Set<KeychainAccessProvider> keychainAccessProviders;

        public KeychainProviderClassNameConverter(Set<KeychainAccessProvider> keychainAccessProviders) {
            this.keychainAccessProviders = keychainAccessProviders;
        }

        public String toString(KeychainAccessProvider provider) {
            if (provider == null) {
                return null;
            }
            return provider.getClass().getName();
        }

        public KeychainAccessProvider fromString(String string) {
            if (string == null) {
                return null;
            }
            return this.keychainAccessProviders.stream().filter(provider -> provider.getClass().getName().equals(string)).findAny().orElse(null);
        }
    }

    private class KeychainProviderDisplayNameConverter
    extends StringConverter<KeychainAccessProvider> {
        private KeychainProviderDisplayNameConverter() {
        }

        public String toString(KeychainAccessProvider provider) {
            if (provider == null) {
                return null;
            }
            return provider.displayName();
        }

        public KeychainAccessProvider fromString(String string) {
            throw new UnsupportedOperationException();
        }
    }
}

