/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.ui.mainwindow;

import com.tobiasdiez.easybind.EasyBind;
import com.tobiasdiez.easybind.optional.ObservableOptionalValue;
import com.tobiasdiez.easybind.optional.OptionalBinding;
import java.util.EnumSet;
import java.util.Optional;
import javafx.beans.binding.Binding;
import javafx.beans.property.ObjectProperty;
import javafx.fxml.FXML;
import javafx.stage.Stage;
import javax.inject.Inject;
import org.cryptomator.common.keychain.KeychainManager;
import org.cryptomator.common.vaults.Vault;
import org.cryptomator.common.vaults.VaultState;
import org.cryptomator.ui.common.FxController;
import org.cryptomator.ui.fxapp.FxApplication;
import org.cryptomator.ui.mainwindow.MainWindow;
import org.cryptomator.ui.mainwindow.MainWindowScoped;
import org.cryptomator.ui.removevault.RemoveVaultComponent;
import org.cryptomator.ui.vaultoptions.SelectedVaultOptionsTab;
import org.cryptomator.ui.vaultoptions.VaultOptionsComponent;

@MainWindowScoped
public class VaultListContextMenuController
implements FxController {
    private final ObservableOptionalValue<Vault> selectedVault;
    private final Stage mainWindow;
    private final FxApplication application;
    private final KeychainManager keychain;
    private final RemoveVaultComponent.Builder removeVault;
    private final VaultOptionsComponent.Builder vaultOptionsWindow;
    private final OptionalBinding<VaultState.Value> selectedVaultState;
    private final Binding<Boolean> selectedVaultPassphraseStored;
    private final Binding<Boolean> selectedVaultRemovable;
    private final Binding<Boolean> selectedVaultUnlockable;
    private final Binding<Boolean> selectedVaultLockable;

    @Inject
    VaultListContextMenuController(ObjectProperty<Vault> selectedVault, @MainWindow Stage mainWindow, FxApplication application, KeychainManager keychain, RemoveVaultComponent.Builder removeVault, VaultOptionsComponent.Builder vaultOptionsWindow) {
        this.selectedVault = EasyBind.wrapNullable(selectedVault);
        this.mainWindow = mainWindow;
        this.application = application;
        this.keychain = keychain;
        this.removeVault = removeVault;
        this.vaultOptionsWindow = vaultOptionsWindow;
        this.selectedVaultState = this.selectedVault.mapObservable(Vault::stateProperty);
        this.selectedVaultPassphraseStored = this.selectedVault.map(this::isPasswordStored).orElse((Object)false);
        this.selectedVaultRemovable = this.selectedVaultState.map(EnumSet.of(VaultState.Value.LOCKED, VaultState.Value.MISSING, VaultState.Value.ERROR, VaultState.Value.NEEDS_MIGRATION)::contains).orElse((Object)false);
        this.selectedVaultUnlockable = this.selectedVaultState.map(VaultState.Value.LOCKED::equals).orElse((Object)false);
        this.selectedVaultLockable = this.selectedVaultState.map(VaultState.Value.UNLOCKED::equals).orElse((Object)false);
    }

    private boolean isPasswordStored(Vault vault) {
        return this.keychain.getPassphraseStoredProperty(vault.getId()).get();
    }

    @FXML
    public void didClickRemoveVault() {
        this.selectedVault.ifValuePresent(v -> this.removeVault.vault((Vault)v).build().showRemoveVault());
    }

    @FXML
    public void didClickShowVaultOptions() {
        this.selectedVault.ifValuePresent(v -> this.vaultOptionsWindow.vault((Vault)v).build().showVaultOptionsWindow(SelectedVaultOptionsTab.ANY));
    }

    @FXML
    public void didClickUnlockVault() {
        this.selectedVault.ifValuePresent(v -> this.application.startUnlockWorkflow((Vault)v, Optional.of(this.mainWindow)));
    }

    @FXML
    public void didClickLockVault() {
        this.selectedVault.ifValuePresent(v -> this.application.startLockWorkflow((Vault)v, Optional.of(this.mainWindow)));
    }

    @FXML
    public void didClickRevealVault() {
        this.selectedVault.ifValuePresent(v -> this.application.getVaultService().reveal((Vault)v));
    }

    public Binding<Boolean> selectedVaultUnlockableProperty() {
        return this.selectedVaultUnlockable;
    }

    public boolean isSelectedVaultUnlockable() {
        return (Boolean)this.selectedVaultUnlockable.getValue();
    }

    public Binding<Boolean> selectedVaultLockableProperty() {
        return this.selectedVaultLockable;
    }

    public boolean isSelectedVaultLockable() {
        return (Boolean)this.selectedVaultLockable.getValue();
    }

    public Binding<Boolean> selectedVaultRemovableProperty() {
        return this.selectedVaultRemovable;
    }

    public boolean isSelectedVaultRemovable() {
        return (Boolean)this.selectedVaultRemovable.getValue();
    }

    public Binding<Boolean> selectedVaultPassphraseStoredProperty() {
        return this.selectedVaultPassphraseStored;
    }

    public boolean isSelectedVaultPassphraseStored() {
        return (Boolean)this.selectedVaultPassphraseStored.getValue();
    }
}

