/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.ui.health;

import com.google.common.base.Preconditions;
import dagger.Lazy;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import javafx.beans.binding.Bindings;
import javafx.beans.binding.BooleanBinding;
import javafx.beans.binding.IntegerBinding;
import javafx.beans.property.ObjectProperty;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.collections.transformation.FilteredList;
import javafx.fxml.FXML;
import javafx.scene.control.ListView;
import javafx.scene.control.SelectionMode;
import javafx.stage.Stage;
import javafx.util.Callback;
import javax.inject.Inject;
import org.cryptomator.ui.common.ErrorComponent;
import org.cryptomator.ui.common.FxController;
import org.cryptomator.ui.health.Check;
import org.cryptomator.ui.health.CheckExecutor;
import org.cryptomator.ui.health.CheckListCellFactory;
import org.cryptomator.ui.health.HealthCheckScoped;
import org.cryptomator.ui.health.HealthCheckWindow;
import org.cryptomator.ui.health.ReportWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@HealthCheckScoped
public class CheckListController
implements FxController {
    private static final Logger LOG = LoggerFactory.getLogger(CheckListController.class);
    private final Stage window;
    private final ObservableList<Check> checks;
    private final CheckExecutor checkExecutor;
    private final FilteredList<Check> chosenChecks;
    private final ReportWriter reportWriter;
    private final ObjectProperty<Check> selectedCheck;
    private final BooleanBinding mainRunStarted;
    private final BooleanBinding somethingsRunning;
    private final Lazy<ErrorComponent.Builder> errorComponentBuilder;
    private final IntegerBinding chosenTaskCount;
    private final BooleanBinding anyCheckSelected;
    private final CheckListCellFactory listCellFactory;
    public ListView<Check> checksListView;

    @Inject
    public CheckListController(@HealthCheckWindow Stage window, List<Check> checks, CheckExecutor checkExecutor, ReportWriter reportWriteTask, ObjectProperty<Check> selectedCheck, Lazy<ErrorComponent.Builder> errorComponentBuilder, CheckListCellFactory listCellFactory) {
        this.window = window;
        this.checks = FXCollections.observableList(checks, Check::observables);
        this.checkExecutor = checkExecutor;
        this.listCellFactory = listCellFactory;
        this.chosenChecks = this.checks.filtered(Check::isChosenForExecution);
        this.reportWriter = reportWriteTask;
        this.selectedCheck = selectedCheck;
        this.errorComponentBuilder = errorComponentBuilder;
        this.chosenTaskCount = Bindings.size(this.chosenChecks);
        this.mainRunStarted = Bindings.isEmpty((ObservableList)this.checks.filtered(c -> c.getState() == Check.CheckState.RUNNABLE));
        this.somethingsRunning = Bindings.isNotEmpty((ObservableList)this.checks.filtered(c -> c.getState() == Check.CheckState.SCHEDULED || c.getState() == Check.CheckState.RUNNING));
        this.anyCheckSelected = selectedCheck.isNotNull();
    }

    @FXML
    public void initialize() {
        this.checksListView.getSelectionModel().setSelectionMode(SelectionMode.SINGLE);
        this.checksListView.setItems(this.checks);
        this.checksListView.setCellFactory((Callback)this.listCellFactory);
        this.selectedCheck.bind((ObservableValue)this.checksListView.getSelectionModel().selectedItemProperty());
    }

    @FXML
    public void selectAllChecks() {
        this.checks.forEach(t -> t.chosenForExecutionProperty().set(true));
    }

    @FXML
    public void deselectAllChecks() {
        this.checks.forEach(t -> t.chosenForExecutionProperty().set(false));
    }

    @FXML
    public void runSelectedChecks() {
        Preconditions.checkState((!this.mainRunStarted.get() ? 1 : 0) != 0);
        Preconditions.checkState((!this.somethingsRunning.get() ? 1 : 0) != 0);
        Preconditions.checkState((!this.chosenChecks.isEmpty() ? 1 : 0) != 0);
        this.checks.filtered(c -> !c.isChosenForExecution()).forEach(c -> c.setState(Check.CheckState.SKIPPED));
        this.checkExecutor.executeBatch((List<Check>)this.chosenChecks);
        this.checksListView.getSelectionModel().select((Object)((Check)this.chosenChecks.get(0)));
        this.checksListView.refresh();
        this.window.sizeToScene();
    }

    @FXML
    public synchronized void cancelRun() {
        Preconditions.checkState((boolean)this.somethingsRunning.get());
        this.checkExecutor.cancel();
    }

    @FXML
    public void exportResults() {
        try {
            this.reportWriter.writeReport((Collection<Check>)this.chosenChecks);
        }
        catch (IOException e) {
            LOG.error("Failed to write health check report.", (Throwable)e);
            ((ErrorComponent.Builder)this.errorComponentBuilder.get()).cause(e).window(this.window).returnToScene(this.window.getScene()).build().showErrorScene();
        }
    }

    public boolean isRunning() {
        return this.somethingsRunning.getValue();
    }

    public BooleanBinding runningProperty() {
        return this.somethingsRunning;
    }

    public boolean isAnyCheckSelected() {
        return this.anyCheckSelected.get();
    }

    public BooleanBinding anyCheckSelectedProperty() {
        return this.anyCheckSelected;
    }

    public boolean isMainRunStarted() {
        return this.mainRunStarted.get();
    }

    public BooleanBinding mainRunStartedProperty() {
        return this.mainRunStarted;
    }

    public int getChosenTaskCount() {
        return this.chosenTaskCount.getValue();
    }

    public IntegerBinding chosenTaskCountProperty() {
        return this.chosenTaskCount;
    }
}

