/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.launcher;

import java.util.Collections;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.cryptomator.ipc.IpcMessageListener;
import org.cryptomator.launcher.FileOpenRequestHandler;
import org.cryptomator.ui.launcher.AppLaunchEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
class IpcMessageHandler
implements IpcMessageListener {
    private static final Logger LOG = LoggerFactory.getLogger(IpcMessageHandler.class);
    private final FileOpenRequestHandler fileOpenRequestHandler;
    private final BlockingQueue<AppLaunchEvent> launchEventQueue;

    @Inject
    public IpcMessageHandler(FileOpenRequestHandler fileOpenRequestHandler, @Named(value="launchEventQueue") BlockingQueue<AppLaunchEvent> launchEventQueue) {
        this.fileOpenRequestHandler = fileOpenRequestHandler;
        this.launchEventQueue = launchEventQueue;
    }

    @Override
    public void revealRunningApp() {
        this.launchEventQueue.add(new AppLaunchEvent(AppLaunchEvent.EventType.REVEAL_APP, Collections.emptyList()));
    }

    @Override
    public void handleLaunchArgs(List<String> args) {
        LOG.debug("Received launch args: {}", (Object)args.stream().reduce((a, b) -> a + ", " + b).orElse(""));
        this.fileOpenRequestHandler.handleLaunchArgs(args);
    }
}

