/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.ipc;

import java.util.concurrent.Executor;
import java.util.concurrent.LinkedTransferQueue;
import java.util.concurrent.TransferQueue;
import org.cryptomator.ipc.IpcCommunicator;
import org.cryptomator.ipc.IpcMessage;
import org.cryptomator.ipc.IpcMessageListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class LoopbackCommunicator
implements IpcCommunicator {
    private static final Logger LOG = LoggerFactory.getLogger(LoopbackCommunicator.class);
    private final TransferQueue<IpcMessage> transferQueue = new LinkedTransferQueue<IpcMessage>();

    LoopbackCommunicator() {
    }

    @Override
    public boolean isClient() {
        return false;
    }

    @Override
    public void listen(IpcMessageListener listener, Executor executor) {
        executor.execute(() -> {
            try {
                IpcMessage msg = (IpcMessage)this.transferQueue.take();
                listener.handleMessage(msg);
            }
            catch (InterruptedException e) {
                LOG.error("Failed to read IPC message", (Throwable)e);
                Thread.currentThread().interrupt();
            }
        });
    }

    @Override
    public void send(IpcMessage message, Executor executor) {
        executor.execute(() -> {
            try {
                this.transferQueue.put(message);
            }
            catch (InterruptedException e) {
                LOG.error("Failed to send IPC message", (Throwable)e);
                Thread.currentThread().interrupt();
            }
        });
    }

    @Override
    public void close() {
    }
}

