/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.common.settings;

import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javafx.geometry.NodeOrientation;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.cryptomator.common.Environment;
import org.cryptomator.common.settings.Settings;
import org.cryptomator.common.settings.UiTheme;
import org.cryptomator.common.settings.VaultSettings;
import org.cryptomator.common.settings.VaultSettingsJsonAdapter;
import org.cryptomator.common.settings.VolumeImpl;
import org.cryptomator.common.settings.WebDavUrlScheme;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class SettingsJsonAdapter
extends TypeAdapter<Settings> {
    private static final Logger LOG = LoggerFactory.getLogger(SettingsJsonAdapter.class);
    private final VaultSettingsJsonAdapter vaultSettingsJsonAdapter = new VaultSettingsJsonAdapter();
    private final Environment env;

    @Inject
    public SettingsJsonAdapter(Environment env) {
        this.env = env;
    }

    public void write(JsonWriter out, Settings value) throws IOException {
        out.beginObject();
        out.name("directories");
        this.writeVaultSettingsArray(out, (Iterable<VaultSettings>)value.getDirectories());
        out.name("askedForUpdateCheck").value(value.askedForUpdateCheck().get());
        out.name("checkForUpdatesEnabled").value(value.checkForUpdates().get());
        out.name("startHidden").value(value.startHidden().get());
        out.name("port").value((long)value.port().get());
        out.name("numTrayNotifications").value((long)value.numTrayNotifications().get());
        out.name("preferredGvfsScheme").value(((WebDavUrlScheme)((Object)value.preferredGvfsScheme().get())).name());
        out.name("debugMode").value(value.debugMode().get());
        out.name("preferredVolumeImpl").value(((VolumeImpl)((Object)value.preferredVolumeImpl().get())).name());
        out.name("theme").value(((UiTheme)((Object)value.theme().get())).name());
        out.name("uiOrientation").value(((NodeOrientation)value.userInterfaceOrientation().get()).name());
        out.name("keychainProvider").value((String)value.keychainProvider().get());
        out.name("licenseKey").value((String)value.licenseKey().get());
        out.name("showMinimizeButton").value(value.showMinimizeButton().get());
        out.name("showTrayIcon").value(value.showTrayIcon().get());
        out.name("windowXPosition").value((long)value.windowXPositionProperty().get());
        out.name("windowYPosition").value((long)value.windowYPositionProperty().get());
        out.name("windowWidth").value((long)value.windowWidthProperty().get());
        out.name("windowHeight").value((long)value.windowHeightProperty().get());
        out.name("displayConfiguration").value((String)value.displayConfigurationProperty().get());
        out.endObject();
    }

    private void writeVaultSettingsArray(JsonWriter out, Iterable<VaultSettings> vaultSettings) throws IOException {
        out.beginArray();
        for (VaultSettings value : vaultSettings) {
            this.vaultSettingsJsonAdapter.write(out, value);
        }
        out.endArray();
    }

    public Settings read(JsonReader in) throws IOException {
        Settings settings = new Settings(this.env);
        in.beginObject();
        block44: while (in.hasNext()) {
            String name;
            switch (name = in.nextName()) {
                case "directories": {
                    settings.getDirectories().addAll(this.readVaultSettingsArray(in));
                    continue block44;
                }
                case "askedForUpdateCheck": {
                    settings.askedForUpdateCheck().set(in.nextBoolean());
                    continue block44;
                }
                case "checkForUpdatesEnabled": {
                    settings.checkForUpdates().set(in.nextBoolean());
                    continue block44;
                }
                case "startHidden": {
                    settings.startHidden().set(in.nextBoolean());
                    continue block44;
                }
                case "port": {
                    settings.port().set(in.nextInt());
                    continue block44;
                }
                case "numTrayNotifications": {
                    settings.numTrayNotifications().set(in.nextInt());
                    continue block44;
                }
                case "preferredGvfsScheme": {
                    settings.preferredGvfsScheme().set((Object)this.parseWebDavUrlSchemePrefix(in.nextString()));
                    continue block44;
                }
                case "debugMode": {
                    settings.debugMode().set(in.nextBoolean());
                    continue block44;
                }
                case "preferredVolumeImpl": {
                    settings.preferredVolumeImpl().set((Object)this.parsePreferredVolumeImplName(in.nextString()));
                    continue block44;
                }
                case "theme": {
                    settings.theme().set((Object)this.parseUiTheme(in.nextString()));
                    continue block44;
                }
                case "uiOrientation": {
                    settings.userInterfaceOrientation().set((Object)this.parseUiOrientation(in.nextString()));
                    continue block44;
                }
                case "keychainProvider": {
                    settings.keychainProvider().set((Object)in.nextString());
                    continue block44;
                }
                case "licenseKey": {
                    settings.licenseKey().set((Object)in.nextString());
                    continue block44;
                }
                case "showMinimizeButton": {
                    settings.showMinimizeButton().set(in.nextBoolean());
                    continue block44;
                }
                case "showTrayIcon": {
                    settings.showTrayIcon().set(in.nextBoolean());
                    continue block44;
                }
                case "windowXPosition": {
                    settings.windowXPositionProperty().set(in.nextInt());
                    continue block44;
                }
                case "windowYPosition": {
                    settings.windowYPositionProperty().set(in.nextInt());
                    continue block44;
                }
                case "windowWidth": {
                    settings.windowWidthProperty().set(in.nextInt());
                    continue block44;
                }
                case "windowHeight": {
                    settings.windowHeightProperty().set(in.nextInt());
                    continue block44;
                }
                case "displayConfiguration": {
                    settings.displayConfigurationProperty().set((Object)in.nextString());
                    continue block44;
                }
            }
            LOG.warn("Unsupported vault setting found in JSON: " + name);
            in.skipValue();
        }
        in.endObject();
        return settings;
    }

    private VolumeImpl parsePreferredVolumeImplName(String nioAdapterName) {
        try {
            return VolumeImpl.valueOf(nioAdapterName.toUpperCase());
        }
        catch (IllegalArgumentException e) {
            LOG.warn("Invalid volume type {}. Defaulting to {}.", (Object)nioAdapterName, (Object)Settings.DEFAULT_PREFERRED_VOLUME_IMPL);
            return Settings.DEFAULT_PREFERRED_VOLUME_IMPL;
        }
    }

    private WebDavUrlScheme parseWebDavUrlSchemePrefix(String webDavUrlSchemeName) {
        try {
            return WebDavUrlScheme.valueOf(webDavUrlSchemeName.toUpperCase());
        }
        catch (IllegalArgumentException e) {
            LOG.warn("Invalid WebDAV url scheme {}. Defaulting to {}.", (Object)webDavUrlSchemeName, (Object)Settings.DEFAULT_GVFS_SCHEME);
            return Settings.DEFAULT_GVFS_SCHEME;
        }
    }

    private UiTheme parseUiTheme(String uiThemeName) {
        try {
            return UiTheme.valueOf(uiThemeName.toUpperCase());
        }
        catch (IllegalArgumentException e) {
            LOG.warn("Invalid ui theme {}. Defaulting to {}.", (Object)uiThemeName, (Object)Settings.DEFAULT_THEME);
            return Settings.DEFAULT_THEME;
        }
    }

    private NodeOrientation parseUiOrientation(String uiOrientationName) {
        try {
            return NodeOrientation.valueOf((String)uiOrientationName.toUpperCase());
        }
        catch (IllegalArgumentException e) {
            LOG.warn("Invalid ui orientation {}. Defaulting to {}.", (Object)uiOrientationName, (Object)Settings.DEFAULT_USER_INTERFACE_ORIENTATION);
            return Settings.DEFAULT_USER_INTERFACE_ORIENTATION;
        }
    }

    private List<VaultSettings> readVaultSettingsArray(JsonReader in) throws IOException {
        ArrayList<VaultSettings> result = new ArrayList<VaultSettings>();
        in.beginArray();
        while (!JsonToken.END_ARRAY.equals((Object)in.peek())) {
            result.add(this.vaultSettingsJsonAdapter.read(in));
        }
        in.endArray();
        return result;
    }
}

