/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.common.mountpoint;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Optional;
import javax.inject.Inject;
import org.cryptomator.common.Environment;
import org.cryptomator.common.mountpoint.InvalidMountPointException;
import org.cryptomator.common.mountpoint.MountPointChooser;
import org.cryptomator.common.mountpoint.MountPointHelper;
import org.cryptomator.common.settings.VaultSettings;
import org.cryptomator.common.vaults.Volume;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class TemporaryMountPointChooser
implements MountPointChooser {
    private static final Logger LOG = LoggerFactory.getLogger(TemporaryMountPointChooser.class);
    private final VaultSettings vaultSettings;
    private final Environment environment;
    private final MountPointHelper helper;

    @Inject
    public TemporaryMountPointChooser(VaultSettings vaultSettings, Environment environment, MountPointHelper helper) {
        this.vaultSettings = vaultSettings;
        this.environment = environment;
        this.helper = helper;
    }

    @Override
    public boolean isApplicable(Volume caller) {
        if (this.environment.getMountPointsDir().isEmpty()) {
            LOG.warn("\"cryptomator.mountPointsDir\" is not set to a valid path!");
            return false;
        }
        return true;
    }

    @Override
    public Optional<Path> chooseMountPoint(Volume caller) {
        assert (this.environment.getMountPointsDir().isPresent());
        this.helper.clearIrregularUnmountDebrisIfNeeded();
        return this.environment.getMountPointsDir().map(dir -> this.helper.chooseTemporaryMountPoint(this.vaultSettings, (Path)dir));
    }

    @Override
    public boolean prepare(Volume caller, Path mountPoint) throws InvalidMountPointException {
        try {
            switch (caller.getMountPointRequirement()) {
                case PARENT_NO_MOUNT_POINT: {
                    Files.createDirectories(mountPoint.getParent(), new FileAttribute[0]);
                    LOG.debug("Successfully created folder for mount point: {}", (Object)mountPoint);
                    return false;
                }
                case EMPTY_MOUNT_POINT: {
                    Files.createDirectories(mountPoint, new FileAttribute[0]);
                    LOG.debug("Successfully created mount point: {}", (Object)mountPoint);
                    return true;
                }
                case NONE: {
                    throw new InvalidMountPointException(new IllegalStateException("Illegal MountPointRequirement"));
                }
            }
            throw new InvalidMountPointException(new IllegalStateException("Not implemented"));
        }
        catch (IOException exception) {
            throw new InvalidMountPointException("IOException while preparing mountpoint", exception);
        }
    }

    @Override
    public void cleanup(Volume caller, Path mountPoint) {
        try {
            Files.delete(mountPoint);
            LOG.debug("Successfully deleted mount point: {}", (Object)mountPoint);
        }
        catch (IOException e) {
            LOG.warn("Could not delete mount point: {}", (Object)e.getMessage());
        }
    }
}

