/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.common.mountpoint;

import java.io.File;
import java.io.IOException;
import java.nio.file.DirectoryNotEmptyException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Optional;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.cryptomator.common.Environment;
import org.cryptomator.common.settings.VaultSettings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
class MountPointHelper {
    public static Logger LOG = LoggerFactory.getLogger(MountPointHelper.class);
    private static final int MAX_TMPMOUNTPOINT_CREATION_RETRIES = 10;
    private final Optional<Path> tmpMountPointDir;
    private volatile boolean unmountDebrisCleared = false;

    @Inject
    public MountPointHelper(Environment env) {
        this.tmpMountPointDir = env.getMountPointsDir();
    }

    public Path chooseTemporaryMountPoint(VaultSettings vaultSettings, Path parentDir) {
        String basename = vaultSettings.mountName().get();
        Path mountPoint = parentDir.resolve(basename);
        if (Files.notExists(mountPoint, new LinkOption[0])) {
            return mountPoint;
        }
        mountPoint = parentDir.resolve(basename + " (" + vaultSettings.getId() + ")");
        if (Files.notExists(mountPoint, new LinkOption[0])) {
            return mountPoint;
        }
        for (int i = 1; i < 10; ++i) {
            mountPoint = parentDir.resolve(basename + "_(" + vaultSettings.getId() + ")_" + i);
            if (!Files.notExists(mountPoint, new LinkOption[0])) continue;
            return mountPoint;
        }
        LOG.error("Failed to find feasible mountpoint at {}{}{}_x. Giving up after {} attempts.", new Object[]{parentDir, File.separator, basename, 10});
        return null;
    }

    public synchronized void clearIrregularUnmountDebrisIfNeeded() {
        if (this.unmountDebrisCleared || this.tmpMountPointDir.isEmpty()) {
            return;
        }
        if (Files.exists(this.tmpMountPointDir.get(), LinkOption.NOFOLLOW_LINKS)) {
            this.clearIrregularUnmountDebris(this.tmpMountPointDir.get());
        }
        this.unmountDebrisCleared = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearIrregularUnmountDebris(Path dirContainingMountPoints) {
        IOException cleanupFailed = new IOException("Cleanup failed");
        try {
            LOG.debug("Performing cleanup of mountpoint dir {}.", (Object)dirContainingMountPoints);
            for (Path p : Files.newDirectoryStream(dirContainingMountPoints)) {
                try {
                    BasicFileAttributes attr = Files.readAttributes(p, BasicFileAttributes.class, LinkOption.NOFOLLOW_LINKS);
                    if (attr.isOther() && attr.isDirectory()) {
                        Files.delete(p);
                        continue;
                    }
                    if (attr.isDirectory()) {
                        this.deleteEmptyDir(p);
                        continue;
                    }
                    if (attr.isSymbolicLink()) {
                        this.deleteDeadLink(p);
                        continue;
                    }
                    LOG.debug("Found non-directory element in mountpoint dir: {}", (Object)p);
                }
                catch (IOException e) {
                    cleanupFailed.addSuppressed(e);
                }
            }
            if (cleanupFailed.getSuppressed().length > 0) {
                throw cleanupFailed;
            }
        }
        catch (IOException e) {
            LOG.warn("Unable to perform cleanup of mountpoint dir {}.", (Object)dirContainingMountPoints, (Object)e);
        }
        finally {
            this.unmountDebrisCleared = true;
        }
    }

    private void deleteEmptyDir(Path dir) throws IOException {
        assert (Files.isDirectory(dir, LinkOption.NOFOLLOW_LINKS));
        try {
            this.ensureIsEmpty(dir);
            Files.delete(dir);
        }
        catch (DirectoryNotEmptyException e) {
            LOG.info("Found non-empty directory in mountpoint dir: {}", (Object)dir);
        }
    }

    private void deleteDeadLink(Path symlink) throws IOException {
        assert (Files.isSymbolicLink(symlink));
        if (Files.notExists(symlink, new LinkOption[0])) {
            Files.delete(symlink);
        }
    }

    private void ensureIsEmpty(Path dir) throws IOException {
        if (Files.newDirectoryStream(dir).iterator().hasNext()) {
            throw new DirectoryNotEmptyException(dir.toString());
        }
    }
}

