/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.common.mountpoint;

import com.google.common.collect.Iterables;
import dagger.Binds;
import dagger.Module;
import dagger.Provides;
import dagger.multibindings.IntKey;
import dagger.multibindings.IntoMap;
import java.util.Comparator;
import java.util.Map;
import java.util.TreeMap;
import javax.inject.Named;
import org.cryptomator.common.mountpoint.AvailableDriveLetterChooser;
import org.cryptomator.common.mountpoint.CustomDriveLetterChooser;
import org.cryptomator.common.mountpoint.CustomMountPointChooser;
import org.cryptomator.common.mountpoint.MacVolumeMountChooser;
import org.cryptomator.common.mountpoint.MountPointChooser;
import org.cryptomator.common.mountpoint.TemporaryMountPointChooser;
import org.cryptomator.common.vaults.PerVault;

@Module
public abstract class MountPointChooserModule {
    @Binds
    @IntoMap
    @IntKey(value=1000)
    @PerVault
    public abstract MountPointChooser bindCustomMountPointChooser(CustomMountPointChooser var1);

    @Binds
    @IntoMap
    @IntKey(value=900)
    @PerVault
    public abstract MountPointChooser bindCustomDriveLetterChooser(CustomDriveLetterChooser var1);

    @Binds
    @IntoMap
    @IntKey(value=800)
    @PerVault
    public abstract MountPointChooser bindAvailableDriveLetterChooser(AvailableDriveLetterChooser var1);

    @Binds
    @IntoMap
    @IntKey(value=101)
    @PerVault
    public abstract MountPointChooser bindMacVolumeMountChooser(MacVolumeMountChooser var1);

    @Binds
    @IntoMap
    @IntKey(value=100)
    @PerVault
    public abstract MountPointChooser bindTemporaryMountPointChooser(TemporaryMountPointChooser var1);

    @Provides
    @PerVault
    @Named(value="orderedMountPointChoosers")
    public static Iterable<MountPointChooser> provideOrderedMountPointChoosers(Map<Integer, MountPointChooser> choosers) {
        TreeMap sortedChoosers = new TreeMap(Comparator.reverseOrder());
        sortedChoosers.putAll(choosers);
        return Iterables.unmodifiableIterable(sortedChoosers.values());
    }
}

