/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.common;

import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Optional;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.function.Predicate;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class Environment {
    private static final Logger LOG = LoggerFactory.getLogger(Environment.class);
    private static final Path RELATIVE_HOME_DIR = Paths.get("~", new String[0]);
    private static final char PATH_LIST_SEP = ':';
    private static final int DEFAULT_MIN_PW_LENGTH = 8;

    @Inject
    public Environment() {
        LOG.debug("user.home: {}", (Object)System.getProperty("user.home"));
        LOG.debug("java.library.path: {}", (Object)System.getProperty("java.library.path"));
        LOG.debug("user.language: {}", (Object)System.getProperty("user.language"));
        LOG.debug("user.region: {}", (Object)System.getProperty("user.region"));
        LOG.debug("logback.configurationFile: {}", (Object)System.getProperty("logback.configurationFile"));
        LOG.debug("cryptomator.settingsPath: {}", (Object)System.getProperty("cryptomator.settingsPath"));
        LOG.debug("cryptomator.ipcSocketPath: {}", (Object)System.getProperty("cryptomator.ipcSocketPath"));
        LOG.debug("cryptomator.keychainPath: {}", (Object)System.getProperty("cryptomator.keychainPath"));
        LOG.debug("cryptomator.logDir: {}", (Object)System.getProperty("cryptomator.logDir"));
        LOG.debug("cryptomator.pluginDir: {}", (Object)System.getProperty("cryptomator.pluginDir"));
        LOG.debug("cryptomator.mountPointsDir: {}", (Object)System.getProperty("cryptomator.mountPointsDir"));
        LOG.debug("cryptomator.minPwLength: {}", (Object)System.getProperty("cryptomator.minPwLength"));
        LOG.debug("cryptomator.appVersion: {}", (Object)System.getProperty("cryptomator.appVersion"));
        LOG.debug("cryptomator.buildNumber: {}", (Object)System.getProperty("cryptomator.buildNumber"));
        LOG.debug("cryptomator.showTrayIcon: {}", (Object)System.getProperty("cryptomator.showTrayIcon"));
        LOG.debug("fuse.experimental: {}", (Object)Boolean.getBoolean("fuse.experimental"));
    }

    public boolean useCustomLogbackConfig() {
        return this.getPath("logback.configurationFile").map(x$0 -> Files.exists(x$0, new LinkOption[0])).orElse(false);
    }

    public Stream<Path> getSettingsPath() {
        return this.getPaths("cryptomator.settingsPath");
    }

    public Stream<Path> ipcSocketPath() {
        return this.getPaths("cryptomator.ipcSocketPath");
    }

    public Stream<Path> getKeychainPath() {
        return this.getPaths("cryptomator.keychainPath");
    }

    public Optional<Path> getLogDir() {
        return this.getPath("cryptomator.logDir").map(this::replaceHomeDir);
    }

    public Optional<Path> getPluginDir() {
        return this.getPath("cryptomator.pluginDir").map(this::replaceHomeDir);
    }

    public Optional<Path> getMountPointsDir() {
        return this.getPath("cryptomator.mountPointsDir").map(this::replaceHomeDir);
    }

    public Optional<String> getAppVersion() {
        return Optional.ofNullable(System.getProperty("cryptomator.appVersion"));
    }

    public Optional<String> getBuildNumber() {
        return Optional.ofNullable(System.getProperty("cryptomator.buildNumber"));
    }

    public int getMinPwLength() {
        return this.getInt("cryptomator.minPwLength", 8);
    }

    public boolean showTrayIcon() {
        return Boolean.getBoolean("cryptomator.showTrayIcon");
    }

    @Deprecated
    public boolean useExperimentalFuse() {
        return Boolean.getBoolean("fuse.experimental");
    }

    private int getInt(String propertyName, int defaultValue) {
        String value = System.getProperty(propertyName);
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    private Optional<Path> getPath(String propertyName) {
        String value = System.getProperty(propertyName);
        return Optional.ofNullable(value).map(x$0 -> Paths.get(x$0, new String[0]));
    }

    public Path getHomeDir() {
        return this.getPath("user.home").orElseThrow();
    }

    public Stream<Path> getPaths(String propertyName) {
        Stream<String> rawSettingsPaths = this.getRawList(propertyName, ':');
        return rawSettingsPaths.filter(Predicate.not(Strings::isNullOrEmpty)).map(x$0 -> Paths.get(x$0, new String[0])).map(this::replaceHomeDir);
    }

    private Path replaceHomeDir(Path path) {
        if (path.startsWith(RELATIVE_HOME_DIR)) {
            return this.getHomeDir().resolve(RELATIVE_HOME_DIR.relativize(path));
        }
        return path;
    }

    private Stream<String> getRawList(String propertyName, char separator) {
        String value = System.getProperty(propertyName);
        if (value == null) {
            return Stream.empty();
        }
        Iterable iter = Splitter.on((char)separator).split((CharSequence)value);
        Spliterator spliterator = Spliterators.spliteratorUnknownSize(iter.iterator(), 1040);
        return StreamSupport.stream(spliterator, false);
    }
}

