/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.frontend.webdav.mount;

import com.google.common.io.CharStreams;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.TimeUnit;
import org.cryptomator.frontend.webdav.mount.Mounter;

class ProcessUtil {
    ProcessUtil() {
    }

    public static void assertExitValue(Process proc, int expectedExitValue) throws Mounter.CommandFailedException {
        int actualExitValue = proc.exitValue();
        if (actualExitValue != expectedExitValue) {
            try {
                String error = ProcessUtil.toString(proc.getErrorStream(), StandardCharsets.UTF_8);
                throw new Mounter.CommandFailedException("Command failed with exit code " + actualExitValue + ". Expected " + expectedExitValue + ". Stderr: " + error);
            }
            catch (IOException e) {
                throw new Mounter.CommandFailedException("Command failed with exit code " + actualExitValue + ". Expected " + expectedExitValue + ".");
            }
        }
    }

    public static Process startAndWaitFor(ProcessBuilder processBuilder, long timeout, TimeUnit unit) throws Mounter.CommandFailedException, CommandTimeoutException {
        try {
            Process proc = processBuilder.start();
            ProcessUtil.waitFor(proc, timeout, unit);
            return proc;
        }
        catch (IOException e) {
            throw new Mounter.CommandFailedException(e);
        }
    }

    public static void waitFor(Process proc, long timeout, TimeUnit unit) throws CommandTimeoutException {
        try {
            boolean finishedInTime = proc.waitFor(timeout, unit);
            if (!finishedInTime) {
                proc.destroyForcibly();
                throw new CommandTimeoutException();
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    public static String toString(InputStream in, Charset charset) throws IOException {
        return CharStreams.toString((Readable)new InputStreamReader(in, charset));
    }

    public static class CommandTimeoutException
    extends Mounter.CommandFailedException {
        public CommandTimeoutException() {
            super("Command timed out.");
        }
    }
}

