/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.frontend.webdav;

import java.net.InetSocketAddress;
import java.nio.file.Path;
import java.util.concurrent.ExecutorService;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.cryptomator.frontend.webdav.DaggerWebDavServerComponent;
import org.cryptomator.frontend.webdav.ServerLifecycleException;
import org.cryptomator.frontend.webdav.WebDavServerComponent;
import org.cryptomator.frontend.webdav.WebDavServletFactory;
import org.cryptomator.frontend.webdav.servlet.WebDavServletComponent;
import org.cryptomator.frontend.webdav.servlet.WebDavServletController;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class WebDavServer {
    private static final Logger LOG = LoggerFactory.getLogger(WebDavServer.class);
    private final Server server;
    private final ExecutorService executorService;
    private final ServerConnector localConnector;
    private final WebDavServletFactory servletFactory;

    @Inject
    WebDavServer(Server server, ExecutorService executorService, ServerConnector connector, WebDavServletFactory servletContextFactory) {
        this.server = server;
        this.executorService = executorService;
        this.localConnector = connector;
        this.servletFactory = servletContextFactory;
    }

    public static WebDavServer create() {
        WebDavServerComponent comp = DaggerWebDavServerComponent.create();
        return comp.server();
    }

    public void bind(String bindAddr, int port) {
        this.bind(InetSocketAddress.createUnresolved(bindAddr, port));
    }

    public void bind(InetSocketAddress socketBindAddress) {
        try {
            this.localConnector.stop();
            LOG.info("Binding server socket to {}:{}", (Object)socketBindAddress.getHostString(), (Object)socketBindAddress.getPort());
            this.localConnector.setHost(socketBindAddress.getHostString());
            this.localConnector.setPort(socketBindAddress.getPort());
            this.localConnector.start();
        }
        catch (Exception e) {
            throw new ServerLifecycleException("Failed to restart socket.", e);
        }
    }

    public boolean isRunning() {
        return this.server.isRunning();
    }

    public synchronized void start() throws ServerLifecycleException {
        if (this.executorService.isShutdown()) {
            throw new IllegalStateException("Server has already been terminated.");
        }
        try {
            this.server.start();
            LOG.info("WebDavServer started.");
        }
        catch (Exception e) {
            throw new ServerLifecycleException("Server couldn't be started", e);
        }
    }

    public synchronized void stop() throws ServerLifecycleException {
        try {
            this.server.stop();
            LOG.info("WebDavServer stopped.");
        }
        catch (Exception e) {
            throw new ServerLifecycleException("Server couldn't be stopped", e);
        }
    }

    public synchronized void terminate() throws ServerLifecycleException {
        this.stop();
        this.executorService.shutdownNow();
    }

    public WebDavServletController createWebDavServlet(Path rootPath, String contextPath) {
        WebDavServletComponent servletComp = this.servletFactory.create(rootPath, contextPath);
        return servletComp.servlet();
    }
}

