/*
 * Decompiled with CFR 0.152.
 */
package com.dokany.java.structure;

import com.dokany.java.constants.FileSystemFeature;
import com.dokany.java.structure.EnumIntegerSet;

public final class VolumeInformation {
    private final int maxComponentLength;
    private final String name;
    private final int serialNumber;
    private final String fileSystemName;
    private final EnumIntegerSet<FileSystemFeature> fileSystemFeatures;
    public static final int DEFAULT_MAX_COMPONENT_LENGTH = 255;
    public static final int DEFAULT_SERIAL_NUMBER = 305419896;
    public static final String DEFAULT_VOLUME_NAME = "VOLUME1";
    public static final String DEFAULT_FS_NAME = "DOKANY";
    public static final EnumIntegerSet<FileSystemFeature> DEFAULT_FS_FEATURES = new EnumIntegerSet<FileSystemFeature>(FileSystemFeature.class);

    public VolumeInformation(String volumeName, int serialNumber, String fileSystemName) {
        this(255, volumeName, serialNumber, fileSystemName, DEFAULT_FS_FEATURES);
    }

    public VolumeInformation() {
        this(255, DEFAULT_VOLUME_NAME, 305419896, DEFAULT_FS_NAME, DEFAULT_FS_FEATURES);
    }

    public int getMaxComponentLength() {
        return this.maxComponentLength;
    }

    public String getName() {
        return this.name;
    }

    public int getSerialNumber() {
        return this.serialNumber;
    }

    public String getFileSystemName() {
        return this.fileSystemName;
    }

    public EnumIntegerSet<FileSystemFeature> getFileSystemFeatures() {
        return this.fileSystemFeatures;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof VolumeInformation)) {
            return false;
        }
        VolumeInformation other = (VolumeInformation)o;
        if (this.getMaxComponentLength() != other.getMaxComponentLength()) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        if (this.getSerialNumber() != other.getSerialNumber()) {
            return false;
        }
        String this$fileSystemName = this.getFileSystemName();
        String other$fileSystemName = other.getFileSystemName();
        if (this$fileSystemName == null ? other$fileSystemName != null : !this$fileSystemName.equals(other$fileSystemName)) {
            return false;
        }
        EnumIntegerSet<FileSystemFeature> this$fileSystemFeatures = this.getFileSystemFeatures();
        EnumIntegerSet<FileSystemFeature> other$fileSystemFeatures = other.getFileSystemFeatures();
        return !(this$fileSystemFeatures == null ? other$fileSystemFeatures != null : !((Object)this$fileSystemFeatures).equals(other$fileSystemFeatures));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getMaxComponentLength();
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        result = result * 59 + this.getSerialNumber();
        String $fileSystemName = this.getFileSystemName();
        result = result * 59 + ($fileSystemName == null ? 43 : $fileSystemName.hashCode());
        EnumIntegerSet<FileSystemFeature> $fileSystemFeatures = this.getFileSystemFeatures();
        result = result * 59 + ($fileSystemFeatures == null ? 43 : ((Object)$fileSystemFeatures).hashCode());
        return result;
    }

    public String toString() {
        return "VolumeInformation(maxComponentLength=" + this.getMaxComponentLength() + ", name=" + this.getName() + ", serialNumber=" + this.getSerialNumber() + ", fileSystemName=" + this.getFileSystemName() + ", fileSystemFeatures=" + this.getFileSystemFeatures() + ")";
    }

    public VolumeInformation(int maxComponentLength, String name, int serialNumber, String fileSystemName, EnumIntegerSet<FileSystemFeature> fileSystemFeatures) {
        this.maxComponentLength = maxComponentLength;
        this.name = name;
        this.serialNumber = serialNumber;
        this.fileSystemName = fileSystemName;
        this.fileSystemFeatures = fileSystemFeatures;
    }

    static {
        DEFAULT_FS_FEATURES.add(FileSystemFeature.CASE_PRESERVED_NAMES);
    }
}

