/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.frontend.fuse;

import java.io.IOException;
import java.nio.channels.ClosedChannelException;
import java.nio.file.AccessMode;
import java.nio.file.DirectoryNotEmptyException;
import java.nio.file.DirectoryStream;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.FileStore;
import java.nio.file.FileSystemException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.NotDirectoryException;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.PosixFileAttributeView;
import java.nio.file.attribute.PosixFilePermission;
import java.nio.file.attribute.PosixFilePermissions;
import java.time.DateTimeException;
import java.util.EnumSet;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Named;
import jnr.constants.platform.OpenFlags;
import jnr.ffi.Pointer;
import jnr.ffi.types.gid_t;
import jnr.ffi.types.mode_t;
import jnr.ffi.types.off_t;
import jnr.ffi.types.size_t;
import jnr.ffi.types.uid_t;
import org.cryptomator.frontend.fuse.BitMaskEnumUtil;
import org.cryptomator.frontend.fuse.FileAttributesUtil;
import org.cryptomator.frontend.fuse.FileNameTranscoder;
import org.cryptomator.frontend.fuse.MacUtil;
import org.cryptomator.frontend.fuse.OpenFileFactory;
import org.cryptomator.frontend.fuse.PerAdapter;
import org.cryptomator.frontend.fuse.ReadOnlyAdapter;
import org.cryptomator.frontend.fuse.ReadOnlyLinkHandler;
import org.cryptomator.frontend.fuse.ReadWriteDirectoryHandler;
import org.cryptomator.frontend.fuse.ReadWriteFileHandler;
import org.cryptomator.frontend.fuse.locks.DataLock;
import org.cryptomator.frontend.fuse.locks.LockManager;
import org.cryptomator.frontend.fuse.locks.PathLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ru.serce.jnrfuse.ErrorCodes;
import ru.serce.jnrfuse.struct.FuseFileInfo;
import ru.serce.jnrfuse.struct.Timespec;

@PerAdapter
public class ReadWriteAdapter
extends ReadOnlyAdapter {
    private static final Logger LOG = LoggerFactory.getLogger(ReadWriteAdapter.class);
    private final ReadWriteFileHandler fileHandler;
    private final FileAttributesUtil attrUtil;
    private final BitMaskEnumUtil bitMaskUtil;

    @Inject
    public ReadWriteAdapter(@Named(value="root") Path root, @Named(value="maxFileNameLength") int maxFileNameLength, FileNameTranscoder fileNameTranscoder, FileStore fileStore, LockManager lockManager, ReadWriteDirectoryHandler dirHandler, ReadWriteFileHandler fileHandler, ReadOnlyLinkHandler linkHandler, FileAttributesUtil attrUtil, BitMaskEnumUtil bitMaskUtil, OpenFileFactory fileFactory) {
        super(root, maxFileNameLength, fileNameTranscoder, fileStore, lockManager, dirHandler, fileHandler, linkHandler, attrUtil, fileFactory);
        this.fileHandler = fileHandler;
        this.attrUtil = attrUtil;
        this.bitMaskUtil = bitMaskUtil;
    }

    @Override
    protected int checkAccess(Path path, Set<AccessMode> requiredAccessModes) {
        return this.checkAccess(path, requiredAccessModes, EnumSet.noneOf(AccessMode.class));
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public int mkdir(String path, @mode_t long mode) {
        try (PathLock pathLock = this.lockManager.createPathLock(path).forWriting();){
            DataLock dataLock = pathLock.lockDataForWriting();
            try {
                Path node = this.resolvePath(this.fileNameTranscoder.fuseToNio(path));
                LOG.trace("mkdir {} ({})", (Object)path, (Object)mode);
                Files.createDirectory(node, new FileAttribute[0]);
                int n = 0;
                if (dataLock != null) {
                    dataLock.close();
                }
                return n;
            }
            catch (Throwable throwable) {
                if (dataLock != null) {
                    try {
                        dataLock.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
        }
        catch (FileAlreadyExistsException e) {
            LOG.warn("mkdir {} failed, file already exists.", (Object)path);
            return -ErrorCodes.EEXIST();
        }
        catch (FileSystemException e) {
            return this.getErrorCodeForGenericFileSystemException(e, "mkdir " + path);
        }
        catch (IOException | RuntimeException e) {
            LOG.error("mkdir " + path + " failed.", (Throwable)e);
            return -ErrorCodes.EIO();
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public int symlink(String targetPath, String linkPath) {
        try (PathLock pathLock = this.lockManager.createPathLock(linkPath).forWriting();){
            DataLock dataLock = pathLock.lockDataForWriting();
            try {
                Path link = this.resolvePath(this.fileNameTranscoder.fuseToNio(linkPath));
                Path target = link.getFileSystem().getPath(this.fileNameTranscoder.fuseToNio(targetPath), new String[0]);
                LOG.trace("symlink {} -> {}", (Object)linkPath, (Object)targetPath);
                Files.createSymbolicLink(link, target, new FileAttribute[0]);
                int n = 0;
                if (dataLock != null) {
                    dataLock.close();
                }
                return n;
            }
            catch (Throwable throwable) {
                if (dataLock != null) {
                    try {
                        dataLock.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
        }
        catch (FileAlreadyExistsException e) {
            LOG.warn("symlink {} -> {} failed, file already exists.", (Object)linkPath, (Object)targetPath);
            return -ErrorCodes.EEXIST();
        }
        catch (FileSystemException e) {
            return this.getErrorCodeForGenericFileSystemException(e, "symlink " + targetPath + " -> " + linkPath);
        }
        catch (IOException | RuntimeException e) {
            LOG.error("symlink failed.", (Throwable)e);
            return -ErrorCodes.EIO();
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public int create(String path, @mode_t long mode, FuseFileInfo fi) {
        try (PathLock pathLock = this.lockManager.createPathLock(path).forWriting();){
            DataLock dataLock = pathLock.lockDataForWriting();
            try {
                Path node = this.resolvePath(this.fileNameTranscoder.fuseToNio(path));
                Set<OpenFlags> flags = this.bitMaskUtil.bitMaskToSet(OpenFlags.class, fi.flags.longValue());
                LOG.trace("create {} with flags {}", (Object)path, flags);
                if (this.fileStore.supportsFileAttributeView(PosixFileAttributeView.class)) {
                    FileAttribute<Set<PosixFilePermission>> attrs = PosixFilePermissions.asFileAttribute(this.attrUtil.octalModeToPosixPermissions(mode));
                    this.fileHandler.createAndOpen(node, fi, attrs);
                } else {
                    this.fileHandler.createAndOpen(node, fi, new FileAttribute[0]);
                }
                int n = 0;
                if (dataLock != null) {
                    dataLock.close();
                }
                return n;
            }
            catch (Throwable throwable) {
                if (dataLock != null) {
                    try {
                        dataLock.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
        }
        catch (FileAlreadyExistsException e) {
            LOG.warn("create {} failed, file already exists.", (Object)path);
            return -ErrorCodes.EEXIST();
        }
        catch (FileSystemException e) {
            return this.getErrorCodeForGenericFileSystemException(e, "create " + path);
        }
        catch (IOException | RuntimeException e) {
            LOG.error("create " + path + " failed.", (Throwable)e);
            return -ErrorCodes.EIO();
        }
    }

    public int chown(String path, @uid_t long uid, @gid_t long gid) {
        LOG.trace("Ignoring chown(uid={}, gid={}) call. Files will be served with static uid/gid.", (Object)uid, (Object)gid);
        return 0;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public int chmod(String path, @mode_t long mode) {
        try (PathLock pathLock = this.lockManager.createPathLock(path).forReading();){
            DataLock dataLock = pathLock.lockDataForWriting();
            try {
                Path node = this.resolvePath(this.fileNameTranscoder.fuseToNio(path));
                LOG.trace("chmod {} ({})", (Object)path, (Object)mode);
                Files.setPosixFilePermissions(node, this.attrUtil.octalModeToPosixPermissions(mode));
                int n = 0;
                if (dataLock != null) {
                    dataLock.close();
                }
                return n;
            }
            catch (Throwable throwable) {
                if (dataLock != null) {
                    try {
                        dataLock.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
        }
        catch (NoSuchFileException e) {
            LOG.warn("chmod {} failed, file not found.", (Object)path);
            return -ErrorCodes.ENOENT();
        }
        catch (UnsupportedOperationException e) {
            LOG.warn("Setting posix permissions not supported by underlying file system.");
            return -ErrorCodes.ENOSYS();
        }
        catch (IOException | RuntimeException e) {
            LOG.error("chmod " + path + " failed.", (Throwable)e);
            return -ErrorCodes.EIO();
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public int unlink(String path) {
        try (PathLock pathLock = this.lockManager.createPathLock(path).forWriting();){
            Path node;
            DataLock dataLock;
            block19: {
                dataLock = pathLock.lockDataForWriting();
                try {
                    node = this.resolvePath(this.fileNameTranscoder.fuseToNio(path));
                    if (!Files.isDirectory(node, LinkOption.NOFOLLOW_LINKS)) break block19;
                    LOG.warn("unlink {} failed, node is a directory.", (Object)path);
                    int n = -ErrorCodes.EISDIR();
                    if (dataLock != null) {
                        dataLock.close();
                    }
                    return n;
                }
                catch (Throwable throwable) {
                    if (dataLock != null) {
                        try {
                            dataLock.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
            }
            LOG.trace("unlink {}", (Object)path);
            Files.delete(node);
            int n = 0;
            if (dataLock != null) {
                dataLock.close();
            }
            return n;
        }
        catch (NoSuchFileException e) {
            LOG.warn("unlink {} failed, file not found.", (Object)path);
            return -ErrorCodes.ENOENT();
        }
        catch (IOException | RuntimeException e) {
            LOG.error("unlink " + path + " failed.", (Throwable)e);
            return -ErrorCodes.EIO();
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public int rmdir(String path) {
        try (PathLock pathLock = this.lockManager.createPathLock(path).forWriting();){
            DataLock dataLock = pathLock.lockDataForWriting();
            try {
                Path node = this.resolvePath(this.fileNameTranscoder.fuseToNio(path));
                if (!Files.isDirectory(node, LinkOption.NOFOLLOW_LINKS)) {
                    throw new NotDirectoryException(path);
                }
                LOG.trace("rmdir {}", (Object)path);
                this.deleteAppleDoubleFiles(node);
                Files.delete(node);
                int n = 0;
                if (dataLock != null) {
                    dataLock.close();
                }
                return n;
            }
            catch (Throwable throwable) {
                if (dataLock != null) {
                    try {
                        dataLock.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
        }
        catch (NotDirectoryException e) {
            LOG.warn("rmdir {} failed, node is not a directory.", (Object)path);
            return -ErrorCodes.ENOTDIR();
        }
        catch (NoSuchFileException e) {
            LOG.warn("rmdir {} failed, file not found.", (Object)path);
            return -ErrorCodes.ENOENT();
        }
        catch (DirectoryNotEmptyException e) {
            LOG.warn("rmdir {} failed, directory not empty.", (Object)path);
            return -ErrorCodes.ENOTEMPTY();
        }
        catch (IOException | RuntimeException e) {
            LOG.error("rmdir " + path + " failed.", (Throwable)e);
            return -ErrorCodes.EIO();
        }
    }

    private void deleteAppleDoubleFiles(Path node) throws IOException {
        try (DirectoryStream<Path> directoryStream = Files.newDirectoryStream(node, MacUtil::isAppleDoubleOrDStoreName);){
            for (Path p : directoryStream) {
                Files.delete(p);
            }
        }
    }

    /*
     * Exception decompiling
     */
    public int rename(String oldPath, String newPath) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [2[TRYBLOCK]], but top level block is 27[DOLOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public int utimens(String path, Timespec[] timespec) {
        assert (timespec.length == 2);
        try (PathLock pathLock = this.lockManager.createPathLock(path).forReading();){
            DataLock dataLock = pathLock.lockDataForWriting();
            try {
                Path node = this.resolvePath(this.fileNameTranscoder.fuseToNio(path));
                LOG.trace("utimens {} (last modification {} sec {} nsec, last access {} sec {} nsec)", new Object[]{path, timespec[1].tv_sec.get(), timespec[1].tv_nsec.longValue(), timespec[0].tv_sec.get(), timespec[0].tv_nsec.longValue()});
                this.fileHandler.utimens(node, timespec[1], timespec[0]);
                int n = 0;
                if (dataLock != null) {
                    dataLock.close();
                }
                return n;
            }
            catch (Throwable throwable) {
                if (dataLock != null) {
                    try {
                        dataLock.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
        }
        catch (ArithmeticException | DateTimeException e) {
            LOG.warn("utimens {} failed, invalid argument.", (Throwable)e);
            return -ErrorCodes.EINVAL();
        }
        catch (NoSuchFileException e) {
            LOG.warn("utimens {} failed, file not found.", (Object)path);
            return -ErrorCodes.ENOENT();
        }
        catch (IOException | RuntimeException e) {
            LOG.error("utimens " + path + " failed.", (Throwable)e);
            return -ErrorCodes.EIO();
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public int write(String path, Pointer buf, @size_t long size, @off_t long offset, FuseFileInfo fi) {
        try (PathLock pathLock = this.lockManager.createPathLock(path).forReading();){
            DataLock dataLock = pathLock.lockDataForWriting();
            try {
                LOG.trace("write {} bytes to file {} starting at {}...", new Object[]{size, path, offset});
                int written = this.fileHandler.write(buf, size, offset, fi);
                LOG.trace("wrote {} bytes to file {}.", (Object)written, (Object)path);
                int n = written;
                if (dataLock != null) {
                    dataLock.close();
                }
                return n;
            }
            catch (Throwable throwable) {
                if (dataLock != null) {
                    try {
                        dataLock.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
        }
        catch (ClosedChannelException e) {
            LOG.warn("write {} failed, invalid file handle {}", (Object)path, (Object)fi.fh.get());
            return -ErrorCodes.EBADF();
        }
        catch (IOException | RuntimeException e) {
            LOG.error("write " + path + " failed.", (Throwable)e);
            return -ErrorCodes.EIO();
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public int truncate(String path, @off_t long size) {
        try (PathLock pathLock = this.lockManager.createPathLock(path).forReading();){
            DataLock dataLock = pathLock.lockDataForWriting();
            try {
                Path node = this.resolvePath(this.fileNameTranscoder.fuseToNio(path));
                LOG.trace("truncate {} {}", (Object)path, (Object)size);
                this.fileHandler.truncate(node, size);
                int n = 0;
                if (dataLock != null) {
                    dataLock.close();
                }
                return n;
            }
            catch (Throwable throwable) {
                if (dataLock != null) {
                    try {
                        dataLock.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
        }
        catch (NoSuchFileException e) {
            LOG.warn("utimens {} failed, file not found.", (Object)path);
            return -ErrorCodes.ENOENT();
        }
        catch (IOException | RuntimeException e) {
            LOG.error("truncate " + path + " failed.", (Throwable)e);
            return -ErrorCodes.EIO();
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public int ftruncate(String path, long size, FuseFileInfo fi) {
        try (PathLock pathLock = this.lockManager.createPathLock(path).forReading();){
            DataLock dataLock = pathLock.lockDataForWriting();
            try {
                LOG.trace("ftruncate {} to size: {}", (Object)path, (Object)size);
                this.fileHandler.ftruncate(size, fi);
                int n = 0;
                if (dataLock != null) {
                    dataLock.close();
                }
                return n;
            }
            catch (Throwable throwable) {
                if (dataLock != null) {
                    try {
                        dataLock.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
        }
        catch (ClosedChannelException e) {
            LOG.warn("ftruncate {} failed, invalid file handle {}", (Object)path, (Object)fi.fh.get());
            return -ErrorCodes.EBADF();
        }
        catch (IOException | RuntimeException e) {
            LOG.error("ftruncate " + path + " failed.", (Throwable)e);
            return -ErrorCodes.EIO();
        }
    }

    public int fsync(String path, int isdatasync, FuseFileInfo fi) {
        try {
            boolean metaData = isdatasync == 0;
            LOG.trace("fsync {}", (Object)path);
            this.fileHandler.fsync(fi, metaData);
            return 0;
        }
        catch (ClosedChannelException e) {
            LOG.warn("fsync {} failed, invalid file handle {}", (Object)path, (Object)fi.fh.get());
            return -ErrorCodes.EBADF();
        }
        catch (IOException | RuntimeException e) {
            LOG.error("fsync " + path + " failed.", (Throwable)e);
            return -ErrorCodes.EIO();
        }
    }
}

