/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.frontend.fuse;

import com.google.common.collect.Iterators;
import com.google.common.collect.UnmodifiableIterator;
import java.io.IOException;
import java.nio.file.DirectoryIteratorException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.PosixFileAttributes;
import java.util.Iterator;
import javax.inject.Inject;
import jnr.ffi.Pointer;
import org.cryptomator.frontend.fuse.FileAttributesUtil;
import org.cryptomator.frontend.fuse.FileNameTranscoder;
import org.cryptomator.frontend.fuse.PerAdapter;
import ru.serce.jnrfuse.ErrorCodes;
import ru.serce.jnrfuse.FuseFillDir;
import ru.serce.jnrfuse.struct.FileStat;
import ru.serce.jnrfuse.struct.FuseFileInfo;

@PerAdapter
public class ReadOnlyDirectoryHandler {
    private static final Path SAME_DIR = Paths.get(".", new String[0]);
    private static final Path PARENT_DIR = Paths.get("..", new String[0]);
    protected final FileAttributesUtil attrUtil;
    private final FileNameTranscoder fileNameTranscoder;

    @Inject
    public ReadOnlyDirectoryHandler(FileAttributesUtil attrUtil, FileNameTranscoder fileNameTranscoder) {
        this.attrUtil = attrUtil;
        this.fileNameTranscoder = fileNameTranscoder;
    }

    public int getattr(Path path, BasicFileAttributes attrs, FileStat stat) {
        if (attrs instanceof PosixFileAttributes) {
            PosixFileAttributes posixAttrs = (PosixFileAttributes)attrs;
            long mode = this.attrUtil.posixPermissionsToOctalMode(posixAttrs.permissions());
            stat.st_mode.set((Number)(0x4000L | (mode &= 0x16DL)));
        } else {
            stat.st_mode.set((Number)16749);
        }
        this.attrUtil.copyBasicFileAttributesFromNioToFuse(attrs, stat);
        return 0;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int readdir(Path path, Pointer buf, FuseFillDir filler, long offset, FuseFileInfo fi) throws IOException {
        try (DirectoryStream<Path> ds = Files.newDirectoryStream(path);){
            UnmodifiableIterator sameAndParent = Iterators.forArray((Object[])new Path[]{SAME_DIR, PARENT_DIR});
            Iterator iter = Iterators.concat((Iterator)sameAndParent, ds.iterator());
            while (iter.hasNext()) {
                String fileName = ((Path)iter.next()).getFileName().toString();
                if (filler.apply(buf, this.fileNameTranscoder.nioToFuse(fileName), null, 0L) == 0) continue;
                int n = -ErrorCodes.ENOMEM();
                return n;
            }
            int n = 0;
            return n;
        }
        catch (DirectoryIteratorException e) {
            throw new IOException(e);
        }
    }
}

