/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.webdav.core.servlet;

import org.apache.jackrabbit.webdav.lock.AbstractActiveLock;
import org.apache.jackrabbit.webdav.lock.LockInfo;
import org.apache.jackrabbit.webdav.lock.Scope;
import org.apache.jackrabbit.webdav.lock.Type;

class ExclusiveSharedLock
extends AbstractActiveLock {
    private final String token;
    private final Type type;
    private final Scope scope;
    private String owner;
    private boolean isDeep = true;
    private long expirationTime = Integer.MAX_VALUE;

    ExclusiveSharedLock(String token, LockInfo lockInfo) {
        this.token = token;
        this.type = lockInfo.getType();
        this.scope = lockInfo.getScope();
        this.owner = lockInfo.getOwner();
        this.isDeep = lockInfo.isDeep();
        this.setTimeout(lockInfo.getTimeout());
    }

    public boolean isLockedByToken(String lockToken) {
        return this.token.equals(lockToken);
    }

    public boolean isExpired() {
        return System.currentTimeMillis() > this.expirationTime;
    }

    public String getToken() {
        return this.token;
    }

    public String getOwner() {
        return this.owner;
    }

    public void setOwner(String owner) {
        this.owner = owner;
    }

    public long getTimeout() {
        return this.expirationTime - System.currentTimeMillis();
    }

    public void setTimeout(long timeout) {
        if (timeout > 0L) {
            this.expirationTime = System.currentTimeMillis() + timeout;
        }
    }

    public boolean isDeep() {
        return this.isDeep;
    }

    public void setIsDeep(boolean isDeep) {
        this.isDeep = isDeep;
    }

    public Type getType() {
        return this.type;
    }

    public Scope getScope() {
        return this.scope;
    }

    public int hashCode() {
        return this.getToken().hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof ExclusiveSharedLock) {
            ExclusiveSharedLock other = (ExclusiveSharedLock)((Object)obj);
            return this.getToken().equals(other.getToken());
        }
        return false;
    }
}

