/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.webdav.core.filters;

import java.io.IOException;
import java.util.Enumeration;
import java.util.concurrent.atomic.AtomicLong;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.cryptomator.webdav.core.filters.HttpFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoggingFilter
implements HttpFilter {
    private static final Logger LOG = LoggerFactory.getLogger(LoggingFilter.class);
    private final AtomicLong REQUEST_ID_GEN = new AtomicLong();

    @Override
    public void doFilterHttp(HttpServletRequest request, HttpServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (LOG.isDebugEnabled()) {
            long requestId = this.REQUEST_ID_GEN.getAndIncrement();
            LOG.debug("REQUEST {}:\n{} {} {}\n{}", new Object[]{requestId, request.getMethod(), request.getRequestURI(), request.getProtocol(), this.headers(request)});
            chain.doFilter((ServletRequest)request, (ServletResponse)response);
            LOG.debug("RESPONSE {}:\n{}\n{}", new Object[]{requestId, response.getStatus(), this.headers(response)});
        } else {
            chain.doFilter((ServletRequest)request, (ServletResponse)response);
        }
    }

    private String headers(HttpServletResponse response) {
        StringBuilder result = new StringBuilder();
        for (String headerName : response.getHeaderNames()) {
            for (String value : response.getHeaders(headerName)) {
                result.append(headerName).append(": ").append(value).append('\n');
            }
        }
        return result.toString();
    }

    private String headers(HttpServletRequest request) {
        StringBuilder result = new StringBuilder();
        Enumeration headerNames = request.getHeaderNames();
        while (headerNames.hasMoreElements()) {
            String headerName = (String)headerNames.nextElement();
            Enumeration values = request.getHeaders(headerName);
            while (values.hasMoreElements()) {
                result.append(headerName).append(": ").append((String)values.nextElement()).append('\n');
            }
        }
        return result.toString();
    }
}

