/*
 * Decompiled with CFR 0.152.
 */
package com.tobiasdiez.easybind;

import com.tobiasdiez.easybind.EasyObservableList;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.collections.transformation.TransformationList;

class MappedBackedList<E, F>
extends TransformationList<E, F>
implements EasyObservableList<E> {
    private final Function<F, E> mapper;
    private final List<E> backingList;

    public MappedBackedList(ObservableList<? extends F> sourceList, Function<F, E> mapper) {
        super(sourceList);
        this.mapper = mapper;
        this.backingList = new ArrayList(sourceList.size());
        sourceList.stream().map(mapper).forEach(this.backingList::add);
    }

    protected void sourceChanged(ListChangeListener.Change<? extends F> change) {
        this.beginChange();
        while (change.next()) {
            if (change.wasPermutated()) {
                int i;
                int from = change.getFrom();
                int to = change.getTo();
                int[] permutation = new int[to - from];
                for (int i2 = 0; i2 < to - from; ++i2) {
                    permutation[i2] = change.getPermutation(i2);
                }
                Object[] permutedPart = new Object[to - from];
                for (i = from; i < to; ++i) {
                    permutedPart[permutation[i]] = this.backingList.get(i);
                }
                for (i = 0; i < to; ++i) {
                    this.backingList.set(i + from, permutedPart[i]);
                }
                this.nextPermutation(from, to, permutation);
                continue;
            }
            if (change.wasUpdated()) {
                this.backingList.set(change.getFrom(), this.mapper.apply(this.getSource().get(change.getFrom())));
                this.nextUpdate(change.getFrom());
                continue;
            }
            if (change.wasRemoved()) {
                int removePosition = change.getFrom();
                ArrayList<E> removed = new ArrayList<E>(change.getRemovedSize());
                for (int i = 0; i < change.getRemovedSize(); ++i) {
                    removed.add(this.backingList.remove(removePosition));
                }
                this.nextRemove(change.getFrom(), removed);
            }
            if (!change.wasAdded()) continue;
            int addStart = change.getFrom();
            int addEnd = change.getTo();
            for (int i = addStart; i < addEnd; ++i) {
                this.backingList.add(i, this.mapper.apply(change.getList().get(i)));
            }
            this.nextAdd(addStart, addEnd);
        }
        this.endChange();
    }

    public int getSourceIndex(int index) {
        return index;
    }

    public int getViewIndex(int index) {
        return index;
    }

    public E get(int index) {
        return this.backingList.get(index);
    }

    public int size() {
        return this.backingList.size();
    }
}

