/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.cryptolib.api;

import com.google.common.base.Preconditions;
import java.security.SecureRandom;
import java.util.Arrays;
import org.cryptomator.cryptolib.common.DestroyableSecretKey;

public class Masterkey
extends DestroyableSecretKey {
    private static final String KEY_ALGORITHM = "MASTERKEY";
    public static final String ENC_ALG = "AES";
    public static final String MAC_ALG = "HmacSHA256";
    public static final int SUBKEY_LEN_BYTES = 32;

    public Masterkey(byte[] key) {
        super(Masterkey.checkKeyLength(key), KEY_ALGORITHM);
    }

    private static byte[] checkKeyLength(byte[] key) {
        Preconditions.checkArgument((key.length == 64 ? 1 : 0) != 0, (String)"Invalid raw key length %s", (int)key.length);
        return key;
    }

    public static Masterkey generate(SecureRandom csprng) {
        byte[] key = new byte[64];
        try {
            csprng.nextBytes(key);
            Masterkey masterkey = new Masterkey(key);
            return masterkey;
        }
        finally {
            Arrays.fill(key, (byte)0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Masterkey from(DestroyableSecretKey encKey, DestroyableSecretKey macKey) {
        Preconditions.checkArgument((encKey.getEncoded().length == 32 ? 1 : 0) != 0, (Object)"Invalid key length of encKey");
        Preconditions.checkArgument((macKey.getEncoded().length == 32 ? 1 : 0) != 0, (Object)"Invalid key length of macKey");
        byte[] key = new byte[64];
        try {
            System.arraycopy(encKey.getEncoded(), 0, key, 0, 32);
            System.arraycopy(macKey.getEncoded(), 0, key, 32, 32);
            Masterkey masterkey = new Masterkey(key);
            return masterkey;
        }
        finally {
            Arrays.fill(key, (byte)0);
        }
    }

    @Override
    public Masterkey copy() {
        return new Masterkey(this.getEncoded());
    }

    public DestroyableSecretKey getEncKey() {
        return new DestroyableSecretKey(this.getEncoded(), 0, 32, ENC_ALG);
    }

    public DestroyableSecretKey getMacKey() {
        return new DestroyableSecretKey(this.getEncoded(), 32, 32, MAC_ALG);
    }
}

