
# Community Code of Conduct

This code of conduct is intended to lay down the basis on which we, as a community of developers, maintainers and users, work with each other and with others outside of the community. As always when dealing with groups of people from many different backgrounds, there are no hard and fast rules here, and the intention is not to lay down any sort of restrictive frame to work in, but rather to clarify how we (prefer to) approach each other when working together as volunteers/professionals to improve our respective projects, products and life.

## Our Goal with this Code of Conduct

We, as contributors and maintainers, aim to create a _focused but welcoming_ environment for others; collaboration, acceptance and respect are the cornerstones upon which we must build our community, otherwise there is no future for it. As such, we want to ensure smooth communication and keep participation in our project and community free of harassment. We therefore ask of everyone, new contributors and long-standing members alike, to be accepting of others regardless of their age, ethnicity, level of experience, nationality, personal appearance, race, religion, or sexual orientation. None of these (and alike) attributes should influence how we work together in this project, and should not be grounds to judge or dismiss work done.

## Community of adults, language, and expected tolerance

To achieve the required level of focus needed, Our community as a whole targets exclusively **adult** participants with a common level of tolerance. This means that the expected conduct and tolerance levels should be fitting the average adult mindset and all participants in the community are assumed to be of adult age or having the mental capacity of an adult.

When dealing with others in the community, please mind your language use. Try to avoid common curse words or blasphemous expressions. Using strong language is fine, but excessive use of coarse language is frowned upon. Although everyone is assumed to be of adult age (see previous point), and you may be upset about something, you're kindly requested to keep your use of language under control.

Please keep in mind that the community is made up of people from all walks of life. You are asked to show a reasonable level of tolerance towards other community members, even if their method of approach is different than what you are used to or not the way you would approach others. Many computer software developers are very direct in their approaches or replies because their profession requires them to be focused and efficient in communication; our community has a larger than average percentage of developers among their ranks so you should expect more direct and "things as they are" responses in communication than you might expect in other communities. Be tolerant of this and try to follow instructions if they are given!
Conversely, try to keep in mind that other community members may not have the same level of computer skill you do and may need more guidance than you can provide. In that case, please forward the user(s) to the Pale Moon forum in a kind manner or (if already there) step back and excuse yourself and ask someone else to provide further assistance in lieu of getting upset or frustrated.

Our community is primarily using English as a communication language. Please, at all times, use English when creating tracker issues or asking something of developers. The only exception is the foreign language boards on the forum where you can communicate in non-English languages with other community members to get assistance or discuss things, and of course private communication can be in any language you wish.

Please do not try to unnecessarily mask your identity. We are all people here, with personalities and identities. It is much easier to relate to and assist someone who actually tries to approach others with a personal identity than someone who goes at length to mask themselves. None of the topics in our community should be personally or ideologically sensitive, so there will be no need to hide/cloak/mask yourself.

Please do not start discussions about politics, religion, or other touchy subjects that are not necessarily related to the platform and its applications (off-topic) and can easily lead to an very unwelcome atmosphere. Although enforcing of this point will be done leniently, you are asked to apply common sense and stop a particular line of conversation if it gets too heated or opinionated for the community's overall atmosphere. If you want to continue an off-topic or in-depth discussion with someone about such topics, please take it to private chat/channels!

If your background, religion, upbringing or other social factors make you more sensitive than average in terms of social interaction, imagery and/or language use, and if you easily take offense or are prone to moral outrage over opinions of others, then please understand that this community may possibly not be a good match for you or require you to put in extra effort to be a content member. You should consider this before you decide to join the community in that case, and understand it may require effort to adjust to our average level of tolerance.

Of course, it should be clear that your participation in our community is at all times one of your own free will. You may leave at any time you wish, for any reason or no reason at all. We do, however, ask of you in that case that no matter the reason, you treat the community you are leaving with respect and honor the choices made for and in it, and do not externalize your grievances with the community as a whole or any specific members in it. If you feel a compelling need to do so (i.e. to go on a "ragequit crusade") then please consider first escalating this to the owner to work things out as adults in private before making a potentially self-damaging mess of things.

## Examples of acceptable and unacceptable behavior

Please note that these lists are examples and not exhaustive. If you have any doubts whether behavior is considered unacceptable, always err on the side of caution.

Examples of behavior that helps create a positive working environment:

* Using friendly, neutral and welcoming language.
* Being tolerant to the occasional strong language expression and not taking offense at the drop of a hat.
* Being clear in your descriptions and not assuming the reader has any sort of prior knowledge of what you are talking about.
* Being courteous (use "please" when you ask someone to do something for you).
* Being respectful of differing viewpoints, backgrounds and experiences.
* Gracefully accepting constructive criticism, even if you disagree with such criticism.
* Similarly, accepting that someone may not act on criticism given.
* Focusing on what is best for the community and its projects instead of individuals.
* Showing understanding and a reasonable level of empathy towards other community members.

Examples of unacceptable behavior:

* Unwelcome personal attention or advances (sexual or otherwise). If someone asks you to stop approaching them, please respect that.
* Displaying disproportionate levels of moral outrage and offense, especially when in response to someone's opinion.
* Bullying, trolling, uncalled-for insulting/derogatory comments, and personal or political attacks.
* Being disruptive to ongoing discussions (e.g. by purposefully making a technical discussion into a sociopolitical one or trying to derail topical discussions).
* Public or private harassment of other community members/contributors.
* Publishing others' personal/private information, such as a physical or electronic address, without explicit permission.
* Other conduct which could reasonably be considered inappropriate in a professional/workplace setting.

## Responsibilities of the project's staff/leadership

Project maintainers are responsible for clarifying the standards of acceptable behavior and are expected to take appropriate and above all fair corrective action in response to instances of unacceptable behavior.

Corrective action: Project staff has the right and responsibility to evaluate, and if necessary to remove, edit, or reject any comments, repository commits, code changes, wiki edits, issues or issue comments, and other contributions that are not aligned with this Code of Conduct or the community's or projects' best interests, or to ban (temporarily or permanently) any contributor, community member or maintainer for other behaviors that they deem inappropriate, threatening, disproportionately offensive, or harmful. In cases where there is no clear and definitive breach of rules or common sense, it is expected that staff members consult with project leadership before bans are issued to discuss the severity and intended action.

## Applicability

This Code of Conduct applies within project spaces (forum, website, IRC, repositories and other project-controlled resources with user interaction) as well as in public spaces when an individual is representing the project or its community. Examples of representing a project or community include using an official project e-mail address, posting via an official social media account, acting on behalf of the project on IRC or other chat networks, or acting as an appointed or voluntary (spontaneous) representative at an online or offline event. Representation of a project in general should be courteous, respectful, and at all times keeping in mind that any representation reflects directly on the project's public image. Do not claim to officially represent the project if you have any doubts about your ability to maintain a professional composure that does not harm the project.

## Enforcing this Code of Conduct

**We expect our community to apply a good measure of self-regulation when it comes to the conduct displayed by its members. We believe that any community of adults is capable of applying the concepts of common sense, common decency and common courtesy to interactions between its members.**
That said, there are always exceptional situations possible where things need to be escalated, which is where this section comes into play.
Incidents involving abusive, harassing, or otherwise unacceptable behavior that need to be escalated for resolution may be reported by contacting the project owner at moonchild@palemoon.org. The project owner will then review and investigate all complaints and related communication of the case, and will respond in a way that they deem appropriate for the circumstances. It is imperative that any such reports are complete (nothing left out), true to fact, and presented in a coherent fashion.

## Confidentiality

The project team is generally obligated to maintain confidentiality with regard to the reporter of an incident, although in exceptional cases where intervention of authorities is required, the reporter may be individually identified to aid in the investigation or resolution of a conflict situation.

Project staff members who do not follow or enforce the Code of Conduct in good faith may face temporary or permanent repercussions as determined by other members of the project's staff. Being a member of staff does not excuse you from adhering to acceptable behavior outlined in this Code of Conduct.
