/***************************************************************
 * Name:      helpdialog.cpp
 * Author:    David Vachulka (arch_dvx@users.sourceforge.net)
 * Copyright: 2021
 * License:   GPL3
 **************************************************************/

#include <wx/wxhtml.h>
#include <wx/stdpaths.h>
#include "helpdialog.h"
#include "dxdefs.h"
#include "dxsettings.h"

IMPLEMENT_DYNAMIC_CLASS(HelpDialog, wxDialog)

BEGIN_EVENT_TABLE(HelpDialog, wxDialog)
    EVT_HTML_LINK_CLICKED(ID_HTML, HelpDialog::OnLink)
END_EVENT_TABLE()

HelpDialog::HelpDialog(wxWindow* parent)
: wxDialog(parent, wxID_ANY, _("Help"), wxDefaultPosition, wxDefaultSize, wxDEFAULT_FRAME_STYLE)
{
    wxBoxSizer *mainSizer = new wxBoxSizer(wxVERTICAL);

    wxPanel *panel= new wxPanel(this, wxID_ANY, wxDefaultPosition, wxDefaultSize, wxBORDER_SUNKEN);
    wxBoxSizer *sizer = new wxBoxSizer(wxVERTICAL);
    wxHtmlWindow *html = new wxHtmlWindow(panel, ID_HTML);
    wxString page = "<html><body>";
#if defined (__WXMAC__)
    page.Append(wxString::Format("<p style=\"text-align:center\"><img src=\"%s\"></p>", wxStandardPaths::Get().GetResourcesDir()+"/icons/about.png"));
#else
    page.Append(wxString::Format("<p style=\"text-align:center\"><img src=\"%s\"></p>", wxString(DXREMINDERS_DATADIR)+wxFILE_SEP_PATH+"icons"+wxFILE_SEP_PATH+"about.png"));
#endif
    page.Append("<p style=\"text-align:center\"><h1>dxreminders</h1></p>");
    page.Append("<p>"+_("dxreminders is simple and small program for reminders.")+" <a href=\"https://dxreminders.dxsolutions.org/about.html\">"+_("More...")+"</a></p>");
#if defined (__WXGTK__)
    page.Append("<p>"+_("If your desktop is XFCE, you can use ")+" <a href=\"https://dxreminders.dxsolutions.org/plugin/\">"+_("plugin.")+"</a></p><br />");
#else
    page.Append("<br />");
#endif
    page.Append("<br /><b>"+_("Shortcut keys")+"</b><br />");
    page.Append("<ul>");
    page.Append("<li>"+_("New event")+": "+dxsettings.shortcutKey(ID_MENU_NEWEVENT)+"</li>");
    page.Append("<li>"+_("Remove all events")+": "+dxsettings.shortcutKey(ID_MENU_REMOVEALLEVENTS)+"</li>");
    page.Append("<li>"+_("Backup database")+": "+dxsettings.shortcutKey(ID_MENU_SAVEDB)+"</li>");
    page.Append("<li>"+_("Import database")+": "+dxsettings.shortcutKey(ID_MENU_LOADDB)+"</li>");
    page.Append("<li>"+_("Show/hide note")+": "+dxsettings.shortcutKey(ID_MENU_SHOWHIDENOTE)+"</li>");
    page.Append("<li>"+_("Filter")+": "+dxsettings.shortcutKey(ID_BTN_FILTER)+"</li>");
    page.Append("<li>"+_("Clear filter")+"/"+_("Revert filter")+": "+dxsettings.shortcutKey(ID_BTN_FILTERCLEAR)+"</li>");
    page.Append("<li>"+_("Hide events")+"/"+_("Show events")+": "+dxsettings.shortcutKey(ID_MENU_SHOWEVENTS)+"</li>");
    page.Append("<li>"+_("Show all do not delete events")+"/"+_("Hide all do not delete events")+": "+dxsettings.shortcutKey(ID_MENU_SHOWNOTDELETE)+"</li>");
#if !defined (__WXMAC__)
    page.Append("<li>"+_("Full screen")+": "+dxsettings.shortcutKey(ID_MENU_FULLSCREEN)+"</li>");
#endif
    page.Append("<li>"+_("Calendar focus")+": "+dxsettings.shortcutKey(ID_MENU_CALENDARFOCUS)+"</li>");
    page.Append("<li>"+_("Events list focus")+": "+dxsettings.shortcutKey(ID_MENU_EVENTLISTFOCUS)+"</li>");
    page.Append("</ul>");
    page.Append("<br />");
    page.Append("<br /><b>"+_("Calendar keys")+"</b><br />");
    page.Append("<ul>");
    page.Append("<li>"+_("Selected date plus year:")+" +</li>");
    page.Append("<li>"+_("Selected date minus year:")+" -</li>");
    page.Append("<li>"+_("Selected date plus month:")+" PgDn</li>");
    page.Append("<li>"+_("Selected date minus month:")+" PgUp</li>");
    page.Append("<li>"+_("Selected date plus day:")+" Right</li>");
    page.Append("<li>"+_("Selected date minus day:")+" Left</li>");
    page.Append("<li>"+_("Selected date plus week:")+" Down</li>");
    page.Append("<li>"+_("Selected date minus week:")+" Up</li>");
    page.Append("<li>"+_("Today:")+" Ctrl+Home</li>");
    page.Append("<li>"+_("First day of selected month:")+" Home</li>");
    page.Append("<li>"+_("Last day of selected month:")+" End</li>");
    page.Append("</ul>");
    page.Append("</body></html>");
#if defined (__WXMAC__)
    page.Replace("Ctrl","&#8984;");
#endif
    html->SetPage(page);
    html->SetMinSize(wxSize(550,400));
    sizer->Add(html, 1, wxALL|wxEXPAND, 0);
    panel->SetSizer(sizer);
    sizer->Fit(panel);
    sizer->SetSizeHints(panel);
    mainSizer->Add(panel, 1, wxALL|wxEXPAND, 5);

    wxStdDialogButtonSizer *btnSizer = new wxStdDialogButtonSizer();
    wxButton* okButton = new wxButton(this, wxID_OK, "", wxDefaultPosition, wxDefaultSize, 0);
    btnSizer->AddButton(okButton);
    btnSizer->Realize();
    mainSizer->Add(btnSizer, 0, wxALL|wxALIGN_CENTER_HORIZONTAL, 5);

    this->SetSizer(mainSizer);
    mainSizer->Fit(this);
    mainSizer->SetSizeHints(this);
}

void HelpDialog::OnLink(wxHtmlLinkEvent &event)
{
    if(event.GetLinkInfo().GetHref().StartsWith("http"))
    {
        wxLaunchDefaultBrowser(event.GetLinkInfo().GetHref());
        return;
    }
    event.Skip();
}
