/***************************************************************
 * Name:      eventmsgdialog.h
 * Author:    David Vachulka (arch_dvx@users.sourceforge.net)
 * Copyright: 2013
 * License:   GPL3
 **************************************************************/

#ifndef EVENTMSGDIALOG_H
#define EVENTMSGDIALOG_H

#ifndef WX_PRECOMP
    #include <wx/wx.h>
#endif
#include <wx/datectrl.h>
#include <wx/spinctrl.h>
#include <wx/timectrl.h>
#include "data/engine.h"

class EventMsgDialog;

class LaterDialog: public wxDialog
{
    DECLARE_DYNAMIC_CLASS(LaterDialog)
    DECLARE_EVENT_TABLE()
public:
    LaterDialog() {}
    LaterDialog(wxWindow *parent);
    
    wxInt64 reminder() const { return m_reminder; }
private:
    wxBoxSizer *m_mainSizer;
    wxChoice *m_reminderCtrl;
    wxDateTime m_date;
    wxInt64 m_reminder;
    wxInt64 m_reminderOwn;
    wxBitmapButton *m_reminderEdit;

    void OnReminder(wxCommandEvent& event);
    void OnReminderEdit(wxCommandEvent& event);
};

class EventPanel: public wxPanel
{
    DECLARE_EVENT_TABLE()
public:
    EventPanel(wxWindow *parent, Event event, EventMsgDialog *dialog);

    wxInt64 id() const;
    wxDateTime date() const;
    void setId(wxInt64 id);
    bool notdelete() const;

private:
    wxInt64 m_id;
    wxDateTime m_date;
    bool m_notdelete;
    EventMsgDialog *m_dialog;

    void OnRemindLater(wxCommandEvent& event);
    void OnOk(wxCommandEvent& event);
};

class EventMsgDialog: public wxDialog
{
    DECLARE_DYNAMIC_CLASS(EventMsgDialog)
    DECLARE_EVENT_TABLE()
public:
    EventMsgDialog() {}
    EventMsgDialog(wxWindow *parent);

    void removeEvent(wxInt64 id);
private:
    std::vector<EventPanel*> m_events;
    wxScrolledWindow *m_scrl;
    size_t m_hidden;

    void OnOk(wxCommandEvent& event);
    void OnRemindLater(wxCommandEvent& event);
    void OnClose(wxCloseEvent& event);
};

#endif  /* EVENTMSGDIALOG_H */

