/***************************************************************
 * Name:      dxoptions.h
 * Author:    David Vachulka (arch_dvx@users.sourceforge.net)
 * Copyright: 2020
 * License:   GPL3
 **************************************************************/

#ifndef DXOPTIONS_H
#define DXOPTIONS_H

#ifndef WX_PRECOMP
    #include <wx/wx.h>
#endif
#include <wx/checkbox.h>
#include <wx/clrpicker.h>
#include <wx/fontpicker.h>
#include <wx/radiobut.h>
#include <wx/spinctrl.h>
#include <wx/listbook.h>
#include "widgets/dxtimepickerctrl.h"
#include "dxsettings.h"
#include "dxreminders.h"

class OptionsDialog: public wxDialog
{
    DECLARE_DYNAMIC_CLASS(OptionsDialog)
    DECLARE_EVENT_TABLE()
public:
    OptionsDialog() {}
    OptionsDialog(wxWindow *parent, bool ipc);

    bool resizeFrame();
private:
    wxBoxSizer *m_mainSizer;
    wxListbook *m_book;
    wxPanel *m_datePage;
    wxBoxSizer *m_datetimeSizer;
    wxCheckBox *m_startOnLogin;
    wxCheckBox *m_startAtTray;
    wxCheckBox *m_hideTrayIcon;
    wxCheckBox *m_notaskbar;
    wxCheckBox *m_silentMode;
    wxCheckBox *m_encrypt;
    wxCheckBox *m_closeDayDialog;
    wxCheckBox *m_rightclickNewevent;
    wxRadioButton *m_look0;
    wxRadioButton *m_look1;
    wxRadioButton *m_look2;
    wxRadioButton *m_look3;
    wxCheckBox *m_resize;
    wxCheckBox *m_showNote;
    wxColourPickerCtrl *m_calForeground;
    wxColourPickerCtrl *m_calBackground;
    wxColourPickerCtrl *m_calHighlightFg;
    wxColourPickerCtrl *m_calHighlightBg;
    wxColourPickerCtrl *m_calWeekendFg;
    wxColourPickerCtrl *m_calWeekendBg;
    wxColourPickerCtrl *m_calHolidayFg;
    wxColourPickerCtrl *m_calHolidayBg;
    wxColourPickerCtrl *m_calReminder;
    wxColourPickerCtrl *m_calRecurrence;
    wxFontPickerCtrl *m_calFont;
    wxFontPickerCtrl *m_calMiniFont;
    wxButton *m_defaultColors;
    dxSettings m_settings;
    dxremindersFrame *m_reminders;
    wxCheckBox *m_colDateShow;
    wxCheckBox *m_colReminderShow;
    wxCheckBox *m_colRecurrenceShow;
    wxColourPickerCtrl *m_oddMonth;
    wxColourPickerCtrl *m_evenMonth;
    wxColourPickerCtrl *m_highlightFg;
    wxColourPickerCtrl *m_highlightBg1;
    wxColourPickerCtrl *m_highlightBg2;
    wxColourPickerCtrl *m_highlightBg3;
    wxColourPickerCtrl *m_highlightBg4;
    wxColourPickerCtrl *m_highlightBg5;
    wxCheckBox *m_disableColors;
    wxFontPickerCtrl *m_eventsFont;
    wxCheckBox *m_alwaysNone;
    wxCheckBox *m_alwaysOncenotdelete;
    wxDateTime m_date;
    wxChoice *m_dateLayout;
    wxChoice *m_dateFormat;
    wxTextCtrl *m_dateFormatText;
    wxStaticText *m_dateFormatPreview;
    wxChoice *m_timeFormat;
    wxTextCtrl *m_timeFormatText;
    wxStaticText *m_timeFormatPreview;
    wxCheckBox *m_useAMPM;
    wxRadioButton *m_reminderTime0;
    wxRadioButton *m_reminderTime1;
    wxRadioButton *m_reminderTime2;
    dxTimePickerCtrl *m_reminderPresetTime;
    wxSpinCtrl *m_reminderMinutes;
    wxCheckBox *m_calendarToday;
    wxCheckBox *m_showWeekNumber;
    wxChoice *m_defaultReminder;
    wxChoice *m_defaultRecurrence;

    void OnCheckBox(wxCommandEvent& event);
    void OnOk(wxCommandEvent& event);
    void OnCancel(wxCommandEvent& event);
    void OnApply(wxCommandEvent& event);
    void saveOptions();
    void OnDefaultColors(wxCommandEvent& event);
    void OnDefaultEvents(wxCommandEvent& event);
    void OnDateText(wxKeyEvent& event);
    void OnTimeText(wxKeyEvent& event);
    int dateFormatToSelection(const wxString &format);
    wxString selectionToDateFormat(int selection);
    int timeFormatToSelection(const wxString &format);
    wxString selectionToTimeFormat(int selection);
    void OnChoiceDateFormat(wxCommandEvent& event);
    void OnChoiceTimeFormat(wxCommandEvent& event);
    void OnFont(wxFontPickerEvent& event);
    void showHideDateFormat();
    void showHideTimeFormat();
};

#endif  /* DXOPTIONS_H */

