/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.mssql.edit;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.mssql.edit.SQLServerBaseTableManager;
import org.jkiss.dbeaver.ext.mssql.model.SQLServerDataSource;
import org.jkiss.dbeaver.ext.mssql.model.SQLServerSchema;
import org.jkiss.dbeaver.ext.mssql.model.SQLServerTable;
import org.jkiss.dbeaver.ext.mssql.model.SQLServerTableBase;
import org.jkiss.dbeaver.ext.mssql.model.SQLServerTableCheckConstraint;
import org.jkiss.dbeaver.ext.mssql.model.SQLServerTableColumn;
import org.jkiss.dbeaver.ext.mssql.model.SQLServerTableForeignKey;
import org.jkiss.dbeaver.ext.mssql.model.SQLServerTableIndex;
import org.jkiss.dbeaver.ext.mssql.model.SQLServerTableUniqueKey;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.edit.DBECommand;
import org.jkiss.dbeaver.model.edit.DBECommandContext;
import org.jkiss.dbeaver.model.edit.DBEPersistAction;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.impl.edit.SQLDatabasePersistAction;
import org.jkiss.dbeaver.model.impl.sql.edit.SQLObjectEditor;
import org.jkiss.dbeaver.model.impl.sql.edit.SQLStructEditor;
import org.jkiss.dbeaver.model.messages.ModelMessages;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.rdb.DBSTableIndex;
import org.jkiss.utils.CommonUtils;

public class SQLServerTableManager
extends SQLServerBaseTableManager<SQLServerTableBase> {
    private static final Class<?>[] CHILD_TYPES = new Class[]{SQLServerTableColumn.class, SQLServerTableUniqueKey.class, SQLServerTableForeignKey.class, SQLServerTableIndex.class, SQLServerTableCheckConstraint.class};

    protected SQLServerTable createDatabaseObject(DBRProgressMonitor monitor, DBECommandContext context, Object container, Object copyFrom, Map<String, Object> options) {
        SQLServerSchema schema = (SQLServerSchema)container;
        SQLServerTable table = new SQLServerTable(schema);
        this.setNewObjectName(monitor, schema, table);
        return table;
    }

    protected void addObjectModifyActions(DBRProgressMonitor monitor, DBCExecutionContext executionContext, List<DBEPersistAction> actionList, SQLObjectEditor.ObjectChangeCommand command, Map<String, Object> options) {
        if (command.getProperties().size() > 1 || command.getProperty((Object)"description") == null) {
            StringBuilder query = new StringBuilder("ALTER TABLE ");
            query.append(((SQLServerTableBase)command.getObject()).getFullyQualifiedName(DBPEvaluationContext.DDL)).append(" ");
            this.appendTableModifiers(monitor, (SQLServerTableBase)command.getObject(), (SQLObjectEditor.NestedObjectCommand)command, query, true);
            actionList.add((DBEPersistAction)new SQLDatabasePersistAction(query.toString()));
        }
    }

    protected void appendTableModifiers(DBRProgressMonitor monitor, SQLServerTableBase table, SQLObjectEditor.NestedObjectCommand tableProps, StringBuilder ddl, boolean alter) {
    }

    protected void addObjectDeleteActions(DBRProgressMonitor monitor, DBCExecutionContext executionContext, List<DBEPersistAction> actions, SQLObjectEditor.ObjectDeleteCommand command, Map<String, Object> options) {
        SQLServerTableBase object = (SQLServerTableBase)command.getObject();
        actions.add((DBEPersistAction)new SQLDatabasePersistAction(ModelMessages.model_jdbc_drop_table, "DROP " + (object.isView() ? "VIEW" : "TABLE") + " " + object.getFullyQualifiedName(DBPEvaluationContext.DDL) + (!object.isView() && CommonUtils.getOption(options, (String)"deleteCascade") ? " CASCADE CONSTRAINTS" : "")));
    }

    @NotNull
    public Class<?>[] getChildTypes() {
        return CHILD_TYPES;
    }

    public void renameObject(@NotNull DBECommandContext commandContext, @NotNull SQLServerTableBase object, @NotNull Map<String, Object> options, @NotNull String newName) throws DBException {
        this.processObjectRename(commandContext, object, options, newName);
    }

    protected boolean isIncludeIndexInDDL(DBRProgressMonitor monitor, DBSTableIndex index) throws DBException {
        return !index.isPrimary() && super.isIncludeIndexInDDL(monitor, index);
    }

    protected void addExtraDDLCommands(DBRProgressMonitor monitor, SQLServerTableBase table, Map<String, Object> options, SQLStructEditor.StructCreateCommand createCommand) {
        SQLObjectEditor ccm = this.getObjectEditor(((SQLServerDataSource)table.getDataSource()).getContainer().getPlatform().getEditorsRegistry(), SQLServerTableCheckConstraint.class);
        if (ccm != null) {
            try {
                Collection checkConstraints;
                if (table instanceof SQLServerTable && !CommonUtils.isEmpty((Collection)(checkConstraints = CommonUtils.safeCollection(((SQLServerTable)table).getCheckConstraints(monitor))))) {
                    for (SQLServerTableCheckConstraint checkConstraint : checkConstraints) {
                        createCommand.aggregateCommand((DBECommand)ccm.makeCreateCommand((DBSObject)checkConstraint, options));
                    }
                }
            }
            catch (DBException e) {
                log.debug((Object)e);
            }
        }
    }
}

