/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.navigator.dialogs;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.exec.DBCExecutionContextDefaults;
import org.jkiss.dbeaver.model.navigator.DBNDatabaseNode;
import org.jkiss.dbeaver.model.navigator.DBNUtils;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.DBRRunnableWithResult;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.DBSObjectContainer;
import org.jkiss.dbeaver.model.struct.rdb.DBSCatalog;
import org.jkiss.dbeaver.model.struct.rdb.DBSSchema;
import org.jkiss.dbeaver.ui.internal.UINavigatorMessages;
import org.jkiss.dbeaver.ui.navigator.dialogs.ObjectListDialog;
import org.jkiss.dbeaver.ui.navigator.itemlist.DatabaseObjectListControl;
import org.jkiss.utils.CommonUtils;

public class SelectDatabaseDialog
extends ObjectListDialog<DBNDatabaseNode> {
    private static final Log log = Log.getLog(SelectDatabaseDialog.class);
    private final DBPDataSourceContainer dataSourceContainer;
    private volatile String currentInstanceName;
    private DatabaseObjectListControl<DBNDatabaseNode> instanceList;
    private final List<DBNDatabaseNode> selectedInstances = new ArrayList<DBNDatabaseNode>();

    public SelectDatabaseDialog(Shell parentShell, DBPDataSourceContainer dataSourceContainer, String currentInstanceName, Collection<DBNDatabaseNode> objects, Collection<DBNDatabaseNode> selected) {
        super(parentShell, UINavigatorMessages.label_choose_catalog, true, "SchemaSelector", objects, selected);
        this.dataSourceContainer = dataSourceContainer;
        this.currentInstanceName = currentInstanceName;
    }

    @Override
    protected void createUpperControls(Composite dialogArea) {
        DBPDataSource dataSource = this.dataSourceContainer.getDataSource();
        if (this.currentInstanceName != null && dataSource != null) {
            DBSObjectContainer instanceContainer = (DBSObjectContainer)DBUtils.getAdapter(DBSObjectContainer.class, (Object)dataSource);
            DBCExecutionContextDefaults contextDefaults = null;
            DBCExecutionContext defaultContext = DBUtils.getDefaultContext((DBSObject)instanceContainer, (boolean)true);
            if (defaultContext != null) {
                contextDefaults = defaultContext.getContextDefaults();
            }
            if (instanceContainer != null && contextDefaults != null && contextDefaults.supportsCatalogChange()) {
                this.createInstanceSelector(dialogArea, instanceContainer);
            }
        }
    }

    private void createInstanceSelector(Composite group, final DBSObjectContainer instanceContainer) {
        ++((GridLayout)group.getLayout()).numColumns;
        this.instanceList = SelectDatabaseDialog.createObjectSelector(group, true, "DatabaseInstanceSelector", this.selectedInstances, new DBRRunnableWithResult<List<DBNDatabaseNode>>(){

            public void run(DBRProgressMonitor monitor) throws InvocationTargetException {
                try {
                    DBNDatabaseNode activeInstanceNode;
                    DBSObject activeInstance;
                    if (!CommonUtils.isEmpty((String)SelectDatabaseDialog.this.currentInstanceName) && SelectDatabaseDialog.this.selectedInstances.isEmpty() && (activeInstance = instanceContainer.getChild(monitor, SelectDatabaseDialog.this.currentInstanceName)) != null && (activeInstanceNode = DBNUtils.getNodeByObject((DBRProgressMonitor)monitor, (DBSObject)activeInstance, (boolean)false)) != null) {
                        SelectDatabaseDialog.this.selectedInstances.add(activeInstanceNode);
                    }
                    Collection instances = instanceContainer.getChildren(monitor);
                    ArrayList<DBNDatabaseNode> instanceNodes = new ArrayList<DBNDatabaseNode>();
                    if (!CommonUtils.isEmpty((Collection)instances)) {
                        for (DBSObject instance : instances) {
                            DBNDatabaseNode instanceNode;
                            if (!(instance instanceof DBSCatalog) && !(instance instanceof DBSSchema) || (instanceNode = DBNUtils.getNodeByObject((DBRProgressMonitor)monitor, (DBSObject)instance, (boolean)false)) == null) continue;
                            instanceNodes.add(instanceNode);
                        }
                    }
                    this.result = instanceNodes;
                    SelectDatabaseDialog.this.objectList.loadData();
                }
                catch (DBException e) {
                    throw new InvocationTargetException(e);
                }
            }
        });
        this.instanceList.createProgressPanel();
        GridData gd = new GridData(1808);
        gd.heightHint = 300;
        gd.minimumWidth = 300;
        this.instanceList.setLayoutData(gd);
        this.instanceList.getSelectionProvider().addSelectionChangedListener(event -> {
            DBNDatabaseNode instance;
            IStructuredSelection selection = (IStructuredSelection)event.getSelection();
            this.selectedInstances.clear();
            this.selectedInstances.addAll(selection.toList());
            DBNDatabaseNode dBNDatabaseNode = instance = this.selectedInstances.isEmpty() ? null : this.selectedInstances.get(0);
            if (instance != null && !CommonUtils.equalObjects((Object)instance.getNodeName(), (Object)this.currentInstanceName)) {
                this.currentInstanceName = instance.getNodeName();
                this.objectList.loadData();
            }
        });
        this.instanceList.loadData();
        this.closeOnFocusLost(new Control[]{this.instanceList});
    }

    @Override
    protected List<DBNDatabaseNode> getObjects(DBRProgressMonitor monitor) throws DBException {
        DBNDatabaseNode instanceNode;
        Object rootObject = this.selectedInstances != null && this.currentInstanceName != null ? ((instanceNode = (DBNDatabaseNode)DBUtils.findObject(this.selectedInstances, (String)this.currentInstanceName)) == null ? null : instanceNode.getObject()) : this.dataSourceContainer.getDataSource();
        if (rootObject instanceof DBSObjectContainer) {
            try {
                Collection objectList = ((DBSObjectContainer)rootObject).getChildren(monitor);
                if (objectList == null) {
                    return Collections.emptyList();
                }
                ArrayList<DBNDatabaseNode> nodeList = new ArrayList<DBNDatabaseNode>(objectList.size());
                for (DBSObject object : objectList) {
                    DBNDatabaseNode databaseNode;
                    if (!(object instanceof DBSObjectContainer) || (databaseNode = DBNUtils.getNodeByObject((DBRProgressMonitor)monitor, (DBSObject)object, (boolean)false)) == null) continue;
                    nodeList.add(databaseNode);
                }
                return nodeList;
            }
            catch (DBException e) {
                log.error((Object)e);
                return Collections.emptyList();
            }
        }
        return this.objects;
    }

    public String getCurrentInstanceName() {
        DBNDatabaseNode selectedObject = (DBNDatabaseNode)this.getSelectedObject();
        if (selectedObject.getObject() instanceof DBSCatalog) {
            return selectedObject.getObject().getName();
        }
        return this.currentInstanceName;
    }
}

