/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.tools;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.sat4j.specs.ContradictionException;
import org.sat4j.specs.IConstr;
import org.sat4j.specs.IGroupSolver;
import org.sat4j.specs.ISolver;
import org.sat4j.specs.IVecInt;
import org.sat4j.tools.AbstractClauseSelectorSolver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GroupClauseSelectorSolver<T extends ISolver>
extends AbstractClauseSelectorSolver<T>
implements IGroupSolver {
    private static final long serialVersionUID = 1L;
    private final Map<Integer, Integer> varToHighLevel = new HashMap<Integer, Integer>();
    private final Map<Integer, Integer> highLevelToVar = new HashMap<Integer, Integer>();

    public GroupClauseSelectorSolver(T solver) {
        super(solver);
    }

    public IConstr addControlableClause(IVecInt literals, int desc) throws ContradictionException {
        if (desc == 0) {
            return super.addClause(literals);
        }
        Integer hlvar = this.highLevelToVar.get(desc);
        if (hlvar == null) {
            hlvar = this.createNewVar(literals);
            this.highLevelToVar.put(desc, hlvar);
            this.varToHighLevel.put(hlvar, desc);
        }
        literals.push(hlvar);
        return super.addClause(literals);
    }

    public IConstr addNonControlableClause(IVecInt literals) throws ContradictionException {
        return super.addClause(literals);
    }

    @Override
    public IConstr addClause(IVecInt literals, int desc) throws ContradictionException {
        return this.addControlableClause(literals, desc);
    }

    @Override
    public Collection<Integer> getAddedVars() {
        return this.varToHighLevel.keySet();
    }

    @Override
    public int[] model() {
        int[] fullmodel = super.modelWithInternalVariables();
        if (fullmodel == null) {
            return null;
        }
        int[] model = new int[fullmodel.length - this.varToHighLevel.size()];
        int j = 0;
        int[] nArray = fullmodel;
        int n = fullmodel.length;
        int n2 = 0;
        while (n2 < n) {
            int element = nArray[n2];
            if (this.varToHighLevel.get(Math.abs(element)) == null) {
                model[j++] = element;
            }
            ++n2;
        }
        return model;
    }

    public Map<Integer, Integer> getVarToHighLevel() {
        return this.varToHighLevel;
    }
}

