/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.utils;

import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.text.MessageFormat;
import java.util.Date;
import java.util.Locale;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.app.DBPPlatform;
import org.jkiss.dbeaver.model.data.DBDContent;
import org.jkiss.dbeaver.model.data.DBDContentCached;
import org.jkiss.dbeaver.model.data.DBDContentStorage;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.messages.ModelMessages;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.VoidProgressMonitor;
import org.jkiss.dbeaver.utils.GeneralUtils;
import org.jkiss.dbeaver.utils.UnicodeReader;
import org.jkiss.utils.ArrayUtils;
import org.jkiss.utils.CommonUtils;
import org.jkiss.utils.IOUtils;

public class ContentUtils {
    static final int STREAM_COPY_BUFFER_SIZE = 10000;
    private static final String LOB_DIR = ".lob";
    private static final Log log = Log.getLog(ContentUtils.class);

    public static File getLobFolder(DBRProgressMonitor monitor, DBPPlatform application) throws IOException {
        return application.getTempFolder(monitor, LOB_DIR);
    }

    public static File createTempContentFile(DBRProgressMonitor monitor, DBPPlatform application, String fileName) throws IOException {
        return ContentUtils.makeTempFile(monitor, ContentUtils.getLobFolder(monitor, application), fileName, "data");
    }

    public static File makeTempFile(DBRProgressMonitor monitor, File folder, String name, String extension) throws IOException {
        File tempFile = new File(folder, String.valueOf(name = CommonUtils.escapeFileName((String)name)) + "-" + System.currentTimeMillis() + "." + extension);
        if (!tempFile.createNewFile()) {
            throw new IOException(MessageFormat.format(ModelMessages.error_can_create_temp_file, tempFile.getAbsolutePath(), folder.getAbsoluteFile()));
        }
        return tempFile;
    }

    public static void deleteTempFile(DBRProgressMonitor monitor, IFile file) {
        try {
            file.delete(true, false, monitor.getNestedMonitor());
        }
        catch (CoreException e) {
            log.warn("Can't delete temporary file '" + file.getFullPath().toString() + "'", e);
        }
    }

    public static void saveContentToFile(InputStream contentStream, File file, DBRProgressMonitor monitor) throws IOException {
        Throwable throwable = null;
        Object var4_5 = null;
        try (FileOutputStream os = new FileOutputStream(file);){
            ContentUtils.copyStreams(contentStream, file.length(), os, monitor);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        if (monitor.isCanceled() && !file.delete()) {
            log.warn("Can't delete incomplete file '" + file.getAbsolutePath() + "'");
        }
    }

    public static void saveContentToFile(Reader contentReader, File file, String charset, DBRProgressMonitor monitor) throws IOException {
        Throwable throwable = null;
        Object var5_6 = null;
        try (OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(file), charset);){
            ContentUtils.copyStreams(contentReader, file.length(), writer, monitor);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        if (monitor.isCanceled() && !file.delete()) {
            log.warn("Can't delete incomplete file '" + file.getAbsolutePath() + "'");
        }
    }

    public static void copyStreams(InputStream inputStream, long contentLength, OutputStream outputStream, DBRProgressMonitor monitor) throws IOException {
        monitor.beginTask("Copy binary content", contentLength < 0L ? 10000 : (int)contentLength);
        try {
            byte[] buffer = new byte[10000];
            while (!monitor.isCanceled()) {
                int count = inputStream.read(buffer);
                if (count <= 0) {
                    break;
                }
                outputStream.write(buffer, 0, count);
                monitor.worked(10000);
            }
        }
        finally {
            monitor.done();
        }
    }

    public static void copyStreams(Reader reader, long contentLength, Writer writer, DBRProgressMonitor monitor) throws IOException {
        monitor.beginTask("Copy character content", contentLength < 0L ? 10000 : (int)contentLength);
        try {
            char[] buffer = new char[10000];
            while (!monitor.isCanceled()) {
                int count = reader.read(buffer);
                if (count <= 0) {
                    break;
                }
                writer.write(buffer, 0, count);
                monitor.worked(10000);
            }
        }
        finally {
            monitor.done();
        }
    }

    public static long calculateContentLength(File file, String charset) throws IOException {
        return ContentUtils.calculateContentLength(new FileInputStream(file), charset);
    }

    public static long calculateContentLength(InputStream stream, String charset) throws IOException {
        return ContentUtils.calculateContentLength(new InputStreamReader(stream, charset));
    }

    public static long calculateContentLength(Reader reader) throws IOException {
        try {
            int count;
            long length = 0L;
            char[] buffer = new char[10000];
            while ((count = reader.read(buffer)) > 0) {
                length += (long)count;
            }
            long l = length;
            return l;
        }
        finally {
            reader.close();
        }
    }

    public static void close(Closeable closeable) {
        try {
            closeable.close();
        }
        catch (IOException e) {
            log.warn("Error closing stream", e);
        }
    }

    public static void copyStreamToFile(DBRProgressMonitor monitor, InputStream inputStream, long contentLength, IFile localFile) throws IOException {
        File file = localFile.getLocation().toFile();
        try {
            Throwable throwable = null;
            Object var7_7 = null;
            try (FileOutputStream outputStream = new FileOutputStream(file);){
                ContentUtils.copyStreams(inputStream, contentLength, outputStream, monitor);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        finally {
            inputStream.close();
        }
        ContentUtils.syncFile(monitor, (IResource)localFile);
    }

    public static void copyReaderToFile(DBRProgressMonitor monitor, Reader reader, long contentLength, String charset, IFile localFile) throws IOException {
        try {
            if (charset == null) {
                charset = localFile.getCharset();
            } else {
                localFile.setCharset(charset, monitor.getNestedMonitor());
            }
        }
        catch (CoreException e) {
            log.warn("Can't set content charset", e);
        }
        File file = localFile.getLocation().toFile();
        try {
            Throwable throwable = null;
            Object var8_9 = null;
            try (FileOutputStream outputStream = new FileOutputStream(file);){
                OutputStreamWriter writer = new OutputStreamWriter((OutputStream)outputStream, charset == null ? GeneralUtils.DEFAULT_ENCODING : charset);
                ContentUtils.copyStreams(reader, contentLength, writer, monitor);
                ((Writer)writer).flush();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        finally {
            reader.close();
        }
        ContentUtils.syncFile(monitor, (IResource)localFile);
    }

    public static void syncFile(DBRProgressMonitor monitor, IResource localFile) {
        try {
            localFile.refreshLocal(0, monitor.getNestedMonitor());
        }
        catch (CoreException e) {
            log.warn("Can't synchronize file '" + localFile + "' with contents", e);
        }
    }

    public static IFile getUniqueFile(IFolder folder, String fileName, String fileExt) {
        IFile file = folder.getFile(String.valueOf(fileName) + "." + fileExt);
        int index = 1;
        while (file.exists()) {
            file = folder.getFile(String.valueOf(fileName) + "-" + index + "." + fileExt);
            ++index;
        }
        return file;
    }

    public static String readFileToString(File file) throws IOException {
        Throwable throwable = null;
        Object var2_3 = null;
        try (FileInputStream fileStream = new FileInputStream(file);){
            int count;
            UnicodeReader unicodeReader = new UnicodeReader(fileStream, StandardCharsets.UTF_8);
            StringBuilder result = new StringBuilder((int)file.length());
            char[] buffer = new char[4000];
            while ((count = unicodeReader.read(buffer)) > 0) {
                result.append(buffer, 0, count);
            }
            return result.toString();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public static String readToString(InputStream is, Charset charset) throws IOException {
        return IOUtils.readToString((Reader)new UnicodeReader(is, charset));
    }

    @Nullable
    public static IFile convertPathToWorkspaceFile(IPath path) {
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IFile file = root.getFileForLocation(path);
        if (file != null) {
            return file;
        }
        IPath folderPath = path.removeLastSegments(1);
        URI folderURI = folderPath.toFile().toURI();
        Object[] containers = root.findContainersForLocationURI(folderURI);
        if (!ArrayUtils.isEmpty((Object[])containers)) {
            Object container = containers[0];
            file = container.getFile(path.removeFirstSegments(path.segmentCount() - 1));
        }
        return file;
    }

    @Nullable
    public static IPath convertPathToWorkspacePath(IPath path) {
        IFile wFile = ContentUtils.convertPathToWorkspaceFile(path);
        return wFile == null ? null : wFile.getFullPath();
    }

    public static boolean isTextContent(DBDContent content) {
        String contentType;
        String string = contentType = content == null ? null : content.getContentType();
        return contentType != null && contentType.toLowerCase(Locale.ENGLISH).startsWith("text");
    }

    public static boolean isTextMime(String mimeType) {
        return mimeType != null && mimeType.toLowerCase(Locale.ENGLISH).startsWith("text");
    }

    public static boolean isTextValue(Object value) {
        if (value == null) {
            return false;
        }
        if (value instanceof CharSequence) {
            return true;
        }
        if (value instanceof byte[]) {
            byte[] byArray = (byte[])value;
            int n = byArray.length;
            int n2 = 0;
            while (n2 < n) {
                byte b = byArray[n2];
                if (!(Character.isLetterOrDigit(b) || Character.isSpaceChar(b) || Character.isISOControl(b))) {
                    return false;
                }
                ++n2;
            }
        }
        return true;
    }

    public static boolean isXML(DBDContent content) {
        return "text/xml".equalsIgnoreCase(content.getContentType());
    }

    public static boolean isJSON(DBDContent content) {
        return "text/json".equalsIgnoreCase(content.getContentType());
    }

    @Nullable
    public static String getContentStringValue(@NotNull DBRProgressMonitor monitor, @NotNull DBDContent object) throws DBCException {
        block8: {
            if (object.isNull()) {
                return null;
            }
            DBDContentStorage data = object.getContents(monitor);
            if (data != null) {
                String string;
                Object cachedValue;
                if (data instanceof DBDContentCached && (cachedValue = ((DBDContentCached)((Object)data)).getCachedValue()) instanceof String) {
                    return (String)cachedValue;
                }
                Reader contentReader = data.getContentReader();
                if (contentReader == null) break block8;
                try {
                    StringWriter buf = new StringWriter();
                    ContentUtils.copyStreams(contentReader, object.getContentLength(), buf, monitor);
                    string = buf.toString();
                }
                catch (Throwable throwable) {
                    try {
                        IOUtils.close((Closeable)contentReader);
                        throw throwable;
                    }
                    catch (IOException e) {
                        log.debug("Can't extract string from content", e);
                    }
                }
                IOUtils.close((Closeable)contentReader);
                return string;
            }
        }
        return object.toString();
    }

    @Nullable
    public static byte[] getContentBinaryValue(@NotNull DBRProgressMonitor monitor, @NotNull DBDContent object) throws DBCException {
        block7: {
            DBDContentStorage data = object.getContents(monitor);
            if (data != null) {
                byte[] byArray;
                Object cachedValue;
                if (data instanceof DBDContentCached && (cachedValue = ((DBDContentCached)((Object)data)).getCachedValue()) instanceof byte[]) {
                    return (byte[])cachedValue;
                }
                InputStream contentStream = data.getContentStream();
                if (contentStream == null) break block7;
                try {
                    ByteArrayOutputStream buf = new ByteArrayOutputStream();
                    ContentUtils.copyStreams(contentStream, object.getContentLength(), buf, monitor);
                    byArray = buf.toByteArray();
                }
                catch (Throwable throwable) {
                    try {
                        IOUtils.close((Closeable)contentStream);
                        throw throwable;
                    }
                    catch (IOException e) {
                        log.debug("Can't extract string from content", e);
                    }
                }
                IOUtils.close((Closeable)contentStream);
                return byArray;
            }
        }
        return null;
    }

    public static void deleteTempFile(File tempFile) {
        if (!tempFile.delete()) {
            log.warn("Can't delete temp file '" + tempFile.getAbsolutePath() + "'");
        }
    }

    public static boolean deleteFileRecursive(File file) {
        File[] files;
        if (file.isDirectory() && (files = file.listFiles()) != null) {
            File[] fileArray = files;
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                File ch = fileArray[n2];
                if (!ContentUtils.deleteFileRecursive(ch)) {
                    return false;
                }
                ++n2;
            }
        }
        return file.delete();
    }

    public static void checkFolderExists(IFolder folder) throws DBException {
        ContentUtils.checkFolderExists(folder, new VoidProgressMonitor());
    }

    public static void checkFolderExists(IFolder folder, DBRProgressMonitor monitor) throws DBException {
        if (!folder.exists()) {
            try {
                folder.create(true, true, monitor.getNestedMonitor());
            }
            catch (CoreException e) {
                throw new DBException("Can't create folder '" + folder.getFullPath() + "'", e);
            }
        }
    }

    public static void makeFileBackup(IFile file) {
        Serializable backupTime;
        IFile backupFile;
        if (!file.exists()) {
            return;
        }
        String backupFileName = String.valueOf(file.getName()) + ".bak";
        if (!backupFileName.startsWith(".")) {
            backupFileName = "." + backupFileName;
        }
        if ((backupFile = file.getParent().getFile((IPath)new Path(backupFileName))).exists() && CommonUtils.isSameDay((Date)(backupTime = new Date(backupFile.getModificationStamp())), (Date)new Date())) {
            return;
        }
        try {
            backupTime = null;
            Object var4_6 = null;
            try (InputStream fis = file.getContents();){
                if (!backupFile.exists()) {
                    backupFile.create(fis, 6144, (IProgressMonitor)new NullProgressMonitor());
                } else {
                    backupFile.setContents(fis, 6144, (IProgressMonitor)new NullProgressMonitor());
                }
            }
            catch (Throwable throwable) {
                if (backupTime == null) {
                    backupTime = throwable;
                } else if (backupTime != throwable) {
                    ((Throwable)backupTime).addSuppressed(throwable);
                }
                throw backupTime;
            }
        }
        catch (Exception e) {
            log.error("Error creating backup copy of " + file.getFullPath(), e);
        }
    }

    public static void makeFileBackup(File file) {
        Serializable backupTime;
        File backupFile;
        if (!file.exists()) {
            return;
        }
        String backupFileName = String.valueOf(file.getName()) + ".bak";
        if (!backupFileName.startsWith(".")) {
            backupFileName = "." + backupFileName;
        }
        if ((backupFile = new File(file.getParent(), backupFileName)).exists() && CommonUtils.isSameDay((Date)(backupTime = new Date(backupFile.lastModified())), (Date)new Date())) {
            return;
        }
        try {
            backupTime = null;
            Object var4_6 = null;
            try (FileInputStream fis = new FileInputStream(file);){
                Throwable throwable = null;
                Object var7_11 = null;
                try (FileOutputStream fos = new FileOutputStream(backupFile);){
                    IOUtils.copyStream((InputStream)fis, (OutputStream)fos);
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (Throwable throwable) {
                if (backupTime == null) {
                    backupTime = throwable;
                } else if (backupTime != throwable) {
                    ((Throwable)backupTime).addSuppressed(throwable);
                }
                throw backupTime;
            }
        }
        catch (Exception e) {
            log.error("Error creating backup copy of " + file.getAbsolutePath(), e);
        }
    }
}

