/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.mysql.model;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.mysql.MySQLConstants;
import org.jkiss.dbeaver.ext.mysql.model.MySQLCharset;
import org.jkiss.dbeaver.ext.mysql.model.MySQLCollation;
import org.jkiss.dbeaver.ext.mysql.model.MySQLDataSource;
import org.jkiss.dbeaver.ext.mysql.model.MySQLEvent;
import org.jkiss.dbeaver.ext.mysql.model.MySQLPackage;
import org.jkiss.dbeaver.ext.mysql.model.MySQLProcedure;
import org.jkiss.dbeaver.ext.mysql.model.MySQLProcedureParameter;
import org.jkiss.dbeaver.ext.mysql.model.MySQLSequence;
import org.jkiss.dbeaver.ext.mysql.model.MySQLTable;
import org.jkiss.dbeaver.ext.mysql.model.MySQLTableBase;
import org.jkiss.dbeaver.ext.mysql.model.MySQLTableColumn;
import org.jkiss.dbeaver.ext.mysql.model.MySQLTableConstraint;
import org.jkiss.dbeaver.ext.mysql.model.MySQLTableConstraintColumn;
import org.jkiss.dbeaver.ext.mysql.model.MySQLTableIndex;
import org.jkiss.dbeaver.ext.mysql.model.MySQLTableIndexColumn;
import org.jkiss.dbeaver.ext.mysql.model.MySQLTrigger;
import org.jkiss.dbeaver.ext.mysql.model.MySQLView;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.DBPObjectStatistics;
import org.jkiss.dbeaver.model.DBPObjectStatisticsCollector;
import org.jkiss.dbeaver.model.DBPRefreshableObject;
import org.jkiss.dbeaver.model.DBPSaveableObject;
import org.jkiss.dbeaver.model.DBPScriptObject;
import org.jkiss.dbeaver.model.DBPScriptObjectExt2;
import org.jkiss.dbeaver.model.DBPSystemObject;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCPreparedStatement;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCResultSet;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCSession;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCStatement;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCUtils;
import org.jkiss.dbeaver.model.impl.jdbc.cache.JDBCCompositeCache;
import org.jkiss.dbeaver.model.impl.jdbc.cache.JDBCObjectCache;
import org.jkiss.dbeaver.model.impl.jdbc.cache.JDBCObjectLookupCache;
import org.jkiss.dbeaver.model.impl.jdbc.cache.JDBCStructCache;
import org.jkiss.dbeaver.model.impl.jdbc.cache.JDBCStructLookupCache;
import org.jkiss.dbeaver.model.impl.struct.AbstractTableConstraint;
import org.jkiss.dbeaver.model.meta.Association;
import org.jkiss.dbeaver.model.meta.IPropertyCacheValidator;
import org.jkiss.dbeaver.model.meta.IPropertyValueListProvider;
import org.jkiss.dbeaver.model.meta.LazyProperty;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.meta.PropertyGroup;
import org.jkiss.dbeaver.model.preferences.DBPPropertySource;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.sql.SQLUtils;
import org.jkiss.dbeaver.model.struct.DBSEntity;
import org.jkiss.dbeaver.model.struct.DBSEntityConstraintType;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.DBSObjectFilter;
import org.jkiss.dbeaver.model.struct.rdb.DBSCatalog;
import org.jkiss.dbeaver.model.struct.rdb.DBSIndexType;
import org.jkiss.dbeaver.model.struct.rdb.DBSProcedureContainer;
import org.jkiss.dbeaver.model.struct.rdb.DBSProcedureParameterKind;
import org.jkiss.utils.ByteNumberFormat;
import org.jkiss.utils.CommonUtils;

public class MySQLCatalog
implements DBSCatalog,
DBPSaveableObject,
DBPRefreshableObject,
DBPSystemObject,
DBSProcedureContainer,
DBPObjectStatisticsCollector,
DBPObjectStatistics,
DBPScriptObject,
DBPScriptObjectExt2 {
    final TableCache tableCache = new TableCache();
    final ProceduresCache proceduresCache = new ProceduresCache();
    final PackageCache packageCache = new PackageCache();
    final TriggerCache triggerCache = new TriggerCache();
    final UniqueKeyCache uniqueKeyCache = new UniqueKeyCache(this.tableCache);
    final CheckConstraintCache checkConstraintCache = new CheckConstraintCache(this.tableCache);
    final IndexCache indexCache = new IndexCache(this.tableCache);
    final EventCache eventCache = new EventCache();
    final SequenceCache sequenceCache = new SequenceCache();
    private final MySQLDataSource dataSource;
    private String name;
    private Long databaseSize;
    private boolean persisted;
    private volatile boolean hasStatistics;
    private long dbSize;
    private transient String databaseDDL;
    private final AdditionalInfo additionalInfo = new AdditionalInfo();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PropertyGroup
    @LazyProperty(cacheValidator=AdditionalInfoValidator.class)
    public AdditionalInfo getAdditionalInfo(DBRProgressMonitor monitor) throws DBCException {
        AdditionalInfo additionalInfo = this.additionalInfo;
        synchronized (additionalInfo) {
            if (!this.additionalInfo.loaded) {
                this.loadAdditionalInfo(monitor);
            }
            return this.additionalInfo;
        }
    }

    public AdditionalInfo getAdditionalInfo() {
        return this.additionalInfo;
    }

    private void loadAdditionalInfo(DBRProgressMonitor monitor) throws DBCException {
        if (!this.isPersisted()) {
            this.additionalInfo.loaded = true;
            return;
        }
        MySQLDataSource dataSource = this.getDataSource();
        if (!this.getDataSource().supportsInformationSchema()) {
            this.additionalInfo.loaded = false;
            return;
        }
        Throwable throwable = null;
        Object var4_5 = null;
        try (JDBCSession session = (JDBCSession)DBUtils.openMetaSession((DBRProgressMonitor)monitor, (DBSObject)this, (String)"Load table status");){
            try {
                Throwable throwable2 = null;
                Object var7_11 = null;
                try (JDBCPreparedStatement dbStat = session.prepareStatement("SELECT * FROM information_schema.SCHEMATA WHERE SCHEMA_NAME=?");){
                    dbStat.setString(1, this.getName());
                    Throwable throwable3 = null;
                    Object var10_16 = null;
                    try (JDBCResultSet dbResult = dbStat.executeQuery();){
                        if (dbResult.next()) {
                            this.additionalInfo.defaultCharset = dataSource.getCharset(JDBCUtils.safeGetString((ResultSet)dbResult, (String)"DEFAULT_CHARACTER_SET_NAME"));
                            this.additionalInfo.defaultCollation = dataSource.getCollation(JDBCUtils.safeGetString((ResultSet)dbResult, (String)"DEFAULT_COLLATION_NAME"));
                            this.additionalInfo.sqlPath = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"SQL_PATH");
                        }
                        this.additionalInfo.loaded = true;
                    }
                    catch (Throwable throwable4) {
                        if (throwable3 == null) {
                            throwable3 = throwable4;
                        } else if (throwable3 != throwable4) {
                            throwable3.addSuppressed(throwable4);
                        }
                        throw throwable3;
                    }
                }
                catch (Throwable throwable5) {
                    if (throwable2 == null) {
                        throwable2 = throwable5;
                    } else if (throwable2 != throwable5) {
                        throwable2.addSuppressed(throwable5);
                    }
                    throw throwable2;
                }
            }
            catch (SQLException e) {
                throw new DBCException((Throwable)e, (DBCExecutionContext)session.getExecutionContext());
            }
        }
        catch (Throwable throwable6) {
            if (throwable == null) {
                throwable = throwable6;
            } else if (throwable != throwable6) {
                throwable.addSuppressed(throwable6);
            }
            throw throwable;
        }
    }

    public MySQLCatalog(MySQLDataSource dataSource, ResultSet dbResult) {
        this.tableCache.setCaseSensitive(false);
        this.dataSource = dataSource;
        if (dbResult != null) {
            this.name = JDBCUtils.safeGetString((ResultSet)dbResult, (int)1);
            this.persisted = true;
        } else {
            this.additionalInfo.loaded = true;
            this.additionalInfo.defaultCharset = dataSource.getCharset("utf8");
            this.additionalInfo.defaultCollation = dataSource.getCollation("utf8_general_ci");
            this.additionalInfo.sqlPath = "";
            this.persisted = false;
        }
    }

    public boolean hasStatistics() {
        return true;
    }

    public long getStatObjectSize() {
        return this.dbSize;
    }

    @Nullable
    public DBPPropertySource getStatProperties() {
        return null;
    }

    void setDatabaseSize(long dbSize) {
        this.dbSize = dbSize;
    }

    public DBSObject getParentObject() {
        return this.dataSource.getContainer();
    }

    @NotNull
    public MySQLDataSource getDataSource() {
        return this.dataSource;
    }

    @Property(viewable=true, editable=true, order=1)
    @NotNull
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public boolean isPersisted() {
        return this.persisted;
    }

    public void setPersisted(boolean persisted) {
        this.persisted = persisted;
    }

    @Nullable
    public String getDescription() {
        return null;
    }

    @Property(viewable=true, order=20, formatter=ByteNumberFormat.class)
    public Long getDatabaseSize(DBRProgressMonitor monitor) throws DBException {
        if (this.databaseSize == null && this.getDataSource().supportsInformationSchema()) {
            try {
                Throwable throwable = null;
                Object var3_5 = null;
                try (JDBCSession session = (JDBCSession)DBUtils.openUtilSession((DBRProgressMonitor)monitor, (DBSObject)this, (String)"Read database size");){
                    Throwable throwable2 = null;
                    Object var6_10 = null;
                    try (JDBCPreparedStatement dbStat = session.prepareStatement("SELECT SUM((DATA_LENGTH+INDEX_LENGTH))\nFROM INFORMATION_SCHEMA.TABLES \nWHERE TABLE_SCHEMA=?");){
                        dbStat.setString(1, this.getName());
                        Throwable throwable3 = null;
                        Object var9_15 = null;
                        try (JDBCResultSet dbResult = dbStat.executeQuery();){
                            this.databaseSize = dbResult.next() ? Long.valueOf(dbResult.getLong(1)) : Long.valueOf(0L);
                        }
                        catch (Throwable throwable4) {
                            if (throwable3 == null) {
                                throwable3 = throwable4;
                            } else if (throwable3 != throwable4) {
                                throwable3.addSuppressed(throwable4);
                            }
                            throw throwable3;
                        }
                    }
                    catch (Throwable throwable5) {
                        if (throwable2 == null) {
                            throwable2 = throwable5;
                        } else if (throwable2 != throwable5) {
                            throwable2.addSuppressed(throwable5);
                        }
                        throw throwable2;
                    }
                }
                catch (Throwable throwable6) {
                    if (throwable == null) {
                        throwable = throwable6;
                    } else if (throwable != throwable6) {
                        throwable.addSuppressed(throwable6);
                    }
                    throw throwable;
                }
            }
            catch (SQLException e) {
                throw new DBException((Throwable)e, (DBPDataSource)this.getDataSource());
            }
        }
        return this.databaseSize;
    }

    public TableCache getTableCache() {
        return this.tableCache;
    }

    public ProceduresCache getProceduresCache() {
        return this.proceduresCache;
    }

    public TriggerCache getTriggerCache() {
        return this.triggerCache;
    }

    public UniqueKeyCache getUniqueKeyCache() {
        return this.uniqueKeyCache;
    }

    public CheckConstraintCache getCheckConstraintCache() {
        return this.checkConstraintCache;
    }

    public IndexCache getIndexCache() {
        return this.indexCache;
    }

    public EventCache getEventCache() {
        return this.eventCache;
    }

    public SequenceCache getSequenceCache() {
        return this.sequenceCache;
    }

    @Association
    public Collection<MySQLTableIndex> getIndexes(DBRProgressMonitor monitor) throws DBException {
        return this.getDataSource().supportsInformationSchema() ? this.indexCache.getObjects(monitor, (DBSObject)this, null) : Collections.emptyList();
    }

    @Association
    public Collection<MySQLTable> getTables(DBRProgressMonitor monitor) throws DBException {
        return this.tableCache.getTypedObjects(monitor, (DBSObject)this, MySQLTable.class);
    }

    public MySQLTable getTable(DBRProgressMonitor monitor, String name) throws DBException {
        return (MySQLTable)this.tableCache.getObject(monitor, (DBSObject)this, name, MySQLTable.class);
    }

    @Association
    public Collection<MySQLView> getViews(DBRProgressMonitor monitor) throws DBException {
        return this.tableCache.getTypedObjects(monitor, (DBSObject)this, MySQLView.class);
    }

    @Association
    public Collection<MySQLProcedure> getProcedures(DBRProgressMonitor monitor) throws DBException {
        return this.getDataSource().supportsInformationSchema() ? this.proceduresCache.getAllObjects(monitor, (DBSObject)this) : Collections.emptyList();
    }

    public MySQLProcedure getProcedure(DBRProgressMonitor monitor, String procName) throws DBException {
        return (MySQLProcedure)this.proceduresCache.getObject(monitor, (DBSObject)this, procName);
    }

    @Association
    public Collection<MySQLPackage> getPackages(DBRProgressMonitor monitor) throws DBException {
        return this.packageCache.getAllObjects(monitor, (DBSObject)this);
    }

    @Association
    public Collection<MySQLTrigger> getTriggers(DBRProgressMonitor monitor) throws DBException {
        return this.getDataSource().supportsInformationSchema() ? this.triggerCache.getAllObjects(monitor, (DBSObject)this) : Collections.emptyList();
    }

    public MySQLTrigger getTrigger(DBRProgressMonitor monitor, String name) throws DBException {
        return (MySQLTrigger)this.triggerCache.getObject(monitor, (DBSObject)this, name);
    }

    @Association
    public Collection<MySQLEvent> getEvents(DBRProgressMonitor monitor) throws DBException {
        return this.getDataSource().supportsInformationSchema() ? this.eventCache.getAllObjects(monitor, (DBSObject)this) : Collections.emptyList();
    }

    @Association
    public Collection<MySQLSequence> getSequences(DBRProgressMonitor monitor) throws DBException {
        return this.getDataSource().supportsInformationSchema() ? this.sequenceCache.getAllObjects(monitor, (DBSObject)this) : Collections.emptyList();
    }

    public Collection<MySQLTableBase> getChildren(@NotNull DBRProgressMonitor monitor) throws DBException {
        return this.tableCache.getAllObjects(monitor, (DBSObject)this);
    }

    public MySQLTableBase getChild(@NotNull DBRProgressMonitor monitor, @NotNull String childName) throws DBException {
        return (MySQLTableBase)this.tableCache.getObject(monitor, (DBSObject)this, childName);
    }

    @NotNull
    public Class<? extends DBSEntity> getPrimaryChildType(@Nullable DBRProgressMonitor monitor) throws DBException {
        return MySQLTable.class;
    }

    public synchronized void cacheStructure(@NotNull DBRProgressMonitor monitor, int scope) throws DBException {
        monitor.subTask("Cache tables");
        this.tableCache.getAllObjects(monitor, (DBSObject)this);
        if ((scope & 2) != 0) {
            monitor.subTask("Cache table columns");
            this.tableCache.loadChildren(monitor, (DBSObject)this, null);
        }
        if ((scope & 4) != 0) {
            monitor.subTask("Cache table constraints");
            this.uniqueKeyCache.getAllObjects(monitor, (DBSObject)this);
            if (this.getDataSource().supportsCheckConstraints()) {
                this.checkConstraintCache.getAllObjects(monitor, (DBSObject)this);
            }
        }
    }

    public boolean isStatisticsCollected() {
        return this.hasStatistics;
    }

    public void collectObjectStatistics(DBRProgressMonitor monitor, boolean totalSizeOnly, boolean forceRefresh) throws DBException {
        if (this.hasStatistics && !forceRefresh) {
            return;
        }
        try {
            Throwable throwable = null;
            Object var5_6 = null;
            try (JDBCSession session = (JDBCSession)DBUtils.openMetaSession((DBRProgressMonitor)monitor, (DBSObject)this, (String)"Load table status");){
                try {
                    Throwable throwable2 = null;
                    Object var8_12 = null;
                    try (JDBCStatement dbStat = session.createStatement();){
                        Throwable throwable3 = null;
                        Object var11_17 = null;
                        try (JDBCResultSet dbResult = dbStat.executeQuery("SHOW TABLE STATUS FROM " + DBUtils.getQuotedIdentifier((DBSObject)this));){
                            while (dbResult.next()) {
                                String tableName = dbResult.getString("Name");
                                MySQLTableBase table = (MySQLTableBase)this.tableCache.getObject(monitor, (DBSObject)this, tableName);
                                if (!(table instanceof MySQLTable)) continue;
                                ((MySQLTable)table).fetchAdditionalInfo(dbResult);
                            }
                        }
                        catch (Throwable throwable4) {
                            if (throwable3 == null) {
                                throwable3 = throwable4;
                            } else if (throwable3 != throwable4) {
                                throwable3.addSuppressed(throwable4);
                            }
                            throw throwable3;
                        }
                    }
                    catch (Throwable throwable5) {
                        if (throwable2 == null) {
                            throwable2 = throwable5;
                        } else if (throwable2 != throwable5) {
                            throwable2.addSuppressed(throwable5);
                        }
                        throw throwable2;
                    }
                }
                catch (SQLException e) {
                    throw new DBCException((Throwable)e, (DBCExecutionContext)session.getExecutionContext());
                }
            }
            catch (Throwable throwable6) {
                if (throwable == null) {
                    throwable = throwable6;
                } else if (throwable != throwable6) {
                    throwable.addSuppressed(throwable6);
                }
                throw throwable;
            }
        }
        finally {
            this.hasStatistics = true;
        }
    }

    public boolean supportsObjectDefinitionOption(String option) {
        return "ddl.includeNestedObjects".equals(option);
    }

    public String getObjectDefinitionText(DBRProgressMonitor monitor, Map<String, Object> options) throws DBException {
        if (this.databaseDDL == null) {
            try {
                Throwable throwable = null;
                Object var4_6 = null;
                try (JDBCSession session = (JDBCSession)DBUtils.openMetaSession((DBRProgressMonitor)monitor, (DBSObject)this, (String)"Load database DDL");){
                    Throwable throwable2 = null;
                    Object var7_11 = null;
                    try (JDBCStatement dbStat = session.createStatement();){
                        Throwable throwable3 = null;
                        Object var10_16 = null;
                        try (JDBCResultSet dbResult = dbStat.executeQuery("SHOW CREATE DATABASE " + DBUtils.getQuotedIdentifier((DBSObject)this));){
                            this.databaseDDL = dbResult.nextRow() ? JDBCUtils.safeGetString((ResultSet)dbResult, (String)"Create Database") : "-- Database definition is not available";
                        }
                        catch (Throwable throwable4) {
                            if (throwable3 == null) {
                                throwable3 = throwable4;
                            } else if (throwable3 != throwable4) {
                                throwable3.addSuppressed(throwable4);
                            }
                            throw throwable3;
                        }
                    }
                    catch (Throwable throwable5) {
                        if (throwable2 == null) {
                            throwable2 = throwable5;
                        } else if (throwable2 != throwable5) {
                            throwable2.addSuppressed(throwable5);
                        }
                        throw throwable2;
                    }
                }
                catch (Throwable throwable6) {
                    if (throwable == null) {
                        throwable = throwable6;
                    } else if (throwable != throwable6) {
                        throwable.addSuppressed(throwable6);
                    }
                    throw throwable;
                }
            }
            catch (SQLException e) {
                throw new DBException("Error reading database DDL", (Throwable)e);
            }
        }
        CommonUtils.getOption(options, (String)"ddl.includeNestedObjects");
        return this.databaseDDL;
    }

    public synchronized DBSObject refreshObject(@NotNull DBRProgressMonitor monitor) throws DBException {
        this.hasStatistics = false;
        this.databaseDDL = null;
        this.tableCache.clearCache();
        this.indexCache.clearCache();
        this.uniqueKeyCache.clearCache();
        if (this.getDataSource().supportsCheckConstraints()) {
            this.checkConstraintCache.clearCache();
        }
        this.proceduresCache.clearCache();
        this.triggerCache.clearCache();
        this.eventCache.clearCache();
        this.sequenceCache.clearCache();
        return this;
    }

    public boolean isSystem() {
        return "information_schema".equalsIgnoreCase(this.getName()) || "performance_schema".equalsIgnoreCase(this.getName()) || "mysql".equalsIgnoreCase(this.getName());
    }

    public String toString() {
        return String.valueOf(this.name) + " [" + this.dataSource.getContainer().getName() + "]";
    }

    public static class AdditionalInfo {
        private volatile boolean loaded = false;
        private MySQLCharset defaultCharset;
        private MySQLCollation defaultCollation;
        private String sqlPath;

        @Property(viewable=true, editable=true, updatable=true, listProvider=CharsetListProvider.class, order=2)
        public MySQLCharset getDefaultCharset() {
            return this.defaultCharset;
        }

        public void setDefaultCharset(MySQLCharset defaultCharset) {
            this.defaultCharset = defaultCharset;
        }

        @Property(viewable=true, editable=true, updatable=true, listProvider=CollationListProvider.class, order=3)
        public MySQLCollation getDefaultCollation() {
            return this.defaultCollation;
        }

        public void setDefaultCollation(MySQLCollation defaultCollation) {
            this.defaultCollation = defaultCollation;
        }

        @Property(viewable=true, order=4)
        public String getSqlPath() {
            return this.sqlPath;
        }

        void setSqlPath(String sqlPath) {
            this.sqlPath = sqlPath;
        }
    }

    public static class AdditionalInfoValidator
    implements IPropertyCacheValidator<MySQLCatalog> {
        public boolean isPropertyCached(MySQLCatalog object, Object propertyId) {
            return object.additionalInfo.loaded;
        }
    }

    public static class CharsetListProvider
    implements IPropertyValueListProvider<MySQLCatalog> {
        public boolean allowCustomValue() {
            return false;
        }

        public Object[] getPossibleValues(MySQLCatalog object) {
            return object.getDataSource().getCharsets().toArray();
        }
    }

    static class CheckConstraintCache
    extends JDBCCompositeCache<MySQLCatalog, MySQLTable, MySQLTableConstraint, MySQLTableConstraintColumn> {
        CheckConstraintCache(TableCache tableCache) {
            super((JDBCStructCache)tableCache, MySQLTable.class, (Object)"TABLE_NAME", (Object)"CONSTRAINT_NAME");
        }

        protected JDBCStatement prepareObjectsStatement(JDBCSession session, MySQLCatalog owner, MySQLTable forTable) throws SQLException {
            StringBuilder sql = new StringBuilder(500);
            sql.append("SELECT cc.CONSTRAINT_NAME, cc.CHECK_CLAUSE, tc.TABLE_NAME\nFROM INFORMATION_SCHEMA.CHECK_CONSTRAINTS cc, INFORMATION_SCHEMA.TABLE_CONSTRAINTS tc\nWHERE cc.CONSTRAINT_NAME = tc.CONSTRAINT_NAME\nAND cc.CONSTRAINT_SCHEMA =?");
            if (forTable != null) {
                sql.append(" AND tc.TABLE_NAME=?");
            }
            sql.append("\nORDER BY cc.CONSTRAINT_NAME");
            JDBCPreparedStatement dbStat = session.prepareStatement(sql.toString());
            dbStat.setString(1, owner.getName());
            if (forTable != null) {
                dbStat.setString(2, forTable.getName());
            }
            return dbStat;
        }

        protected MySQLTableConstraint fetchObject(JDBCSession session, MySQLCatalog owner, MySQLTable parent, String checkConstraintName, JDBCResultSet resultSet) throws SQLException, DBException {
            return new MySQLTableConstraint(parent, checkConstraintName, null, DBSEntityConstraintType.CHECK, true, resultSet);
        }

        protected MySQLTableConstraintColumn[] fetchObjectRow(JDBCSession session, MySQLTable mySQLTable, MySQLTableConstraint forObject, JDBCResultSet resultSet) throws SQLException, DBException {
            return new MySQLTableConstraintColumn[0];
        }

        protected void cacheChildren(DBRProgressMonitor monitor, MySQLTableConstraint object, List<MySQLTableConstraintColumn> children) {
        }
    }

    public static class CollationListProvider
    implements IPropertyValueListProvider<MySQLCatalog> {
        public boolean allowCustomValue() {
            return false;
        }

        public Object[] getPossibleValues(MySQLCatalog object) {
            if (object.additionalInfo.defaultCharset == null) {
                return null;
            }
            return object.additionalInfo.defaultCharset.getCollations().toArray();
        }
    }

    static class EventCache
    extends JDBCObjectCache<MySQLCatalog, MySQLEvent> {
        EventCache() {
        }

        @NotNull
        protected JDBCStatement prepareObjectsStatement(@NotNull JDBCSession session, @NotNull MySQLCatalog owner) throws SQLException {
            JDBCPreparedStatement dbStat = session.prepareStatement("SELECT * FROM information_schema.EVENTS WHERE EVENT_SCHEMA=?");
            dbStat.setString(1, DBUtils.getQuotedIdentifier((DBSObject)owner));
            return dbStat;
        }

        protected MySQLEvent fetchObject(@NotNull JDBCSession session, @NotNull MySQLCatalog owner, @NotNull JDBCResultSet dbResult) throws SQLException, DBException {
            return new MySQLEvent(owner, (ResultSet)dbResult);
        }
    }

    static class IndexCache
    extends JDBCCompositeCache<MySQLCatalog, MySQLTable, MySQLTableIndex, MySQLTableIndexColumn> {
        IndexCache(TableCache tableCache) {
            super((JDBCStructCache)tableCache, MySQLTable.class, (Object)"TABLE_NAME", (Object)"INDEX_NAME");
        }

        @NotNull
        protected JDBCStatement prepareObjectsStatement(JDBCSession session, MySQLCatalog owner, MySQLTable forTable) throws SQLException {
            StringBuilder sql = new StringBuilder();
            sql.append("SELECT * FROM ").append("information_schema.STATISTICS").append(" WHERE ").append("TABLE_SCHEMA").append("=?");
            if (forTable != null) {
                sql.append(" AND ").append("TABLE_NAME").append("=?");
            }
            sql.append(" ORDER BY ").append("INDEX_NAME").append(",").append("SEQ_IN_INDEX");
            JDBCPreparedStatement dbStat = session.prepareStatement(sql.toString());
            dbStat.setString(1, owner.getName());
            if (forTable != null) {
                dbStat.setString(2, forTable.getName());
            }
            return dbStat;
        }

        @Nullable
        protected MySQLTableIndex fetchObject(JDBCSession session, MySQLCatalog owner, MySQLTable parent, String indexName, JDBCResultSet dbResult) throws SQLException, DBException {
            String indexTypeName = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"INDEX_TYPE");
            DBSIndexType indexType = MySQLConstants.INDEX_TYPE_BTREE.getId().equals(indexTypeName) ? MySQLConstants.INDEX_TYPE_BTREE : (MySQLConstants.INDEX_TYPE_FULLTEXT.getId().equals(indexTypeName) ? MySQLConstants.INDEX_TYPE_FULLTEXT : (MySQLConstants.INDEX_TYPE_HASH.getId().equals(indexTypeName) ? MySQLConstants.INDEX_TYPE_HASH : (MySQLConstants.INDEX_TYPE_RTREE.getId().equals(indexTypeName) ? MySQLConstants.INDEX_TYPE_RTREE : DBSIndexType.OTHER)));
            return new MySQLTableIndex(parent, indexName, indexType, (ResultSet)dbResult);
        }

        @Nullable
        protected MySQLTableIndexColumn[] fetchObjectRow(JDBCSession session, MySQLTable parent, MySQLTableIndex object, JDBCResultSet dbResult) throws SQLException, DBException {
            MySQLTableColumn tableColumn;
            int ordinalPosition = JDBCUtils.safeGetInt((ResultSet)dbResult, (String)"SEQ_IN_INDEX");
            String columnName = JDBCUtils.safeGetStringTrimmed((ResultSet)dbResult, (String)"COLUMN_NAME");
            String ascOrDesc = JDBCUtils.safeGetStringTrimmed((ResultSet)dbResult, (String)"COLLATION");
            boolean nullable = "YES".equals(JDBCUtils.safeGetStringTrimmed((ResultSet)dbResult, (String)"NULLABLE"));
            String subPart = JDBCUtils.safeGetStringTrimmed((ResultSet)dbResult, (String)"SUB_PART");
            MySQLTableColumn mySQLTableColumn = tableColumn = columnName == null ? null : parent.getAttribute(session.getProgressMonitor(), columnName);
            if (tableColumn == null) {
                log.debug((Object)("Column '" + columnName + "' not found in table '" + parent.getName() + "' for index '" + object.getName() + "'"));
                return null;
            }
            return new MySQLTableIndexColumn[]{new MySQLTableIndexColumn(object, tableColumn, ordinalPosition, "A".equalsIgnoreCase(ascOrDesc), nullable, subPart)};
        }

        protected void cacheChildren(DBRProgressMonitor monitor, MySQLTableIndex index, List<MySQLTableIndexColumn> rows) {
            index.setColumns(rows);
        }
    }

    static class PackageCache
    extends JDBCObjectLookupCache<MySQLCatalog, MySQLPackage> {
        PackageCache() {
        }

        protected MySQLPackage fetchObject(@NotNull JDBCSession session, @NotNull MySQLCatalog owner, @NotNull JDBCResultSet dbResult) throws SQLException, DBException {
            return new MySQLPackage(owner, (ResultSet)dbResult);
        }

        @NotNull
        public JDBCStatement prepareLookupStatement(JDBCSession session, MySQLCatalog owner, MySQLPackage object, String objectName) throws SQLException {
            JDBCPreparedStatement dbStat = session.prepareStatement("SELECT name,comment FROM mysql.proc\nWHERE db = ? AND type = 'PACKAGE'" + (object == null && objectName == null ? "" : " \nAND name = ?"));
            dbStat.setString(1, owner.getName());
            if (object != null || objectName != null) {
                dbStat.setString(2, object != null ? object.getName() : objectName);
            }
            return dbStat;
        }
    }

    static class ProceduresCache
    extends JDBCStructLookupCache<MySQLCatalog, MySQLProcedure, MySQLProcedureParameter> {
        ProceduresCache() {
            super((Object)"PROCEDURE_NAME");
        }

        protected MySQLProcedure fetchObject(@NotNull JDBCSession session, @NotNull MySQLCatalog owner, @NotNull JDBCResultSet dbResult) throws SQLException, DBException {
            return new MySQLProcedure(owner, (ResultSet)dbResult);
        }

        protected JDBCStatement prepareChildrenStatement(@NotNull JDBCSession session, @NotNull MySQLCatalog owner, @Nullable MySQLProcedure procedure) throws SQLException {
            return session.getMetaData().getProcedureColumns(owner.getName(), null, procedure == null ? null : JDBCUtils.escapeWildCards((JDBCSession)session, (String)procedure.getName()), "%").getSourceStatement();
        }

        protected MySQLProcedureParameter fetchChild(@NotNull JDBCSession session, @NotNull MySQLCatalog owner, @NotNull MySQLProcedure parent, @NotNull JDBCResultSet dbResult) throws SQLException, DBException {
            DBSProcedureParameterKind parameterType;
            String columnName = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"COLUMN_NAME");
            int columnTypeNum = JDBCUtils.safeGetInt((ResultSet)dbResult, (String)"COLUMN_TYPE");
            int valueType = JDBCUtils.safeGetInt((ResultSet)dbResult, (String)"DATA_TYPE");
            String typeName = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"TYPE_NAME");
            int position = JDBCUtils.safeGetInt((ResultSet)dbResult, (String)"ORDINAL_POSITION");
            long columnSize = JDBCUtils.safeGetLong((ResultSet)dbResult, (String)"LENGTH");
            boolean notNull = JDBCUtils.safeGetInt((ResultSet)dbResult, (String)"NULLABLE") == 0;
            int scale = JDBCUtils.safeGetInt((ResultSet)dbResult, (String)"SCALE");
            int precision = JDBCUtils.safeGetInt((ResultSet)dbResult, (String)"PRECISION");
            switch (columnTypeNum) {
                case 1: {
                    parameterType = DBSProcedureParameterKind.IN;
                    break;
                }
                case 2: {
                    parameterType = DBSProcedureParameterKind.INOUT;
                    break;
                }
                case 4: {
                    parameterType = DBSProcedureParameterKind.OUT;
                    break;
                }
                case 5: {
                    parameterType = DBSProcedureParameterKind.RETURN;
                    break;
                }
                case 3: {
                    parameterType = DBSProcedureParameterKind.RESULTSET;
                    break;
                }
                default: {
                    parameterType = DBSProcedureParameterKind.UNKNOWN;
                }
            }
            if (CommonUtils.isEmpty((String)columnName) && parameterType == DBSProcedureParameterKind.RETURN) {
                columnName = "RETURN";
            }
            return new MySQLProcedureParameter(parent, columnName, typeName, valueType, position, columnSize, scale, precision, notNull, parameterType);
        }

        @NotNull
        public JDBCStatement prepareLookupStatement(@NotNull JDBCSession session, @NotNull MySQLCatalog owner, @Nullable MySQLProcedure object, @Nullable String objectName) throws SQLException {
            JDBCPreparedStatement dbStat = session.prepareStatement("SELECT * FROM information_schema.ROUTINES\nWHERE ROUTINE_SCHEMA=?" + (object == null && objectName == null ? "" : " AND ROUTINE_NAME=?") + "\nAND ROUTINE_TYPE IN ('PROCEDURE','FUNCTION')" + "\nORDER BY " + "ROUTINE_NAME");
            dbStat.setString(1, owner.getName());
            if (object != null || objectName != null) {
                dbStat.setString(2, object != null ? object.getName() : objectName);
            }
            return dbStat;
        }
    }

    static class SequenceCache
    extends JDBCObjectCache<MySQLCatalog, MySQLSequence> {
        SequenceCache() {
        }

        @NotNull
        protected JDBCStatement prepareObjectsStatement(@NotNull JDBCSession session, @NotNull MySQLCatalog mySQLCatalog) throws SQLException {
            JDBCPreparedStatement dbStat = session.prepareStatement("SELECT TABLE_NAME FROM information_schema.TABLES WHERE TABLE_SCHEMA=? AND TABLE_TYPE = 'SEQUENCE'");
            dbStat.setString(1, DBUtils.getQuotedIdentifier((DBSObject)mySQLCatalog));
            return dbStat;
        }

        @Nullable
        protected MySQLSequence fetchObject(@NotNull JDBCSession session, @NotNull MySQLCatalog mySQLCatalog, @NotNull JDBCResultSet resultSet) throws SQLException, DBException {
            String sequenceName = JDBCUtils.safeGetString((ResultSet)resultSet, (String)"TABLE_NAME");
            return new MySQLSequence(mySQLCatalog, sequenceName);
        }
    }

    public static class TableCache
    extends JDBCStructLookupCache<MySQLCatalog, MySQLTableBase, MySQLTableColumn> {
        TableCache() {
            super((Object)"TABLE_NAME");
        }

        @NotNull
        public JDBCStatement prepareLookupStatement(@NotNull JDBCSession session, @NotNull MySQLCatalog owner, @Nullable MySQLTableBase object, @Nullable String objectName) throws SQLException {
            StringBuilder sql = new StringBuilder("SHOW ");
            MySQLDataSource dataSource = owner.getDataSource();
            if (session.getMetaData().getDatabaseMajorVersion() > 4) {
                sql.append("FULL ");
            }
            sql.append("TABLES FROM ").append(DBUtils.getQuotedIdentifier((DBSObject)owner));
            if (!session.getDataSource().getContainer().getPreferenceStore().getBoolean("database.meta.server.side.filters")) {
                if (object != null || objectName != null) {
                    sql.append(" LIKE ").append(SQLUtils.quoteString((DBPDataSource)session.getDataSource(), (String)(object != null ? object.getName() : objectName)));
                }
            } else {
                String tableNameCol = DBUtils.getQuotedIdentifier((DBPDataSource)dataSource, (String)("Tables_in_" + owner.getName()));
                if (object != null || objectName != null) {
                    sql.append(" WHERE ").append(tableNameCol).append(" LIKE ").append(SQLUtils.quoteString((DBPDataSource)session.getDataSource(), (String)(object != null ? object.getName() : objectName)));
                    if (dataSource.supportsSequences()) {
                        sql.append(" AND Table_type <> 'SEQUENCE'");
                    }
                } else {
                    DBSObjectFilter tableFilters = dataSource.getContainer().getObjectFilter(MySQLTable.class, (DBSObject)owner, true);
                    if (tableFilters != null && !tableFilters.isNotApplicable()) {
                        boolean hasCond;
                        sql.append(" WHERE ");
                        if (!CommonUtils.isEmpty((Collection)tableFilters.getInclude())) {
                            sql.append("(");
                            hasCond = false;
                            for (String incName : tableFilters.getInclude()) {
                                if (hasCond) {
                                    sql.append(" OR ");
                                }
                                hasCond = true;
                                sql.append(tableNameCol).append(" LIKE ").append(SQLUtils.quoteString((DBPDataSource)session.getDataSource(), (String)SQLUtils.makeSQLLike((String)incName)));
                            }
                            sql.append(")");
                        }
                        if (!CommonUtils.isEmpty((Collection)tableFilters.getExclude())) {
                            if (!CommonUtils.isEmpty((Collection)tableFilters.getInclude())) {
                                sql.append(" AND ");
                            }
                            sql.append("(");
                            hasCond = false;
                            for (String incName : tableFilters.getExclude()) {
                                if (hasCond) {
                                    sql.append(" OR ");
                                }
                                hasCond = true;
                                sql.append(tableNameCol).append(" NOT LIKE ").append(SQLUtils.quoteString((DBPDataSource)session.getDataSource(), (String)incName));
                            }
                            sql.append(")");
                        }
                    } else if (dataSource.supportsSequences()) {
                        sql.append(" WHERE Table_type <> 'SEQUENCE'");
                    }
                }
            }
            return session.prepareStatement(sql.toString());
        }

        protected MySQLTableBase fetchObject(@NotNull JDBCSession session, @NotNull MySQLCatalog owner, @NotNull JDBCResultSet dbResult) throws SQLException, DBException {
            String tableType = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"TABLE_TYPE");
            if (tableType != null && tableType.contains("VIEW")) {
                return new MySQLView(owner, (ResultSet)dbResult);
            }
            return new MySQLTable(owner, (ResultSet)dbResult);
        }

        protected JDBCStatement prepareChildrenStatement(@NotNull JDBCSession session, @NotNull MySQLCatalog owner, @Nullable MySQLTableBase forTable) throws SQLException {
            StringBuilder sql = new StringBuilder();
            sql.append("SELECT * FROM ").append("information_schema.COLUMNS").append(" WHERE ").append("TABLE_SCHEMA").append("=?");
            if (forTable != null) {
                sql.append(" AND ").append("TABLE_NAME").append("=?");
            }
            sql.append(" ORDER BY ").append("ORDINAL_POSITION");
            JDBCPreparedStatement dbStat = session.prepareStatement(sql.toString());
            dbStat.setString(1, owner.getName());
            if (forTable != null) {
                dbStat.setString(2, forTable.getName());
            }
            return dbStat;
        }

        protected MySQLTableColumn fetchChild(@NotNull JDBCSession session, @NotNull MySQLCatalog owner, @NotNull MySQLTableBase table, @NotNull JDBCResultSet dbResult) throws SQLException, DBException {
            return new MySQLTableColumn(table, (ResultSet)dbResult);
        }
    }

    static class TriggerCache
    extends JDBCObjectLookupCache<MySQLCatalog, MySQLTrigger> {
        TriggerCache() {
        }

        protected MySQLTrigger fetchObject(@NotNull JDBCSession session, @NotNull MySQLCatalog owner, @NotNull JDBCResultSet dbResult) throws SQLException, DBException {
            String tableName = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"EVENT_OBJECT_TABLE");
            MySQLTable triggerTable = CommonUtils.isEmpty((String)tableName) ? null : owner.getTable(session.getProgressMonitor(), tableName);
            return new MySQLTrigger(owner, triggerTable, (ResultSet)dbResult);
        }

        @NotNull
        public JDBCStatement prepareLookupStatement(JDBCSession session, MySQLCatalog owner, MySQLTrigger object, String objectName) throws SQLException {
            JDBCPreparedStatement dbStat = session.prepareStatement("SELECT * FROM INFORMATION_SCHEMA.TRIGGERS\nWHERE TRIGGER_SCHEMA = ?" + (object == null && objectName == null ? "" : " \nAND TRIGGER_NAME = ?"));
            dbStat.setString(1, owner.getName());
            if (object != null || objectName != null) {
                dbStat.setString(2, object != null ? object.getName() : objectName);
            }
            return dbStat;
        }
    }

    static class UniqueKeyCache
    extends JDBCCompositeCache<MySQLCatalog, MySQLTable, MySQLTableConstraint, MySQLTableConstraintColumn> {
        UniqueKeyCache(TableCache tableCache) {
            super((JDBCStructCache)tableCache, MySQLTable.class, (Object)"TABLE_NAME", (Object)"CONSTRAINT_NAME");
        }

        @NotNull
        protected JDBCStatement prepareObjectsStatement(JDBCSession session, MySQLCatalog owner, MySQLTable forTable) throws SQLException {
            StringBuilder sql = new StringBuilder(500);
            sql.append("SELECT kc.CONSTRAINT_NAME,kc.TABLE_NAME,kc.COLUMN_NAME,kc.ORDINAL_POSITION\nFROM INFORMATION_SCHEMA.KEY_COLUMN_USAGE kc WHERE kc.TABLE_SCHEMA=? AND kc.REFERENCED_TABLE_NAME IS NULL");
            if (forTable != null) {
                sql.append(" AND kc.TABLE_NAME=?");
            }
            sql.append("\nORDER BY kc.CONSTRAINT_NAME,kc.ORDINAL_POSITION");
            JDBCPreparedStatement dbStat = session.prepareStatement(sql.toString());
            dbStat.setString(1, owner.getName());
            if (forTable != null) {
                dbStat.setString(2, forTable.getName());
            }
            return dbStat;
        }

        @Nullable
        protected MySQLTableConstraint fetchObject(JDBCSession session, MySQLCatalog owner, MySQLTable parent, String constraintName, JDBCResultSet dbResult) throws SQLException, DBException {
            if (constraintName.equals("PRIMARY")) {
                return new MySQLTableConstraint(parent, constraintName, null, DBSEntityConstraintType.PRIMARY_KEY, true);
            }
            return new MySQLTableConstraint(parent, constraintName, null, DBSEntityConstraintType.UNIQUE_KEY, true);
        }

        @Nullable
        protected MySQLTableConstraintColumn[] fetchObjectRow(JDBCSession session, MySQLTable parent, MySQLTableConstraint object, JDBCResultSet dbResult) throws SQLException, DBException {
            String columnName = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"COLUMN_NAME");
            MySQLTableColumn column = parent.getAttribute(session.getProgressMonitor(), columnName);
            if (column == null) {
                log.warn((Object)("Column '" + columnName + "' not found in table '" + parent.getFullyQualifiedName(DBPEvaluationContext.DDL) + "'"));
                return null;
            }
            int ordinalPosition = JDBCUtils.safeGetInt((ResultSet)dbResult, (String)"ORDINAL_POSITION");
            return new MySQLTableConstraintColumn[]{new MySQLTableConstraintColumn((AbstractTableConstraint<MySQLTable>)object, column, ordinalPosition)};
        }

        protected void cacheChildren(DBRProgressMonitor monitor, MySQLTableConstraint constraint, List<MySQLTableConstraintColumn> rows) {
            constraint.setColumns(rows);
        }
    }
}

