/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.mysql.edit;

import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.mysql.model.MySQLCatalog;
import org.jkiss.dbeaver.ext.mysql.model.MySQLTable;
import org.jkiss.dbeaver.ext.mysql.model.MySQLTableBase;
import org.jkiss.dbeaver.ext.mysql.model.MySQLTableColumn;
import org.jkiss.dbeaver.model.DBPDataKind;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.edit.DBECommandContext;
import org.jkiss.dbeaver.model.edit.DBEObjectRenamer;
import org.jkiss.dbeaver.model.edit.DBEObjectReorderer;
import org.jkiss.dbeaver.model.edit.DBEPersistAction;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.impl.edit.DBECommandAbstract;
import org.jkiss.dbeaver.model.impl.edit.SQLDatabasePersistAction;
import org.jkiss.dbeaver.model.impl.sql.edit.SQLObjectEditor;
import org.jkiss.dbeaver.model.impl.sql.edit.struct.SQLTableColumnManager;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.sql.SQLUtils;
import org.jkiss.dbeaver.model.struct.DBSDataType;
import org.jkiss.dbeaver.model.struct.DBSEntity;
import org.jkiss.dbeaver.model.struct.DBSEntityAttribute;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.DBSTypedObject;
import org.jkiss.dbeaver.model.struct.cache.DBSObjectCache;
import org.jkiss.utils.CommonUtils;

public class MySQLTableColumnManager
extends SQLTableColumnManager<MySQLTableColumn, MySQLTableBase>
implements DBEObjectRenamer<MySQLTableColumn>,
DBEObjectReorderer<MySQLTableColumn> {
    private final SQLTableColumnManager.ColumnModifier<MySQLTableColumn> MySQLDataTypeModifier = (monitor, column, sql, command) -> {
        sql.append(' ');
        String fullTypeName = column.getFullTypeName();
        String typeName = column.getTypeName();
        if (!fullTypeName.contains("(") && (typeName.equalsIgnoreCase("varchar") || typeName.equalsIgnoreCase("VARBINARY"))) {
            sql.append(typeName);
            String modifiers = SQLUtils.getColumnTypeModifiers((DBPDataSource)column.getDataSource(), (DBSTypedObject)column, (String)typeName, (DBPDataKind)column.getDataKind());
            if (modifiers != null) {
                sql.append(modifiers);
            }
        } else {
            sql.append(fullTypeName);
        }
    };
    private final SQLTableColumnManager.ColumnModifier<MySQLTableColumn> CharsetModifier = (monitor, column, sql, command) -> {
        if (column.getDataKind() == DBPDataKind.STRING && column.getCharset() != null) {
            sql.append(" CHARACTER SET ").append(column.getCharset().getName());
        }
    };
    private final SQLTableColumnManager.ColumnModifier<MySQLTableColumn> CollationModifier = (monitor, column, sql, command) -> {
        if (column.getDataKind() == DBPDataKind.STRING && column.getCollation() != null) {
            sql.append(" COLLATE ").append(column.getCollation().getName());
        }
    };
    private final SQLTableColumnManager.ColumnModifier<MySQLTableColumn> ExtraInfoModifier = (monitor, column, sql, command) -> {
        String extraInfo = column.getExtraInfo();
        if (!CommonUtils.isEmpty((String)extraInfo)) {
            if ("VIRTUAL GENERATED".equalsIgnoreCase(extraInfo)) {
                if (!CommonUtils.isEmpty((String)column.getGenExpression())) {
                    sql.append(" GENERATED ALWAYS AS (").append(column.getGenExpression()).append(") VIRTUAL");
                } else {
                    log.debug((Object)("No virtual column generate expression found for " + column.getName()));
                }
            } else if (!"DEFAULT_GENERATED".equals(extraInfo)) {
                sql.append(" ").append(extraInfo);
            }
        }
    };

    @Nullable
    public DBSObjectCache<? extends DBSObject, MySQLTableColumn> getObjectsCache(MySQLTableColumn object) {
        return ((MySQLCatalog)((MySQLTableBase)object.getParentObject()).getContainer()).getTableCache().getChildrenCache((MySQLTableBase)object.getParentObject());
    }

    protected SQLTableColumnManager.ColumnModifier[] getSupportedModifiers(MySQLTableColumn column, Map<String, Object> options) {
        return new SQLTableColumnManager.ColumnModifier[]{this.MySQLDataTypeModifier, this.CharsetModifier, this.CollationModifier, this.DefaultModifier, this.ExtraInfoModifier, this.NullNotNullModifier};
    }

    public StringBuilder getNestedDeclaration(DBRProgressMonitor monitor, MySQLTableBase owner, DBECommandAbstract<MySQLTableColumn> command, Map<String, Object> options) {
        StringBuilder decl = super.getNestedDeclaration(monitor, (DBSEntity)owner, command, options);
        MySQLTableColumn column = (MySQLTableColumn)command.getObject();
        if (column.isAutoGenerated() && (CommonUtils.isEmpty((String)column.getExtraInfo()) || !column.getExtraInfo().toLowerCase(Locale.ENGLISH).contains("auto_increment"))) {
            decl.append(" AUTO_INCREMENT");
        }
        if (!CommonUtils.isEmpty((String)column.getComment())) {
            decl.append(" COMMENT ").append(SQLUtils.quoteString((DBSObject)column, (String)column.getComment()));
        }
        return decl;
    }

    protected MySQLTableColumn createDatabaseObject(DBRProgressMonitor monitor, DBECommandContext context, Object container, Object copyFrom, Map<String, Object> options) throws DBException {
        MySQLTableColumn column;
        MySQLTable table = (MySQLTable)container;
        if (copyFrom instanceof DBSEntityAttribute) {
            column = new MySQLTableColumn(monitor, table, (DBSEntityAttribute)copyFrom);
        } else {
            column = new MySQLTableColumn(table);
            DBSDataType columnType = MySQLTableColumnManager.findBestDataType((DBSObject)table, (String[])new String[]{"varchar"});
            column.setName(this.getNewColumnName(monitor, context, (DBSEntity)table));
            String typeName = columnType == null ? "integer" : columnType.getName().toLowerCase();
            column.setTypeName(typeName);
            column.setMaxLength(columnType != null && columnType.getDataKind() == DBPDataKind.STRING ? 100 : 0);
            column.setValueType(columnType == null ? 4 : columnType.getTypeID());
            column.setOrdinalPosition(table.getCachedAttributes().size() + 1);
            column.setFullTypeName(DBUtils.getFullTypeName((DBSTypedObject)column));
        }
        return column;
    }

    protected void addObjectModifyActions(DBRProgressMonitor monitor, DBCExecutionContext executionContext, List<DBEPersistAction> actionList, SQLObjectEditor.ObjectChangeCommand command, Map<String, Object> options) {
        MySQLTableColumn column = (MySQLTableColumn)command.getObject();
        actionList.add((DBEPersistAction)new SQLDatabasePersistAction("Modify column", "ALTER TABLE " + ((MySQLTableBase)column.getTable()).getFullyQualifiedName(DBPEvaluationContext.DDL) + " MODIFY COLUMN " + this.getNestedDeclaration(monitor, (MySQLTableBase)column.getTable(), (DBECommandAbstract<MySQLTableColumn>)command, options)));
    }

    public void renameObject(@NotNull DBECommandContext commandContext, @NotNull MySQLTableColumn object, @NotNull Map<String, Object> options, @NotNull String newName) throws DBException {
        this.processObjectRename(commandContext, (DBSObject)object, options, newName);
    }

    protected void addObjectRenameActions(DBRProgressMonitor monitor, DBCExecutionContext executionContext, List<DBEPersistAction> actions, SQLObjectEditor.ObjectRenameCommand command, Map<String, Object> options) {
        MySQLTableColumn column = (MySQLTableColumn)command.getObject();
        actions.add((DBEPersistAction)new SQLDatabasePersistAction("Rename column", "ALTER TABLE " + ((MySQLTableBase)column.getTable()).getFullyQualifiedName(DBPEvaluationContext.DDL) + " CHANGE " + DBUtils.getQuotedIdentifier((DBPDataSource)column.getDataSource(), (String)command.getOldName()) + " " + this.getNestedDeclaration(monitor, (MySQLTableBase)column.getTable(), (DBECommandAbstract<MySQLTableColumn>)command, options)));
    }

    protected void addObjectReorderActions(DBRProgressMonitor monitor, DBCExecutionContext executionContext, List<DBEPersistAction> actions, SQLObjectEditor.ObjectReorderCommand command, Map<String, Object> options) {
        MySQLTableColumn column = (MySQLTableColumn)command.getObject();
        String order = "FIRST";
        if (column.getOrdinalPosition() > 0) {
            for (MySQLTableColumn col : ((MySQLTableBase)((MySQLTableColumn)command.getObject()).getTable()).getCachedAttributes()) {
                if (col.getOrdinalPosition() != column.getOrdinalPosition() - 1) continue;
                order = "AFTER " + DBUtils.getQuotedIdentifier((DBSObject)col);
                break;
            }
        }
        actions.add((DBEPersistAction)new SQLDatabasePersistAction("Reorder column", "ALTER TABLE " + ((MySQLTableBase)column.getTable()).getFullyQualifiedName(DBPEvaluationContext.DDL) + " CHANGE " + DBUtils.getQuotedIdentifier((DBSObject)((DBSObject)command.getObject())) + " " + this.getNestedDeclaration(monitor, (MySQLTableBase)column.getTable(), (DBECommandAbstract<MySQLTableColumn>)command, options) + " " + order));
    }

    public int getMinimumOrdinalPosition(MySQLTableColumn object) {
        return 1;
    }

    public int getMaximumOrdinalPosition(MySQLTableColumn object) {
        return ((MySQLTableBase)object.getTable()).getCachedAttributes().size();
    }

    public void setObjectOrdinalPosition(DBECommandContext commandContext, MySQLTableColumn object, List<MySQLTableColumn> siblingObjects, int newPosition) throws DBException {
        this.processObjectReorder(commandContext, (DBSObject)object, siblingObjects, newPosition);
    }
}

