/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.tools.transfer.stream;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.DBPQualifiedObject;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.data.DBDDataFilter;
import org.jkiss.dbeaver.model.data.DBDDataReceiver;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCExecutionSource;
import org.jkiss.dbeaver.model.exec.DBCSession;
import org.jkiss.dbeaver.model.exec.DBCStatistics;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSDataContainer;
import org.jkiss.dbeaver.model.struct.DBSEntity;
import org.jkiss.dbeaver.model.struct.DBSEntityAssociation;
import org.jkiss.dbeaver.model.struct.DBSEntityAttribute;
import org.jkiss.dbeaver.model.struct.DBSEntityConstraint;
import org.jkiss.dbeaver.model.struct.DBSEntityType;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.tools.transfer.stream.StreamDataImporterColumnInfo;
import org.jkiss.dbeaver.tools.transfer.stream.model.StreamDataSource;
import org.jkiss.utils.CommonUtils;

public class StreamEntityMapping
implements DBSEntity,
DBSDataContainer,
DBPQualifiedObject {
    private final File inputFile;
    private final DBPDataSource dataSource;
    private final String entityName;
    private final List<StreamDataImporterColumnInfo> streamColumns = new ArrayList<StreamDataImporterColumnInfo>();

    public StreamEntityMapping(File inputFile) {
        this.inputFile = inputFile;
        this.entityName = inputFile.getName();
        this.dataSource = new StreamDataSource(this.entityName);
    }

    StreamEntityMapping(Map<String, Object> config) throws DBCException {
        this.entityName = CommonUtils.toString((Object)config.get("entityId"));
        String inputFileName = CommonUtils.toString((Object)config.get("inputFile"));
        if (CommonUtils.isEmpty((String)inputFileName)) {
            inputFileName = this.entityName;
        }
        this.inputFile = new File(inputFileName);
        this.dataSource = new StreamDataSource(this.entityName);
    }

    public File getInputFile() {
        return this.inputFile;
    }

    public String getEntityName() {
        return this.entityName;
    }

    @NotNull
    public DBSEntityType getEntityType() {
        return DBSEntityType.TABLE;
    }

    public List<StreamDataImporterColumnInfo> getAttributes(@NotNull DBRProgressMonitor monitor) throws DBException {
        return this.streamColumns;
    }

    public DBSEntityAttribute getAttribute(@NotNull DBRProgressMonitor monitor, @NotNull String attributeName) throws DBException {
        return (DBSEntityAttribute)DBUtils.findObject(this.streamColumns, (String)attributeName);
    }

    public Collection<? extends DBSEntityConstraint> getConstraints(@NotNull DBRProgressMonitor monitor) throws DBException {
        return null;
    }

    public Collection<? extends DBSEntityAssociation> getAssociations(@NotNull DBRProgressMonitor monitor) throws DBException {
        return null;
    }

    public Collection<? extends DBSEntityAssociation> getReferences(@NotNull DBRProgressMonitor monitor) throws DBException {
        return null;
    }

    public String getDescription() {
        return null;
    }

    public DBSObject getParentObject() {
        return this.dataSource;
    }

    @NotNull
    public DBPDataSource getDataSource() {
        return this.dataSource;
    }

    public int getSupportedFeatures() {
        return 0;
    }

    @NotNull
    public DBCStatistics readData(@NotNull DBCExecutionSource source, @NotNull DBCSession session, @NotNull DBDDataReceiver dataReceiver, DBDDataFilter dataFilter, long firstRow, long maxRows, long flags, int fetchSize) throws DBCException {
        throw new DBCException("Not implemented");
    }

    public long countData(@NotNull DBCExecutionSource source, @NotNull DBCSession session, DBDDataFilter dataFilter, long flags) throws DBCException {
        return -1L;
    }

    @NotNull
    public String getName() {
        return this.entityName;
    }

    public boolean isPersisted() {
        return true;
    }

    @NotNull
    public String getFullyQualifiedName(DBPEvaluationContext context) {
        return this.getName();
    }

    public List<StreamDataImporterColumnInfo> getStreamColumns() {
        return this.streamColumns;
    }

    void setStreamColumns(List<StreamDataImporterColumnInfo> streamColumns) {
        this.streamColumns.clear();
        this.streamColumns.addAll(streamColumns);
    }

    public StreamDataImporterColumnInfo getStreamColumn(String name) {
        for (StreamDataImporterColumnInfo col : this.streamColumns) {
            if (!name.equals(col.getName())) continue;
            return col;
        }
        return null;
    }

    Map<String, Object> saveSettings() {
        LinkedHashMap<String, Object> mappings = new LinkedHashMap<String, Object>();
        mappings.put("entityId", this.entityName);
        return mappings;
    }

    public boolean isSameColumns(@NotNull StreamEntityMapping mapping) {
        if (this.streamColumns.size() != mapping.streamColumns.size()) {
            return false;
        }
        int index = 0;
        while (index < this.streamColumns.size()) {
            StreamDataImporterColumnInfo oldColumn = this.streamColumns.get(index);
            StreamDataImporterColumnInfo newColumn = mapping.streamColumns.get(index);
            if (!oldColumn.getName().equals(newColumn.getName())) {
                return false;
            }
            ++index;
        }
        return true;
    }

    public String toString() {
        return this.inputFile.getAbsolutePath();
    }

    public int hashCode() {
        return this.inputFile.hashCode();
    }

    public boolean equals(Object obj) {
        return obj instanceof StreamEntityMapping && CommonUtils.equalObjects((Object)this.inputFile, (Object)((StreamEntityMapping)obj).inputFile);
    }
}

