/*$
apdtool
Copyright (c) 2020-2021 Azel

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in all
copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
SOFTWARE.
$*/

/****************************
 * トーンテーブル
 ****************************/

extern uint8_t *g_tone_table;

#define TABLEDATA_TONE_WIDTH  256
#define TABLEDATA_TONE_BITS   8
#define TABLEDATA_TONE_GETVAL8(x,y)  *(g_tone_table + ((y) & 255) * TABLEDATA_TONE_WIDTH + ((x) & 255))
#define TABLEDATA_TONE_GETVAL16(x,y) *((uint16_t *)g_tone_table + ((y) & 255) * TABLEDATA_TONE_WIDTH + ((x) & 255))


void ToneTable_free(void);
void ToneTable_init(void);
void ToneTable_setData(int bits);

