/*
 * Decompiled with CFR 0.152.
 */
package ancestris.modules.gedcom.matchers;

import ancestris.modules.gedcom.matchers.EntityMatcher;
import ancestris.modules.gedcom.matchers.NoteMatcherOptions;
import ancestris.modules.gedcom.searchdupes.NonDuplicates;
import ancestris.util.GedcomUtilities;
import genj.gedcom.AbstractNote;
import genj.gedcom.Property;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class NoteMatcher
extends EntityMatcher<AbstractNote, NoteMatcherOptions> {
    private final Map<AbstractNote, Map<String, Integer>> noteMaps;
    private final Set<String> alreadyCompared;
    private final Map<String, int[]> sizeMap = new HashMap<String, int[]>(){
        {
            this.put("A-", new int[]{1, 3});
            this.put("B-", new int[]{2, 6});
            this.put("C-", new int[]{4, 12});
            this.put("D-", new int[]{8, 24});
            this.put("E-", new int[]{16, 48});
            this.put("F-", new int[]{32, 100});
            this.put("G-", new int[]{64, 200});
            this.put("H-", new int[]{128, 400});
            this.put("I-", new int[]{256, 800});
            this.put("J-", new int[]{512, 2000});
            this.put("K-", new int[]{1000, 10000});
        }
    };

    public NoteMatcher() {
        this.options = new NoteMatcherOptions();
        this.noteMaps = new HashMap<AbstractNote, Map<String, Integer>>();
        this.alreadyCompared = new HashSet<String>();
    }

    @Override
    public int compare(AbstractNote left, AbstractNote right) {
        String key = this.getIdKey(left.getId(), right.getId());
        if (this.alreadyCompared.contains(key)) {
            return 0;
        }
        this.alreadyCompared.add(key);
        if (left.getValue().equals(right.getValue())) {
            return 100;
        }
        return GedcomUtilities.calcCosine(this.noteMaps.get(left), this.noteMaps.get(right));
    }

    @Override
    public String[] getKeys(AbstractNote entity) {
        HashSet<CallSite> keys = new HashSet<CallSite>();
        Property pRefn = entity.getProperty("REFN");
        if (pRefn != null && pRefn.getValue().equals(NonDuplicates.REFN_NAME)) {
            return (String[])keys.toArray(String[]::new);
        }
        String note = entity.getValue().replaceAll("<[^>]*>", "");
        if (note.isBlank()) {
            return (String[])keys.toArray(String[]::new);
        }
        Map<String, Integer> map = NoteMatcher.getWordsMap(note);
        Integer size = map.keySet().size();
        ArrayList<String> sizeClasses = new ArrayList<String>();
        boolean found = false;
        for (String sizeKey : this.sizeMap.keySet()) {
            if (size < this.sizeMap.get(sizeKey)[0] || size > this.sizeMap.get(sizeKey)[1]) continue;
            sizeClasses.add(sizeKey);
            found = true;
        }
        if (!found) {
            sizeClasses.add("Z-");
        }
        for (String word : NoteMatcher.getKeyWords(map, 15)) {
            for (String sizeClass : sizeClasses) {
                keys.add((CallSite)((Object)(sizeClass + word)));
            }
        }
        this.noteMaps.put(entity, map);
        return (String[])keys.toArray(String[]::new);
    }

    @Override
    public String getHexaKey(AbstractNote entity) {
        return "";
    }

    @Override
    public void reset() {
        this.alreadyCompared.clear();
    }
}

