/*
 * Decompiled with CFR 0.152.
 */
package genj.renderer;

import ancestris.util.swing.FileChooserBuilder;
import genj.gedcom.Entity;
import genj.gedcom.Gedcom;
import genj.gedcom.GedcomOptions;
import genj.gedcom.Media;
import genj.gedcom.Property;
import genj.gedcom.PropertyBlob;
import genj.gedcom.PropertyFile;
import genj.gedcom.PropertyXRef;
import genj.io.InputSource;
import genj.io.input.FileInput;
import genj.io.input.URLInput;
import genj.renderer.MediaUtils;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.channels.FileChannel;
import java.nio.channels.WritableByteChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import javax.imageio.ImageReadParam;
import javax.imageio.ImageReader;
import javax.imageio.stream.ImageInputStream;
import org.apache.commons.io.FileUtils;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.rendering.ImageType;
import org.apache.pdfbox.rendering.PDFRenderer;
import org.openide.util.Exceptions;

public class MediaRenderer {
    private static final Logger LOG = Logger.getLogger("ancestris.mediarenderer");
    private static final Map<String, CacheEntry> CACHE = new WeakHashMap<String, CacheEntry>();
    private static final Map<String, BufferedImage> CACHE_IMAGE = new WeakHashMap<String, BufferedImage>(1);

    public static Dimension getSize(Property root) {
        InputSource source = MediaRenderer.getSource(root);
        if (source == null) {
            return new Dimension();
        }
        return MediaRenderer.getSize(source);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Dimension getSize(InputSource source) {
        CacheEntry cached;
        block15: {
            String key = source.getLocation() + (Serializable)(source instanceof URLInput ? Boolean.valueOf(GedcomOptions.getInstance().isCheckRemote()) : "");
            cached = CACHE.get(key);
            if (cached != null) {
                return cached.size;
            }
            cached = new CacheEntry();
            cached.source = source;
            cached.size = new Dimension();
            CACHE.put(source.getLocation(), cached);
            if (Arrays.asList(FileChooserBuilder.pdfExtensions).contains(source.getExtension())) {
                BufferedImage image = MediaRenderer.getImageFromPdf(source);
                if (image != null) {
                    cached.size.setSize(image.getWidth(), image.getHeight());
                }
            } else {
                try (InputStream in = source.open();){
                    if (in == null) break block15;
                    LOG.log(Level.FINER, "Reading size from {0}", source);
                    ImageInputStream iin = ImageIO.createImageInputStream(in);
                    Iterator<ImageReader> iter = ImageIO.getImageReaders(iin);
                    if (!iter.hasNext()) break block15;
                    ImageReader reader = iter.next();
                    try {
                        reader.setInput(iin, false, false);
                        cached.size.setSize(reader.getWidth(0), reader.getHeight(0));
                    }
                    finally {
                        reader.dispose();
                    }
                }
                catch (IOException ioe) {
                    LOG.log(Level.FINER, "Can't get image dimension for " + source.getName(), ioe);
                }
            }
        }
        return cached.size;
    }

    public static InputSource getSource(Property prop) {
        Optional<InputSource> ois = MediaRenderer.getInternalSource(prop);
        if (ois.isPresent()) {
            return ois.get();
        }
        return null;
    }

    private static Optional<InputSource> getInternalSource(Property prop) {
        if (prop instanceof PropertyFile) {
            PropertyFile propertyFile = (PropertyFile)prop;
            return propertyFile.getInput();
        }
        if (prop instanceof PropertyBlob) {
            PropertyBlob propertyBlob = (PropertyBlob)prop;
            return propertyBlob.getInput();
        }
        for (int i = 0; i < prop.getNoOfProperties(); ++i) {
            PropertyFile propertyFile;
            Property filep;
            PropertyXRef propertyXRef;
            Entity e;
            Property child = prop.getProperty(i);
            if (child instanceof PropertyXRef && (e = (Entity)(propertyXRef = (PropertyXRef)child).getTargetEntity().orElse(null)) instanceof Media) {
                Media m = (Media)e;
                PropertyBlob blob = m.getBlob();
                if (blob != null) {
                    return blob.getInput();
                }
                return Optional.ofNullable(m.getFile());
            }
            if (!"OBJE".equals(child.getTag()) || !((filep = child.getProperty("FILE")) instanceof PropertyFile)) continue;
            PropertyFile file = propertyFile = (PropertyFile)filep;
            return file.getInput();
        }
        return Optional.empty();
    }

    public static void render(Graphics g, Rectangle bounds, Property root) {
        Optional<BufferedImage> oImage = MediaRenderer.getScaleImage(root, bounds.width, bounds.height);
        if (oImage.isPresent()) {
            Image image = oImage.get();
            g.drawImage(image, bounds.x, bounds.y, bounds.x + bounds.width, bounds.y + bounds.height, 0, 0, image.getWidth(null), image.getHeight(null), null);
        }
    }

    public static Optional<BufferedImage> getScaleImage(Property prop, int x, int y) {
        InputSource source = MediaRenderer.getSource(prop);
        if (source == null) {
            return Optional.empty();
        }
        return MediaRenderer.getScaleImage(source, x, y);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Optional<BufferedImage> getScaleImage(InputSource source, int x, int y) {
        BufferedImage image;
        block19: {
            Dimension render = new Dimension(x, y);
            image = null;
            if (Arrays.asList(FileChooserBuilder.pdfExtensions).contains(source.getExtension())) {
                image = MediaRenderer.getScaleImageFromPdf(source, x, y);
            } else {
                try (InputStream in = source.open();){
                    if (in == null) break block19;
                    LOG.log(Level.FINE, "Reading image from {0} for {1} and {2}", new Object[]{source, x, y});
                    try (ImageInputStream iin = ImageIO.createImageInputStream(in);){
                        Iterator<ImageReader> iter = ImageIO.getImageReaders(iin);
                        if (!iter.hasNext() || x <= 0 || y <= 0) break block19;
                        ImageReader reader = iter.next();
                        try {
                            reader.setInput(iin, false, false);
                            Dimension size = new Dimension(reader.getWidth(0), reader.getHeight(0));
                            ImageReadParam param = reader.getDefaultReadParam();
                            param.setSourceSubsampling(Math.max(1, (int)Math.floor(size.width / x)), Math.max(1, (int)Math.floor(size.height / y)), 0, 0);
                            image = reader.read(0, param);
                        }
                        finally {
                            reader.dispose();
                        }
                    }
                }
                catch (IOException ioe) {
                    LOG.log(Level.FINER, "Can't get image for " + source, ioe);
                }
            }
        }
        return Optional.ofNullable(MediaUtils.adaptResult(Optional.ofNullable(image), source.getExtension(), source instanceof URLInput));
    }

    public static Optional<BufferedImage> getImage(InputSource inputSource) {
        BufferedImage image;
        block19: {
            if (inputSource == null) {
                return Optional.empty();
            }
            if (CACHE_IMAGE.containsKey(inputSource.getLocation())) {
                return Optional.ofNullable(CACHE_IMAGE.get(inputSource.getLocation()));
            }
            image = null;
            if (Arrays.asList(FileChooserBuilder.pdfExtensions).contains(inputSource.getExtension())) {
                image = MediaRenderer.getImageFromPdf(inputSource);
            } else {
                try (InputStream in = inputSource.open();){
                    if (in == null) break block19;
                    try (ImageInputStream iin = ImageIO.createImageInputStream(in);){
                        image = ImageIO.read(iin);
                    }
                }
                catch (IOException ioe) {
                    LOG.log(Level.FINER, "Can't get image for " + inputSource, ioe);
                }
            }
        }
        CACHE_IMAGE.clear();
        if (image != null) {
            CACHE_IMAGE.put(inputSource.getLocation(), image);
        }
        return Optional.ofNullable(image);
    }

    private static BufferedImage getImageFromPdf(InputSource inputSource) {
        long startTime = System.currentTimeMillis();
        try {
            InputStream in = inputSource.open();
            if (in != null) {
                MediaRenderer.logTime(startTime, " Start PDF " + inputSource.getName());
                PDDocument document = PDDocument.load((InputStream)in);
                MediaRenderer.logTime(startTime, " PDF loaded");
                ImageIO.scanForPlugins();
                PDFRenderer pdfRenderer = new PDFRenderer(document);
                BufferedImage image = pdfRenderer.renderImageWithDPI(0, 300.0f, ImageType.RGB);
                MediaRenderer.logTime(startTime, " Rendered PDF");
                return image;
            }
        }
        catch (Throwable e) {
            LOG.log(Level.WARNING, "Can't get image for " + inputSource, e);
        }
        return null;
    }

    private static long logTime(long startTime, String msg) {
        long now = System.currentTimeMillis();
        LOG.log(Level.FINE, String.format("%.3f: %s", (double)(now - startTime) / 1000.0, msg));
        return now;
    }

    private static BufferedImage getScaleImageFromPdf(InputSource inputSource, int x, int y) {
        if (x > 0 && y > 0) {
            BufferedImage image = MediaRenderer.getImageFromPdf(inputSource);
            if (image != null) {
                Image tmp = image.getScaledInstance(x, y, 4);
                BufferedImage dimg = new BufferedImage(x, y, 2);
                Graphics2D g2d = dimg.createGraphics();
                g2d.drawImage(tmp, 0, 0, null);
                g2d.dispose();
                image = dimg;
            }
            return image;
        }
        return null;
    }

    public static String getHTMLValue(Property property, int width, int height, File parentDir) {
        InputSource is = MediaRenderer.getSource(property);
        if (is == null) {
            return "";
        }
        Object fileLink = "";
        if (is instanceof FileInput) {
            FileInput fileInput = (FileInput)is;
            try {
                File file = MediaRenderer.externalizeFile(fileInput.getFile(), parentDir);
                fileLink = "file:///" + file.getAbsolutePath().replace('\\', '/');
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        } else if (is instanceof URLInput) {
            URLInput urlinput = (URLInput)is;
            fileLink = urlinput.getURL().toString();
        }
        String imgFormat = "<img src=''{0}'' width=''{1}'' height=''{2}''>";
        Optional<BufferedImage> oImage = MediaRenderer.getImage(is);
        if (oImage.isPresent()) {
            BufferedImage image = oImage.get();
            if (width == 0 && height == 0) {
                width = image.getWidth();
                height = image.getHeight();
            } else if (width == 0) {
                width = height * image.getWidth() / image.getHeight();
            } else if (height == 0) {
                height = width * image.getHeight() / image.getWidth();
            }
        }
        return MessageFormat.format(imgFormat, fileLink, width, height);
    }

    public static String getHTMLValue(Property property, File parentDir) {
        String tmpStr = property.getImage(false).toString();
        String imageName = tmpStr.substring(tmpStr.indexOf("#") + 1) + ".png";
        String imageKey = parentDir.getAbsolutePath().replace('\\', '/') + "/" + imageName;
        File imageFile = new File(imageKey);
        if (!imageFile.exists()) {
            try {
                imageFile = MediaRenderer.externalizeFile(MediaRenderer.getFileFromResource(Gedcom.class, imageName), parentDir);
            }
            catch (Exception e) {
                try {
                    imageFile = MediaRenderer.externalizeFile(MediaRenderer.getFileFromResource(Gedcom.class, "images/Attribute.png"), parentDir);
                }
                catch (IOException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
            if (imageFile == null) {
                return "";
            }
        }
        imageKey = "file:///" + imageFile.getAbsolutePath().replace('\\', '/');
        return MessageFormat.format("<img src=''{0}''>", imageKey);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static File externalizeFile(File file, File parentDir) throws IOException {
        File dir = new File(parentDir, "images");
        if (!dir.exists() && !dir.mkdirs()) {
            throw new IOException("cannot create directory " + dir);
        }
        if (dir.exists()) {
            File copy = new File(dir, file.getName());
            FileChannel from = null;
            AbstractInterruptibleChannel to = null;
            long count = -1L;
            try {
                from = new FileInputStream(file).getChannel();
                count = from.size();
                to = new FileOutputStream(copy).getChannel();
                from.transferTo(0L, count, (WritableByteChannel)((Object)to));
            }
            catch (Throwable t) {
                LOG.log(Level.WARNING, "Copying '" + file + "' to '" + copy + "' failed (size=" + count + ")", t);
            }
            finally {
                try {
                    to.close();
                }
                catch (Throwable throwable) {}
                try {
                    from.close();
                }
                catch (Throwable throwable) {}
                return copy;
            }
        }
        return null;
    }

    public static File getFileFromResource(Class clazz, String resource) {
        File destination = null;
        try {
            File directory = new File(System.getProperty("java.io.tmpdir"), "AncestrisTmpDir");
            directory.mkdirs();
            int index = resource.lastIndexOf("/");
            String targetName = resource;
            if (index != -1) {
                targetName = resource.substring(index + 1);
            }
            URI uri = clazz.getResource(resource).toURI();
            destination = new File(directory, targetName);
            FileUtils.copyURLToFile((URL)uri.toURL(), (File)destination);
        }
        catch (IOException | URISyntaxException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        return destination;
    }

    private static class CacheEntry {
        InputSource source;
        Dimension size;

        private CacheEntry() {
        }
    }
}

