/*
 * Decompiled with CFR 0.152.
 */
package ancestris.modules.releve.editor;

import ancestris.modules.releve.model.AbstractRecord;
import ancestris.modules.releve.model.Field;
import genj.util.ChangeSupport;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.event.ChangeListener;

public abstract class Bean
extends JPanel {
    private AbstractRecord record;
    private AbstractRecord.FieldType fieldType;
    protected JComponent defaultFocus = null;
    protected ChangeSupport changeSupport = new ChangeSupport((Object)this);

    protected Bean() {
        this.setOpaque(false);
    }

    public final Bean setContext(AbstractRecord record, AbstractRecord.FieldType fieldType) {
        this.record = record;
        this.fieldType = fieldType;
        this.setFieldImpl();
        this.changeSupport.setChanged(false);
        this.resetKeyboardActions();
        KeyStroke escape = KeyStroke.getKeyStroke(27, 0);
        this.getInputMap(1).put(escape, this);
        this.getActionMap().put(this, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Bean.this.setFieldImpl();
            }
        });
        return this;
    }

    public final void refresh() {
        this.setFieldImpl();
        this.changeSupport.setChanged(false);
    }

    protected abstract void setFieldImpl();

    protected void replaceValue(Field newField) {
        this.replaceValueImpl(newField);
        this.changeSupport.setChanged(true);
    }

    protected abstract void replaceValueImpl(Field var1);

    public final void commit() {
        if (!this.hasChanged()) {
            return;
        }
        this.commitImpl();
        this.changeSupport.setChanged(false);
    }

    protected abstract void commitImpl();

    public final AbstractRecord getRecord() {
        return this.record;
    }

    public final Field getField() {
        return this.record.getField(this.fieldType);
    }

    public final AbstractRecord.FieldType getFieldType() {
        return this.fieldType;
    }

    public final String getFieldValue() {
        return this.record.getFieldValue(this.fieldType);
    }

    public final String getFieldString() {
        return this.record.getFieldString(this.fieldType);
    }

    public final void setFieldValue(String value) {
        this.record.setFieldValue(this.fieldType, value);
    }

    public boolean hasChanged() {
        return this.changeSupport.hasChanged();
    }

    public void addChangeListener(ChangeListener l) {
        this.changeSupport.addChangeListener(l);
    }

    public void removeChangeListener(ChangeListener l) {
        this.changeSupport.removeChangeListener(l);
    }

    @Override
    public boolean requestFocusInWindow() {
        if (this.defaultFocus != null) {
            return this.defaultFocus.requestFocusInWindow();
        }
        return false;
    }
}

