/*
 * Decompiled with CFR 0.152.
 */
package genj.option;

import ancestris.swing.UndoTextArea;
import ancestris.util.swing.DialogManager;
import genj.option.Multiline;
import genj.option.MultipleChoiceOption;
import genj.option.Option;
import genj.option.OptionUI;
import genj.option.OptionsWidget;
import genj.util.Registry;
import genj.util.Resources;
import genj.util.swing.FontChooser;
import genj.util.swing.GraphicsHelper;
import genj.util.swing.TextFieldWidget;
import java.awt.Color;
import java.awt.Font;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.font.TextAttribute;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.io.File;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JColorChooser;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public abstract class PropertyOption
extends Option {
    protected String property;
    protected Object instance;

    public static List<PropertyOption> introspect(Object instance) {
        return PropertyOption.introspect(instance, false);
    }

    public static List<PropertyOption> introspect(Object instance, boolean recursively) {
        return PropertyOption.introspect(instance, recursively ? new ArrayList() : null);
    }

    private static List<PropertyOption> introspect(Object instance, List<Object> trackingRecursivelyVisited) {
        if (trackingRecursivelyVisited != null) {
            trackingRecursivelyVisited.add(instance);
        }
        ArrayList<PropertyOption> result = new ArrayList<PropertyOption>();
        HashSet<String> beanattrs = new HashSet<String>();
        try {
            PropertyDescriptor[] properties;
            BeanInfo info = Introspector.getBeanInfo(instance.getClass());
            for (PropertyDescriptor property : properties = info.getPropertyDescriptors()) {
                try {
                    if (property.getReadMethod() == null || property.getWriteMethod() == null || !Impl.isSupportedArgument(property.getPropertyType())) continue;
                    property.getReadMethod().invoke(instance, (Object[])null);
                    result.add(BeanPropertyImpl.create(instance, property));
                    beanattrs.add(property.getName());
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }
        catch (IntrospectionException info) {
            // empty catch block
        }
        Field[] fields = instance.getClass().getFields();
        for (int f = 0; f < fields.length; ++f) {
            int mod;
            Field field = fields[f];
            Class<?> type = field.getType();
            if (beanattrs.contains(field.getName()) || Modifier.isFinal(mod = field.getModifiers()) || Modifier.isStatic(mod)) continue;
            try {
                field.get(instance);
            }
            catch (Throwable t) {
                continue;
            }
            if (Impl.isSupportedArgument(type)) {
                result.add(FieldImpl.create(instance, field));
                continue;
            }
            if (trackingRecursivelyVisited == null) continue;
            try {
                for (PropertyOption recursiveOption : PropertyOption.introspect(field.get(instance), trackingRecursivelyVisited)) {
                    String cat = recursiveOption.getCategory();
                    recursiveOption.setCategory(field.getName());
                    result.add(recursiveOption);
                }
                continue;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return result;
    }

    protected PropertyOption(Object instance, String property) {
        this.instance = instance;
        this.property = property;
    }

    public abstract void persist(Registry var1);

    public abstract void restore(Registry var1);

    public abstract Object getValue();

    public abstract void setValue(Object var1);

    public abstract void setName(String var1);

    public abstract void setToolTip(String var1);

    public String getProperty() {
        return this.property;
    }

    @Override
    public String getCategory() {
        Resources resources;
        String result = super.getCategory();
        if (result == null && (result = (resources = Resources.get(this.instance)).getString("options", false)) != null) {
            super.setCategory(result);
        }
        return result;
    }

    private static class FontMapper
    extends Mapper {
        private static final String FAMILY = "family=";
        private static final String STYLE = "style=";
        private static final String SIZE = "size=";

        private FontMapper() {
        }

        @Override
        protected Object toObject(Object object, Class<?> expected) {
            if (expected != Font.class || object == null || object.getClass() != String.class) {
                return super.toObject(object, expected);
            }
            String string = (String)object;
            HashMap<TextAttribute, Object> map = new HashMap<TextAttribute, Object>();
            String family = this.getAttribute(string, FAMILY);
            if (family == null) {
                family = "SansSerif";
            }
            map.put(TextAttribute.FAMILY, family);
            try {
                map.put(TextAttribute.SIZE, this.getAttribute(string, SIZE));
            }
            catch (Throwable t) {
                map.put(TextAttribute.SIZE, Float.valueOf(11.0f));
            }
            return new Font(map);
        }

        protected String getAttribute(String string, String key) {
            char c;
            int j;
            int i = string.indexOf(key);
            if (i < 0) {
                return null;
            }
            for (j = i += key.length(); j < string.length() && (Character.isLetterOrDigit(c = string.charAt(j)) || Character.isWhitespace(c)); ++j) {
            }
            return j < i ? null : string.substring(i, j);
        }
    }

    private static class Mapper {
        private Mapper() {
        }

        private static Class<?> box(Class<?> type) {
            if (type == Boolean.TYPE) {
                return Boolean.class;
            }
            if (type == Byte.TYPE) {
                return Byte.class;
            }
            if (type == Character.TYPE) {
                return Character.class;
            }
            if (type == Short.TYPE) {
                return Short.class;
            }
            if (type == Integer.TYPE) {
                return Integer.class;
            }
            if (type == Long.TYPE) {
                return Long.class;
            }
            if (type == Float.TYPE) {
                return Float.class;
            }
            if (type == Double.TYPE) {
                return Double.class;
            }
            return type;
        }

        protected String toString(Object object) {
            return object != null ? object.toString() : "";
        }

        protected Object toObject(Object object, Class<?> expected) {
            expected = Mapper.box(expected);
            if (object == null || object.getClass() == expected) {
                return object;
            }
            try {
                Pattern p;
                Matcher m;
                if (expected == Color.class && object instanceof String && (m = (p = Pattern.compile("^java.awt.Color\\[r=([0-9]+),g=([0-9]+),b=([0-9]+)\\]")).matcher((String)object)).find()) {
                    try {
                        return new Color(Integer.valueOf(m.group(1)), Integer.valueOf(m.group(2)), Integer.valueOf(m.group(3)));
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
                return expected.getConstructor(object.getClass()).newInstance(object);
            }
            catch (Throwable t) {
                throw new IllegalArgumentException("can't map " + object + " to expected");
            }
        }
    }

    private static class BeanPropertyImpl
    extends Impl {
        PropertyDescriptor descriptor;

        protected static PropertyOption create(Object instance, PropertyDescriptor descriptor) {
            BeanPropertyImpl result = new BeanPropertyImpl(instance, descriptor);
            if (descriptor.getPropertyType() == Integer.TYPE) {
                try {
                    final Method choices = instance.getClass().getMethod(descriptor.getReadMethod().getName() + "s", null);
                    if (choices.getReturnType().isArray()) {
                        return new MultipleChoiceOption(result){

                            @Override
                            public Object[] getChoicesImpl() throws Throwable {
                                return (Object[])choices.invoke(this.instance, (Object[])null);
                            }
                        };
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            return result;
        }

        private BeanPropertyImpl(Object instance, PropertyDescriptor property) {
            super(instance, property.getName(), property.getPropertyType());
            this.multiline = property.getReadMethod().getAnnotation(Multiline.class) != null;
            this.descriptor = property;
        }

        @Override
        protected Object getValueImpl() throws Throwable {
            return this.descriptor.getReadMethod().invoke(this.instance, (Object[])null);
        }

        @Override
        protected void setValueImpl(Object value) throws Throwable {
            this.descriptor.getWriteMethod().invoke(this.instance, value);
        }
    }

    private static class FieldImpl
    extends Impl {
        protected Field field;

        protected static PropertyOption create(Object instance, Field field) {
            FieldImpl result = new FieldImpl(instance, field);
            if (field.getType() == Integer.TYPE) {
                try {
                    final Field choices = instance.getClass().getField(field.getName() + "s");
                    if (choices.getType().isArray()) {
                        return new MultipleChoiceOption(result){

                            @Override
                            public Object[] getChoicesImpl() throws Throwable {
                                return (Object[])choices.get(this.instance);
                            }
                        };
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            return result;
        }

        private FieldImpl(Object instance, Field field) {
            super(instance, field.getName(), field.getType());
            this.multiline = field.getAnnotation(Multiline.class) != null;
            this.field = field;
        }

        @Override
        protected Object getValueImpl() throws Throwable {
            return this.field.get(this.instance);
        }

        @Override
        protected void setValueImpl(Object value) throws Throwable {
            this.field.set(this.instance, value);
        }
    }

    private static abstract class Impl
    extends PropertyOption {
        protected Class<?> type;
        protected boolean multiline = false;
        private String name;
        private String toolTip;
        private Mapper mapper;

        protected Impl(Object instance, String property, Class<?> type) {
            super(instance, property);
            this.type = type;
            this.mapper = type == Font.class ? new FontMapper() : new Mapper();
        }

        @Override
        public String getName() {
            if (this.name == null) {
                Resources resources = Resources.get(this.instance);
                this.name = resources.getString("option." + this.property, false);
                if (this.name == null) {
                    this.name = resources.getString(this.property, false);
                    if (this.name == null) {
                        this.name = this.property;
                    }
                }
            }
            return this.name;
        }

        @Override
        public void setName(String set) {
            this.name = set;
        }

        @Override
        public String getToolTip() {
            if (this.toolTip == null) {
                Resources resources = Resources.get(this.instance);
                this.toolTip = resources.getString("option." + this.property + ".tip", false);
                if (this.toolTip == null) {
                    this.toolTip = resources.getString(this.property + ".tip", false);
                }
            }
            return this.toolTip;
        }

        @Override
        public void setToolTip(String set) {
            this.toolTip = set;
        }

        @Override
        public void restore() {
            this.restore(Registry.get(this.instance));
        }

        @Override
        public void restore(Registry registry) {
            String value = registry.get(this.getProperty(), (String)null);
            if (value != null) {
                this.setValue(value);
            }
        }

        @Override
        public void persist() {
            this.persist(Registry.get(this.instance));
        }

        @Override
        public void persist(Registry registry) {
            Object value = this.getValue();
            if (value != null) {
                registry.put(this.getProperty(), value.toString());
            }
        }

        @Override
        public OptionUI getUI(OptionsWidget widget) {
            if (Color.class.isAssignableFrom(this.type)) {
                return new ColorUI(this);
            }
            if (Font.class.isAssignableFrom(this.type)) {
                return new FontUI(this);
            }
            if (this.type == Boolean.TYPE) {
                return new BooleanUI(this);
            }
            if (this.type == String.class && this.multiline) {
                return new MultilineUI(this);
            }
            return new SimpleUI(this);
        }

        @Override
        public final Object getValue() {
            try {
                return this.getValueImpl();
            }
            catch (Throwable t) {
                return null;
            }
        }

        protected abstract Object getValueImpl() throws Throwable;

        @Override
        public final void setValue(Object value) {
            try {
                Object old = this.getValueImpl();
                if (old == value) {
                    return;
                }
                if (old != null && value != null && old.equals(value)) {
                    return;
                }
                this.setValueImpl(this.mapper.toObject(value, this.type));
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            this.fireChangeNotification();
        }

        protected abstract void setValueImpl(Object var1) throws Throwable;

        private static boolean isSupportedArgument(Class<?> type) {
            return Font.class.isAssignableFrom(type) || Color.class.isAssignableFrom(type) || File.class.isAssignableFrom(type) || String.class.isAssignableFrom(type) || Float.TYPE.isAssignableFrom(type) || Double.TYPE.isAssignableFrom(type) || Long.TYPE.isAssignableFrom(type) || Integer.TYPE.isAssignableFrom(type) || Boolean.TYPE.isAssignableFrom(type);
        }
    }

    protected static abstract class DialogUI
    extends JButton
    implements ActionListener,
    OptionUI {
        protected PropertyOption option;

        public DialogUI(PropertyOption option) {
            this.option = option;
            this.setMargin(new Insets(2, 2, 2, 2));
            this.addActionListener(this);
        }

        @Override
        public String getTextRepresentation() {
            return null;
        }

        @Override
        public JComponent getComponentRepresentation() {
            this.setText("...");
            return this;
        }

        @Override
        public void endRepresentation() {
        }

        protected abstract JComponent getEditor(Object var1);

        protected abstract Object getValue(JComponent var1);

        @Override
        public void actionPerformed(ActionEvent e) {
            Object value = this.option.getValue();
            JComponent editor = this.getEditor(value);
            Object rc = DialogManager.create(this.option.getName(), new JScrollPane(editor)).setOptionType(2).setDialogId("property.option").show();
            if (rc == DialogManager.OK_OPTION) {
                this.option.setValue(this.getValue(editor));
                this.getComponentRepresentation();
            }
        }
    }

    protected static class MultilineUI
    extends DialogUI {
        public MultilineUI(PropertyOption option) {
            super(option);
        }

        @Override
        protected JComponent getEditor(Object value) {
            UndoTextArea text = new UndoTextArea();
            text.setRows(4);
            text.setColumns(12);
            text.setLineWrap(true);
            text.setText(value != null ? value.toString() : "");
            return text;
        }

        @Override
        protected Object getValue(JComponent editor) {
            return ((JTextArea)editor).getText();
        }
    }

    protected static class SimpleUI
    extends TextFieldWidget
    implements OptionUI {
        private PropertyOption option;

        public SimpleUI(PropertyOption option) {
            this.option = option;
            Object value = option.getValue();
            this.setText(value != null ? value.toString() : "");
            this.setSelectAllOnFocus(true);
            this.setColumns(12);
        }

        @Override
        public String getTextRepresentation() {
            return this.getText();
        }

        @Override
        public JComponent getComponentRepresentation() {
            return this;
        }

        @Override
        public void endRepresentation() {
            this.option.setValue(this.getText());
        }
    }

    protected static class BooleanUI
    extends JCheckBox
    implements OptionUI {
        private PropertyOption option;

        public BooleanUI(PropertyOption option) {
            this.option = option;
            this.setOpaque(false);
            this.setHorizontalAlignment(2);
            Boolean value = (Boolean)option.getValue();
            if (value.booleanValue()) {
                this.setSelected(true);
            }
        }

        @Override
        public String getTextRepresentation() {
            return null;
        }

        @Override
        public JComponent getComponentRepresentation() {
            return this;
        }

        @Override
        public void endRepresentation() {
            this.option.setValue(this.isSelected() ? Boolean.TRUE : Boolean.FALSE);
        }
    }

    protected static class ColorUI
    extends DialogUI {
        public ColorUI(PropertyOption option) {
            super(option);
        }

        @Override
        protected JComponent getEditor(Object value) {
            JColorChooser editor = new JColorChooser();
            if (value != null) {
                editor.setColor((Color)value);
            }
            return editor;
        }

        @Override
        public JComponent getComponentRepresentation() {
            JComponent c = super.getComponentRepresentation();
            Object value = this.option.getValue();
            if (c instanceof AbstractButton && value != null) {
                ((AbstractButton)c).setText(null);
                ((AbstractButton)c).setIcon(GraphicsHelper.getIcon(new Rectangle(8, 8), (Color)value));
            }
            return c;
        }

        @Override
        protected Object getValue(JComponent editor) {
            return ((JColorChooser)editor).getColor();
        }
    }

    protected static class FontUI
    implements OptionUI {
        private FontChooser chooser = new FontChooser();
        private PropertyOption option;

        public FontUI(PropertyOption option) {
            this.option = option;
        }

        @Override
        public String getTextRepresentation() {
            Font font = (Font)this.option.getValue();
            return font == null ? "" : font.getFamily() + "," + font.getSize();
        }

        @Override
        public JComponent getComponentRepresentation() {
            Font value = (Font)this.option.getValue();
            this.chooser.setSelectedFont(value);
            return this.chooser;
        }

        @Override
        public void endRepresentation() {
            this.option.setValue(this.chooser.getSelectedFont());
        }
    }
}

