/*
 * Decompiled with CFR 0.152.
 */
package genj.crypto;

import genj.crypto.Enigma;
import genj.util.Base64;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.DESKeySpec;

class EnigmaImpl
extends Enigma {
    private static final Logger LOG = Logger.getLogger("ancestris.crypto");
    private SecretKey key;
    private Cipher cipher;
    private static final String SALT_PADDING = "GENEALOGYJ";
    private static final String ALGORITHM = "DES";

    EnigmaImpl() {
    }

    @Override
    protected Enigma init(String password) {
        try {
            byte[] salt = (password + SALT_PADDING).getBytes("UTF-8");
            DESKeySpec keyspec = new DESKeySpec(salt);
            this.cipher = Cipher.getInstance(ALGORITHM);
            this.key = SecretKeyFactory.getInstance(ALGORITHM).generateSecret(keyspec);
        }
        catch (Throwable t) {
            LOG.log(Level.WARNING, "Couldn't initialize Enigma", t);
            return null;
        }
        return this;
    }

    @Override
    protected String encryptImpl(String value) throws IOException {
        try {
            byte[] utf8bytes = value.getBytes("UTF-8");
            this.cipher.init(1, this.key);
            byte[] desbytes = this.cipher.doFinal(utf8bytes);
            String base64 = Base64.encode(desbytes).toString();
            return base64;
        }
        catch (Throwable t) {
            throw new IOException("Encrypt failed : " + t + '/' + t.getMessage());
        }
    }

    @Override
    protected String decryptImpl(String value) throws IOException {
        try {
            byte[] desbytes = Base64.decode(value);
            this.cipher.init(2, this.key);
            byte[] utf8bytes = this.cipher.doFinal(desbytes);
            String javaString = new String(utf8bytes, "UTF-8");
            return javaString;
        }
        catch (Throwable t) {
            throw new IOException("Decrypt failed : " + t.getMessage());
        }
    }
}

