/*
 * Decompiled with CFR 0.152.
 */
package ancestris.modules.editors.gedcomconversion;

import ancestris.modules.editors.gedcomconversion.GedcomSevenConverter;
import genj.gedcom.Entity;
import genj.gedcom.Gedcom;
import genj.gedcom.GedcomException;
import genj.gedcom.Grammar;
import genj.gedcom.Media;
import genj.gedcom.MetaProperty;
import genj.gedcom.Note;
import genj.gedcom.Property;
import genj.gedcom.PropertyFile;
import genj.gedcom.PropertyMedia;
import genj.gedcom.PropertyNote;
import genj.gedcom.PropertySource;
import genj.gedcom.PropertyXRef;
import genj.gedcom.Source;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public class GedcomVersionConverter {
    private final Gedcom gedcom;
    private Exception error = null;
    Grammar fromGrammar = null;
    Grammar toGrammar = null;
    boolean isConvertible = false;
    boolean upgrade = false;
    boolean isMediaConvert = true;
    boolean isGedcom7 = false;
    private List<Property> invalidPropsInvalidTags;
    private List<Property> invalidPropsMultipleTags;
    private Map<Property, String[]> invalidPropsMissingTags;
    private final Set<String> REPLACED_TAGS_ADDR = new HashSet<String>(Arrays.asList("_EMAIL", "_FAX", "_WWW"));
    private final Set<String> REPLACED_TAGS_NAME = new HashSet<String>(Arrays.asList("_TYPE", "_FONE", "_ROMN"));
    private final Set<String> REPLACED_TAGS_FAMC = new HashSet<String>(Arrays.asList("_STAT"));
    private final Set<String> REPLACED_TAGS_PLAC = new HashSet<String>(Arrays.asList("_MAP", "_FONE", "_ROMN"));
    private final Set<String> REPLACED_TAGS_MAP = new HashSet<String>(Arrays.asList("_LATI", "_LONG"));
    private final Set<String> REPLACED_TAGS_INDI = new HashSet<String>(Arrays.asList("_FACT"));
    private final Set<String> REPLACED_TAGS_EVEN = new HashSet<String>(Arrays.asList("_RESN", "_RELI"));
    private final Set<String> MOVED_TAGS = new HashSet<String>(Arrays.asList("FORM", "TITL"));
    private final Set<String> REMOVED_TAGS = new HashSet<String>(Arrays.asList("BLOB"));
    private final Set<String> EVENTS = new HashSet<String>(Arrays.asList("ANUL", "ADOP", "BAPM", "BARM", "BASM", "BIRT", "BLES", "BURI", "CAST", "CENS", "CENS", "CHR", "CHRA", "CONF", "CREM", "DEAT", "DIV", "DIVF", "DSCR", "EDUC", "EMIG", "ENGA", "EVEN", "FCOM", "GRAD", "IDNO", "IMMI", "MARB", "MARC", "MARL", "MARR", "MARS", "NATI", "NATU", "NCHI", "NMR", "OCCU", "ORDN", "PROB", "PROP", "RELI", "RESI", "RETI", "SSN", "TITL", "WILL"));

    public GedcomVersionConverter(Gedcom gedcom, String fromGrammar, String toGrammar) {
        this.gedcom = gedcom;
        this.isConvertible = false;
        if (fromGrammar.equals("5.5") && toGrammar.equals("5.5.1")) {
            this.fromGrammar = Grammar.V55;
            this.toGrammar = Grammar.V551;
            this.upgrade = true;
            this.isConvertible = true;
        } else if (fromGrammar.equals("5.5.1") && toGrammar.equals("5.5")) {
            this.fromGrammar = Grammar.V551;
            this.toGrammar = Grammar.V55;
            this.upgrade = false;
            this.isConvertible = true;
        } else if (fromGrammar.equals("5.5.1") && toGrammar.equals("7.0.5")) {
            this.toGrammar = Grammar.v70;
            this.fromGrammar = Grammar.V551;
            this.isConvertible = true;
            this.isGedcom7 = true;
        } else if (fromGrammar.equals("7.0.5") && toGrammar.equals("5.5.1")) {
            this.toGrammar = Grammar.V551;
            this.fromGrammar = Grammar.v70;
            this.isConvertible = true;
            this.isGedcom7 = true;
        }
    }

    public boolean convert() {
        if (this.isConvertible) {
            this.invalidPropsInvalidTags = new LinkedList<Property>();
            this.invalidPropsMultipleTags = new LinkedList<Property>();
            this.invalidPropsMissingTags = new LinkedHashMap<Property, String[]>();
            if (this.isGedcom7) {
                GedcomSevenConverter g7conv = new GedcomSevenConverter(this.gedcom, this.fromGrammar, this.toGrammar, this.invalidPropsInvalidTags, this.invalidPropsMultipleTags, this.invalidPropsMissingTags);
                return g7conv.convert();
            }
            this.getAnomalies(false);
            if (this.upgrade) {
                this.upgradeGedcom();
            } else {
                this.downgradeGedcom();
            }
            this.getAnomalies(true);
            if (!(this.invalidPropsInvalidTags.isEmpty() && this.invalidPropsMultipleTags.isEmpty() && this.invalidPropsMissingTags.isEmpty())) {
                this.error = new Exception(NbBundle.getMessage(GedcomVersionConverter.class, (String)"ERR_VersionErrors"));
                return false;
            }
        }
        if (this.isMediaConvert) {
            this.transformMedia();
        }
        return true;
    }

    private void getAnomalies(boolean allowUndescore) {
        ArrayList<Property> listOfProperties = new ArrayList<Property>();
        List allEntities = this.gedcom.getEntities();
        for (Entity entity : allEntities) {
            if (entity.getTag().equals("HEAD")) continue;
            this.getPropertiesRecursively((Property)entity, listOfProperties);
        }
        this.invalidPropsInvalidTags.clear();
        this.invalidPropsMultipleTags.clear();
        this.invalidPropsMissingTags.clear();
        for (Property property : listOfProperties) {
            String[] missingTags;
            if (this.isInvalidTagPath(this.toGrammar, property, allowUndescore)) {
                this.invalidPropsInvalidTags.add(property);
            }
            if (this.isMultipleSingleton(this.toGrammar, property)) {
                this.invalidPropsMultipleTags.add(property);
            }
            if ((missingTags = this.getMissingKidTags(this.toGrammar, property)).length == 0) continue;
            this.invalidPropsMissingTags.put(property, missingTags);
        }
    }

    private void upgradeGedcom() {
        while (!this.invalidPropsInvalidTags.isEmpty()) {
            String parentTag;
            Property prop = (Property)((LinkedList)this.invalidPropsInvalidTags).removeFirst();
            String entityTag = prop.getEntity().getTag();
            String tag = prop.getTag();
            String newTag = tag.substring(1, tag.length());
            Property parent = prop.getParent();
            String string = parentTag = parent != null ? parent.getTag() : "";
            if (this.REPLACED_TAGS_ADDR.contains(tag) && parent.getProperty("ADDR") != null) {
                this.replaceProperty(prop, parent, newTag);
                continue;
            }
            if (this.REPLACED_TAGS_NAME.contains(tag) && parentTag.equals("NAME") && entityTag.equals("INDI")) {
                this.replaceProperty(prop, parent, newTag);
                continue;
            }
            if (this.REPLACED_TAGS_FAMC.contains(tag) && parentTag.equals("FAMC")) {
                this.replaceProperty(prop, parent, newTag);
                continue;
            }
            if (this.REPLACED_TAGS_PLAC.contains(tag) && parentTag.equals("PLAC")) {
                this.replaceProperty(prop, parent, newTag);
                continue;
            }
            if (this.REPLACED_TAGS_MAP.contains(tag) && (parentTag.equals("MAP") || parentTag.equals("_MAP"))) {
                this.replaceProperty(prop, parent, newTag);
                continue;
            }
            if (this.REPLACED_TAGS_INDI.contains(tag) && parentTag.equals("INDI")) {
                this.replaceProperty(prop, parent, newTag);
                continue;
            }
            if (this.REPLACED_TAGS_EVEN.contains(tag) && this.EVENTS.contains(parentTag)) {
                this.replaceProperty(prop, parent, newTag);
                continue;
            }
            if (this.MOVED_TAGS.contains(tag) && parentTag.equals("OBJE")) {
                if (!entityTag.equals("OBJE") && tag.equals("TITL")) continue;
                Property p = parent.getProperty("FILE");
                if (p == null) {
                    p = parent.addProperty("FILE", "");
                }
                Property newProp = p.addProperty(tag, prop.getValue());
                this.moveSubTree(prop, newProp);
                parent.delProperty(prop);
                continue;
            }
            if (!this.REMOVED_TAGS.contains(tag)) continue;
            this.replaceProperty(prop, parent, "_" + tag);
        }
        LinkedList<Property> listProp = new LinkedList<Property>();
        listProp.addAll(this.invalidPropsMissingTags.keySet());
        while (!listProp.isEmpty()) {
            String[] tags;
            Property property = (Property)listProp.removeFirst();
            for (String tag : tags = this.invalidPropsMissingTags.get(property)) {
                if (property.getProperty(tag) != null) continue;
                property.addProperty(tag, "");
            }
        }
    }

    private void downgradeGedcom() {
        while (!this.invalidPropsInvalidTags.isEmpty()) {
            String parentTag;
            Property prop = (Property)((LinkedList)this.invalidPropsInvalidTags).removeFirst();
            String entityTag = prop.getEntity().getTag();
            String tag = prop.getTag();
            String newTag = "_" + tag;
            Property parent = prop.getParent();
            String string = parentTag = parent != null ? parent.getTag() : "";
            if (this.REPLACED_TAGS_ADDR.contains(newTag) && parent.getProperty("ADDR") != null) {
                this.replaceProperty(prop, parent, newTag);
                continue;
            }
            if (this.REPLACED_TAGS_NAME.contains(newTag) && parentTag.equals("NAME") && entityTag.equals("INDI")) {
                this.replaceProperty(prop, parent, newTag);
                continue;
            }
            if (this.REPLACED_TAGS_FAMC.contains(newTag) && parentTag.equals("FAMC")) {
                this.replaceProperty(prop, parent, newTag);
                continue;
            }
            if (this.REPLACED_TAGS_PLAC.contains(newTag) && parentTag.equals("PLAC")) {
                this.replaceProperty(prop, parent, newTag);
                continue;
            }
            if (this.REPLACED_TAGS_MAP.contains(newTag) && (parentTag.equals("MAP") || parentTag.equals("_MAP"))) {
                this.replaceProperty(prop, parent, newTag);
                continue;
            }
            if (this.REPLACED_TAGS_INDI.contains(newTag) && parentTag.equals("INDI")) {
                this.replaceProperty(prop, parent, newTag);
                continue;
            }
            if (this.REPLACED_TAGS_EVEN.contains(newTag) && this.EVENTS.contains(parentTag)) {
                this.replaceProperty(prop, parent, newTag);
                continue;
            }
            if (this.MOVED_TAGS.contains(tag) && parentTag.equals("FILE")) {
                Property obje = parent.getParent();
                Property newProp = obje.addProperty(tag, prop.getValue());
                this.moveSubTree(prop, newProp);
                parent.delProperty(prop);
                continue;
            }
            if (!this.REMOVED_TAGS.contains(newTag)) continue;
            this.replaceProperty(prop, parent, tag);
        }
        LinkedList<Property> listProp = new LinkedList<Property>();
        listProp.addAll(this.invalidPropsMissingTags.keySet());
        while (!listProp.isEmpty()) {
            String[] tags;
            Property property = (Property)listProp.removeFirst();
            for (String tag : tags = this.invalidPropsMissingTags.get(property)) {
                if (property.getProperty(tag) != null) continue;
                property.addProperty(tag, "");
            }
        }
    }

    public boolean isConvertible() {
        return this.isConvertible || this.isMediaConvert;
    }

    public boolean isWithError() {
        return this.error != null;
    }

    public String[] getInvalidPropsInvalidTags() {
        if (this.invalidPropsInvalidTags == null) {
            return null;
        }
        ArrayList<String> list = new ArrayList<String>();
        for (Property prop : this.invalidPropsInvalidTags) {
            StringBuilder sb = new StringBuilder();
            sb.append(prop.getPath().toString());
            sb.append(" (");
            if (prop.getEntity() != null) {
                sb.append(prop.getEntity().getId());
            } else {
                sb.append("No entity");
            }
            sb.append(") - ");
            sb.append(prop.getDisplayValue());
            list.add(sb.toString());
        }
        if (!list.isEmpty()) {
            try {
                Collections.sort(list, null);
            }
            catch (NoSuchMethodError noSuchMethodError) {
                // empty catch block
            }
        }
        return list.toArray(new String[list.size()]);
    }

    public String[] getInvalidPropsMultipleTags() {
        if (this.invalidPropsMultipleTags == null) {
            return null;
        }
        ArrayList<String> list = new ArrayList<String>();
        for (Property prop : this.invalidPropsMultipleTags) {
            list.add(prop.getPath().toString() + " (" + prop.getEntity().getId() + ") - " + prop.getDisplayValue());
        }
        Collections.sort(list, null);
        return list.toArray(new String[list.size()]);
    }

    public String[] getInvalidPropsMissingTags() {
        if (this.invalidPropsMissingTags == null) {
            return null;
        }
        ArrayList<String> list = new ArrayList<String>();
        for (Property prop : this.invalidPropsMissingTags.keySet()) {
            String[] arr = this.invalidPropsMissingTags.get(prop);
            StringBuilder builder = new StringBuilder();
            for (int i = 0; i < arr.length; ++i) {
                String s = arr[i];
                builder.append(s);
                if (i == arr.length - 1) continue;
                builder.append(", ");
            }
            String value = prop.getDisplayValue().trim();
            if (value.isEmpty()) {
                value = NbBundle.getMessage(GedcomVersionConverter.class, (String)"VAL_EmptyValue");
            }
            list.add(prop.getPath().toString() + " (" + prop.getEntity().getId() + ") - " + value + " : " + builder.toString());
        }
        Collections.sort(list, null);
        return list.toArray(new String[list.size()]);
    }

    private boolean isInvalidTagPath(Grammar toGrammar, Property property, boolean allowUndescore) {
        if (property instanceof PropertyXRef) {
            return false;
        }
        if (allowUndescore && property.getTag().startsWith("_")) {
            return false;
        }
        return !toGrammar.isValid(property.getPath());
    }

    private boolean isMultipleSingleton(Grammar toGrammar, Property property) {
        return toGrammar.getMeta(property.getPath()).isSingleton() && property.getParent().getProperties(property.getTag()).length > 1;
    }

    private String[] getMissingKidTags(Grammar toGrammar, Property parent) {
        MetaProperty[] metas;
        ArrayList<String> listOfTags = new ArrayList<String>();
        MetaProperty meta = toGrammar.getMeta(parent.getPath());
        for (MetaProperty metaChild : metas = meta.getNestedChildren()) {
            String tag = metaChild.getTag();
            if (!metaChild.isRequired() || parent.getProperty(tag) != null) continue;
            listOfTags.add(tag);
        }
        return listOfTags.toArray(new String[listOfTags.size()]);
    }

    public void getPropertiesRecursively(Property parent, List<Property> props) {
        Property[] children;
        for (Property child : children = parent.getProperties()) {
            props.add(child);
            this.getPropertiesRecursively(child, props);
        }
    }

    private void replaceProperty(Property prop, Property parent, String newTag) {
        Property newProp = parent.addProperty(newTag, prop.getValue());
        this.moveSubTree(prop, newProp);
        parent.delProperty(prop);
        this.invalidPropsInvalidTags.remove(prop);
    }

    private void moveSubTree(Property fromProp, Property toProp) {
        LinkedList<Tab> subtree = new LinkedList<Tab>();
        LinkedList<Tab> removedTabs = new LinkedList<Tab>();
        subtree.add(new Tab(fromProp, null, toProp));
        this.storePropertiesRecursively(fromProp, subtree);
        for (Tab tabElement : subtree) {
            if (tabElement.parentIndex == null) continue;
            Property fromParent = ((Tab)subtree.get((int)tabElement.parentIndex.intValue())).toProp;
            tabElement.setToProp(fromParent.addProperty(tabElement.fromProp.getTag(), tabElement.fromProp.getValue()));
        }
        subtree.remove(0);
        while (!subtree.isEmpty()) {
            removedTabs.clear();
            for (Tab tabElement : subtree) {
                boolean isLeaf = tabElement.fromProp.getNoOfProperties() == 0;
                if (!isLeaf) continue;
                tabElement.fromProp.getParent().delProperty(tabElement.fromProp);
                this.invalidPropsInvalidTags.remove(tabElement.fromProp);
                this.invalidPropsInvalidTags.add(tabElement.toProp);
                removedTabs.add(tabElement);
            }
            subtree.removeAll(removedTabs);
        }
    }

    private void storePropertiesRecursively(Property parent, List<Tab> tree) {
        Property[] children;
        for (Property child : children = parent.getProperties()) {
            tree.add(new Tab(child, this.getParentIndexFromChild(tree, child), null));
            this.storePropertiesRecursively(child, tree);
        }
    }

    private Integer getParentIndexFromChild(List<Tab> tree, Property child) {
        for (Tab tabElement : tree) {
            if (tabElement.fromProp != child.getParent()) continue;
            return tree.indexOf(tabElement);
        }
        return null;
    }

    private void transformMedia() {
        ArrayList<Property> allProps = new ArrayList<Property>();
        List allEntities = this.gedcom.getEntities();
        for (Entity entity : allEntities) {
            if (entity.getTag().equals("HEAD")) continue;
            this.getPropertiesRecursively((Property)entity, allProps);
        }
        ArrayList<Property> listOfNotes = new ArrayList<Property>();
        ArrayList<Property> listOfMedia = new ArrayList<Property>();
        ArrayList<Property> listOfSources = new ArrayList<Property>();
        for (Property property : allProps) {
            if (property.getTag().equals("NOTE") && !(property instanceof PropertyNote) && !property.getEntity().getTag().equals("NOTE")) {
                listOfNotes.add(property);
            }
            if (property.getTag().equals("OBJE") && !(property instanceof PropertyMedia) && !property.getEntity().getTag().equals("OBJE")) {
                listOfMedia.add(property);
            }
            if (!property.getTag().equals("SOUR") || property instanceof PropertySource || property.getEntity().getTag().equals("SOUR")) continue;
            listOfSources.add(property);
        }
        HashMap<String, Note> notesMap = new HashMap<String, Note>();
        Note noteRecord = null;
        try {
            for (Property property : listOfNotes) {
                Property property2 = property.getParent();
                String itemNote = property.getValue();
                if (!itemNote.isEmpty()) {
                    noteRecord = (Note)notesMap.get(itemNote);
                    if (noteRecord == null) {
                        noteRecord = (Note)this.gedcom.createEntity("NOTE");
                        noteRecord.setValue(property.getValue());
                        notesMap.put(itemNote, noteRecord);
                    }
                    property2.addNote(noteRecord);
                }
                property2.delProperty(property);
            }
        }
        catch (GedcomException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        Media mediaRecord = null;
        try {
            for (Property property : listOfMedia) {
                Property parent = property.getParent();
                mediaRecord = (Media)this.gedcom.createEntity("OBJE");
                Property propTitle = property.getProperty("TITL");
                List fileProps = property.getProperties(PropertyFile.class);
                for (PropertyFile fileProp : fileProps) {
                    Property fromProp;
                    Property toProp = mediaRecord.addProperty("FILE", fileProp.getValue());
                    if (propTitle != null) {
                        toProp.addProperty("TITL", propTitle.getValue());
                    }
                    if ((fromProp = fileProp.getProperty("FORM")) == null) continue;
                    toProp = toProp.addProperty("FORM", fromProp.getValue());
                    if ((fromProp = fromProp.getProperty("MEDI")) == null) continue;
                    toProp.addProperty("TYPE", fromProp.getValue());
                }
                parent.addMedia(mediaRecord);
                parent.delProperty(property);
            }
        }
        catch (GedcomException gedcomException) {
            Exceptions.printStackTrace((Throwable)gedcomException);
        }
        Object var9_14 = null;
        try {
            for (Property property : listOfSources) {
                Property parent = property.getParent();
                Source source = (Source)this.gedcom.createEntity("SOUR");
                Property fromProp = property.getProperty("TEXT");
                if (fromProp != null) {
                    source.addProperty("TEXT", fromProp.getValue());
                }
                if ((fromProp = property.getProperty("NOTE")) != null) {
                    String value = fromProp.getValue();
                    if (value.startsWith("@")) {
                        Property xref = source.addProperty("NOTE", value);
                        try {
                            ((PropertyNote)xref).link();
                        }
                        catch (GedcomException e) {
                            source.delProperty(xref);
                        }
                    } else {
                        source.addProperty("NOTE", value);
                    }
                }
                Property xref = parent.addProperty("SOUR", '@' + source.getId() + '@');
                try {
                    ((PropertySource)xref).link();
                }
                catch (GedcomException e) {
                    parent.delProperty(xref);
                }
                parent.delProperty(property);
            }
        }
        catch (GedcomException gedcomException) {
            Exceptions.printStackTrace((Throwable)gedcomException);
        }
    }

    private class Tab {
        public Property fromProp;
        public Integer parentIndex;
        public Property toProp;

        private Tab(Property fromProp, Integer parentIndex, Property toProp) {
            this.fromProp = fromProp;
            this.parentIndex = parentIndex;
            this.toProp = toProp;
        }

        public void setToProp(Property prop) {
            this.toProp = prop;
        }
    }
}

