/*
 * Decompiled with CFR 0.152.
 */
package ancestris.modules.gedcom.matchers;

import ancestris.modules.gedcom.matchers.EntityMatcher;
import ancestris.modules.gedcom.matchers.IndiMatcherOptions;
import genj.gedcom.Fam;
import genj.gedcom.GedcomException;
import genj.gedcom.Indi;
import genj.gedcom.Property;
import genj.gedcom.PropertyDate;
import genj.gedcom.PropertyName;
import genj.gedcom.PropertyPlace;
import java.text.Normalizer;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import org.openide.util.Exceptions;

public class IndiMatcher
extends EntityMatcher<Indi, IndiMatcherOptions> {
    private static final Logger LOG = Logger.getLogger(IndiMatcher.class.getName());

    public IndiMatcher() {
        this.options = new IndiMatcherOptions();
    }

    @Override
    public int compare(Indi leftIndi, Indi rightIndi) {
        boolean sameLastnames;
        int score = 0;
        if (((IndiMatcherOptions)this.options).isExcludeEmptyNames() && (this.isEmptyName(leftIndi) || this.isEmptyName(rightIndi))) {
            return -1;
        }
        if (((IndiMatcherOptions)this.options).isExcludeSameFamily() && (leftIndi.getParents().contains(rightIndi) || rightIndi.getParents().contains(leftIndi))) {
            return 0;
        }
        if (leftIndi.getSex() == rightIndi.getSex()) {
            score += 5;
        }
        if (sameLastnames = this.compareLastNames(leftIndi, rightIndi)) {
            score += 5;
        }
        boolean sameFirstnames = this.compareFirstNames(leftIndi, rightIndi);
        if (((IndiMatcherOptions)this.options).isAllFirstNamesEquals() && !sameFirstnames) {
            return 0;
        }
        if (!(!((IndiMatcherOptions)this.options).isCheckAllNames() || sameLastnames && sameFirstnames)) {
            return 0;
        }
        if (sameFirstnames) {
            score += 10;
        }
        if (this.compareDates(leftIndi.getBirthDate(), rightIndi.getBirthDate()) < ((IndiMatcherOptions)this.options).getDateinterval()) {
            score += ((IndiMatcherOptions)this.options).isEmptyValueInvalid() ? 20 : 10;
        }
        if (score >= 30) {
            score += 20;
        }
        if (this.compareBirthPlace(leftIndi, rightIndi)) {
            score += 20;
        }
        if (this.compareDates(leftIndi.getDeathDate(), rightIndi.getDeathDate()) < ((IndiMatcherOptions)this.options).getDateinterval()) {
            score += ((IndiMatcherOptions)this.options).isEmptyValueInvalid() ? 20 : 10;
        }
        if (this.compareDeathPlace(leftIndi, rightIndi)) {
            score += 20;
        }
        return (score += 20 * this.compareMarriage(leftIndi, rightIndi)) > 100 ? 100 : score;
    }

    private boolean isEmptyName(Indi indi) {
        Property[] names;
        for (Property name : names = indi.getProperties("NAME")) {
            String nameStr = ((PropertyName)name).getLastName().trim();
            if (nameStr.isEmpty() || nameStr.equals("?")) {
                return true;
            }
            nameStr = ((PropertyName)name).getFirstName().trim();
            if (!nameStr.isEmpty() && !nameStr.equals("?")) continue;
            return true;
        }
        return false;
    }

    private boolean namesAreEqual(String name1, String name2) {
        return this.normalizeName(name1).equals(this.normalizeName(name2));
    }

    private String normalizeName(String str) {
        str = Normalizer.normalize(str, Normalizer.Form.NFD);
        str = str.toLowerCase().replaceAll("-", " ").replaceAll("'", " ").replaceAll("\\p{M}", "");
        return str;
    }

    private boolean compareLastNames(Indi leftIndi, Indi rightIndi) {
        if (((IndiMatcherOptions)this.options).isCheckAllNames()) {
            Property[] leftNames = leftIndi.getProperties("NAME");
            Property[] rightNames = rightIndi.getProperties("NAME");
            double count = 0.0;
            block0: for (Property leftName : leftNames) {
                for (Property rightName : rightNames) {
                    if (!this.namesAreEqual(((PropertyName)leftName).getLastName(), ((PropertyName)rightName).getLastName())) continue;
                    count += 1.0;
                    continue block0;
                }
            }
            return count > 0.0;
        }
        Property leftName = leftIndi.getProperty("NAME");
        Property rightName = rightIndi.getProperty("NAME");
        if (leftName != null && rightName != null) {
            return this.namesAreEqual(((PropertyName)leftName).getLastName(), ((PropertyName)rightName).getLastName());
        }
        return false;
    }

    private boolean compareFirstNames(Indi leftIndi, Indi rightIndi) {
        if (((IndiMatcherOptions)this.options).isCheckAllNames()) {
            Property[] leftNames = leftIndi.getProperties("NAME");
            Property[] rightNames = rightIndi.getProperties("NAME");
            if (((IndiMatcherOptions)this.options).isAllFirstNamesEquals()) {
                for (Property leftName : leftNames) {
                    double count = 0.0;
                    String[] leftFistNames = ((PropertyName)leftName).getFirstName().split(" ");
                    String[] rightFistNames = new String[]{};
                    for (Property rightName : rightNames) {
                        rightFistNames = ((PropertyName)rightName).getFirstName().split(" ");
                        for (String leftFistName : leftFistNames) {
                            for (String rightFistName : rightFistNames) {
                                if (!this.namesAreEqual(leftFistName, rightFistName)) continue;
                                count += 1.0;
                            }
                        }
                    }
                    if (count != (double)Math.max(leftFistNames.length, rightFistNames.length)) continue;
                    return true;
                }
                return false;
            }
            for (Property leftName : leftNames) {
                String[] leftFistNames = ((PropertyName)leftName).getFirstName().split(" ");
                for (Property rightName : rightNames) {
                    String[] rightFistNames = ((PropertyName)rightName).getFirstName().split(" ");
                    for (String leftFistName : leftFistNames) {
                        for (String rightFistName : rightFistNames) {
                            if (!this.namesAreEqual(leftFistName, rightFistName)) continue;
                            return true;
                        }
                    }
                }
            }
            return false;
        }
        Property leftName = leftIndi.getProperty("NAME");
        Property rightName = rightIndi.getProperty("NAME");
        if (leftName == null || rightName == null) {
            return false;
        }
        if (((IndiMatcherOptions)this.options).isAllFirstNamesEquals()) {
            double count = 0.0;
            String[] leftFistNames = ((PropertyName)leftName).getFirstName().split(" ");
            String[] rightFistNames = ((PropertyName)rightName).getFirstName().split(" ");
            for (String leftFistName : leftFistNames) {
                for (String rightFistName : rightFistNames) {
                    if (!this.namesAreEqual(leftFistName, rightFistName)) continue;
                    count += 1.0;
                }
            }
            return count == (double)Math.max(leftFistNames.length, rightFistNames.length);
        }
        String[] leftFistNames = ((PropertyName)leftName).getFirstName().split(" ");
        String[] rightFistNames = ((PropertyName)rightName).getFirstName().split(" ");
        for (String leftFistName : leftFistNames) {
            for (String rightFistName : rightFistNames) {
                if (!this.namesAreEqual(leftFistName, rightFistName)) continue;
                return true;
            }
        }
        return false;
    }

    private int compareDates(PropertyDate leftDate, PropertyDate rightDate) {
        if (leftDate != null && rightDate != null) {
            if (leftDate.isValid() && rightDate.isValid()) {
                try {
                    return Math.abs(leftDate.getStart().getJulianDay() - rightDate.getStart().getJulianDay());
                }
                catch (GedcomException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                    if (((IndiMatcherOptions)this.options).isEmptyValueInvalid()) {
                        return ((IndiMatcherOptions)this.options).getDateinterval();
                    }
                    return ((IndiMatcherOptions)this.options).getDateinterval() - 1;
                }
            }
            if (((IndiMatcherOptions)this.options).isEmptyValueInvalid()) {
                return ((IndiMatcherOptions)this.options).getDateinterval();
            }
            return ((IndiMatcherOptions)this.options).getDateinterval() - 1;
        }
        if (((IndiMatcherOptions)this.options).isEmptyValueInvalid()) {
            return ((IndiMatcherOptions)this.options).getDateinterval();
        }
        return ((IndiMatcherOptions)this.options).getDateinterval() - 1;
    }

    private boolean compareBirthPlace(Indi leftIndi, Indi rightIndi) {
        Property leftIndiBirthProperty = leftIndi.getProperty("BIRT");
        Property rightIndiBirthProperty = rightIndi.getProperty("BIRT");
        if (leftIndiBirthProperty != null && rightIndiBirthProperty != null) {
            PropertyPlace rightIndiPropertyPlace = (PropertyPlace)rightIndiBirthProperty.getProperty("PLAC");
            PropertyPlace leftIndiPropertyPlace = (PropertyPlace)leftIndiBirthProperty.getProperty("PLAC");
            if (rightIndiPropertyPlace != null && leftIndiPropertyPlace != null) {
                return rightIndiPropertyPlace.compareTo((Property)leftIndiPropertyPlace) == 0;
            }
            return false;
        }
        return false;
    }

    private boolean compareDeathPlace(Indi leftIndi, Indi rightIndi) {
        Property leftIndiDeathProperty = leftIndi.getProperty("DEAT");
        Property rightIndiDeathProperty = rightIndi.getProperty("DEAT");
        if (leftIndiDeathProperty != null && rightIndiDeathProperty != null) {
            PropertyPlace rightIndiPropertyPlace = (PropertyPlace)rightIndiDeathProperty.getProperty("PLAC");
            PropertyPlace leftIndiPropertyPlace = (PropertyPlace)leftIndiDeathProperty.getProperty("PLAC");
            if (rightIndiPropertyPlace != null && leftIndiPropertyPlace != null) {
                return rightIndiPropertyPlace.compareTo((Property)leftIndiPropertyPlace) == 0;
            }
            return false;
        }
        return false;
    }

    private int compareMarriage(Indi leftIndi, Indi rightIndi) {
        Fam[] leftFams = leftIndi.getFamiliesWhereSpouse();
        Fam[] rightFams = rightIndi.getFamiliesWhereSpouse();
        int match = 0;
        for (Fam leftFam : leftFams) {
            for (Fam rightFam : rightFams) {
                match = 0;
                boolean sameMarrDate = false;
                Indi leftSpouse = leftFam.getOtherSpouse(leftIndi);
                Indi rightSpouse = rightFam.getOtherSpouse(rightIndi);
                if (leftSpouse != null && rightSpouse != null) {
                    if (leftSpouse.equals(rightSpouse)) {
                        match += 3;
                    } else {
                        boolean sameSpouse = this.compareLastNames(leftSpouse, rightSpouse);
                        if (sameSpouse) {
                            ++match;
                        }
                        if (sameSpouse = this.compareFirstNames(leftSpouse, rightSpouse)) {
                            ++match;
                        }
                    }
                }
                PropertyDate leftDate = leftFam.getMarriageDate();
                PropertyDate rightDate = rightFam.getMarriageDate();
                if (leftDate != null && rightDate != null) {
                    boolean bl = sameMarrDate = this.compareDates(leftDate, rightDate) < ((IndiMatcherOptions)this.options).getDateinterval();
                }
                if (sameMarrDate) {
                    ++match;
                }
                if (match <= 1) continue;
                return match;
            }
        }
        return match;
    }

    @Override
    protected String[] getKeys(Indi entity) {
        ArrayList keys = new ArrayList();
        List names = entity.getProperties(PropertyName.class);
        names.forEach(name -> keys.add(name.getLastName()));
        return keys.toArray(new String[0]);
    }
}

