/*
 * Decompiled with CFR 0.152.
 */
package ancestris.reports.namehistory;

import genj.chart.Chart;
import genj.chart.IndexedSeries;
import genj.gedcom.Gedcom;
import genj.gedcom.GedcomException;
import genj.gedcom.Indi;
import genj.gedcom.PropertyDate;
import genj.gedcom.PropertyName;
import genj.gedcom.time.Calendar;
import genj.gedcom.time.PointInTime;
import genj.report.Report;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Collection;
import java.util.Map;
import java.util.TreeMap;

public class ReportNameHistory
extends Report {
    public String[] prefixPresentations = new String[]{this.translateGUI("prefixAsIs"), this.translateGUI("prefixLast"), this.translateGUI("prefixIgnore")};
    public boolean makeGroupOther = false;
    private int lifespanWithoutDEAT = 80;
    private float minUseOfName = 2.0f;

    public float getMinUseOfName() {
        return this.minUseOfName;
    }

    public void setMinUseOfName(float set) {
        this.minUseOfName = Math.max(0.0f, Math.min(set, 50.0f));
    }

    public int getLifespanWithoutDEAT() {
        return this.lifespanWithoutDEAT;
    }

    public void setLifespanWithoutDEAT(int set) {
        this.lifespanWithoutDEAT = Math.max(20, Math.min(120, set));
    }

    public Chart start(Gedcom gedcom) {
        int numOthers;
        Collection indis = gedcom.getEntities("INDI");
        int start = this.findStart(indis);
        int length = PointInTime.getNow().getYear() - start + 1;
        IndexedSeries others = new IndexedSeries("", start, length);
        TreeMap<String, IndexedSeries> name2series = new TreeMap<String, IndexedSeries>();
        for (Indi indi : indis) {
            this.analyze(gedcom, indis, indi, name2series, others);
        }
        if (name2series.isEmpty()) {
            return null;
        }
        if (this.makeGroupOther && (numOthers = PropertyName.getLastNames((Gedcom)gedcom, (boolean)false).size() - name2series.size()) > 0) {
            others.setName(this.translate("others", new Object[]{numOthers}));
            name2series.put(String.valueOf('\uffff'), others);
        }
        return new Chart(this.translate("title", new Object[]{gedcom.getName()}), null, this.translate("yaxis"), IndexedSeries.toArray(name2series.values()), (NumberFormat)new DecimalFormat("#"), true);
    }

    private int findStart(Collection indis) {
        int result = PointInTime.getNow().getYear() - 100;
        for (Indi indi : indis) {
            PointInTime start;
            PropertyDate birth = indi.getBirthDateOption();
            if (birth == null || !(start = birth.getStart()).isValid()) continue;
            try {
                result = Math.min(result, start.getPointInTime((Calendar)PointInTime.GREGORIAN).getYear());
            }
            catch (GedcomException gedcomException) {}
        }
        return result;
    }

    private void analyze(Gedcom gedcom, Collection indis, Indi indi, Map name2series, IndexedSeries others) {
        IndexedSeries series;
        int start;
        PropertyName name = (PropertyName)indi.getProperty("NAME");
        if (name == null || !name.isValid()) {
            return;
        }
        String last = name.getLastName();
        if (last.length() == 0) {
            return;
        }
        try {
            start = indi.getBirthDateOption().getStart().getPointInTime((Calendar)PointInTime.GREGORIAN).getYear();
            if (start == Integer.MAX_VALUE) {
                return;
            }
        }
        catch (Throwable t) {
            return;
        }
        int end = Integer.MAX_VALUE;
        try {
            end = indi.getDeathDateOption().getStart().getPointInTime((Calendar)PointInTime.GREGORIAN).getYear();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (end == Integer.MAX_VALUE) {
            end = start + this.lifespanWithoutDEAT;
        }
        if ((float)name.getLastNameCount() < (float)indis.size() * this.minUseOfName / 100.0f) {
            if (!this.makeGroupOther) {
                this.println(name + " excluded with " + name.getLastNameCount() + " frequency.");
                return;
            }
            series = others;
        } else {
            series = (IndexedSeries)name2series.get(last);
            if (series == null) {
                series = new IndexedSeries(last, others);
                name2series.put(last, series);
            }
        }
        while (start <= end) {
            series.inc(start);
            ++start;
        }
    }
}

