; NOTE: Assertions have been autogenerated by utils/update_test_checks.py
; RUN: opt < %s -S -early-cse -earlycse-debug-hash | FileCheck %s
; RUN: opt < %s -S -basic-aa -early-cse-memssa | FileCheck %s

; Ensure we don't simplify away additions vectors of +0.0's (same as scalars).
define <4 x float> @fV( <4 x float> %a) {
; CHECK-LABEL: @fV(
; CHECK-NEXT:    [[B:%.*]] = fadd <4 x float> [[A:%.*]], zeroinitializer
; CHECK-NEXT:    ret <4 x float> [[B]]
;
  %b = fadd  <4 x float> %a, <float 0.0,float 0.0,float 0.0,float 0.0>
  ret <4 x float> %b
}

define <4 x float> @fW( <4 x float> %a) {
; CHECK-LABEL: @fW(
; CHECK-NEXT:    ret <4 x float> [[A:%.*]]
;
  %b = fadd  <4 x float> %a, <float -0.0,float -0.0,float -0.0,float -0.0>
  ret <4 x float> %b
}

; CSE unary fnegs.
define void @fX(ptr%p, <4 x float> %a) {
; CHECK-LABEL: @fX(
; CHECK-NEXT:    [[X:%.*]] = fneg <4 x float> [[A:%.*]]
; CHECK-NEXT:    store volatile <4 x float> [[X]], ptr [[P:%.*]], align 16
; CHECK-NEXT:    store volatile <4 x float> [[X]], ptr [[P]], align 16
; CHECK-NEXT:    ret void
;
  %x = fneg <4 x float> %a
  %y = fneg <4 x float> %a
  store volatile <4 x float> %x, ptr %p
  store volatile <4 x float> %y, ptr %p
  ret void
}
