; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -mtriple=riscv64 -mattr=+v,+d,+zfh,+experimental-zvfh,+f,+d -verify-machineinstrs \
; RUN:   < %s | FileCheck %s
declare { <vscale x 1 x i64>, i64 } @llvm.riscv.vleff.nxv1i64(
  <vscale x 1 x i64>,
  <vscale x 1 x i64>*,
  i64);

define <vscale x 1 x i64> @intrinsic_vleff_v_nxv1i64_nxv1i64(<vscale x 1 x i64>* %0, i64 %1, i64* %2) nounwind {
; CHECK-LABEL: intrinsic_vleff_v_nxv1i64_nxv1i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e64, m1, ta, mu
; CHECK-NEXT:    vle64ff.v v8, (a0)
; CHECK-NEXT:    csrr a0, vl
; CHECK-NEXT:    sd a0, 0(a2)
; CHECK-NEXT:    ret
entry:
  %a = call { <vscale x 1 x i64>, i64 } @llvm.riscv.vleff.nxv1i64(
    <vscale x 1 x i64> undef,
    <vscale x 1 x i64>* %0,
    i64 %1)
  %b = extractvalue { <vscale x 1 x i64>, i64 } %a, 0
  %c = extractvalue { <vscale x 1 x i64>, i64 } %a, 1
  store i64 %c, i64* %2
  ret <vscale x 1 x i64> %b
}

declare { <vscale x 1 x i64>, i64 } @llvm.riscv.vleff.mask.nxv1i64(
  <vscale x 1 x i64>,
  <vscale x 1 x i64>*,
  <vscale x 1 x i1>,
  i64,
  i64);

define <vscale x 1 x i64> @intrinsic_vleff_mask_v_nxv1i64_nxv1i64(<vscale x 1 x i64> %0, <vscale x 1 x i64>* %1, <vscale x 1 x i1> %2, i64 %3, i64* %4) nounwind {
; CHECK-LABEL: intrinsic_vleff_mask_v_nxv1i64_nxv1i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e64, m1, ta, mu
; CHECK-NEXT:    vle64ff.v v8, (a0), v0.t
; CHECK-NEXT:    csrr a0, vl
; CHECK-NEXT:    sd a0, 0(a2)
; CHECK-NEXT:    ret
entry:
  %a = call { <vscale x 1 x i64>, i64 } @llvm.riscv.vleff.mask.nxv1i64(
    <vscale x 1 x i64> %0,
    <vscale x 1 x i64>* %1,
    <vscale x 1 x i1> %2,
    i64 %3, i64 1)
  %b = extractvalue { <vscale x 1 x i64>, i64 } %a, 0
  %c = extractvalue { <vscale x 1 x i64>, i64 } %a, 1
  store i64 %c, i64* %4

  ret <vscale x 1 x i64> %b
}

declare { <vscale x 2 x i64>, i64 } @llvm.riscv.vleff.nxv2i64(
  <vscale x 2 x i64>,
  <vscale x 2 x i64>*,
  i64);

define <vscale x 2 x i64> @intrinsic_vleff_v_nxv2i64_nxv2i64(<vscale x 2 x i64>* %0, i64 %1, i64* %2) nounwind {
; CHECK-LABEL: intrinsic_vleff_v_nxv2i64_nxv2i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e64, m2, ta, mu
; CHECK-NEXT:    vle64ff.v v8, (a0)
; CHECK-NEXT:    csrr a0, vl
; CHECK-NEXT:    sd a0, 0(a2)
; CHECK-NEXT:    ret
entry:
  %a = call { <vscale x 2 x i64>, i64 } @llvm.riscv.vleff.nxv2i64(
    <vscale x 2 x i64> undef,
    <vscale x 2 x i64>* %0,
    i64 %1)
  %b = extractvalue { <vscale x 2 x i64>, i64 } %a, 0
  %c = extractvalue { <vscale x 2 x i64>, i64 } %a, 1
  store i64 %c, i64* %2
  ret <vscale x 2 x i64> %b
}

declare { <vscale x 2 x i64>, i64 } @llvm.riscv.vleff.mask.nxv2i64(
  <vscale x 2 x i64>,
  <vscale x 2 x i64>*,
  <vscale x 2 x i1>,
  i64,
  i64);

define <vscale x 2 x i64> @intrinsic_vleff_mask_v_nxv2i64_nxv2i64(<vscale x 2 x i64> %0, <vscale x 2 x i64>* %1, <vscale x 2 x i1> %2, i64 %3, i64* %4) nounwind {
; CHECK-LABEL: intrinsic_vleff_mask_v_nxv2i64_nxv2i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e64, m2, ta, mu
; CHECK-NEXT:    vle64ff.v v8, (a0), v0.t
; CHECK-NEXT:    csrr a0, vl
; CHECK-NEXT:    sd a0, 0(a2)
; CHECK-NEXT:    ret
entry:
  %a = call { <vscale x 2 x i64>, i64 } @llvm.riscv.vleff.mask.nxv2i64(
    <vscale x 2 x i64> %0,
    <vscale x 2 x i64>* %1,
    <vscale x 2 x i1> %2,
    i64 %3, i64 1)
  %b = extractvalue { <vscale x 2 x i64>, i64 } %a, 0
  %c = extractvalue { <vscale x 2 x i64>, i64 } %a, 1
  store i64 %c, i64* %4

  ret <vscale x 2 x i64> %b
}

declare { <vscale x 4 x i64>, i64 } @llvm.riscv.vleff.nxv4i64(
  <vscale x 4 x i64>,
  <vscale x 4 x i64>*,
  i64);

define <vscale x 4 x i64> @intrinsic_vleff_v_nxv4i64_nxv4i64(<vscale x 4 x i64>* %0, i64 %1, i64* %2) nounwind {
; CHECK-LABEL: intrinsic_vleff_v_nxv4i64_nxv4i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e64, m4, ta, mu
; CHECK-NEXT:    vle64ff.v v8, (a0)
; CHECK-NEXT:    csrr a0, vl
; CHECK-NEXT:    sd a0, 0(a2)
; CHECK-NEXT:    ret
entry:
  %a = call { <vscale x 4 x i64>, i64 } @llvm.riscv.vleff.nxv4i64(
    <vscale x 4 x i64> undef,
    <vscale x 4 x i64>* %0,
    i64 %1)
  %b = extractvalue { <vscale x 4 x i64>, i64 } %a, 0
  %c = extractvalue { <vscale x 4 x i64>, i64 } %a, 1
  store i64 %c, i64* %2
  ret <vscale x 4 x i64> %b
}

declare { <vscale x 4 x i64>, i64 } @llvm.riscv.vleff.mask.nxv4i64(
  <vscale x 4 x i64>,
  <vscale x 4 x i64>*,
  <vscale x 4 x i1>,
  i64,
  i64);

define <vscale x 4 x i64> @intrinsic_vleff_mask_v_nxv4i64_nxv4i64(<vscale x 4 x i64> %0, <vscale x 4 x i64>* %1, <vscale x 4 x i1> %2, i64 %3, i64* %4) nounwind {
; CHECK-LABEL: intrinsic_vleff_mask_v_nxv4i64_nxv4i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e64, m4, ta, mu
; CHECK-NEXT:    vle64ff.v v8, (a0), v0.t
; CHECK-NEXT:    csrr a0, vl
; CHECK-NEXT:    sd a0, 0(a2)
; CHECK-NEXT:    ret
entry:
  %a = call { <vscale x 4 x i64>, i64 } @llvm.riscv.vleff.mask.nxv4i64(
    <vscale x 4 x i64> %0,
    <vscale x 4 x i64>* %1,
    <vscale x 4 x i1> %2,
    i64 %3, i64 1)
  %b = extractvalue { <vscale x 4 x i64>, i64 } %a, 0
  %c = extractvalue { <vscale x 4 x i64>, i64 } %a, 1
  store i64 %c, i64* %4

  ret <vscale x 4 x i64> %b
}

declare { <vscale x 8 x i64>, i64 } @llvm.riscv.vleff.nxv8i64(
  <vscale x 8 x i64>,
  <vscale x 8 x i64>*,
  i64);

define <vscale x 8 x i64> @intrinsic_vleff_v_nxv8i64_nxv8i64(<vscale x 8 x i64>* %0, i64 %1, i64* %2) nounwind {
; CHECK-LABEL: intrinsic_vleff_v_nxv8i64_nxv8i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e64, m8, ta, mu
; CHECK-NEXT:    vle64ff.v v8, (a0)
; CHECK-NEXT:    csrr a0, vl
; CHECK-NEXT:    sd a0, 0(a2)
; CHECK-NEXT:    ret
entry:
  %a = call { <vscale x 8 x i64>, i64 } @llvm.riscv.vleff.nxv8i64(
    <vscale x 8 x i64> undef,
    <vscale x 8 x i64>* %0,
    i64 %1)
  %b = extractvalue { <vscale x 8 x i64>, i64 } %a, 0
  %c = extractvalue { <vscale x 8 x i64>, i64 } %a, 1
  store i64 %c, i64* %2
  ret <vscale x 8 x i64> %b
}

declare { <vscale x 8 x i64>, i64 } @llvm.riscv.vleff.mask.nxv8i64(
  <vscale x 8 x i64>,
  <vscale x 8 x i64>*,
  <vscale x 8 x i1>,
  i64,
  i64);

define <vscale x 8 x i64> @intrinsic_vleff_mask_v_nxv8i64_nxv8i64(<vscale x 8 x i64> %0, <vscale x 8 x i64>* %1, <vscale x 8 x i1> %2, i64 %3, i64* %4) nounwind {
; CHECK-LABEL: intrinsic_vleff_mask_v_nxv8i64_nxv8i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e64, m8, ta, mu
; CHECK-NEXT:    vle64ff.v v8, (a0), v0.t
; CHECK-NEXT:    csrr a0, vl
; CHECK-NEXT:    sd a0, 0(a2)
; CHECK-NEXT:    ret
entry:
  %a = call { <vscale x 8 x i64>, i64 } @llvm.riscv.vleff.mask.nxv8i64(
    <vscale x 8 x i64> %0,
    <vscale x 8 x i64>* %1,
    <vscale x 8 x i1> %2,
    i64 %3, i64 1)
  %b = extractvalue { <vscale x 8 x i64>, i64 } %a, 0
  %c = extractvalue { <vscale x 8 x i64>, i64 } %a, 1
  store i64 %c, i64* %4

  ret <vscale x 8 x i64> %b
}

declare { <vscale x 1 x double>, i64 } @llvm.riscv.vleff.nxv1f64(
  <vscale x 1 x double>,
  <vscale x 1 x double>*,
  i64);

define <vscale x 1 x double> @intrinsic_vleff_v_nxv1f64_nxv1f64(<vscale x 1 x double>* %0, i64 %1, i64* %2) nounwind {
; CHECK-LABEL: intrinsic_vleff_v_nxv1f64_nxv1f64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e64, m1, ta, mu
; CHECK-NEXT:    vle64ff.v v8, (a0)
; CHECK-NEXT:    csrr a0, vl
; CHECK-NEXT:    sd a0, 0(a2)
; CHECK-NEXT:    ret
entry:
  %a = call { <vscale x 1 x double>, i64 } @llvm.riscv.vleff.nxv1f64(
    <vscale x 1 x double> undef,
    <vscale x 1 x double>* %0,
    i64 %1)
  %b = extractvalue { <vscale x 1 x double>, i64 } %a, 0
  %c = extractvalue { <vscale x 1 x double>, i64 } %a, 1
  store i64 %c, i64* %2
  ret <vscale x 1 x double> %b
}

declare { <vscale x 1 x double>, i64 } @llvm.riscv.vleff.mask.nxv1f64(
  <vscale x 1 x double>,
  <vscale x 1 x double>*,
  <vscale x 1 x i1>,
  i64,
  i64);

define <vscale x 1 x double> @intrinsic_vleff_mask_v_nxv1f64_nxv1f64(<vscale x 1 x double> %0, <vscale x 1 x double>* %1, <vscale x 1 x i1> %2, i64 %3, i64* %4) nounwind {
; CHECK-LABEL: intrinsic_vleff_mask_v_nxv1f64_nxv1f64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e64, m1, ta, mu
; CHECK-NEXT:    vle64ff.v v8, (a0), v0.t
; CHECK-NEXT:    csrr a0, vl
; CHECK-NEXT:    sd a0, 0(a2)
; CHECK-NEXT:    ret
entry:
  %a = call { <vscale x 1 x double>, i64 } @llvm.riscv.vleff.mask.nxv1f64(
    <vscale x 1 x double> %0,
    <vscale x 1 x double>* %1,
    <vscale x 1 x i1> %2,
    i64 %3, i64 1)
  %b = extractvalue { <vscale x 1 x double>, i64 } %a, 0
  %c = extractvalue { <vscale x 1 x double>, i64 } %a, 1
  store i64 %c, i64* %4

  ret <vscale x 1 x double> %b
}

declare { <vscale x 2 x double>, i64 } @llvm.riscv.vleff.nxv2f64(
  <vscale x 2 x double>,
  <vscale x 2 x double>*,
  i64);

define <vscale x 2 x double> @intrinsic_vleff_v_nxv2f64_nxv2f64(<vscale x 2 x double>* %0, i64 %1, i64* %2) nounwind {
; CHECK-LABEL: intrinsic_vleff_v_nxv2f64_nxv2f64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e64, m2, ta, mu
; CHECK-NEXT:    vle64ff.v v8, (a0)
; CHECK-NEXT:    csrr a0, vl
; CHECK-NEXT:    sd a0, 0(a2)
; CHECK-NEXT:    ret
entry:
  %a = call { <vscale x 2 x double>, i64 } @llvm.riscv.vleff.nxv2f64(
    <vscale x 2 x double> undef,
    <vscale x 2 x double>* %0,
    i64 %1)
  %b = extractvalue { <vscale x 2 x double>, i64 } %a, 0
  %c = extractvalue { <vscale x 2 x double>, i64 } %a, 1
  store i64 %c, i64* %2
  ret <vscale x 2 x double> %b
}

declare { <vscale x 2 x double>, i64 } @llvm.riscv.vleff.mask.nxv2f64(
  <vscale x 2 x double>,
  <vscale x 2 x double>*,
  <vscale x 2 x i1>,
  i64,
  i64);

define <vscale x 2 x double> @intrinsic_vleff_mask_v_nxv2f64_nxv2f64(<vscale x 2 x double> %0, <vscale x 2 x double>* %1, <vscale x 2 x i1> %2, i64 %3, i64* %4) nounwind {
; CHECK-LABEL: intrinsic_vleff_mask_v_nxv2f64_nxv2f64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e64, m2, ta, mu
; CHECK-NEXT:    vle64ff.v v8, (a0), v0.t
; CHECK-NEXT:    csrr a0, vl
; CHECK-NEXT:    sd a0, 0(a2)
; CHECK-NEXT:    ret
entry:
  %a = call { <vscale x 2 x double>, i64 } @llvm.riscv.vleff.mask.nxv2f64(
    <vscale x 2 x double> %0,
    <vscale x 2 x double>* %1,
    <vscale x 2 x i1> %2,
    i64 %3, i64 1)
  %b = extractvalue { <vscale x 2 x double>, i64 } %a, 0
  %c = extractvalue { <vscale x 2 x double>, i64 } %a, 1
  store i64 %c, i64* %4

  ret <vscale x 2 x double> %b
}

declare { <vscale x 4 x double>, i64 } @llvm.riscv.vleff.nxv4f64(
  <vscale x 4 x double>,
  <vscale x 4 x double>*,
  i64);

define <vscale x 4 x double> @intrinsic_vleff_v_nxv4f64_nxv4f64(<vscale x 4 x double>* %0, i64 %1, i64* %2) nounwind {
; CHECK-LABEL: intrinsic_vleff_v_nxv4f64_nxv4f64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e64, m4, ta, mu
; CHECK-NEXT:    vle64ff.v v8, (a0)
; CHECK-NEXT:    csrr a0, vl
; CHECK-NEXT:    sd a0, 0(a2)
; CHECK-NEXT:    ret
entry:
  %a = call { <vscale x 4 x double>, i64 } @llvm.riscv.vleff.nxv4f64(
    <vscale x 4 x double> undef,
    <vscale x 4 x double>* %0,
    i64 %1)
  %b = extractvalue { <vscale x 4 x double>, i64 } %a, 0
  %c = extractvalue { <vscale x 4 x double>, i64 } %a, 1
  store i64 %c, i64* %2
  ret <vscale x 4 x double> %b
}

declare { <vscale x 4 x double>, i64 } @llvm.riscv.vleff.mask.nxv4f64(
  <vscale x 4 x double>,
  <vscale x 4 x double>*,
  <vscale x 4 x i1>,
  i64,
  i64);

define <vscale x 4 x double> @intrinsic_vleff_mask_v_nxv4f64_nxv4f64(<vscale x 4 x double> %0, <vscale x 4 x double>* %1, <vscale x 4 x i1> %2, i64 %3, i64* %4) nounwind {
; CHECK-LABEL: intrinsic_vleff_mask_v_nxv4f64_nxv4f64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e64, m4, ta, mu
; CHECK-NEXT:    vle64ff.v v8, (a0), v0.t
; CHECK-NEXT:    csrr a0, vl
; CHECK-NEXT:    sd a0, 0(a2)
; CHECK-NEXT:    ret
entry:
  %a = call { <vscale x 4 x double>, i64 } @llvm.riscv.vleff.mask.nxv4f64(
    <vscale x 4 x double> %0,
    <vscale x 4 x double>* %1,
    <vscale x 4 x i1> %2,
    i64 %3, i64 1)
  %b = extractvalue { <vscale x 4 x double>, i64 } %a, 0
  %c = extractvalue { <vscale x 4 x double>, i64 } %a, 1
  store i64 %c, i64* %4

  ret <vscale x 4 x double> %b
}

declare { <vscale x 8 x double>, i64 } @llvm.riscv.vleff.nxv8f64(
  <vscale x 8 x double>,
  <vscale x 8 x double>*,
  i64);

define <vscale x 8 x double> @intrinsic_vleff_v_nxv8f64_nxv8f64(<vscale x 8 x double>* %0, i64 %1, i64* %2) nounwind {
; CHECK-LABEL: intrinsic_vleff_v_nxv8f64_nxv8f64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e64, m8, ta, mu
; CHECK-NEXT:    vle64ff.v v8, (a0)
; CHECK-NEXT:    csrr a0, vl
; CHECK-NEXT:    sd a0, 0(a2)
; CHECK-NEXT:    ret
entry:
  %a = call { <vscale x 8 x double>, i64 } @llvm.riscv.vleff.nxv8f64(
    <vscale x 8 x double> undef,
    <vscale x 8 x double>* %0,
    i64 %1)
  %b = extractvalue { <vscale x 8 x double>, i64 } %a, 0
  %c = extractvalue { <vscale x 8 x double>, i64 } %a, 1
  store i64 %c, i64* %2
  ret <vscale x 8 x double> %b
}

declare { <vscale x 8 x double>, i64 } @llvm.riscv.vleff.mask.nxv8f64(
  <vscale x 8 x double>,
  <vscale x 8 x double>*,
  <vscale x 8 x i1>,
  i64,
  i64);

define <vscale x 8 x double> @intrinsic_vleff_mask_v_nxv8f64_nxv8f64(<vscale x 8 x double> %0, <vscale x 8 x double>* %1, <vscale x 8 x i1> %2, i64 %3, i64* %4) nounwind {
; CHECK-LABEL: intrinsic_vleff_mask_v_nxv8f64_nxv8f64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e64, m8, ta, mu
; CHECK-NEXT:    vle64ff.v v8, (a0), v0.t
; CHECK-NEXT:    csrr a0, vl
; CHECK-NEXT:    sd a0, 0(a2)
; CHECK-NEXT:    ret
entry:
  %a = call { <vscale x 8 x double>, i64 } @llvm.riscv.vleff.mask.nxv8f64(
    <vscale x 8 x double> %0,
    <vscale x 8 x double>* %1,
    <vscale x 8 x i1> %2,
    i64 %3, i64 1)
  %b = extractvalue { <vscale x 8 x double>, i64 } %a, 0
  %c = extractvalue { <vscale x 8 x double>, i64 } %a, 1
  store i64 %c, i64* %4

  ret <vscale x 8 x double> %b
}

declare { <vscale x 1 x i32>, i64 } @llvm.riscv.vleff.nxv1i32(
  <vscale x 1 x i32>,
  <vscale x 1 x i32>*,
  i64);

define <vscale x 1 x i32> @intrinsic_vleff_v_nxv1i32_nxv1i32(<vscale x 1 x i32>* %0, i64 %1, i64* %2) nounwind {
; CHECK-LABEL: intrinsic_vleff_v_nxv1i32_nxv1i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e32, mf2, ta, mu
; CHECK-NEXT:    vle32ff.v v8, (a0)
; CHECK-NEXT:    csrr a0, vl
; CHECK-NEXT:    sd a0, 0(a2)
; CHECK-NEXT:    ret
entry:
  %a = call { <vscale x 1 x i32>, i64 } @llvm.riscv.vleff.nxv1i32(
    <vscale x 1 x i32> undef,
    <vscale x 1 x i32>* %0,
    i64 %1)
  %b = extractvalue { <vscale x 1 x i32>, i64 } %a, 0
  %c = extractvalue { <vscale x 1 x i32>, i64 } %a, 1
  store i64 %c, i64* %2
  ret <vscale x 1 x i32> %b
}

declare { <vscale x 1 x i32>, i64 } @llvm.riscv.vleff.mask.nxv1i32(
  <vscale x 1 x i32>,
  <vscale x 1 x i32>*,
  <vscale x 1 x i1>,
  i64,
  i64);

define <vscale x 1 x i32> @intrinsic_vleff_mask_v_nxv1i32_nxv1i32(<vscale x 1 x i32> %0, <vscale x 1 x i32>* %1, <vscale x 1 x i1> %2, i64 %3, i64* %4) nounwind {
; CHECK-LABEL: intrinsic_vleff_mask_v_nxv1i32_nxv1i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e32, mf2, ta, mu
; CHECK-NEXT:    vle32ff.v v8, (a0), v0.t
; CHECK-NEXT:    csrr a0, vl
; CHECK-NEXT:    sd a0, 0(a2)
; CHECK-NEXT:    ret
entry:
  %a = call { <vscale x 1 x i32>, i64 } @llvm.riscv.vleff.mask.nxv1i32(
    <vscale x 1 x i32> %0,
    <vscale x 1 x i32>* %1,
    <vscale x 1 x i1> %2,
    i64 %3, i64 1)
  %b = extractvalue { <vscale x 1 x i32>, i64 } %a, 0
  %c = extractvalue { <vscale x 1 x i32>, i64 } %a, 1
  store i64 %c, i64* %4

  ret <vscale x 1 x i32> %b
}

declare { <vscale x 2 x i32>, i64 } @llvm.riscv.vleff.nxv2i32(
  <vscale x 2 x i32>,
  <vscale x 2 x i32>*,
  i64);

define <vscale x 2 x i32> @intrinsic_vleff_v_nxv2i32_nxv2i32(<vscale x 2 x i32>* %0, i64 %1, i64* %2) nounwind {
; CHECK-LABEL: intrinsic_vleff_v_nxv2i32_nxv2i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e32, m1, ta, mu
; CHECK-NEXT:    vle32ff.v v8, (a0)
; CHECK-NEXT:    csrr a0, vl
; CHECK-NEXT:    sd a0, 0(a2)
; CHECK-NEXT:    ret
entry:
  %a = call { <vscale x 2 x i32>, i64 } @llvm.riscv.vleff.nxv2i32(
    <vscale x 2 x i32> undef,
    <vscale x 2 x i32>* %0,
    i64 %1)
  %b = extractvalue { <vscale x 2 x i32>, i64 } %a, 0
  %c = extractvalue { <vscale x 2 x i32>, i64 } %a, 1
  store i64 %c, i64* %2
  ret <vscale x 2 x i32> %b
}

declare { <vscale x 2 x i32>, i64 } @llvm.riscv.vleff.mask.nxv2i32(
  <vscale x 2 x i32>,
  <vscale x 2 x i32>*,
  <vscale x 2 x i1>,
  i64,
  i64);

define <vscale x 2 x i32> @intrinsic_vleff_mask_v_nxv2i32_nxv2i32(<vscale x 2 x i32> %0, <vscale x 2 x i32>* %1, <vscale x 2 x i1> %2, i64 %3, i64* %4) nounwind {
; CHECK-LABEL: intrinsic_vleff_mask_v_nxv2i32_nxv2i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e32, m1, ta, mu
; CHECK-NEXT:    vle32ff.v v8, (a0), v0.t
; CHECK-NEXT:    csrr a0, vl
; CHECK-NEXT:    sd a0, 0(a2)
; CHECK-NEXT:    ret
entry:
  %a = call { <vscale x 2 x i32>, i64 } @llvm.riscv.vleff.mask.nxv2i32(
    <vscale x 2 x i32> %0,
    <vscale x 2 x i32>* %1,
    <vscale x 2 x i1> %2,
    i64 %3, i64 1)
  %b = extractvalue { <vscale x 2 x i32>, i64 } %a, 0
  %c = extractvalue { <vscale x 2 x i32>, i64 } %a, 1
  store i64 %c, i64* %4

  ret <vscale x 2 x i32> %b
}

declare { <vscale x 4 x i32>, i64 } @llvm.riscv.vleff.nxv4i32(
  <vscale x 4 x i32>,
  <vscale x 4 x i32>*,
  i64);

define <vscale x 4 x i32> @intrinsic_vleff_v_nxv4i32_nxv4i32(<vscale x 4 x i32>* %0, i64 %1, i64* %2) nounwind {
; CHECK-LABEL: intrinsic_vleff_v_nxv4i32_nxv4i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e32, m2, ta, mu
; CHECK-NEXT:    vle32ff.v v8, (a0)
; CHECK-NEXT:    csrr a0, vl
; CHECK-NEXT:    sd a0, 0(a2)
; CHECK-NEXT:    ret
entry:
  %a = call { <vscale x 4 x i32>, i64 } @llvm.riscv.vleff.nxv4i32(
    <vscale x 4 x i32> undef,
    <vscale x 4 x i32>* %0,
    i64 %1)
  %b = extractvalue { <vscale x 4 x i32>, i64 } %a, 0
  %c = extractvalue { <vscale x 4 x i32>, i64 } %a, 1
  store i64 %c, i64* %2
  ret <vscale x 4 x i32> %b
}

declare { <vscale x 4 x i32>, i64 } @llvm.riscv.vleff.mask.nxv4i32(
  <vscale x 4 x i32>,
  <vscale x 4 x i32>*,
  <vscale x 4 x i1>,
  i64,
  i64);

define <vscale x 4 x i32> @intrinsic_vleff_mask_v_nxv4i32_nxv4i32(<vscale x 4 x i32> %0, <vscale x 4 x i32>* %1, <vscale x 4 x i1> %2, i64 %3, i64* %4) nounwind {
; CHECK-LABEL: intrinsic_vleff_mask_v_nxv4i32_nxv4i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e32, m2, ta, mu
; CHECK-NEXT:    vle32ff.v v8, (a0), v0.t
; CHECK-NEXT:    csrr a0, vl
; CHECK-NEXT:    sd a0, 0(a2)
; CHECK-NEXT:    ret
entry:
  %a = call { <vscale x 4 x i32>, i64 } @llvm.riscv.vleff.mask.nxv4i32(
    <vscale x 4 x i32> %0,
    <vscale x 4 x i32>* %1,
    <vscale x 4 x i1> %2,
    i64 %3, i64 1)
  %b = extractvalue { <vscale x 4 x i32>, i64 } %a, 0
  %c = extractvalue { <vscale x 4 x i32>, i64 } %a, 1
  store i64 %c, i64* %4

  ret <vscale x 4 x i32> %b
}

declare { <vscale x 8 x i32>, i64 } @llvm.riscv.vleff.nxv8i32(
  <vscale x 8 x i32>,
  <vscale x 8 x i32>*,
  i64);

define <vscale x 8 x i32> @intrinsic_vleff_v_nxv8i32_nxv8i32(<vscale x 8 x i32>* %0, i64 %1, i64* %2) nounwind {
; CHECK-LABEL: intrinsic_vleff_v_nxv8i32_nxv8i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e32, m4, ta, mu
; CHECK-NEXT:    vle32ff.v v8, (a0)
; CHECK-NEXT:    csrr a0, vl
; CHECK-NEXT:    sd a0, 0(a2)
; CHECK-NEXT:    ret
entry:
  %a = call { <vscale x 8 x i32>, i64 } @llvm.riscv.vleff.nxv8i32(
    <vscale x 8 x i32> undef,
    <vscale x 8 x i32>* %0,
    i64 %1)
  %b = extractvalue { <vscale x 8 x i32>, i64 } %a, 0
  %c = extractvalue { <vscale x 8 x i32>, i64 } %a, 1
  store i64 %c, i64* %2
  ret <vscale x 8 x i32> %b
}

declare { <vscale x 8 x i32>, i64 } @llvm.riscv.vleff.mask.nxv8i32(
  <vscale x 8 x i32>,
  <vscale x 8 x i32>*,
  <vscale x 8 x i1>,
  i64,
  i64);

define <vscale x 8 x i32> @intrinsic_vleff_mask_v_nxv8i32_nxv8i32(<vscale x 8 x i32> %0, <vscale x 8 x i32>* %1, <vscale x 8 x i1> %2, i64 %3, i64* %4) nounwind {
; CHECK-LABEL: intrinsic_vleff_mask_v_nxv8i32_nxv8i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e32, m4, ta, mu
; CHECK-NEXT:    vle32ff.v v8, (a0), v0.t
; CHECK-NEXT:    csrr a0, vl
; CHECK-NEXT:    sd a0, 0(a2)
; CHECK-NEXT:    ret
entry:
  %a = call { <vscale x 8 x i32>, i64 } @llvm.riscv.vleff.mask.nxv8i32(
    <vscale x 8 x i32> %0,
    <vscale x 8 x i32>* %1,
    <vscale x 8 x i1> %2,
    i64 %3, i64 1)
  %b = extractvalue { <vscale x 8 x i32>, i64 } %a, 0
  %c = extractvalue { <vscale x 8 x i32>, i64 } %a, 1
  store i64 %c, i64* %4

  ret <vscale x 8 x i32> %b
}

declare { <vscale x 16 x i32>, i64 } @llvm.riscv.vleff.nxv16i32(
  <vscale x 16 x i32>,
  <vscale x 16 x i32>*,
  i64);

define <vscale x 16 x i32> @intrinsic_vleff_v_nxv16i32_nxv16i32(<vscale x 16 x i32>* %0, i64 %1, i64* %2) nounwind {
; CHECK-LABEL: intrinsic_vleff_v_nxv16i32_nxv16i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e32, m8, ta, mu
; CHECK-NEXT:    vle32ff.v v8, (a0)
; CHECK-NEXT:    csrr a0, vl
; CHECK-NEXT:    sd a0, 0(a2)
; CHECK-NEXT:    ret
entry:
  %a = call { <vscale x 16 x i32>, i64 } @llvm.riscv.vleff.nxv16i32(
    <vscale x 16 x i32> undef,
    <vscale x 16 x i32>* %0,
    i64 %1)
  %b = extractvalue { <vscale x 16 x i32>, i64 } %a, 0
  %c = extractvalue { <vscale x 16 x i32>, i64 } %a, 1
  store i64 %c, i64* %2
  ret <vscale x 16 x i32> %b
}

declare { <vscale x 16 x i32>, i64 } @llvm.riscv.vleff.mask.nxv16i32(
  <vscale x 16 x i32>,
  <vscale x 16 x i32>*,
  <vscale x 16 x i1>,
  i64,
  i64);

define <vscale x 16 x i32> @intrinsic_vleff_mask_v_nxv16i32_nxv16i32(<vscale x 16 x i32> %0, <vscale x 16 x i32>* %1, <vscale x 16 x i1> %2, i64 %3, i64* %4) nounwind {
; CHECK-LABEL: intrinsic_vleff_mask_v_nxv16i32_nxv16i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e32, m8, ta, mu
; CHECK-NEXT:    vle32ff.v v8, (a0), v0.t
; CHECK-NEXT:    csrr a0, vl
; CHECK-NEXT:    sd a0, 0(a2)
; CHECK-NEXT:    ret
entry:
  %a = call { <vscale x 16 x i32>, i64 } @llvm.riscv.vleff.mask.nxv16i32(
    <vscale x 16 x i32> %0,
    <vscale x 16 x i32>* %1,
    <vscale x 16 x i1> %2,
    i64 %3, i64 1)
  %b = extractvalue { <vscale x 16 x i32>, i64 } %a, 0
  %c = extractvalue { <vscale x 16 x i32>, i64 } %a, 1
  store i64 %c, i64* %4

  ret <vscale x 16 x i32> %b
}

declare { <vscale x 1 x float>, i64 } @llvm.riscv.vleff.nxv1f32(
  <vscale x 1 x float>,
  <vscale x 1 x float>*,
  i64);

define <vscale x 1 x float> @intrinsic_vleff_v_nxv1f32_nxv1f32(<vscale x 1 x float>* %0, i64 %1, i64* %2) nounwind {
; CHECK-LABEL: intrinsic_vleff_v_nxv1f32_nxv1f32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e32, mf2, ta, mu
; CHECK-NEXT:    vle32ff.v v8, (a0)
; CHECK-NEXT:    csrr a0, vl
; CHECK-NEXT:    sd a0, 0(a2)
; CHECK-NEXT:    ret
entry:
  %a = call { <vscale x 1 x float>, i64 } @llvm.riscv.vleff.nxv1f32(
    <vscale x 1 x float> undef,
    <vscale x 1 x float>* %0,
    i64 %1)
  %b = extractvalue { <vscale x 1 x float>, i64 } %a, 0
  %c = extractvalue { <vscale x 1 x float>, i64 } %a, 1
  store i64 %c, i64* %2
  ret <vscale x 1 x float> %b
}

declare { <vscale x 1 x float>, i64 } @llvm.riscv.vleff.mask.nxv1f32(
  <vscale x 1 x float>,
  <vscale x 1 x float>*,
  <vscale x 1 x i1>,
  i64,
  i64);

define <vscale x 1 x float> @intrinsic_vleff_mask_v_nxv1f32_nxv1f32(<vscale x 1 x float> %0, <vscale x 1 x float>* %1, <vscale x 1 x i1> %2, i64 %3, i64* %4) nounwind {
; CHECK-LABEL: intrinsic_vleff_mask_v_nxv1f32_nxv1f32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e32, mf2, ta, mu
; CHECK-NEXT:    vle32ff.v v8, (a0), v0.t
; CHECK-NEXT:    csrr a0, vl
; CHECK-NEXT:    sd a0, 0(a2)
; CHECK-NEXT:    ret
entry:
  %a = call { <vscale x 1 x float>, i64 } @llvm.riscv.vleff.mask.nxv1f32(
    <vscale x 1 x float> %0,
    <vscale x 1 x float>* %1,
    <vscale x 1 x i1> %2,
    i64 %3, i64 1)
  %b = extractvalue { <vscale x 1 x float>, i64 } %a, 0
  %c = extractvalue { <vscale x 1 x float>, i64 } %a, 1
  store i64 %c, i64* %4

  ret <vscale x 1 x float> %b
}

declare { <vscale x 2 x float>, i64 } @llvm.riscv.vleff.nxv2f32(
  <vscale x 2 x float>,
  <vscale x 2 x float>*,
  i64);

define <vscale x 2 x float> @intrinsic_vleff_v_nxv2f32_nxv2f32(<vscale x 2 x float>* %0, i64 %1, i64* %2) nounwind {
; CHECK-LABEL: intrinsic_vleff_v_nxv2f32_nxv2f32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e32, m1, ta, mu
; CHECK-NEXT:    vle32ff.v v8, (a0)
; CHECK-NEXT:    csrr a0, vl
; CHECK-NEXT:    sd a0, 0(a2)
; CHECK-NEXT:    ret
entry:
  %a = call { <vscale x 2 x float>, i64 } @llvm.riscv.vleff.nxv2f32(
    <vscale x 2 x float> undef,
    <vscale x 2 x float>* %0,
    i64 %1)
  %b = extractvalue { <vscale x 2 x float>, i64 } %a, 0
  %c = extractvalue { <vscale x 2 x float>, i64 } %a, 1
  store i64 %c, i64* %2
  ret <vscale x 2 x float> %b
}

declare { <vscale x 2 x float>, i64 } @llvm.riscv.vleff.mask.nxv2f32(
  <vscale x 2 x float>,
  <vscale x 2 x float>*,
  <vscale x 2 x i1>,
  i64,
  i64);

define <vscale x 2 x float> @intrinsic_vleff_mask_v_nxv2f32_nxv2f32(<vscale x 2 x float> %0, <vscale x 2 x float>* %1, <vscale x 2 x i1> %2, i64 %3, i64* %4) nounwind {
; CHECK-LABEL: intrinsic_vleff_mask_v_nxv2f32_nxv2f32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e32, m1, ta, mu
; CHECK-NEXT:    vle32ff.v v8, (a0), v0.t
; CHECK-NEXT:    csrr a0, vl
; CHECK-NEXT:    sd a0, 0(a2)
; CHECK-NEXT:    ret
entry:
  %a = call { <vscale x 2 x float>, i64 } @llvm.riscv.vleff.mask.nxv2f32(
    <vscale x 2 x float> %0,
    <vscale x 2 x float>* %1,
    <vscale x 2 x i1> %2,
    i64 %3, i64 1)
  %b = extractvalue { <vscale x 2 x float>, i64 } %a, 0
  %c = extractvalue { <vscale x 2 x float>, i64 } %a, 1
  store i64 %c, i64* %4

  ret <vscale x 2 x float> %b
}

declare { <vscale x 4 x float>, i64 } @llvm.riscv.vleff.nxv4f32(
  <vscale x 4 x float>,
  <vscale x 4 x float>*,
  i64);

define <vscale x 4 x float> @intrinsic_vleff_v_nxv4f32_nxv4f32(<vscale x 4 x float>* %0, i64 %1, i64* %2) nounwind {
; CHECK-LABEL: intrinsic_vleff_v_nxv4f32_nxv4f32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e32, m2, ta, mu
; CHECK-NEXT:    vle32ff.v v8, (a0)
; CHECK-NEXT:    csrr a0, vl
; CHECK-NEXT:    sd a0, 0(a2)
; CHECK-NEXT:    ret
entry:
  %a = call { <vscale x 4 x float>, i64 } @llvm.riscv.vleff.nxv4f32(
    <vscale x 4 x float> undef,
    <vscale x 4 x float>* %0,
    i64 %1)
  %b = extractvalue { <vscale x 4 x float>, i64 } %a, 0
  %c = extractvalue { <vscale x 4 x float>, i64 } %a, 1
  store i64 %c, i64* %2
  ret <vscale x 4 x float> %b
}

declare { <vscale x 4 x float>, i64 } @llvm.riscv.vleff.mask.nxv4f32(
  <vscale x 4 x float>,
  <vscale x 4 x float>*,
  <vscale x 4 x i1>,
  i64,
  i64);

define <vscale x 4 x float> @intrinsic_vleff_mask_v_nxv4f32_nxv4f32(<vscale x 4 x float> %0, <vscale x 4 x float>* %1, <vscale x 4 x i1> %2, i64 %3, i64* %4) nounwind {
; CHECK-LABEL: intrinsic_vleff_mask_v_nxv4f32_nxv4f32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e32, m2, ta, mu
; CHECK-NEXT:    vle32ff.v v8, (a0), v0.t
; CHECK-NEXT:    csrr a0, vl
; CHECK-NEXT:    sd a0, 0(a2)
; CHECK-NEXT:    ret
entry:
  %a = call { <vscale x 4 x float>, i64 } @llvm.riscv.vleff.mask.nxv4f32(
    <vscale x 4 x float> %0,
    <vscale x 4 x float>* %1,
    <vscale x 4 x i1> %2,
    i64 %3, i64 1)
  %b = extractvalue { <vscale x 4 x float>, i64 } %a, 0
  %c = extractvalue { <vscale x 4 x float>, i64 } %a, 1
  store i64 %c, i64* %4

  ret <vscale x 4 x float> %b
}

declare { <vscale x 8 x float>, i64 } @llvm.riscv.vleff.nxv8f32(
  <vscale x 8 x float>,
  <vscale x 8 x float>*,
  i64);

define <vscale x 8 x float> @intrinsic_vleff_v_nxv8f32_nxv8f32(<vscale x 8 x float>* %0, i64 %1, i64* %2) nounwind {
; CHECK-LABEL: intrinsic_vleff_v_nxv8f32_nxv8f32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e32, m4, ta, mu
; CHECK-NEXT:    vle32ff.v v8, (a0)
; CHECK-NEXT:    csrr a0, vl
; CHECK-NEXT:    sd a0, 0(a2)
; CHECK-NEXT:    ret
entry:
  %a = call { <vscale x 8 x float>, i64 } @llvm.riscv.vleff.nxv8f32(
    <vscale x 8 x float> undef,
    <vscale x 8 x float>* %0,
    i64 %1)
  %b = extractvalue { <vscale x 8 x float>, i64 } %a, 0
  %c = extractvalue { <vscale x 8 x float>, i64 } %a, 1
  store i64 %c, i64* %2
  ret <vscale x 8 x float> %b
}

declare { <vscale x 8 x float>, i64 } @llvm.riscv.vleff.mask.nxv8f32(
  <vscale x 8 x float>,
  <vscale x 8 x float>*,
  <vscale x 8 x i1>,
  i64,
  i64);

define <vscale x 8 x float> @intrinsic_vleff_mask_v_nxv8f32_nxv8f32(<vscale x 8 x float> %0, <vscale x 8 x float>* %1, <vscale x 8 x i1> %2, i64 %3, i64* %4) nounwind {
; CHECK-LABEL: intrinsic_vleff_mask_v_nxv8f32_nxv8f32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e32, m4, ta, mu
; CHECK-NEXT:    vle32ff.v v8, (a0), v0.t
; CHECK-NEXT:    csrr a0, vl
; CHECK-NEXT:    sd a0, 0(a2)
; CHECK-NEXT:    ret
entry:
  %a = call { <vscale x 8 x float>, i64 } @llvm.riscv.vleff.mask.nxv8f32(
    <vscale x 8 x float> %0,
    <vscale x 8 x float>* %1,
    <vscale x 8 x i1> %2,
    i64 %3, i64 1)
  %b = extractvalue { <vscale x 8 x float>, i64 } %a, 0
  %c = extractvalue { <vscale x 8 x float>, i64 } %a, 1
  store i64 %c, i64* %4

  ret <vscale x 8 x float> %b
}

declare { <vscale x 16 x float>, i64 } @llvm.riscv.vleff.nxv16f32(
  <vscale x 16 x float>,
  <vscale x 16 x float>*,
  i64);

define <vscale x 16 x float> @intrinsic_vleff_v_nxv16f32_nxv16f32(<vscale x 16 x float>* %0, i64 %1, i64* %2) nounwind {
; CHECK-LABEL: intrinsic_vleff_v_nxv16f32_nxv16f32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e32, m8, ta, mu
; CHECK-NEXT:    vle32ff.v v8, (a0)
; CHECK-NEXT:    csrr a0, vl
; CHECK-NEXT:    sd a0, 0(a2)
; CHECK-NEXT:    ret
entry:
  %a = call { <vscale x 16 x float>, i64 } @llvm.riscv.vleff.nxv16f32(
    <vscale x 16 x float> undef,
    <vscale x 16 x float>* %0,
    i64 %1)
  %b = extractvalue { <vscale x 16 x float>, i64 } %a, 0
  %c = extractvalue { <vscale x 16 x float>, i64 } %a, 1
  store i64 %c, i64* %2
  ret <vscale x 16 x float> %b
}

declare { <vscale x 16 x float>, i64 } @llvm.riscv.vleff.mask.nxv16f32(
  <vscale x 16 x float>,
  <vscale x 16 x float>*,
  <vscale x 16 x i1>,
  i64,
  i64);

define <vscale x 16 x float> @intrinsic_vleff_mask_v_nxv16f32_nxv16f32(<vscale x 16 x float> %0, <vscale x 16 x float>* %1, <vscale x 16 x i1> %2, i64 %3, i64* %4) nounwind {
; CHECK-LABEL: intrinsic_vleff_mask_v_nxv16f32_nxv16f32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e32, m8, ta, mu
; CHECK-NEXT:    vle32ff.v v8, (a0), v0.t
; CHECK-NEXT:    csrr a0, vl
; CHECK-NEXT:    sd a0, 0(a2)
; CHECK-NEXT:    ret
entry:
  %a = call { <vscale x 16 x float>, i64 } @llvm.riscv.vleff.mask.nxv16f32(
    <vscale x 16 x float> %0,
    <vscale x 16 x float>* %1,
    <vscale x 16 x i1> %2,
    i64 %3, i64 1)
  %b = extractvalue { <vscale x 16 x float>, i64 } %a, 0
  %c = extractvalue { <vscale x 16 x float>, i64 } %a, 1
  store i64 %c, i64* %4

  ret <vscale x 16 x float> %b
}

declare { <vscale x 1 x i16>, i64 } @llvm.riscv.vleff.nxv1i16(
  <vscale x 1 x i16>,
  <vscale x 1 x i16>*,
  i64);

define <vscale x 1 x i16> @intrinsic_vleff_v_nxv1i16_nxv1i16(<vscale x 1 x i16>* %0, i64 %1, i64* %2) nounwind {
; CHECK-LABEL: intrinsic_vleff_v_nxv1i16_nxv1i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, mf4, ta, mu
; CHECK-NEXT:    vle16ff.v v8, (a0)
; CHECK-NEXT:    csrr a0, vl
; CHECK-NEXT:    sd a0, 0(a2)
; CHECK-NEXT:    ret
entry:
  %a = call { <vscale x 1 x i16>, i64 } @llvm.riscv.vleff.nxv1i16(
    <vscale x 1 x i16> undef,
    <vscale x 1 x i16>* %0,
    i64 %1)
  %b = extractvalue { <vscale x 1 x i16>, i64 } %a, 0
  %c = extractvalue { <vscale x 1 x i16>, i64 } %a, 1
  store i64 %c, i64* %2
  ret <vscale x 1 x i16> %b
}

declare { <vscale x 1 x i16>, i64 } @llvm.riscv.vleff.mask.nxv1i16(
  <vscale x 1 x i16>,
  <vscale x 1 x i16>*,
  <vscale x 1 x i1>,
  i64,
  i64);

define <vscale x 1 x i16> @intrinsic_vleff_mask_v_nxv1i16_nxv1i16(<vscale x 1 x i16> %0, <vscale x 1 x i16>* %1, <vscale x 1 x i1> %2, i64 %3, i64* %4) nounwind {
; CHECK-LABEL: intrinsic_vleff_mask_v_nxv1i16_nxv1i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, mf4, ta, mu
; CHECK-NEXT:    vle16ff.v v8, (a0), v0.t
; CHECK-NEXT:    csrr a0, vl
; CHECK-NEXT:    sd a0, 0(a2)
; CHECK-NEXT:    ret
entry:
  %a = call { <vscale x 1 x i16>, i64 } @llvm.riscv.vleff.mask.nxv1i16(
    <vscale x 1 x i16> %0,
    <vscale x 1 x i16>* %1,
    <vscale x 1 x i1> %2,
    i64 %3, i64 1)
  %b = extractvalue { <vscale x 1 x i16>, i64 } %a, 0
  %c = extractvalue { <vscale x 1 x i16>, i64 } %a, 1
  store i64 %c, i64* %4

  ret <vscale x 1 x i16> %b
}

declare { <vscale x 2 x i16>, i64 } @llvm.riscv.vleff.nxv2i16(
  <vscale x 2 x i16>,
  <vscale x 2 x i16>*,
  i64);

define <vscale x 2 x i16> @intrinsic_vleff_v_nxv2i16_nxv2i16(<vscale x 2 x i16>* %0, i64 %1, i64* %2) nounwind {
; CHECK-LABEL: intrinsic_vleff_v_nxv2i16_nxv2i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, mf2, ta, mu
; CHECK-NEXT:    vle16ff.v v8, (a0)
; CHECK-NEXT:    csrr a0, vl
; CHECK-NEXT:    sd a0, 0(a2)
; CHECK-NEXT:    ret
entry:
  %a = call { <vscale x 2 x i16>, i64 } @llvm.riscv.vleff.nxv2i16(
    <vscale x 2 x i16> undef,
    <vscale x 2 x i16>* %0,
    i64 %1)
  %b = extractvalue { <vscale x 2 x i16>, i64 } %a, 0
  %c = extractvalue { <vscale x 2 x i16>, i64 } %a, 1
  store i64 %c, i64* %2
  ret <vscale x 2 x i16> %b
}

declare { <vscale x 2 x i16>, i64 } @llvm.riscv.vleff.mask.nxv2i16(
  <vscale x 2 x i16>,
  <vscale x 2 x i16>*,
  <vscale x 2 x i1>,
  i64,
  i64);

define <vscale x 2 x i16> @intrinsic_vleff_mask_v_nxv2i16_nxv2i16(<vscale x 2 x i16> %0, <vscale x 2 x i16>* %1, <vscale x 2 x i1> %2, i64 %3, i64* %4) nounwind {
; CHECK-LABEL: intrinsic_vleff_mask_v_nxv2i16_nxv2i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, mf2, ta, mu
; CHECK-NEXT:    vle16ff.v v8, (a0), v0.t
; CHECK-NEXT:    csrr a0, vl
; CHECK-NEXT:    sd a0, 0(a2)
; CHECK-NEXT:    ret
entry:
  %a = call { <vscale x 2 x i16>, i64 } @llvm.riscv.vleff.mask.nxv2i16(
    <vscale x 2 x i16> %0,
    <vscale x 2 x i16>* %1,
    <vscale x 2 x i1> %2,
    i64 %3, i64 1)
  %b = extractvalue { <vscale x 2 x i16>, i64 } %a, 0
  %c = extractvalue { <vscale x 2 x i16>, i64 } %a, 1
  store i64 %c, i64* %4

  ret <vscale x 2 x i16> %b
}

declare { <vscale x 4 x i16>, i64 } @llvm.riscv.vleff.nxv4i16(
  <vscale x 4 x i16>,
  <vscale x 4 x i16>*,
  i64);

define <vscale x 4 x i16> @intrinsic_vleff_v_nxv4i16_nxv4i16(<vscale x 4 x i16>* %0, i64 %1, i64* %2) nounwind {
; CHECK-LABEL: intrinsic_vleff_v_nxv4i16_nxv4i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, m1, ta, mu
; CHECK-NEXT:    vle16ff.v v8, (a0)
; CHECK-NEXT:    csrr a0, vl
; CHECK-NEXT:    sd a0, 0(a2)
; CHECK-NEXT:    ret
entry:
  %a = call { <vscale x 4 x i16>, i64 } @llvm.riscv.vleff.nxv4i16(
    <vscale x 4 x i16> undef,
    <vscale x 4 x i16>* %0,
    i64 %1)
  %b = extractvalue { <vscale x 4 x i16>, i64 } %a, 0
  %c = extractvalue { <vscale x 4 x i16>, i64 } %a, 1
  store i64 %c, i64* %2
  ret <vscale x 4 x i16> %b
}

declare { <vscale x 4 x i16>, i64 } @llvm.riscv.vleff.mask.nxv4i16(
  <vscale x 4 x i16>,
  <vscale x 4 x i16>*,
  <vscale x 4 x i1>,
  i64,
  i64);

define <vscale x 4 x i16> @intrinsic_vleff_mask_v_nxv4i16_nxv4i16(<vscale x 4 x i16> %0, <vscale x 4 x i16>* %1, <vscale x 4 x i1> %2, i64 %3, i64* %4) nounwind {
; CHECK-LABEL: intrinsic_vleff_mask_v_nxv4i16_nxv4i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, m1, ta, mu
; CHECK-NEXT:    vle16ff.v v8, (a0), v0.t
; CHECK-NEXT:    csrr a0, vl
; CHECK-NEXT:    sd a0, 0(a2)
; CHECK-NEXT:    ret
entry:
  %a = call { <vscale x 4 x i16>, i64 } @llvm.riscv.vleff.mask.nxv4i16(
    <vscale x 4 x i16> %0,
    <vscale x 4 x i16>* %1,
    <vscale x 4 x i1> %2,
    i64 %3, i64 1)
  %b = extractvalue { <vscale x 4 x i16>, i64 } %a, 0
  %c = extractvalue { <vscale x 4 x i16>, i64 } %a, 1
  store i64 %c, i64* %4

  ret <vscale x 4 x i16> %b
}

declare { <vscale x 8 x i16>, i64 } @llvm.riscv.vleff.nxv8i16(
  <vscale x 8 x i16>,
  <vscale x 8 x i16>*,
  i64);

define <vscale x 8 x i16> @intrinsic_vleff_v_nxv8i16_nxv8i16(<vscale x 8 x i16>* %0, i64 %1, i64* %2) nounwind {
; CHECK-LABEL: intrinsic_vleff_v_nxv8i16_nxv8i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, m2, ta, mu
; CHECK-NEXT:    vle16ff.v v8, (a0)
; CHECK-NEXT:    csrr a0, vl
; CHECK-NEXT:    sd a0, 0(a2)
; CHECK-NEXT:    ret
entry:
  %a = call { <vscale x 8 x i16>, i64 } @llvm.riscv.vleff.nxv8i16(
    <vscale x 8 x i16> undef,
    <vscale x 8 x i16>* %0,
    i64 %1)
  %b = extractvalue { <vscale x 8 x i16>, i64 } %a, 0
  %c = extractvalue { <vscale x 8 x i16>, i64 } %a, 1
  store i64 %c, i64* %2
  ret <vscale x 8 x i16> %b
}

declare { <vscale x 8 x i16>, i64 } @llvm.riscv.vleff.mask.nxv8i16(
  <vscale x 8 x i16>,
  <vscale x 8 x i16>*,
  <vscale x 8 x i1>,
  i64,
  i64);

define <vscale x 8 x i16> @intrinsic_vleff_mask_v_nxv8i16_nxv8i16(<vscale x 8 x i16> %0, <vscale x 8 x i16>* %1, <vscale x 8 x i1> %2, i64 %3, i64* %4) nounwind {
; CHECK-LABEL: intrinsic_vleff_mask_v_nxv8i16_nxv8i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, m2, ta, mu
; CHECK-NEXT:    vle16ff.v v8, (a0), v0.t
; CHECK-NEXT:    csrr a0, vl
; CHECK-NEXT:    sd a0, 0(a2)
; CHECK-NEXT:    ret
entry:
  %a = call { <vscale x 8 x i16>, i64 } @llvm.riscv.vleff.mask.nxv8i16(
    <vscale x 8 x i16> %0,
    <vscale x 8 x i16>* %1,
    <vscale x 8 x i1> %2,
    i64 %3, i64 1)
  %b = extractvalue { <vscale x 8 x i16>, i64 } %a, 0
  %c = extractvalue { <vscale x 8 x i16>, i64 } %a, 1
  store i64 %c, i64* %4

  ret <vscale x 8 x i16> %b
}

declare { <vscale x 16 x i16>, i64 } @llvm.riscv.vleff.nxv16i16(
  <vscale x 16 x i16>,
  <vscale x 16 x i16>*,
  i64);

define <vscale x 16 x i16> @intrinsic_vleff_v_nxv16i16_nxv16i16(<vscale x 16 x i16>* %0, i64 %1, i64* %2) nounwind {
; CHECK-LABEL: intrinsic_vleff_v_nxv16i16_nxv16i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, m4, ta, mu
; CHECK-NEXT:    vle16ff.v v8, (a0)
; CHECK-NEXT:    csrr a0, vl
; CHECK-NEXT:    sd a0, 0(a2)
; CHECK-NEXT:    ret
entry:
  %a = call { <vscale x 16 x i16>, i64 } @llvm.riscv.vleff.nxv16i16(
    <vscale x 16 x i16> undef,
    <vscale x 16 x i16>* %0,
    i64 %1)
  %b = extractvalue { <vscale x 16 x i16>, i64 } %a, 0
  %c = extractvalue { <vscale x 16 x i16>, i64 } %a, 1
  store i64 %c, i64* %2
  ret <vscale x 16 x i16> %b
}

declare { <vscale x 16 x i16>, i64 } @llvm.riscv.vleff.mask.nxv16i16(
  <vscale x 16 x i16>,
  <vscale x 16 x i16>*,
  <vscale x 16 x i1>,
  i64,
  i64);

define <vscale x 16 x i16> @intrinsic_vleff_mask_v_nxv16i16_nxv16i16(<vscale x 16 x i16> %0, <vscale x 16 x i16>* %1, <vscale x 16 x i1> %2, i64 %3, i64* %4) nounwind {
; CHECK-LABEL: intrinsic_vleff_mask_v_nxv16i16_nxv16i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, m4, ta, mu
; CHECK-NEXT:    vle16ff.v v8, (a0), v0.t
; CHECK-NEXT:    csrr a0, vl
; CHECK-NEXT:    sd a0, 0(a2)
; CHECK-NEXT:    ret
entry:
  %a = call { <vscale x 16 x i16>, i64 } @llvm.riscv.vleff.mask.nxv16i16(
    <vscale x 16 x i16> %0,
    <vscale x 16 x i16>* %1,
    <vscale x 16 x i1> %2,
    i64 %3, i64 1)
  %b = extractvalue { <vscale x 16 x i16>, i64 } %a, 0
  %c = extractvalue { <vscale x 16 x i16>, i64 } %a, 1
  store i64 %c, i64* %4

  ret <vscale x 16 x i16> %b
}

declare { <vscale x 32 x i16>, i64 } @llvm.riscv.vleff.nxv32i16(
  <vscale x 32 x i16>,
  <vscale x 32 x i16>*,
  i64);

define <vscale x 32 x i16> @intrinsic_vleff_v_nxv32i16_nxv32i16(<vscale x 32 x i16>* %0, i64 %1, i64* %2) nounwind {
; CHECK-LABEL: intrinsic_vleff_v_nxv32i16_nxv32i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, m8, ta, mu
; CHECK-NEXT:    vle16ff.v v8, (a0)
; CHECK-NEXT:    csrr a0, vl
; CHECK-NEXT:    sd a0, 0(a2)
; CHECK-NEXT:    ret
entry:
  %a = call { <vscale x 32 x i16>, i64 } @llvm.riscv.vleff.nxv32i16(
    <vscale x 32 x i16> undef,
    <vscale x 32 x i16>* %0,
    i64 %1)
  %b = extractvalue { <vscale x 32 x i16>, i64 } %a, 0
  %c = extractvalue { <vscale x 32 x i16>, i64 } %a, 1
  store i64 %c, i64* %2
  ret <vscale x 32 x i16> %b
}

declare { <vscale x 32 x i16>, i64 } @llvm.riscv.vleff.mask.nxv32i16(
  <vscale x 32 x i16>,
  <vscale x 32 x i16>*,
  <vscale x 32 x i1>,
  i64,
  i64);

define <vscale x 32 x i16> @intrinsic_vleff_mask_v_nxv32i16_nxv32i16(<vscale x 32 x i16> %0, <vscale x 32 x i16>* %1, <vscale x 32 x i1> %2, i64 %3, i64* %4) nounwind {
; CHECK-LABEL: intrinsic_vleff_mask_v_nxv32i16_nxv32i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, m8, ta, mu
; CHECK-NEXT:    vle16ff.v v8, (a0), v0.t
; CHECK-NEXT:    csrr a0, vl
; CHECK-NEXT:    sd a0, 0(a2)
; CHECK-NEXT:    ret
entry:
  %a = call { <vscale x 32 x i16>, i64 } @llvm.riscv.vleff.mask.nxv32i16(
    <vscale x 32 x i16> %0,
    <vscale x 32 x i16>* %1,
    <vscale x 32 x i1> %2,
    i64 %3, i64 1)
  %b = extractvalue { <vscale x 32 x i16>, i64 } %a, 0
  %c = extractvalue { <vscale x 32 x i16>, i64 } %a, 1
  store i64 %c, i64* %4

  ret <vscale x 32 x i16> %b
}

declare { <vscale x 1 x half>, i64 } @llvm.riscv.vleff.nxv1f16(
  <vscale x 1 x half>,
  <vscale x 1 x half>*,
  i64);

define <vscale x 1 x half> @intrinsic_vleff_v_nxv1half_nxv1f16(<vscale x 1 x half>* %0, i64 %1, i64* %2) nounwind {
; CHECK-LABEL: intrinsic_vleff_v_nxv1half_nxv1f16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, mf4, ta, mu
; CHECK-NEXT:    vle16ff.v v8, (a0)
; CHECK-NEXT:    csrr a0, vl
; CHECK-NEXT:    sd a0, 0(a2)
; CHECK-NEXT:    ret
entry:
  %a = call { <vscale x 1 x half>, i64 } @llvm.riscv.vleff.nxv1f16(
    <vscale x 1 x half> undef,
    <vscale x 1 x half>* %0,
    i64 %1)
  %b = extractvalue { <vscale x 1 x half>, i64 } %a, 0
  %c = extractvalue { <vscale x 1 x half>, i64 } %a, 1
  store i64 %c, i64* %2
  ret <vscale x 1 x half> %b
}

declare { <vscale x 1 x half>, i64 } @llvm.riscv.vleff.mask.nxv1f16(
  <vscale x 1 x half>,
  <vscale x 1 x half>*,
  <vscale x 1 x i1>,
  i64,
  i64);

define <vscale x 1 x half> @intrinsic_vleff_mask_v_nxv1half_nxv1f16(<vscale x 1 x half> %0, <vscale x 1 x half>* %1, <vscale x 1 x i1> %2, i64 %3, i64* %4) nounwind {
; CHECK-LABEL: intrinsic_vleff_mask_v_nxv1half_nxv1f16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, mf4, ta, mu
; CHECK-NEXT:    vle16ff.v v8, (a0), v0.t
; CHECK-NEXT:    csrr a0, vl
; CHECK-NEXT:    sd a0, 0(a2)
; CHECK-NEXT:    ret
entry:
  %a = call { <vscale x 1 x half>, i64 } @llvm.riscv.vleff.mask.nxv1f16(
    <vscale x 1 x half> %0,
    <vscale x 1 x half>* %1,
    <vscale x 1 x i1> %2,
    i64 %3, i64 1)
  %b = extractvalue { <vscale x 1 x half>, i64 } %a, 0
  %c = extractvalue { <vscale x 1 x half>, i64 } %a, 1
  store i64 %c, i64* %4

  ret <vscale x 1 x half> %b
}

declare { <vscale x 2 x half>, i64 } @llvm.riscv.vleff.nxv2f16(
  <vscale x 2 x half>,
  <vscale x 2 x half>*,
  i64);

define <vscale x 2 x half> @intrinsic_vleff_v_nxv2half_nxv2f16(<vscale x 2 x half>* %0, i64 %1, i64* %2) nounwind {
; CHECK-LABEL: intrinsic_vleff_v_nxv2half_nxv2f16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, mf2, ta, mu
; CHECK-NEXT:    vle16ff.v v8, (a0)
; CHECK-NEXT:    csrr a0, vl
; CHECK-NEXT:    sd a0, 0(a2)
; CHECK-NEXT:    ret
entry:
  %a = call { <vscale x 2 x half>, i64 } @llvm.riscv.vleff.nxv2f16(
    <vscale x 2 x half> undef,
    <vscale x 2 x half>* %0,
    i64 %1)
  %b = extractvalue { <vscale x 2 x half>, i64 } %a, 0
  %c = extractvalue { <vscale x 2 x half>, i64 } %a, 1
  store i64 %c, i64* %2
  ret <vscale x 2 x half> %b
}

declare { <vscale x 2 x half>, i64 } @llvm.riscv.vleff.mask.nxv2f16(
  <vscale x 2 x half>,
  <vscale x 2 x half>*,
  <vscale x 2 x i1>,
  i64,
  i64);

define <vscale x 2 x half> @intrinsic_vleff_mask_v_nxv2half_nxv2f16(<vscale x 2 x half> %0, <vscale x 2 x half>* %1, <vscale x 2 x i1> %2, i64 %3, i64* %4) nounwind {
; CHECK-LABEL: intrinsic_vleff_mask_v_nxv2half_nxv2f16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, mf2, ta, mu
; CHECK-NEXT:    vle16ff.v v8, (a0), v0.t
; CHECK-NEXT:    csrr a0, vl
; CHECK-NEXT:    sd a0, 0(a2)
; CHECK-NEXT:    ret
entry:
  %a = call { <vscale x 2 x half>, i64 } @llvm.riscv.vleff.mask.nxv2f16(
    <vscale x 2 x half> %0,
    <vscale x 2 x half>* %1,
    <vscale x 2 x i1> %2,
    i64 %3, i64 1)
  %b = extractvalue { <vscale x 2 x half>, i64 } %a, 0
  %c = extractvalue { <vscale x 2 x half>, i64 } %a, 1
  store i64 %c, i64* %4

  ret <vscale x 2 x half> %b
}

declare { <vscale x 4 x half>, i64 } @llvm.riscv.vleff.nxv4f16(
  <vscale x 4 x half>,
  <vscale x 4 x half>*,
  i64);

define <vscale x 4 x half> @intrinsic_vleff_v_nxv4half_nxv4f16(<vscale x 4 x half>* %0, i64 %1, i64* %2) nounwind {
; CHECK-LABEL: intrinsic_vleff_v_nxv4half_nxv4f16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, m1, ta, mu
; CHECK-NEXT:    vle16ff.v v8, (a0)
; CHECK-NEXT:    csrr a0, vl
; CHECK-NEXT:    sd a0, 0(a2)
; CHECK-NEXT:    ret
entry:
  %a = call { <vscale x 4 x half>, i64 } @llvm.riscv.vleff.nxv4f16(
    <vscale x 4 x half> undef,
    <vscale x 4 x half>* %0,
    i64 %1)
  %b = extractvalue { <vscale x 4 x half>, i64 } %a, 0
  %c = extractvalue { <vscale x 4 x half>, i64 } %a, 1
  store i64 %c, i64* %2
  ret <vscale x 4 x half> %b
}

declare { <vscale x 4 x half>, i64 } @llvm.riscv.vleff.mask.nxv4f16(
  <vscale x 4 x half>,
  <vscale x 4 x half>*,
  <vscale x 4 x i1>,
  i64,
  i64);

define <vscale x 4 x half> @intrinsic_vleff_mask_v_nxv4half_nxv4f16(<vscale x 4 x half> %0, <vscale x 4 x half>* %1, <vscale x 4 x i1> %2, i64 %3, i64* %4) nounwind {
; CHECK-LABEL: intrinsic_vleff_mask_v_nxv4half_nxv4f16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, m1, ta, mu
; CHECK-NEXT:    vle16ff.v v8, (a0), v0.t
; CHECK-NEXT:    csrr a0, vl
; CHECK-NEXT:    sd a0, 0(a2)
; CHECK-NEXT:    ret
entry:
  %a = call { <vscale x 4 x half>, i64 } @llvm.riscv.vleff.mask.nxv4f16(
    <vscale x 4 x half> %0,
    <vscale x 4 x half>* %1,
    <vscale x 4 x i1> %2,
    i64 %3, i64 1)
  %b = extractvalue { <vscale x 4 x half>, i64 } %a, 0
  %c = extractvalue { <vscale x 4 x half>, i64 } %a, 1
  store i64 %c, i64* %4

  ret <vscale x 4 x half> %b
}

declare { <vscale x 8 x half>, i64 } @llvm.riscv.vleff.nxv8f16(
  <vscale x 8 x half>,
  <vscale x 8 x half>*,
  i64);

define <vscale x 8 x half> @intrinsic_vleff_v_nxv8half_nxv8f16(<vscale x 8 x half>* %0, i64 %1, i64* %2) nounwind {
; CHECK-LABEL: intrinsic_vleff_v_nxv8half_nxv8f16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, m2, ta, mu
; CHECK-NEXT:    vle16ff.v v8, (a0)
; CHECK-NEXT:    csrr a0, vl
; CHECK-NEXT:    sd a0, 0(a2)
; CHECK-NEXT:    ret
entry:
  %a = call { <vscale x 8 x half>, i64 } @llvm.riscv.vleff.nxv8f16(
    <vscale x 8 x half> undef,
    <vscale x 8 x half>* %0,
    i64 %1)
  %b = extractvalue { <vscale x 8 x half>, i64 } %a, 0
  %c = extractvalue { <vscale x 8 x half>, i64 } %a, 1
  store i64 %c, i64* %2
  ret <vscale x 8 x half> %b
}

declare { <vscale x 8 x half>, i64 } @llvm.riscv.vleff.mask.nxv8f16(
  <vscale x 8 x half>,
  <vscale x 8 x half>*,
  <vscale x 8 x i1>,
  i64,
  i64);

define <vscale x 8 x half> @intrinsic_vleff_mask_v_nxv8half_nxv8f16(<vscale x 8 x half> %0, <vscale x 8 x half>* %1, <vscale x 8 x i1> %2, i64 %3, i64* %4) nounwind {
; CHECK-LABEL: intrinsic_vleff_mask_v_nxv8half_nxv8f16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, m2, ta, mu
; CHECK-NEXT:    vle16ff.v v8, (a0), v0.t
; CHECK-NEXT:    csrr a0, vl
; CHECK-NEXT:    sd a0, 0(a2)
; CHECK-NEXT:    ret
entry:
  %a = call { <vscale x 8 x half>, i64 } @llvm.riscv.vleff.mask.nxv8f16(
    <vscale x 8 x half> %0,
    <vscale x 8 x half>* %1,
    <vscale x 8 x i1> %2,
    i64 %3, i64 1)
  %b = extractvalue { <vscale x 8 x half>, i64 } %a, 0
  %c = extractvalue { <vscale x 8 x half>, i64 } %a, 1
  store i64 %c, i64* %4

  ret <vscale x 8 x half> %b
}

declare { <vscale x 16 x half>, i64 } @llvm.riscv.vleff.nxv16f16(
  <vscale x 16 x half>,
  <vscale x 16 x half>*,
  i64);

define <vscale x 16 x half> @intrinsic_vleff_v_nxv16half_nxv16f16(<vscale x 16 x half>* %0, i64 %1, i64* %2) nounwind {
; CHECK-LABEL: intrinsic_vleff_v_nxv16half_nxv16f16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, m4, ta, mu
; CHECK-NEXT:    vle16ff.v v8, (a0)
; CHECK-NEXT:    csrr a0, vl
; CHECK-NEXT:    sd a0, 0(a2)
; CHECK-NEXT:    ret
entry:
  %a = call { <vscale x 16 x half>, i64 } @llvm.riscv.vleff.nxv16f16(
    <vscale x 16 x half> undef,
    <vscale x 16 x half>* %0,
    i64 %1)
  %b = extractvalue { <vscale x 16 x half>, i64 } %a, 0
  %c = extractvalue { <vscale x 16 x half>, i64 } %a, 1
  store i64 %c, i64* %2
  ret <vscale x 16 x half> %b
}

declare { <vscale x 16 x half>, i64 } @llvm.riscv.vleff.mask.nxv16f16(
  <vscale x 16 x half>,
  <vscale x 16 x half>*,
  <vscale x 16 x i1>,
  i64,
  i64);

define <vscale x 16 x half> @intrinsic_vleff_mask_v_nxv16half_nxv16f16(<vscale x 16 x half> %0, <vscale x 16 x half>* %1, <vscale x 16 x i1> %2, i64 %3, i64* %4) nounwind {
; CHECK-LABEL: intrinsic_vleff_mask_v_nxv16half_nxv16f16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, m4, ta, mu
; CHECK-NEXT:    vle16ff.v v8, (a0), v0.t
; CHECK-NEXT:    csrr a0, vl
; CHECK-NEXT:    sd a0, 0(a2)
; CHECK-NEXT:    ret
entry:
  %a = call { <vscale x 16 x half>, i64 } @llvm.riscv.vleff.mask.nxv16f16(
    <vscale x 16 x half> %0,
    <vscale x 16 x half>* %1,
    <vscale x 16 x i1> %2,
    i64 %3, i64 1)
  %b = extractvalue { <vscale x 16 x half>, i64 } %a, 0
  %c = extractvalue { <vscale x 16 x half>, i64 } %a, 1
  store i64 %c, i64* %4

  ret <vscale x 16 x half> %b
}

declare { <vscale x 32 x half>, i64 } @llvm.riscv.vleff.nxv32f16(
  <vscale x 32 x half>,
  <vscale x 32 x half>*,
  i64);

define <vscale x 32 x half> @intrinsic_vleff_v_nxv32half_nxv32f16(<vscale x 32 x half>* %0, i64 %1, i64* %2) nounwind {
; CHECK-LABEL: intrinsic_vleff_v_nxv32half_nxv32f16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, m8, ta, mu
; CHECK-NEXT:    vle16ff.v v8, (a0)
; CHECK-NEXT:    csrr a0, vl
; CHECK-NEXT:    sd a0, 0(a2)
; CHECK-NEXT:    ret
entry:
  %a = call { <vscale x 32 x half>, i64 } @llvm.riscv.vleff.nxv32f16(
    <vscale x 32 x half> undef,
    <vscale x 32 x half>* %0,
    i64 %1)
  %b = extractvalue { <vscale x 32 x half>, i64 } %a, 0
  %c = extractvalue { <vscale x 32 x half>, i64 } %a, 1
  store i64 %c, i64* %2
  ret <vscale x 32 x half> %b
}

declare { <vscale x 32 x half>, i64 } @llvm.riscv.vleff.mask.nxv32f16(
  <vscale x 32 x half>,
  <vscale x 32 x half>*,
  <vscale x 32 x i1>,
  i64,
  i64);

define <vscale x 32 x half> @intrinsic_vleff_mask_v_nxv32half_nxv32f16(<vscale x 32 x half> %0, <vscale x 32 x half>* %1, <vscale x 32 x i1> %2, i64 %3, i64* %4) nounwind {
; CHECK-LABEL: intrinsic_vleff_mask_v_nxv32half_nxv32f16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, m8, ta, mu
; CHECK-NEXT:    vle16ff.v v8, (a0), v0.t
; CHECK-NEXT:    csrr a0, vl
; CHECK-NEXT:    sd a0, 0(a2)
; CHECK-NEXT:    ret
entry:
  %a = call { <vscale x 32 x half>, i64 } @llvm.riscv.vleff.mask.nxv32f16(
    <vscale x 32 x half> %0,
    <vscale x 32 x half>* %1,
    <vscale x 32 x i1> %2,
    i64 %3, i64 1)
  %b = extractvalue { <vscale x 32 x half>, i64 } %a, 0
  %c = extractvalue { <vscale x 32 x half>, i64 } %a, 1
  store i64 %c, i64* %4

  ret <vscale x 32 x half> %b
}

declare { <vscale x 1 x i8>, i64 } @llvm.riscv.vleff.nxv1i8(
  <vscale x 1 x i8>,
  <vscale x 1 x i8>*,
  i64);

define <vscale x 1 x i8> @intrinsic_vleff_v_nxv1i8_nxv1i8(<vscale x 1 x i8>* %0, i64 %1, i64* %2) nounwind {
; CHECK-LABEL: intrinsic_vleff_v_nxv1i8_nxv1i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e8, mf8, ta, mu
; CHECK-NEXT:    vle8ff.v v8, (a0)
; CHECK-NEXT:    csrr a0, vl
; CHECK-NEXT:    sd a0, 0(a2)
; CHECK-NEXT:    ret
entry:
  %a = call { <vscale x 1 x i8>, i64 } @llvm.riscv.vleff.nxv1i8(
    <vscale x 1 x i8> undef,
    <vscale x 1 x i8>* %0,
    i64 %1)
  %b = extractvalue { <vscale x 1 x i8>, i64 } %a, 0
  %c = extractvalue { <vscale x 1 x i8>, i64 } %a, 1
  store i64 %c, i64* %2
  ret <vscale x 1 x i8> %b
}

declare { <vscale x 1 x i8>, i64 } @llvm.riscv.vleff.mask.nxv1i8(
  <vscale x 1 x i8>,
  <vscale x 1 x i8>*,
  <vscale x 1 x i1>,
  i64,
  i64);

define <vscale x 1 x i8> @intrinsic_vleff_mask_v_nxv1i8_nxv1i8(<vscale x 1 x i8> %0, <vscale x 1 x i8>* %1, <vscale x 1 x i1> %2, i64 %3, i64* %4) nounwind {
; CHECK-LABEL: intrinsic_vleff_mask_v_nxv1i8_nxv1i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e8, mf8, ta, mu
; CHECK-NEXT:    vle8ff.v v8, (a0), v0.t
; CHECK-NEXT:    csrr a0, vl
; CHECK-NEXT:    sd a0, 0(a2)
; CHECK-NEXT:    ret
entry:
  %a = call { <vscale x 1 x i8>, i64 } @llvm.riscv.vleff.mask.nxv1i8(
    <vscale x 1 x i8> %0,
    <vscale x 1 x i8>* %1,
    <vscale x 1 x i1> %2,
    i64 %3, i64 1)
  %b = extractvalue { <vscale x 1 x i8>, i64 } %a, 0
  %c = extractvalue { <vscale x 1 x i8>, i64 } %a, 1
  store i64 %c, i64* %4

  ret <vscale x 1 x i8> %b
}

declare { <vscale x 2 x i8>, i64 } @llvm.riscv.vleff.nxv2i8(
  <vscale x 2 x i8>,
  <vscale x 2 x i8>*,
  i64);

define <vscale x 2 x i8> @intrinsic_vleff_v_nxv2i8_nxv2i8(<vscale x 2 x i8>* %0, i64 %1, i64* %2) nounwind {
; CHECK-LABEL: intrinsic_vleff_v_nxv2i8_nxv2i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e8, mf4, ta, mu
; CHECK-NEXT:    vle8ff.v v8, (a0)
; CHECK-NEXT:    csrr a0, vl
; CHECK-NEXT:    sd a0, 0(a2)
; CHECK-NEXT:    ret
entry:
  %a = call { <vscale x 2 x i8>, i64 } @llvm.riscv.vleff.nxv2i8(
    <vscale x 2 x i8> undef,
    <vscale x 2 x i8>* %0,
    i64 %1)
  %b = extractvalue { <vscale x 2 x i8>, i64 } %a, 0
  %c = extractvalue { <vscale x 2 x i8>, i64 } %a, 1
  store i64 %c, i64* %2
  ret <vscale x 2 x i8> %b
}

declare { <vscale x 2 x i8>, i64 } @llvm.riscv.vleff.mask.nxv2i8(
  <vscale x 2 x i8>,
  <vscale x 2 x i8>*,
  <vscale x 2 x i1>,
  i64,
  i64);

define <vscale x 2 x i8> @intrinsic_vleff_mask_v_nxv2i8_nxv2i8(<vscale x 2 x i8> %0, <vscale x 2 x i8>* %1, <vscale x 2 x i1> %2, i64 %3, i64* %4) nounwind {
; CHECK-LABEL: intrinsic_vleff_mask_v_nxv2i8_nxv2i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e8, mf4, ta, mu
; CHECK-NEXT:    vle8ff.v v8, (a0), v0.t
; CHECK-NEXT:    csrr a0, vl
; CHECK-NEXT:    sd a0, 0(a2)
; CHECK-NEXT:    ret
entry:
  %a = call { <vscale x 2 x i8>, i64 } @llvm.riscv.vleff.mask.nxv2i8(
    <vscale x 2 x i8> %0,
    <vscale x 2 x i8>* %1,
    <vscale x 2 x i1> %2,
    i64 %3, i64 1)
  %b = extractvalue { <vscale x 2 x i8>, i64 } %a, 0
  %c = extractvalue { <vscale x 2 x i8>, i64 } %a, 1
  store i64 %c, i64* %4

  ret <vscale x 2 x i8> %b
}

declare { <vscale x 4 x i8>, i64 } @llvm.riscv.vleff.nxv4i8(
  <vscale x 4 x i8>,
  <vscale x 4 x i8>*,
  i64);

define <vscale x 4 x i8> @intrinsic_vleff_v_nxv4i8_nxv4i8(<vscale x 4 x i8>* %0, i64 %1, i64* %2) nounwind {
; CHECK-LABEL: intrinsic_vleff_v_nxv4i8_nxv4i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e8, mf2, ta, mu
; CHECK-NEXT:    vle8ff.v v8, (a0)
; CHECK-NEXT:    csrr a0, vl
; CHECK-NEXT:    sd a0, 0(a2)
; CHECK-NEXT:    ret
entry:
  %a = call { <vscale x 4 x i8>, i64 } @llvm.riscv.vleff.nxv4i8(
    <vscale x 4 x i8> undef,
    <vscale x 4 x i8>* %0,
    i64 %1)
  %b = extractvalue { <vscale x 4 x i8>, i64 } %a, 0
  %c = extractvalue { <vscale x 4 x i8>, i64 } %a, 1
  store i64 %c, i64* %2
  ret <vscale x 4 x i8> %b
}

declare { <vscale x 4 x i8>, i64 } @llvm.riscv.vleff.mask.nxv4i8(
  <vscale x 4 x i8>,
  <vscale x 4 x i8>*,
  <vscale x 4 x i1>,
  i64,
  i64);

define <vscale x 4 x i8> @intrinsic_vleff_mask_v_nxv4i8_nxv4i8(<vscale x 4 x i8> %0, <vscale x 4 x i8>* %1, <vscale x 4 x i1> %2, i64 %3, i64* %4) nounwind {
; CHECK-LABEL: intrinsic_vleff_mask_v_nxv4i8_nxv4i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e8, mf2, ta, mu
; CHECK-NEXT:    vle8ff.v v8, (a0), v0.t
; CHECK-NEXT:    csrr a0, vl
; CHECK-NEXT:    sd a0, 0(a2)
; CHECK-NEXT:    ret
entry:
  %a = call { <vscale x 4 x i8>, i64 } @llvm.riscv.vleff.mask.nxv4i8(
    <vscale x 4 x i8> %0,
    <vscale x 4 x i8>* %1,
    <vscale x 4 x i1> %2,
    i64 %3, i64 1)
  %b = extractvalue { <vscale x 4 x i8>, i64 } %a, 0
  %c = extractvalue { <vscale x 4 x i8>, i64 } %a, 1
  store i64 %c, i64* %4

  ret <vscale x 4 x i8> %b
}

declare { <vscale x 8 x i8>, i64 } @llvm.riscv.vleff.nxv8i8(
  <vscale x 8 x i8>,
  <vscale x 8 x i8>*,
  i64);

define <vscale x 8 x i8> @intrinsic_vleff_v_nxv8i8_nxv8i8(<vscale x 8 x i8>* %0, i64 %1, i64* %2) nounwind {
; CHECK-LABEL: intrinsic_vleff_v_nxv8i8_nxv8i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e8, m1, ta, mu
; CHECK-NEXT:    vle8ff.v v8, (a0)
; CHECK-NEXT:    csrr a0, vl
; CHECK-NEXT:    sd a0, 0(a2)
; CHECK-NEXT:    ret
entry:
  %a = call { <vscale x 8 x i8>, i64 } @llvm.riscv.vleff.nxv8i8(
    <vscale x 8 x i8> undef,
    <vscale x 8 x i8>* %0,
    i64 %1)
  %b = extractvalue { <vscale x 8 x i8>, i64 } %a, 0
  %c = extractvalue { <vscale x 8 x i8>, i64 } %a, 1
  store i64 %c, i64* %2
  ret <vscale x 8 x i8> %b
}

declare { <vscale x 8 x i8>, i64 } @llvm.riscv.vleff.mask.nxv8i8(
  <vscale x 8 x i8>,
  <vscale x 8 x i8>*,
  <vscale x 8 x i1>,
  i64,
  i64);

define <vscale x 8 x i8> @intrinsic_vleff_mask_v_nxv8i8_nxv8i8(<vscale x 8 x i8> %0, <vscale x 8 x i8>* %1, <vscale x 8 x i1> %2, i64 %3, i64* %4) nounwind {
; CHECK-LABEL: intrinsic_vleff_mask_v_nxv8i8_nxv8i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e8, m1, ta, mu
; CHECK-NEXT:    vle8ff.v v8, (a0), v0.t
; CHECK-NEXT:    csrr a0, vl
; CHECK-NEXT:    sd a0, 0(a2)
; CHECK-NEXT:    ret
entry:
  %a = call { <vscale x 8 x i8>, i64 } @llvm.riscv.vleff.mask.nxv8i8(
    <vscale x 8 x i8> %0,
    <vscale x 8 x i8>* %1,
    <vscale x 8 x i1> %2,
    i64 %3, i64 1)
  %b = extractvalue { <vscale x 8 x i8>, i64 } %a, 0
  %c = extractvalue { <vscale x 8 x i8>, i64 } %a, 1
  store i64 %c, i64* %4

  ret <vscale x 8 x i8> %b
}

declare { <vscale x 16 x i8>, i64 } @llvm.riscv.vleff.nxv16i8(
  <vscale x 16 x i8>,
  <vscale x 16 x i8>*,
  i64);

define <vscale x 16 x i8> @intrinsic_vleff_v_nxv16i8_nxv16i8(<vscale x 16 x i8>* %0, i64 %1, i64* %2) nounwind {
; CHECK-LABEL: intrinsic_vleff_v_nxv16i8_nxv16i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e8, m2, ta, mu
; CHECK-NEXT:    vle8ff.v v8, (a0)
; CHECK-NEXT:    csrr a0, vl
; CHECK-NEXT:    sd a0, 0(a2)
; CHECK-NEXT:    ret
entry:
  %a = call { <vscale x 16 x i8>, i64 } @llvm.riscv.vleff.nxv16i8(
    <vscale x 16 x i8> undef,
    <vscale x 16 x i8>* %0,
    i64 %1)
  %b = extractvalue { <vscale x 16 x i8>, i64 } %a, 0
  %c = extractvalue { <vscale x 16 x i8>, i64 } %a, 1
  store i64 %c, i64* %2
  ret <vscale x 16 x i8> %b
}

declare { <vscale x 16 x i8>, i64 } @llvm.riscv.vleff.mask.nxv16i8(
  <vscale x 16 x i8>,
  <vscale x 16 x i8>*,
  <vscale x 16 x i1>,
  i64,
  i64);

define <vscale x 16 x i8> @intrinsic_vleff_mask_v_nxv16i8_nxv16i8(<vscale x 16 x i8> %0, <vscale x 16 x i8>* %1, <vscale x 16 x i1> %2, i64 %3, i64* %4) nounwind {
; CHECK-LABEL: intrinsic_vleff_mask_v_nxv16i8_nxv16i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e8, m2, ta, mu
; CHECK-NEXT:    vle8ff.v v8, (a0), v0.t
; CHECK-NEXT:    csrr a0, vl
; CHECK-NEXT:    sd a0, 0(a2)
; CHECK-NEXT:    ret
entry:
  %a = call { <vscale x 16 x i8>, i64 } @llvm.riscv.vleff.mask.nxv16i8(
    <vscale x 16 x i8> %0,
    <vscale x 16 x i8>* %1,
    <vscale x 16 x i1> %2,
    i64 %3, i64 1)
  %b = extractvalue { <vscale x 16 x i8>, i64 } %a, 0
  %c = extractvalue { <vscale x 16 x i8>, i64 } %a, 1
  store i64 %c, i64* %4

  ret <vscale x 16 x i8> %b
}

declare { <vscale x 32 x i8>, i64 } @llvm.riscv.vleff.nxv32i8(
  <vscale x 32 x i8>,
  <vscale x 32 x i8>*,
  i64);

define <vscale x 32 x i8> @intrinsic_vleff_v_nxv32i8_nxv32i8(<vscale x 32 x i8>* %0, i64 %1, i64* %2) nounwind {
; CHECK-LABEL: intrinsic_vleff_v_nxv32i8_nxv32i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e8, m4, ta, mu
; CHECK-NEXT:    vle8ff.v v8, (a0)
; CHECK-NEXT:    csrr a0, vl
; CHECK-NEXT:    sd a0, 0(a2)
; CHECK-NEXT:    ret
entry:
  %a = call { <vscale x 32 x i8>, i64 } @llvm.riscv.vleff.nxv32i8(
    <vscale x 32 x i8> undef,
    <vscale x 32 x i8>* %0,
    i64 %1)
  %b = extractvalue { <vscale x 32 x i8>, i64 } %a, 0
  %c = extractvalue { <vscale x 32 x i8>, i64 } %a, 1
  store i64 %c, i64* %2
  ret <vscale x 32 x i8> %b
}

declare { <vscale x 32 x i8>, i64 } @llvm.riscv.vleff.mask.nxv32i8(
  <vscale x 32 x i8>,
  <vscale x 32 x i8>*,
  <vscale x 32 x i1>,
  i64,
  i64);

define <vscale x 32 x i8> @intrinsic_vleff_mask_v_nxv32i8_nxv32i8(<vscale x 32 x i8> %0, <vscale x 32 x i8>* %1, <vscale x 32 x i1> %2, i64 %3, i64* %4) nounwind {
; CHECK-LABEL: intrinsic_vleff_mask_v_nxv32i8_nxv32i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e8, m4, ta, mu
; CHECK-NEXT:    vle8ff.v v8, (a0), v0.t
; CHECK-NEXT:    csrr a0, vl
; CHECK-NEXT:    sd a0, 0(a2)
; CHECK-NEXT:    ret
entry:
  %a = call { <vscale x 32 x i8>, i64 } @llvm.riscv.vleff.mask.nxv32i8(
    <vscale x 32 x i8> %0,
    <vscale x 32 x i8>* %1,
    <vscale x 32 x i1> %2,
    i64 %3, i64 1)
  %b = extractvalue { <vscale x 32 x i8>, i64 } %a, 0
  %c = extractvalue { <vscale x 32 x i8>, i64 } %a, 1
  store i64 %c, i64* %4

  ret <vscale x 32 x i8> %b
}

declare { <vscale x 64 x i8>, i64 } @llvm.riscv.vleff.nxv64i8(
  <vscale x 64 x i8>,
  <vscale x 64 x i8>*,
  i64);

define <vscale x 64 x i8> @intrinsic_vleff_v_nxv64i8_nxv64i8(<vscale x 64 x i8>* %0, i64 %1, i64* %2) nounwind {
; CHECK-LABEL: intrinsic_vleff_v_nxv64i8_nxv64i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e8, m8, ta, mu
; CHECK-NEXT:    vle8ff.v v8, (a0)
; CHECK-NEXT:    csrr a0, vl
; CHECK-NEXT:    sd a0, 0(a2)
; CHECK-NEXT:    ret
entry:
  %a = call { <vscale x 64 x i8>, i64 } @llvm.riscv.vleff.nxv64i8(
    <vscale x 64 x i8> undef,
    <vscale x 64 x i8>* %0,
    i64 %1)
  %b = extractvalue { <vscale x 64 x i8>, i64 } %a, 0
  %c = extractvalue { <vscale x 64 x i8>, i64 } %a, 1
  store i64 %c, i64* %2
  ret <vscale x 64 x i8> %b
}

declare { <vscale x 64 x i8>, i64 } @llvm.riscv.vleff.mask.nxv64i8(
  <vscale x 64 x i8>,
  <vscale x 64 x i8>*,
  <vscale x 64 x i1>,
  i64,
  i64);

define <vscale x 64 x i8> @intrinsic_vleff_mask_v_nxv64i8_nxv64i8(<vscale x 64 x i8> %0, <vscale x 64 x i8>* %1, <vscale x 64 x i1> %2, i64 %3, i64* %4) nounwind {
; CHECK-LABEL: intrinsic_vleff_mask_v_nxv64i8_nxv64i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e8, m8, ta, mu
; CHECK-NEXT:    vle8ff.v v8, (a0), v0.t
; CHECK-NEXT:    csrr a0, vl
; CHECK-NEXT:    sd a0, 0(a2)
; CHECK-NEXT:    ret
entry:
  %a = call { <vscale x 64 x i8>, i64 } @llvm.riscv.vleff.mask.nxv64i8(
    <vscale x 64 x i8> %0,
    <vscale x 64 x i8>* %1,
    <vscale x 64 x i1> %2,
    i64 %3, i64 1)
  %b = extractvalue { <vscale x 64 x i8>, i64 } %a, 0
  %c = extractvalue { <vscale x 64 x i8>, i64 } %a, 1
  store i64 %c, i64* %4

  ret <vscale x 64 x i8> %b
}

; Test with the VL output unused
define <vscale x 1 x double> @intrinsic_vleff_dead_vl(<vscale x 1 x double>* %0, i64 %1) nounwind {
; CHECK-LABEL: intrinsic_vleff_dead_vl:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e64, m1, ta, mu
; CHECK-NEXT:    vle64ff.v v8, (a0)
; CHECK-NEXT:    ret
entry:
  %a = call { <vscale x 1 x double>, i64 } @llvm.riscv.vleff.nxv1f64(
    <vscale x 1 x double> undef,
    <vscale x 1 x double>* %0,
    i64 %1)
  %b = extractvalue { <vscale x 1 x double>, i64 } %a, 0
  ret <vscale x 1 x double> %b
}

define <vscale x 1 x double> @intrinsic_vleff_mask_dead_vl(<vscale x 1 x double> %0, <vscale x 1 x double>* %1, <vscale x 1 x i1> %2, i64 %3) nounwind {
; CHECK-LABEL: intrinsic_vleff_mask_dead_vl:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e64, m1, ta, mu
; CHECK-NEXT:    vle64ff.v v8, (a0), v0.t
; CHECK-NEXT:    ret
entry:
  %a = call { <vscale x 1 x double>, i64 } @llvm.riscv.vleff.mask.nxv1f64(
    <vscale x 1 x double> %0,
    <vscale x 1 x double>* %1,
    <vscale x 1 x i1> %2,
    i64 %3, i64 1)
  %b = extractvalue { <vscale x 1 x double>, i64 } %a, 0

  ret <vscale x 1 x double> %b
}

; Test with the loaded value unused
define void @intrinsic_vleff_dead_value(<vscale x 1 x double>* %0, i64 %1, i64* %2) nounwind {
; CHECK-LABEL: intrinsic_vleff_dead_value:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e64, m1, ta, mu
; CHECK-NEXT:    vle64ff.v v8, (a0)
; CHECK-NEXT:    csrr a0, vl
; CHECK-NEXT:    sd a0, 0(a2)
; CHECK-NEXT:    ret
entry:
  %a = call { <vscale x 1 x double>, i64 } @llvm.riscv.vleff.nxv1f64(
    <vscale x 1 x double> undef,
    <vscale x 1 x double>* %0,
    i64 %1)
  %b = extractvalue { <vscale x 1 x double>, i64 } %a, 1
  store i64 %b, i64* %2
  ret void
}

define void @intrinsic_vleff_mask_dead_value(<vscale x 1 x double> %0, <vscale x 1 x double>* %1, <vscale x 1 x i1> %2, i64 %3, i64* %4) nounwind {
; CHECK-LABEL: intrinsic_vleff_mask_dead_value:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e64, m1, ta, mu
; CHECK-NEXT:    vle64ff.v v8, (a0), v0.t
; CHECK-NEXT:    csrr a0, vl
; CHECK-NEXT:    sd a0, 0(a2)
; CHECK-NEXT:    ret
entry:
  %a = call { <vscale x 1 x double>, i64 } @llvm.riscv.vleff.mask.nxv1f64(
    <vscale x 1 x double> %0,
    <vscale x 1 x double>* %1,
    <vscale x 1 x i1> %2,
    i64 %3, i64 1)
  %b = extractvalue { <vscale x 1 x double>, i64 } %a, 1
  store i64 %b, i64* %4

  ret void
}

; Test with both outputs dead. Make sure the vleff isn't deleted.
define void @intrinsic_vleff_dead_all(<vscale x 1 x double>* %0, i64 %1) nounwind {
; CHECK-LABEL: intrinsic_vleff_dead_all:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e64, m1, ta, mu
; CHECK-NEXT:    vle64ff.v v8, (a0)
; CHECK-NEXT:    ret
entry:
  %a = call { <vscale x 1 x double>, i64 } @llvm.riscv.vleff.nxv1f64(
    <vscale x 1 x double> undef,
    <vscale x 1 x double>* %0,
    i64 %1)
  ret void
}

define void @intrinsic_vleff_mask_dead_all(<vscale x 1 x double> %0, <vscale x 1 x double>* %1, <vscale x 1 x i1> %2, i64 %3) nounwind {
; CHECK-LABEL: intrinsic_vleff_mask_dead_all:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e64, m1, ta, mu
; CHECK-NEXT:    vle64ff.v v8, (a0), v0.t
; CHECK-NEXT:    ret
entry:
  %a = call { <vscale x 1 x double>, i64 } @llvm.riscv.vleff.mask.nxv1f64(
    <vscale x 1 x double> %0,
    <vscale x 1 x double>* %1,
    <vscale x 1 x i1> %2,
    i64 %3, i64 1)

  ret void
}
