; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc < %s -mtriple=i686-unknown-unknown   -mattr=+sse,+sse2,+slow-lea,+slow-3ops-lea | FileCheck %s --check-prefixes=ALL,X86,X86-SLOWLEA
; RUN: llc < %s -mtriple=i686-unknown-unknown   -mattr=+sse,+sse2,-slow-lea,-slow-3ops-lea | FileCheck %s --check-prefixes=ALL,X86,X86-FASTLEA
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -mattr=+sse,+sse2,+slow-lea,+slow-3ops-lea | FileCheck %s --check-prefixes=ALL,X64
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -mattr=+sse,+sse2,-slow-lea,-slow-3ops-lea | FileCheck %s --check-prefixes=ALL,X64

; These two forms are equivalent:
;   sub %y, (xor %x, -1)
;   add (add %x, 1), %y
; Some targets may prefer one to the other.

define i8 @scalar_i8(i8 %x, i8 %y) nounwind {
; X86-LABEL: scalar_i8:
; X86:       # %bb.0:
; X86-NEXT:    movb {{[0-9]+}}(%esp), %al
; X86-NEXT:    addb {{[0-9]+}}(%esp), %al
; X86-NEXT:    incb %al
; X86-NEXT:    retl
;
; X64-LABEL: scalar_i8:
; X64:       # %bb.0:
; X64-NEXT:    # kill: def $esi killed $esi def $rsi
; X64-NEXT:    # kill: def $edi killed $edi def $rdi
; X64-NEXT:    leal (%rsi,%rdi), %eax
; X64-NEXT:    incb %al
; X64-NEXT:    # kill: def $al killed $al killed $eax
; X64-NEXT:    retq
  %t0 = xor i8 %x, -1
  %t1 = sub i8 %y, %t0
  ret i8 %t1
}

define i16 @scalar_i16(i16 %x, i16 %y) nounwind {
; X86-LABEL: scalar_i16:
; X86:       # %bb.0:
; X86-NEXT:    movzwl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    addw {{[0-9]+}}(%esp), %ax
; X86-NEXT:    incl %eax
; X86-NEXT:    # kill: def $ax killed $ax killed $eax
; X86-NEXT:    retl
;
; X64-LABEL: scalar_i16:
; X64:       # %bb.0:
; X64-NEXT:    # kill: def $esi killed $esi def $rsi
; X64-NEXT:    # kill: def $edi killed $edi def $rdi
; X64-NEXT:    leal 1(%rsi,%rdi), %eax
; X64-NEXT:    # kill: def $ax killed $ax killed $eax
; X64-NEXT:    retq
  %t0 = xor i16 %x, -1
  %t1 = sub i16 %y, %t0
  ret i16 %t1
}

define i32 @scalar_i32(i32 %x, i32 %y) nounwind {
; X86-SLOWLEA-LABEL: scalar_i32:
; X86-SLOWLEA:       # %bb.0:
; X86-SLOWLEA-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-SLOWLEA-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; X86-SLOWLEA-NEXT:    addl %ecx, %eax
; X86-SLOWLEA-NEXT:    addl $1, %eax
; X86-SLOWLEA-NEXT:    retl
;
; X86-FASTLEA-LABEL: scalar_i32:
; X86-FASTLEA:       # %bb.0:
; X86-FASTLEA-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-FASTLEA-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; X86-FASTLEA-NEXT:    leal 1(%ecx,%eax), %eax
; X86-FASTLEA-NEXT:    retl
;
; X64-LABEL: scalar_i32:
; X64:       # %bb.0:
; X64-NEXT:    # kill: def $esi killed $esi def $rsi
; X64-NEXT:    # kill: def $edi killed $edi def $rdi
; X64-NEXT:    leal 1(%rsi,%rdi), %eax
; X64-NEXT:    retq
  %t0 = xor i32 %x, -1
  %t1 = sub i32 %y, %t0
  ret i32 %t1
}

define i64 @scalar_i64(i64 %x, i64 %y) nounwind {
; X86-LABEL: scalar_i64:
; X86:       # %bb.0:
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    movl {{[0-9]+}}(%esp), %edx
; X86-NEXT:    addl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    adcl {{[0-9]+}}(%esp), %edx
; X86-NEXT:    addl $1, %eax
; X86-NEXT:    adcl $0, %edx
; X86-NEXT:    retl
;
; X64-LABEL: scalar_i64:
; X64:       # %bb.0:
; X64-NEXT:    leaq 1(%rsi,%rdi), %rax
; X64-NEXT:    retq
  %t0 = xor i64 %x, -1
  %t1 = sub i64 %y, %t0
  ret i64 %t1
}

define <16 x i8> @vector_i128_i8(<16 x i8> %x, <16 x i8> %y) nounwind {
; ALL-LABEL: vector_i128_i8:
; ALL:       # %bb.0:
; ALL-NEXT:    paddb %xmm1, %xmm0
; ALL-NEXT:    pcmpeqd %xmm1, %xmm1
; ALL-NEXT:    psubb %xmm1, %xmm0
; ALL-NEXT:    ret{{[l|q]}}
  %t0 = xor <16 x i8> %x, <i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1>
  %t1 = sub <16 x i8> %y, %t0
  ret <16 x i8> %t1
}

define <8 x i16> @vector_i128_i16(<8 x i16> %x, <8 x i16> %y) nounwind {
; ALL-LABEL: vector_i128_i16:
; ALL:       # %bb.0:
; ALL-NEXT:    paddw %xmm1, %xmm0
; ALL-NEXT:    pcmpeqd %xmm1, %xmm1
; ALL-NEXT:    psubw %xmm1, %xmm0
; ALL-NEXT:    ret{{[l|q]}}
  %t0 = xor <8 x i16> %x, <i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1>
  %t1 = sub <8 x i16> %y, %t0
  ret <8 x i16> %t1
}

define <4 x i32> @vector_i128_i32(<4 x i32> %x, <4 x i32> %y) nounwind {
; ALL-LABEL: vector_i128_i32:
; ALL:       # %bb.0:
; ALL-NEXT:    paddd %xmm1, %xmm0
; ALL-NEXT:    pcmpeqd %xmm1, %xmm1
; ALL-NEXT:    psubd %xmm1, %xmm0
; ALL-NEXT:    ret{{[l|q]}}
  %t0 = xor <4 x i32> %x, <i32 -1, i32 -1, i32 -1, i32 -1>
  %t1 = sub <4 x i32> %y, %t0
  ret <4 x i32> %t1
}

define <2 x i64> @vector_i128_i64(<2 x i64> %x, <2 x i64> %y) nounwind {
; ALL-LABEL: vector_i128_i64:
; ALL:       # %bb.0:
; ALL-NEXT:    paddq %xmm1, %xmm0
; ALL-NEXT:    pcmpeqd %xmm1, %xmm1
; ALL-NEXT:    psubq %xmm1, %xmm0
; ALL-NEXT:    ret{{[l|q]}}
  %t0 = xor <2 x i64> %x, <i64 -1, i64 -1>
  %t1 = sub <2 x i64> %y, %t0
  ret <2 x i64> %t1
}
