; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -global-isel -mtriple=amdgcn-mesa-mesa3d -mcpu=hawaii < %s | FileCheck -check-prefixes=GCN,GFX7 %s
; RUN: llc -global-isel -mtriple=amdgcn-mesa-mesa3d -mcpu=fiji < %s | FileCheck -check-prefixes=GCN,GFX8 %s

define i16 @v_powi_f16(i16 %l, i32 %r) {
; GFX7-LABEL: v_powi_f16:
; GFX7:       ; %bb.0:
; GFX7-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7-NEXT:    v_cvt_f32_f16_e32 v0, v0
; GFX7-NEXT:    v_cvt_f32_i32_e32 v1, v1
; GFX7-NEXT:    v_log_f32_e32 v0, v0
; GFX7-NEXT:    v_mul_legacy_f32_e32 v0, v0, v1
; GFX7-NEXT:    v_exp_f32_e32 v0, v0
; GFX7-NEXT:    v_cvt_f16_f32_e32 v0, v0
; GFX7-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-LABEL: v_powi_f16:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    v_cvt_f32_i32_e32 v1, v1
; GFX8-NEXT:    v_log_f16_e32 v0, v0
; GFX8-NEXT:    v_cvt_f16_f32_e32 v1, v1
; GFX8-NEXT:    v_cvt_f32_f16_e32 v0, v0
; GFX8-NEXT:    v_cvt_f32_f16_e32 v1, v1
; GFX8-NEXT:    v_mul_legacy_f32_e32 v0, v0, v1
; GFX8-NEXT:    v_cvt_f16_f32_e32 v0, v0
; GFX8-NEXT:    v_exp_f16_e32 v0, v0
; GFX8-NEXT:    s_setpc_b64 s[30:31]
  %l.cast = bitcast i16 %l to half
  %res = call half @llvm.powi.f16(half %l.cast, i32 %r)
  %res.cast = bitcast half %res to i16
  ret i16 %res.cast
}

define float @v_powi_f32(float %l, i32 %r) {
; GCN-LABEL: v_powi_f32:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-NEXT:    v_cvt_f32_i32_e32 v1, v1
; GCN-NEXT:    v_log_f32_e32 v0, v0
; GCN-NEXT:    v_mul_legacy_f32_e32 v0, v0, v1
; GCN-NEXT:    v_exp_f32_e32 v0, v0
; GCN-NEXT:    s_setpc_b64 s[30:31]
  %res = call float @llvm.powi.f32(float %l, i32 %r)
  ret float %res
}

define float @v_powi_0_f32(float %l) {
; GCN-LABEL: v_powi_0_f32:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-NEXT:    v_mov_b32_e32 v0, 1.0
; GCN-NEXT:    s_setpc_b64 s[30:31]
  %res = call float @llvm.powi.f32(float %l, i32 0)
  ret float %res
}

define float @v_powi_1_f32(float %l) {
; GCN-LABEL: v_powi_1_f32:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-NEXT:    s_setpc_b64 s[30:31]
  %res = call float @llvm.powi.f32(float %l, i32 1)
  ret float %res
}

define float @v_powi_neg1_f32(float %l) {
; GCN-LABEL: v_powi_neg1_f32:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-NEXT:    v_cvt_f32_i32_e32 v1, -1
; GCN-NEXT:    v_log_f32_e32 v0, v0
; GCN-NEXT:    v_mul_legacy_f32_e32 v0, v0, v1
; GCN-NEXT:    v_exp_f32_e32 v0, v0
; GCN-NEXT:    s_setpc_b64 s[30:31]
  %res = call float @llvm.powi.f32(float %l, i32 -1)
  ret float %res
}

define float @v_powi_2_f32(float %l) {
; GCN-LABEL: v_powi_2_f32:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-NEXT:    v_log_f32_e32 v0, v0
; GCN-NEXT:    v_cvt_f32_ubyte0_e32 v1, 2
; GCN-NEXT:    v_mul_legacy_f32_e32 v0, v0, v1
; GCN-NEXT:    v_exp_f32_e32 v0, v0
; GCN-NEXT:    s_setpc_b64 s[30:31]
  %res = call float @llvm.powi.f32(float %l, i32 2)
  ret float %res
}

define float @v_powi_neg2_f32(float %l) {
; GCN-LABEL: v_powi_neg2_f32:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-NEXT:    v_cvt_f32_i32_e32 v1, -2
; GCN-NEXT:    v_log_f32_e32 v0, v0
; GCN-NEXT:    v_mul_legacy_f32_e32 v0, v0, v1
; GCN-NEXT:    v_exp_f32_e32 v0, v0
; GCN-NEXT:    s_setpc_b64 s[30:31]
  %res = call float @llvm.powi.f32(float %l, i32 -2)
  ret float %res
}

define float @v_powi_4_f32(float %l) {
; GCN-LABEL: v_powi_4_f32:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-NEXT:    v_log_f32_e32 v0, v0
; GCN-NEXT:    v_cvt_f32_ubyte0_e32 v1, 4
; GCN-NEXT:    v_mul_legacy_f32_e32 v0, v0, v1
; GCN-NEXT:    v_exp_f32_e32 v0, v0
; GCN-NEXT:    s_setpc_b64 s[30:31]
  %res = call float @llvm.powi.f32(float %l, i32 4)
  ret float %res
}

define float @v_powi_8_f32(float %l) {
; GCN-LABEL: v_powi_8_f32:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-NEXT:    v_log_f32_e32 v0, v0
; GCN-NEXT:    v_cvt_f32_ubyte0_e32 v1, 8
; GCN-NEXT:    v_mul_legacy_f32_e32 v0, v0, v1
; GCN-NEXT:    v_exp_f32_e32 v0, v0
; GCN-NEXT:    s_setpc_b64 s[30:31]
  %res = call float @llvm.powi.f32(float %l, i32 8)
  ret float %res
}

define float @v_powi_16_f32(float %l) {
; GCN-LABEL: v_powi_16_f32:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-NEXT:    v_log_f32_e32 v0, v0
; GCN-NEXT:    v_cvt_f32_ubyte0_e32 v1, 16
; GCN-NEXT:    v_mul_legacy_f32_e32 v0, v0, v1
; GCN-NEXT:    v_exp_f32_e32 v0, v0
; GCN-NEXT:    s_setpc_b64 s[30:31]
  %res = call float @llvm.powi.f32(float %l, i32 16)
  ret float %res
}

define float @v_powi_128_f32(float %l) {
; GCN-LABEL: v_powi_128_f32:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-NEXT:    v_log_f32_e32 v0, v0
; GCN-NEXT:    v_cvt_f32_ubyte0_e32 v1, 0x80
; GCN-NEXT:    v_mul_legacy_f32_e32 v0, v0, v1
; GCN-NEXT:    v_exp_f32_e32 v0, v0
; GCN-NEXT:    s_setpc_b64 s[30:31]
  %res = call float @llvm.powi.f32(float %l, i32 128)
  ret float %res
}

define float @v_powi_neg128_f32(float %l) {
; GCN-LABEL: v_powi_neg128_f32:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-NEXT:    v_cvt_f32_i32_e32 v1, 0xffffff80
; GCN-NEXT:    v_log_f32_e32 v0, v0
; GCN-NEXT:    v_mul_legacy_f32_e32 v0, v0, v1
; GCN-NEXT:    v_exp_f32_e32 v0, v0
; GCN-NEXT:    s_setpc_b64 s[30:31]
  %res = call float @llvm.powi.f32(float %l, i32 -128)
  ret float %res
}

; FIXME: f64 broken
; define double @v_powi_f64(double %l, i32 %r) {
;   %res = call double @llvm.powi.f64(double %l, i32 %r)
;   ret double %res
; }

declare half @llvm.powi.f16(half, i32) #0
declare float @llvm.powi.f32(float, i32) #0
declare double @llvm.powi.f64(double, i32) #0

attributes #0 = { nounwind readnone speculatable willreturn }
