#!/bin/sh
#
# Install (symlinks) fonts into XFT user's directory (~/.fonts)
#

case "$1" in
    --uninstall)
    if test -d $HOME/.fonts; then
	for font in *.bdf *.bdf.gz *.pcf *.pcf.gz *.ttf *.ttf.gz; do
	    if test -f $font -a -f $HOME/.fonts/$font; then
		fp_font="`pwd`/$font"
		echo "Removing $HOME/.fonts/$font"; \
		    rm $HOME/.fonts/$font
	    fi
	done
    fi
    ;;
    
    --help)
    echo "`basename $0` [OPTION]"
    echo "   Option:"
    echo "      --uninstall:  Uninstall fonts localted in ~/.fonts (xft)"
    echo "      --help:       This help text"
    echo " "
    ;;

    *)
    if test -d $HOME/.fonts; then
	for font in *.bdf *.bdf.gz *.pcf *.pcf.gz *.ttf *.ttf.gz; do
	    if test -f "$font" -a ! -f "$HOME/.fonts/$font"; then
		fp_font="`pwd`/$font"
		echo "Installing $fp_font"; \
		    ln -sf $fp_font $HOME/.fonts/$font
		    (cd $HOME/.fonts/ && /usr/X11/bin/mkfontdir)
	    fi
	done
    fi
    ;;
esac
